/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.stats;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveConfForTest;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.utils.TestTxnDbUtil;
import org.apache.hadoop.hive.ql.DriverUtils;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.stats.StatsUpdaterThread;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestStatsUpdaterThread {
    private static final Logger LOG = LoggerFactory.getLogger(TestStatsUpdaterThread.class);
    private HiveConfForTest hiveConf;
    private SessionState ss;

    String getTestDataDir() {
        return this.hiveConf.getTestDataDir();
    }

    @Before
    public void setUp() throws Exception {
        this.hiveConf = new HiveConfForTest(this.getClass());
        this.hiveConf.set(HiveConf.ConfVars.PRE_EXEC_HOOKS.varname, "");
        this.hiveConf.set(HiveConf.ConfVars.POST_EXEC_HOOKS.varname, "");
        this.hiveConf.set(HiveConf.ConfVars.METASTORE_WAREHOUSE.varname, this.getTestDataDir());
        this.hiveConf.setVar(HiveConf.ConfVars.HIVE_INPUT_FORMAT, HiveInputFormat.class.getName());
        this.hiveConf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, "org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory");
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_STATS_AUTOGATHER, true);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_STATS_COL_AUTOGATHER, true);
        this.hiveConf.set(MetastoreConf.ConfVars.STATS_AUTO_UPDATE.getVarname(), "all");
        TestTxnDbUtil.setConfValues((Configuration)this.hiveConf);
        TestTxnDbUtil.prepDb((Configuration)this.hiveConf);
        File f = new File(this.getTestDataDir());
        if (f.exists()) {
            FileUtil.fullyDelete((File)f);
        }
        if (!new File(this.getTestDataDir()).mkdirs()) {
            throw new RuntimeException("Could not create " + this.getTestDataDir());
        }
        this.ss = DriverUtils.setUpAndStartSessionState((HiveConf)this.hiveConf, (String)"hive");
        this.cleanUp();
    }

    @After
    public void cleanUp() throws HiveException {
        this.executeQuery("drop table simple_stats");
        this.executeQuery("drop table simple_stats2");
        this.executeQuery("drop table simple_stats3");
    }

    @Test(timeout=80000L)
    public void testSimpleUpdateWithThreads() throws Exception {
        StatsUpdaterThread su = this.createUpdater();
        su.startWorkers();
        HiveMetaStoreClient msClient = new HiveMetaStoreClient((Configuration)this.hiveConf);
        this.executeQuery("create table simple_stats (i int, s string)");
        this.executeQuery("insert into simple_stats (i, s) values (1, 'test')");
        this.verifyAndUnsetColStats("simple_stats", Lists.newArrayList((Object[])new String[]{"i"}), (IMetaStoreClient)msClient);
        Assert.assertTrue((boolean)su.runOneIteration());
        su.waitForQueuedCommands();
        this.verifyStatsUpToDate("simple_stats", Lists.newArrayList((Object[])new String[]{"i"}), (IMetaStoreClient)msClient, true);
        msClient.close();
    }

    @Test(timeout=80000L)
    public void testMultipleTables() throws Exception {
        StatsUpdaterThread su = this.createUpdater();
        HiveMetaStoreClient msClient = new HiveMetaStoreClient((Configuration)this.hiveConf);
        this.executeQuery("create table simple_stats (s string)");
        this.executeQuery("insert into simple_stats (s) values ('test')");
        this.executeQuery("create table simple_stats2 (s string)");
        this.executeQuery("insert into simple_stats2 (s) values ('test2')");
        this.verifyAndUnsetColStats("simple_stats", Lists.newArrayList((Object[])new String[]{"s"}), (IMetaStoreClient)msClient);
        this.verifyAndUnsetColStats("simple_stats2", Lists.newArrayList((Object[])new String[]{"s"}), (IMetaStoreClient)msClient);
        Assert.assertTrue((boolean)su.runOneIteration());
        this.drainWorkQueue(su);
        this.verifyAndUnsetColStats("simple_stats", Lists.newArrayList((Object[])new String[]{"s"}), (IMetaStoreClient)msClient);
        this.verifyAndUnsetColStats("simple_stats2", Lists.newArrayList((Object[])new String[]{"s"}), (IMetaStoreClient)msClient);
        this.setTableSkipProperty((IMetaStoreClient)msClient, "simple_stats", "true");
        Assert.assertTrue((boolean)su.runOneIteration());
        this.drainWorkQueue(su);
        this.verifyStatsUpToDate("simple_stats", Lists.newArrayList((Object[])new String[]{"i"}), (IMetaStoreClient)msClient, false);
        this.verifyAndUnsetColStats("simple_stats2", Lists.newArrayList((Object[])new String[]{"s"}), (IMetaStoreClient)msClient);
        msClient.close();
    }

    @Test(timeout=160000L)
    public void testTxnTable() throws Exception {
        StatsUpdaterThread su = this.createUpdater();
        HiveMetaStoreClient msClient = new HiveMetaStoreClient((Configuration)this.hiveConf);
        this.executeQuery("create table simple_stats (s string) TBLPROPERTIES (\"transactional\"=\"true\", \"transactional_properties\"=\"insert_only\")");
        this.executeQuery("insert into simple_stats (s) values ('test')");
        ArrayList cols = Lists.newArrayList((Object[])new String[]{"s"});
        String dbName = this.ss.getCurrentDatabase();
        String tblName = "simple_stats";
        String fqName = dbName + "." + tblName;
        ValidWriteIdList initialWriteIds = msClient.getValidWriteIds(fqName);
        this.verifyStatsUpToDate(tblName, cols, (IMetaStoreClient)msClient, initialWriteIds.toString(), true);
        Assert.assertFalse((boolean)su.runOneIteration());
        this.drainWorkQueue(su, 0);
        this.executeQuery("insert overwrite table simple_stats values ('test2')");
        ValidWriteIdList nextWriteIds = msClient.getValidWriteIds(fqName);
        this.verifyStatsUpToDate(tblName, cols, (IMetaStoreClient)msClient, nextWriteIds.toString(), true);
        Assert.assertFalse((boolean)su.runOneIteration());
        this.drainWorkQueue(su, 0);
        String currentWriteIds = msClient.getValidWriteIds(fqName).toString();
        long badTxnId = msClient.openTxn("moo");
        long badWriteId = msClient.allocateTableWriteId(badTxnId, dbName, tblName);
        Table tbl = msClient.getTable(dbName, tblName);
        tbl.setWriteId(badWriteId);
        msClient.alter_table(null, dbName, tblName, tbl, new EnvironmentContext(), initialWriteIds.toString());
        this.verifyStatsUpToDate(tblName, cols, (IMetaStoreClient)msClient, currentWriteIds, false);
        Assert.assertTrue((boolean)su.runOneIteration());
        this.drainWorkQueue(su);
        currentWriteIds = msClient.getValidWriteIds(fqName).toString();
        this.verifyStatsUpToDate(tblName, cols, (IMetaStoreClient)msClient, currentWriteIds, false);
        msClient.abortTxns((List)Lists.newArrayList((Object[])new Long[]{badTxnId}));
        Assert.assertTrue((boolean)su.runOneIteration());
        this.drainWorkQueue(su);
        currentWriteIds = msClient.getValidWriteIds(fqName).toString();
        this.verifyStatsUpToDate(tblName, cols, (IMetaStoreClient)msClient, currentWriteIds, true);
        badTxnId = msClient.openTxn("moo");
        badWriteId = msClient.allocateTableWriteId(badTxnId, dbName, tblName);
        tbl = msClient.getTable(dbName, tblName);
        tbl.setWriteId(badWriteId);
        StatsSetupConst.setBasicStatsState((Map)tbl.getParameters(), (String)"false");
        msClient.alter_table(null, dbName, tblName, tbl, new EnvironmentContext(), initialWriteIds.toString());
        this.verifyStatsUpToDate(tblName, cols, (IMetaStoreClient)msClient, currentWriteIds, false);
        Assert.assertTrue((boolean)su.runOneIteration());
        this.drainWorkQueue(su);
        currentWriteIds = msClient.getValidWriteIds(fqName).toString();
        this.verifyStatsUpToDate(tblName, cols, (IMetaStoreClient)msClient, currentWriteIds, false);
        msClient.commitTxn(badTxnId);
        Assert.assertTrue((boolean)su.runOneIteration());
        this.drainWorkQueue(su);
        currentWriteIds = msClient.getValidWriteIds(fqName).toString();
        this.verifyStatsUpToDate(tblName, cols, (IMetaStoreClient)msClient, currentWriteIds, true);
        msClient.close();
    }

    @Test
    public void testTxnPartitions() throws Exception {
        StatsUpdaterThread su = this.createUpdater();
        HiveMetaStoreClient msClient = new HiveMetaStoreClient((Configuration)this.hiveConf);
        this.executeQuery("create table simple_stats (s string) partitioned by (p int) TBLPROPERTIES (\"transactional\"=\"true\", \"transactional_properties\"=\"insert_only\")");
        this.executeQuery("insert into simple_stats partition(p=1) values ('test')");
        this.executeQuery("insert into simple_stats partition(p=2) values ('test2')");
        this.executeQuery("insert into simple_stats partition(p=3) values ('test3')");
        Assert.assertFalse((boolean)su.runOneIteration());
        this.drainWorkQueue(su, 0);
        this.executeQuery("insert overwrite table simple_stats partition(p=1) values ('test2')");
        this.executeQuery("insert overwrite table simple_stats partition(p=2) values ('test3')");
        Assert.assertFalse((boolean)su.runOneIteration());
        this.drainWorkQueue(su, 0);
        String dbName = this.ss.getCurrentDatabase();
        String tblName = "simple_stats";
        String fqName = dbName + "." + tblName;
        long badTxnId = msClient.openTxn("moo");
        long badWriteId = msClient.allocateTableWriteId(badTxnId, dbName, tblName);
        msClient.abortTxns((List)Lists.newArrayList((Object[])new Long[]{badTxnId}));
        Partition part1 = msClient.getPartition(dbName, tblName, "p=1");
        Partition part2 = msClient.getPartition(dbName, tblName, "p=2");
        part1.setWriteId(badWriteId);
        part2.setWriteId(badWriteId);
        String currentWriteIds = msClient.getValidWriteIds(fqName).toString();
        msClient.alter_partitions(dbName, tblName, (List)Lists.newArrayList((Object[])new Partition[]{part1}), null, currentWriteIds, badWriteId);
        msClient.alter_partitions(dbName, tblName, (List)Lists.newArrayList((Object[])new Partition[]{part2}), null, currentWriteIds, badWriteId);
        Map stats = msClient.getPartitionColumnStatistics(dbName, tblName, (List)Lists.newArrayList((Object[])new String[]{"p=1", "p=2", "p=3"}), (List)Lists.newArrayList((Object[])new String[]{"s"}), "hive", currentWriteIds);
        Assert.assertEquals((long)1L, (long)stats.size());
        Assert.assertTrue((boolean)su.runOneIteration());
        this.drainWorkQueue(su, 2);
        stats = msClient.getPartitionColumnStatistics(dbName, tblName, (List)Lists.newArrayList((Object[])new String[]{"p=1", "p=2", "p=3"}), (List)Lists.newArrayList((Object[])new String[]{"s"}), "hive", currentWriteIds);
        Assert.assertEquals((long)1L, (long)stats.size());
        stats = msClient.getPartitionColumnStatistics(dbName, tblName, null, (List)Lists.newArrayList((Object[])new String[]{"s"}), "hive", currentWriteIds);
        Assert.assertEquals((long)0L, (long)stats.size());
        currentWriteIds = msClient.getValidWriteIds(fqName).toString();
        stats = msClient.getPartitionColumnStatistics(dbName, tblName, (List)Lists.newArrayList((Object[])new String[]{"p=1", "p=2", "p=3"}), (List)Lists.newArrayList((Object[])new String[]{"s"}), "hive", currentWriteIds);
        Assert.assertEquals((long)3L, (long)stats.size());
        msClient.close();
    }

    @Test
    public void testTxnDynamicPartitions() throws Exception {
        StatsUpdaterThread su = this.createUpdater();
        HiveMetaStoreClient msClient = new HiveMetaStoreClient((Configuration)this.hiveConf);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_STATS_AUTOGATHER, false);
        this.executeQuery("create table simple_stats (s string) partitioned by (i int) stored as orc  TBLPROPERTIES (\"transactional\"=\"true\")");
        this.executeQuery("insert into simple_stats (i, s) values (1, 'test')");
        this.executeQuery("insert into simple_stats (i, s) values (2, 'test2')");
        this.executeQuery("insert into simple_stats (i, s) values (3, 'test3')");
        Assert.assertTrue((boolean)su.runOneIteration());
        this.drainWorkQueue(su);
        this.verifyPartStatsUpToDate(3, 1, (IMetaStoreClient)msClient, "simple_stats", true);
        this.executeQuery("insert into simple_stats (i, s) values (1, 'test12')");
        this.executeQuery("insert into simple_stats (i, s) values (2, 'test22')");
        this.executeQuery("insert into simple_stats (i, s) values (3, 'test32')");
        Assert.assertTrue((boolean)su.runOneIteration());
        this.drainWorkQueue(su);
        this.verifyPartStatsUpToDate(3, 1, (IMetaStoreClient)msClient, "simple_stats", true);
        msClient.close();
    }

    @Test(timeout=80000L)
    public void testExistingOnly() throws Exception {
        this.hiveConf.set(MetastoreConf.ConfVars.STATS_AUTO_UPDATE.getVarname(), "existing");
        StatsUpdaterThread su = this.createUpdater();
        HiveMetaStoreClient msClient = new HiveMetaStoreClient((Configuration)this.hiveConf);
        this.executeQuery("create table simple_stats (i int, s string)");
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_STATS_AUTOGATHER, false);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_STATS_COL_AUTOGATHER, false);
        this.executeQuery("insert into simple_stats (i, s) values (1, 'test')");
        this.executeQuery("analyze table simple_stats compute statistics for columns i");
        this.verifyStatsUpToDate("simple_stats", Lists.newArrayList((Object[])new String[]{"s"}), (IMetaStoreClient)msClient, false);
        this.verifyAndUnsetColStats("simple_stats", Lists.newArrayList((Object[])new String[]{"i"}), (IMetaStoreClient)msClient);
        Assert.assertTrue((boolean)su.runOneIteration());
        this.drainWorkQueue(su);
        this.verifyStatsUpToDate("simple_stats", Lists.newArrayList((Object[])new String[]{"i"}), (IMetaStoreClient)msClient, true);
        this.verifyStatsUpToDate("simple_stats", Lists.newArrayList((Object[])new String[]{"s"}), (IMetaStoreClient)msClient, false);
        msClient.close();
    }

    @Ignore(value="HIVE-25363")
    @Test(timeout=160000L)
    public void testQueueingWithThreads() throws Exception {
        int PART_COUNT = 12;
        this.hiveConf.setInt(MetastoreConf.ConfVars.BATCH_RETRIEVE_MAX.getVarname(), 5);
        this.hiveConf.setInt(MetastoreConf.ConfVars.STATS_AUTO_UPDATE_WORKER_COUNT.getVarname(), 2);
        StatsUpdaterThread su = this.createUpdater();
        su.startWorkers();
        HiveMetaStoreClient msClient = new HiveMetaStoreClient((Configuration)this.hiveConf);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_STATS_AUTOGATHER, false);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_STATS_COL_AUTOGATHER, false);
        this.executeQuery("create table simple_stats (s string) partitioned by (i int)");
        for (int i = 0; i < 12; ++i) {
            this.executeQuery("insert into simple_stats partition(i='" + i + "') values ('test')");
        }
        this.verifyPartStatsUpToDate(12, 0, (IMetaStoreClient)msClient, "simple_stats", false);
        this.setPartitionSkipProperty((IMetaStoreClient)msClient, "simple_stats", "i=0", "true");
        Assert.assertTrue((boolean)su.runOneIteration());
        su.waitForQueuedCommands();
        this.verifyStatsUpToDate("simple_stats", "i=0", Lists.newArrayList((Object[])new String[]{"s"}), (IMetaStoreClient)msClient, false);
        this.verifyPartStatsUpToDate(12, 1, (IMetaStoreClient)msClient, "simple_stats", true);
        Assert.assertFalse((boolean)su.runOneIteration());
        this.drainWorkQueue(su, 0);
        msClient.close();
    }

    @Test(timeout=80000L)
    public void testAllPartitions() throws Exception {
        int PART_COUNT = 3;
        StatsUpdaterThread su = this.createUpdater();
        HiveMetaStoreClient msClient = new HiveMetaStoreClient((Configuration)this.hiveConf);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_STATS_AUTOGATHER, false);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_STATS_COL_AUTOGATHER, false);
        this.executeQuery("create table simple_stats (s string) partitioned by (i int)");
        for (int i = 0; i < 3; ++i) {
            this.executeQuery("insert into simple_stats partition(i='" + i + "') values ('test')");
        }
        this.verifyPartStatsUpToDate(3, 0, (IMetaStoreClient)msClient, "simple_stats", false);
        Assert.assertTrue((boolean)su.runOneIteration());
        this.drainWorkQueue(su, 1);
        this.verifyPartStatsUpToDate(3, 0, (IMetaStoreClient)msClient, "simple_stats", true);
        Assert.assertFalse((boolean)su.runOneIteration());
        this.drainWorkQueue(su, 0);
        msClient.close();
    }

    @Test(timeout=80000L)
    public void testPartitionSubset() throws Exception {
        int NONSTAT_PART_COUNT = 3;
        StatsUpdaterThread su = this.createUpdater();
        HiveMetaStoreClient msClient = new HiveMetaStoreClient((Configuration)this.hiveConf);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_STATS_AUTOGATHER, false);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_STATS_COL_AUTOGATHER, false);
        this.executeQuery("create table simple_stats (s string) partitioned by (i int)");
        for (int i = 0; i < 3; ++i) {
            this.executeQuery("insert into simple_stats partition(i='" + i + "') values ('test')");
        }
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_STATS_AUTOGATHER, true);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_STATS_COL_AUTOGATHER, true);
        this.executeQuery("insert into simple_stats partition(i='3') values ('test')");
        this.verifyPartStatsUpToDate(3, 0, (IMetaStoreClient)msClient, "simple_stats", false);
        this.verifyStatsUpToDate("simple_stats", "i=3", Lists.newArrayList((Object[])new String[]{"s"}), (IMetaStoreClient)msClient, true);
        boolean EXCLUDED_PART = true;
        this.setPartitionSkipProperty((IMetaStoreClient)msClient, "simple_stats", "i=1", "true");
        Assert.assertTrue((boolean)su.runOneIteration());
        this.drainWorkQueue(su, 2);
        for (int i = 0; i < 3; ++i) {
            this.verifyStatsUpToDate("simple_stats", "i=" + i, Lists.newArrayList((Object[])new String[]{"s"}), (IMetaStoreClient)msClient, i != 1);
        }
        this.verifyStatsUpToDate("simple_stats", "i=1", Lists.newArrayList((Object[])new String[]{"s"}), (IMetaStoreClient)msClient, false);
        msClient.close();
    }

    @Test(timeout=80000L)
    public void testPartitionsWithDifferentColsAll() throws Exception {
        StatsUpdaterThread su = this.createUpdater();
        HiveMetaStoreClient msClient = new HiveMetaStoreClient((Configuration)this.hiveConf);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_STATS_AUTOGATHER, false);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_STATS_COL_AUTOGATHER, false);
        this.executeQuery("create table simple_stats (s string, t string, u string) partitioned by (i int)");
        this.executeQuery("insert into simple_stats partition(i=0) values ('test', '0', 'foo')");
        this.executeQuery("insert into simple_stats partition(i=1) values ('test', '1', 'bar')");
        this.executeQuery("analyze table simple_stats partition(i=0) compute statistics for columns s");
        this.executeQuery("analyze table simple_stats partition(i=1) compute statistics for columns s, u");
        this.verifyStatsUpToDate("simple_stats", "i=0", Lists.newArrayList((Object[])new String[]{"s"}), (IMetaStoreClient)msClient, true);
        this.verifyStatsUpToDate("simple_stats", "i=0", Lists.newArrayList((Object[])new String[]{"t", "u"}), (IMetaStoreClient)msClient, false);
        this.verifyStatsUpToDate("simple_stats", "i=1", Lists.newArrayList((Object[])new String[]{"s", "u"}), (IMetaStoreClient)msClient, true);
        this.verifyStatsUpToDate("simple_stats", "i=1", Lists.newArrayList((Object[])new String[]{"t"}), (IMetaStoreClient)msClient, false);
        Assert.assertTrue((boolean)su.runOneIteration());
        this.drainWorkQueue(su, 2);
        this.verifyStatsUpToDate("simple_stats", "i=0", Lists.newArrayList((Object[])new String[]{"s", "t", "u"}), (IMetaStoreClient)msClient, true);
        this.verifyStatsUpToDate("simple_stats", "i=1", Lists.newArrayList((Object[])new String[]{"s", "t", "u"}), (IMetaStoreClient)msClient, true);
        Assert.assertFalse((boolean)su.runOneIteration());
        this.drainWorkQueue(su, 0);
        msClient.close();
    }

    @Test(timeout=80000L)
    public void testPartitionsWithDifferentColsExistingOnly() throws Exception {
        this.hiveConf.set(MetastoreConf.ConfVars.STATS_AUTO_UPDATE.getVarname(), "existing");
        StatsUpdaterThread su = this.createUpdater();
        HiveMetaStoreClient msClient = new HiveMetaStoreClient((Configuration)this.hiveConf);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_STATS_AUTOGATHER, false);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_STATS_COL_AUTOGATHER, false);
        this.executeQuery("create table simple_stats (s string, t string, u string) partitioned by (i int)");
        this.executeQuery("insert into simple_stats partition(i=0) values ('test', '0', 'foo')");
        this.executeQuery("insert into simple_stats partition(i=1) values ('test', '1', 'bar')");
        this.executeQuery("insert into simple_stats partition(i=2) values ('test', '2', 'baz')");
        this.executeQuery("analyze table simple_stats partition(i=0) compute statistics for columns s, t");
        this.executeQuery("analyze table simple_stats partition(i=1) compute statistics for columns");
        this.executeQuery("analyze table simple_stats partition(i=2) compute statistics for columns s");
        this.verifyStatsUpToDate("simple_stats", "i=0", Lists.newArrayList((Object[])new String[]{"s", "t"}), (IMetaStoreClient)msClient, true);
        this.verifyStatsUpToDate("simple_stats", "i=0", Lists.newArrayList((Object[])new String[]{"u"}), (IMetaStoreClient)msClient, false);
        this.verifyStatsUpToDate("simple_stats", "i=1", Lists.newArrayList((Object[])new String[]{"s", "t", "u"}), (IMetaStoreClient)msClient, true);
        this.verifyStatsUpToDate("simple_stats", "i=2", Lists.newArrayList((Object[])new String[]{"s"}), (IMetaStoreClient)msClient, true);
        this.verifyStatsUpToDate("simple_stats", "i=2", Lists.newArrayList((Object[])new String[]{"u", "t"}), (IMetaStoreClient)msClient, false);
        this.verifyAndUnsetColStats("simple_stats", "i=0", Lists.newArrayList((Object[])new String[]{"s"}), (IMetaStoreClient)msClient);
        this.verifyAndUnsetColStats("simple_stats", "i=1", Lists.newArrayList((Object[])new String[]{"t"}), (IMetaStoreClient)msClient);
        Assert.assertTrue((boolean)su.runOneIteration());
        this.drainWorkQueue(su, 2);
        this.verifyStatsUpToDate("simple_stats", "i=0", Lists.newArrayList((Object[])new String[]{"s", "t"}), (IMetaStoreClient)msClient, true);
        this.verifyStatsUpToDate("simple_stats", "i=0", Lists.newArrayList((Object[])new String[]{"u"}), (IMetaStoreClient)msClient, false);
        this.verifyStatsUpToDate("simple_stats", "i=1", Lists.newArrayList((Object[])new String[]{"s", "t", "u"}), (IMetaStoreClient)msClient, true);
        this.verifyStatsUpToDate("simple_stats", "i=2", Lists.newArrayList((Object[])new String[]{"s"}), (IMetaStoreClient)msClient, true);
        this.verifyStatsUpToDate("simple_stats", "i=2", Lists.newArrayList((Object[])new String[]{"u", "t"}), (IMetaStoreClient)msClient, false);
        msClient.close();
    }

    @Test(timeout=80000L)
    public void testParallelOps() throws Exception {
        this.hiveConf.setInt(MetastoreConf.ConfVars.STATS_AUTO_UPDATE_WORKER_COUNT.getVarname(), 4);
        StatsUpdaterThread su = this.createUpdater();
        HiveMetaStoreClient msClient = new HiveMetaStoreClient((Configuration)this.hiveConf);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_STATS_AUTOGATHER, false);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_STATS_COL_AUTOGATHER, false);
        this.executeQuery("create table simple_stats (s string)");
        this.executeQuery("create table simple_stats2 (s string) partitioned by (i int)");
        this.executeQuery("create table simple_stats3 (s string) partitioned by (i int)");
        this.executeQuery("insert into simple_stats values ('test')");
        this.executeQuery("insert into simple_stats2 partition(i=0) values ('test')");
        this.executeQuery("insert into simple_stats3 partition(i=0) values ('test')");
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_STATS_AUTOGATHER, true);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_STATS_COL_AUTOGATHER, true);
        this.executeQuery("insert into simple_stats3 partition(i=1) values ('test')");
        Assert.assertTrue((boolean)su.runOneIteration());
        Assert.assertEquals((long)3L, (long)su.getQueueLength());
        this.verifyStatsUpToDate("simple_stats", Lists.newArrayList((Object[])new String[]{"s"}), (IMetaStoreClient)msClient, false);
        this.verifyPartStatsUpToDate(1, 0, (IMetaStoreClient)msClient, "simple_stats2", false);
        this.verifyStatsUpToDate("simple_stats3", "i=0", Lists.newArrayList((Object[])new String[]{"s"}), (IMetaStoreClient)msClient, false);
        this.verifyStatsUpToDate("simple_stats3", "i=1", Lists.newArrayList((Object[])new String[]{"s"}), (IMetaStoreClient)msClient, true);
        Assert.assertFalse((boolean)su.runOneIteration());
        Assert.assertEquals((long)3L, (long)su.getQueueLength());
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_STATS_AUTOGATHER, false);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_STATS_COL_AUTOGATHER, false);
        this.executeQuery("insert into simple_stats3 partition(i=2) values ('test')");
        Assert.assertTrue((boolean)su.runOneIteration());
        Assert.assertEquals((long)4L, (long)su.getQueueLength());
        this.drainWorkQueue(su, 4);
        this.verifyStatsUpToDate("simple_stats", Lists.newArrayList((Object[])new String[]{"s"}), (IMetaStoreClient)msClient, true);
        this.verifyPartStatsUpToDate(1, 0, (IMetaStoreClient)msClient, "simple_stats2", true);
        this.verifyPartStatsUpToDate(3, 0, (IMetaStoreClient)msClient, "simple_stats3", true);
        Assert.assertFalse((boolean)su.runOneIteration());
        this.drainWorkQueue(su, 0);
        msClient.close();
    }

    @Test(timeout=80000L)
    public void testNoStatsUpdateForSimpleReplTable() throws Exception {
        this.testNoStatsUpdateForReplTable("simple", "");
    }

    @Test(timeout=80000L)
    public void testNoStatsUpdateForTxnReplTable() throws Exception {
        this.testNoStatsUpdateForReplTable("txn", "TBLPROPERTIES (\"transactional\"=\"true\",\"transactional_properties\"=\"insert_only\")");
    }

    private void testNoStatsUpdateForReplTable(String tblNamePrefix, String txnProperty) throws Exception {
        String tblWOStats = tblNamePrefix + "_repl_trgt_nostats";
        String tblWithStats = tblNamePrefix + "_repl_trgt_stats";
        String ptnTblWOStats = tblNamePrefix + "_ptn_repl_trgt_nostats";
        String ptnTblWithStats = tblNamePrefix + "_ptn_repl_trgt_stats";
        String dbName = this.ss.getCurrentDatabase();
        this.executeQuery("alter database " + dbName + " set dbproperties('repl.target.for'='true')");
        StatsUpdaterThread su = this.createUpdater();
        HiveMetaStoreClient msClient = new HiveMetaStoreClient((Configuration)this.hiveConf);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_STATS_AUTOGATHER, false);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_STATS_COL_AUTOGATHER, false);
        this.executeQuery("create table " + tblWOStats + "(i int, s string) " + txnProperty);
        this.executeQuery("insert into " + tblWOStats + "(i, s) values (1, 'test')");
        this.verifyStatsUpToDate(tblWOStats, Lists.newArrayList((Object[])new String[]{"i"}), (IMetaStoreClient)msClient, false);
        this.executeQuery("create table " + ptnTblWOStats + "(s string) partitioned by (i int) " + txnProperty);
        this.executeQuery("insert into " + ptnTblWOStats + "(i, s) values (1, 'test')");
        this.executeQuery("insert into " + ptnTblWOStats + "(i, s) values (2, 'test2')");
        this.executeQuery("insert into " + ptnTblWOStats + "(i, s) values (3, 'test3')");
        this.verifyPartStatsUpToDate(3, 1, (IMetaStoreClient)msClient, ptnTblWOStats, false);
        this.executeQuery("create table " + tblWithStats + "(i int, s string)" + txnProperty);
        this.executeQuery("insert into " + tblWithStats + "(i, s) values (1, 'test')");
        this.executeQuery("analyze table " + tblWithStats + " compute statistics for columns");
        this.verifyStatsUpToDate(tblWithStats, Lists.newArrayList((Object[])new String[]{"i"}), (IMetaStoreClient)msClient, true);
        this.executeQuery("create table " + ptnTblWithStats + "(s string) partitioned by (i int) " + txnProperty);
        this.executeQuery("insert into " + ptnTblWithStats + "(i, s) values (1, 'test')");
        this.executeQuery("insert into " + ptnTblWithStats + "(i, s) values (2, 'test2')");
        this.executeQuery("insert into " + ptnTblWithStats + "(i, s) values (3, 'test3')");
        this.executeQuery("analyze table " + ptnTblWithStats + " compute statistics for columns");
        this.verifyPartStatsUpToDate(3, 1, (IMetaStoreClient)msClient, ptnTblWithStats, true);
        Assert.assertFalse((boolean)su.runOneIteration());
        Assert.assertEquals((long)0L, (long)su.getQueueLength());
        this.executeQuery("alter database " + dbName + " set dbproperties('repl.background.enable'='true')");
        Assert.assertTrue((boolean)su.runOneIteration());
        Assert.assertEquals((long)2L, (long)su.getQueueLength());
        this.drainWorkQueue(su, 2);
        this.verifyStatsUpToDate(tblWOStats, Lists.newArrayList((Object[])new String[]{"i"}), (IMetaStoreClient)msClient, true);
        this.verifyStatsUpToDate(tblWithStats, Lists.newArrayList((Object[])new String[]{"i"}), (IMetaStoreClient)msClient, true);
        this.verifyPartStatsUpToDate(3, 1, (IMetaStoreClient)msClient, ptnTblWOStats, true);
        this.verifyPartStatsUpToDate(3, 1, (IMetaStoreClient)msClient, ptnTblWithStats, true);
        this.executeQuery("alter database " + dbName + " set dbproperties('repl.background.enable'='')");
        this.executeQuery("alter database " + dbName + " set dbproperties('repl.target.for'='')");
        this.executeQuery("drop table " + tblWOStats);
        this.executeQuery("drop table " + tblWithStats);
        this.executeQuery("drop table " + ptnTblWOStats);
        this.executeQuery("drop table " + ptnTblWithStats);
        msClient.close();
    }

    @Test(timeout=80000L)
    public void testNoStatsUpdateForSimpleFailoverDb() throws Exception {
        this.testNoStatsUpdateForFailoverDb("simple", "");
    }

    @Test(timeout=80000L)
    public void testNoStatsUpdateForTxnFailoverDb() throws Exception {
        this.testNoStatsUpdateForFailoverDb("txn", "TBLPROPERTIES (\"transactional\"=\"true\",\"transactional_properties\"=\"insert_only\")");
    }

    private void testNoStatsUpdateForFailoverDb(String tblNamePrefix, String txnProperty) throws Exception {
        this.hiveConf.setInt(MetastoreConf.ConfVars.STATS_AUTO_UPDATE_WORKER_COUNT.getVarname(), 4);
        String tblWOStats = tblNamePrefix + "_repl_failover_nostats";
        String ptnTblWOStats = tblNamePrefix + "_ptn_repl_failover_nostats";
        String newTable = "new_table";
        String dbName = this.ss.getCurrentDatabase();
        StatsUpdaterThread su = this.createUpdater();
        HiveMetaStoreClient msClient = new HiveMetaStoreClient((Configuration)this.hiveConf);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_STATS_AUTOGATHER, false);
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_STATS_COL_AUTOGATHER, false);
        this.executeQuery("create table " + tblWOStats + "(i int, s string) " + txnProperty);
        this.executeQuery("insert into " + tblWOStats + "(i, s) values (1, 'test')");
        this.verifyStatsUpToDate(tblWOStats, Lists.newArrayList((Object[])new String[]{"i"}), (IMetaStoreClient)msClient, false);
        this.executeQuery("create table " + ptnTblWOStats + "(s string) partitioned by (i int) " + txnProperty);
        this.executeQuery("insert into " + ptnTblWOStats + "(i, s) values (1, 'test')");
        this.executeQuery("insert into " + ptnTblWOStats + "(i, s) values (2, 'test2')");
        this.executeQuery("insert into " + ptnTblWOStats + "(i, s) values (3, 'test3')");
        this.verifyPartStatsUpToDate(3, 1, (IMetaStoreClient)msClient, ptnTblWOStats, false);
        Assert.assertTrue((boolean)su.runOneIteration());
        Assert.assertEquals((long)2L, (long)su.getQueueLength());
        this.executeQuery("alter database " + dbName + " set dbproperties('repl.failover.endpoint'='" + MetaStoreUtils.FailoverEndpoint.SOURCE + "')");
        this.drainWorkQueue(su, 2);
        this.verifyStatsUpToDate(tblWOStats, Lists.newArrayList((Object[])new String[]{"i"}), (IMetaStoreClient)msClient, false);
        this.verifyPartStatsUpToDate(3, 1, (IMetaStoreClient)msClient, ptnTblWOStats, false);
        Assert.assertEquals((long)0L, (long)su.getQueueLength());
        this.executeQuery("create table " + newTable + "(i int, s string) " + txnProperty);
        this.executeQuery("insert into " + newTable + "(i, s) values (4, 'test4')");
        Assert.assertFalse((boolean)su.runOneIteration());
        Assert.assertEquals((long)0L, (long)su.getQueueLength());
        this.verifyStatsUpToDate(tblWOStats, Lists.newArrayList((Object[])new String[]{"i"}), (IMetaStoreClient)msClient, false);
        this.verifyPartStatsUpToDate(3, 1, (IMetaStoreClient)msClient, ptnTblWOStats, false);
        this.executeQuery("alter database " + dbName + " set dbproperties('repl.failover.endpoint'='')");
        Assert.assertTrue((boolean)su.runOneIteration());
        Assert.assertEquals((long)3L, (long)su.getQueueLength());
        this.drainWorkQueue(su, 3);
        this.verifyStatsUpToDate(newTable, Lists.newArrayList((Object[])new String[]{"i"}), (IMetaStoreClient)msClient, true);
        this.verifyStatsUpToDate(tblWOStats, Lists.newArrayList((Object[])new String[]{"i"}), (IMetaStoreClient)msClient, true);
        this.verifyPartStatsUpToDate(3, 1, (IMetaStoreClient)msClient, ptnTblWOStats, true);
        this.executeQuery("drop table " + tblWOStats);
        this.executeQuery("drop table " + ptnTblWOStats);
        this.executeQuery("drop table " + newTable);
        msClient.close();
    }

    private void verifyPartStatsUpToDate(int partCount, int skip, IMetaStoreClient msClient, String tbl, boolean isUpToDate) throws Exception {
        for (int i = skip; i < partCount; ++i) {
            this.verifyStatsUpToDate(tbl, "i=" + i, Lists.newArrayList((Object[])new String[]{"s"}), msClient, isUpToDate);
        }
    }

    private void drainWorkQueue(StatsUpdaterThread su) throws InterruptedException {
        while (su.runOneWorkerIteration(this.ss, this.ss.getUserName(), this.ss.getConf(), false)) {
        }
    }

    private void drainWorkQueue(StatsUpdaterThread su, int expectedReqs) throws InterruptedException {
        int actualReqs = 0;
        while (su.runOneWorkerIteration(this.ss, this.ss.getUserName(), this.ss.getConf(), false)) {
            ++actualReqs;
        }
        Assert.assertEquals((long)expectedReqs, (long)actualReqs);
    }

    private void setTableSkipProperty(IMetaStoreClient msClient, String tbl, String val) throws Exception {
        Table table = msClient.getTable(this.ss.getCurrentDatabase(), tbl);
        table.getParameters().put("skip.stats.autoupdate", val);
        msClient.alter_table(table.getDbName(), table.getTableName(), table);
    }

    private void setPartitionSkipProperty(IMetaStoreClient msClient, String tblName, String partName, String val) throws Exception {
        Partition part = msClient.getPartition(this.ss.getCurrentDatabase(), tblName, partName);
        part.getParameters().put("skip.stats.autoupdate", val);
        msClient.alter_partition(part.getCatName(), part.getDbName(), tblName, part);
    }

    private void verifyAndUnsetColStats(String tblName, List<String> cols, IMetaStoreClient msClient) throws Exception {
        Table tbl = msClient.getTable(this.ss.getCurrentDatabase(), tblName);
        this.verifyAndUnsetColStatsVal(tbl.getParameters(), cols);
        EnvironmentContext ec = new EnvironmentContext();
        ec.putToProperties("DO_NOT_UPDATE_STATS", "true");
        msClient.alter_table_with_environmentContext(tbl.getDbName(), tbl.getTableName(), tbl, ec);
        tbl = msClient.getTable(this.ss.getCurrentDatabase(), tblName);
        for (String col : cols) {
            Assert.assertFalse((boolean)StatsSetupConst.areColumnStatsUptoDate((Map)tbl.getParameters(), (String)col));
        }
    }

    private void verifyAndUnsetColStatsVal(Map<String, String> params, List<String> cols) {
        Assert.assertTrue((boolean)StatsSetupConst.areBasicStatsUptoDate(params));
        for (String col : cols) {
            Assert.assertTrue((boolean)StatsSetupConst.areColumnStatsUptoDate(params, (String)col));
        }
        StatsSetupConst.removeColumnStatsState(params, cols);
        StatsSetupConst.setBasicStatsState(params, (String)"true");
    }

    private void verifyAndUnsetColStats(String tblName, String partName, List<String> cols, IMetaStoreClient msClient) throws Exception {
        Partition part = msClient.getPartition(this.ss.getCurrentDatabase(), tblName, partName);
        this.verifyAndUnsetColStatsVal(part.getParameters(), cols);
        EnvironmentContext ec = new EnvironmentContext();
        ec.putToProperties("DO_NOT_UPDATE_STATS", "true");
        msClient.alter_partition(part.getCatName(), part.getDbName(), tblName, part, ec);
        part = msClient.getPartition(this.ss.getCurrentDatabase(), tblName, partName);
        for (String col : cols) {
            Assert.assertFalse((boolean)StatsSetupConst.areColumnStatsUptoDate((Map)part.getParameters(), (String)col));
        }
    }

    private void verifyStatsUpToDate(String tbl, List<String> cols, IMetaStoreClient msClient, boolean isUpToDate) throws Exception {
        Table table = msClient.getTable(this.ss.getCurrentDatabase(), tbl);
        this.verifyStatsUpToDate(table.getParameters(), cols, isUpToDate);
    }

    private void verifyStatsUpToDate(String tbl, List<String> cols, IMetaStoreClient msClient, String validWriteIds, boolean isUpToDate) throws Exception {
        Table table = msClient.getTable(this.ss.getCurrentCatalog(), this.ss.getCurrentDatabase(), tbl, validWriteIds);
        this.verifyStatsUpToDate(table.getParameters(), cols, isUpToDate);
    }

    private void verifyStatsUpToDate(Map<String, String> params, List<String> cols, boolean isUpToDate) {
        if (isUpToDate) {
            Assert.assertTrue((boolean)StatsSetupConst.areBasicStatsUptoDate(params));
        }
        for (String col : cols) {
            Assert.assertEquals((Object)isUpToDate, (Object)StatsSetupConst.areColumnStatsUptoDate(params, (String)col));
        }
    }

    private void verifyStatsUpToDate(String tbl, String part, ArrayList<String> cols, IMetaStoreClient msClient, boolean isUpToDate) throws Exception {
        Partition partition = msClient.getPartition(this.ss.getCurrentDatabase(), tbl, part);
        this.verifyStatsUpToDate(partition.getParameters(), cols, isUpToDate);
    }

    private void executeQuery(String query) throws HiveException {
        DriverUtils.runOnDriver((HiveConf)this.hiveConf, (SessionState)this.ss, (String)query);
    }

    private StatsUpdaterThread createUpdater() throws MetaException {
        StatsUpdaterThread su = new StatsUpdaterThread();
        su.setConf((Configuration)this.hiveConf);
        su.init(new AtomicBoolean(false));
        return su;
    }
}

