/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.stats;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.ql.plan.Statistics;
import org.apache.hadoop.hive.ql.stats.BasicStats;
import org.apache.hadoop.hive.ql.stats.Partish;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mockito;

public class TestBasicStats {
    @Test
    public void testDataSizeEstimator() {
        Partish p1 = new LocalPartishBuilder().totalSize(10).buildPartition();
        HiveConf conf = new HiveConf();
        conf.setFloatVar(HiveConf.ConfVars.HIVE_STATS_DESERIALIZATION_FACTOR, 13.0f);
        BasicStats.Factory factory = new BasicStats.Factory(new BasicStats.IStatsEnhancer[]{new BasicStats.DataSizeEstimator(conf)});
        BasicStats res = factory.build(p1);
        Assert.assertEquals((long)130L, (long)res.getDataSize());
    }

    @Test
    public void mergeWithEmpty() {
        HiveConf conf = new HiveConf();
        int avgRowSize = 100;
        int r0 = 13;
        int r1 = 15;
        int deserFactor = (int)conf.getFloatVar(HiveConf.ConfVars.HIVE_STATS_DESERIALIZATION_FACTOR);
        Partish p0 = new LocalPartishBuilder().numRows(r0).rawDataSize(avgRowSize * r0).buildPartition();
        Partish p1 = new LocalPartishBuilder().totalSize(r1 * avgRowSize / deserFactor).buildPartition();
        BasicStats.Factory factory = new BasicStats.Factory(new BasicStats.IStatsEnhancer[]{new BasicStats.DataSizeEstimator(conf), new BasicStats.RowNumEstimator((long)avgRowSize)});
        BasicStats bs0 = factory.build(p0);
        BasicStats bs1 = factory.build(p1);
        BasicStats res = BasicStats.buildFrom((List)Lists.newArrayList((Object[])new BasicStats[]{bs0, bs1}));
        Assert.assertEquals((long)(r0 + r1), (long)res.getNumRows());
        Assert.assertEquals((long)(avgRowSize * (r0 + r1)), (long)res.getDataSize());
    }

    @Test
    @Ignore(value="HIVE-18062 will fix this")
    public void mergedKeepsPartialStateEvenIfValuesAreSuccessfullyEstimated() {
        Partish p0 = new LocalPartishBuilder().numRows(10).rawDataSize(100).buildPartition();
        Partish p1 = new LocalPartishBuilder().totalSize(10).buildPartition();
        HiveConf conf = new HiveConf();
        BasicStats.Factory factory = new BasicStats.Factory(new BasicStats.IStatsEnhancer[]{new BasicStats.DataSizeEstimator(conf), new BasicStats.RowNumEstimator(10L)});
        BasicStats bs0 = factory.build(p0);
        BasicStats bs1 = factory.build(p1);
        BasicStats res = BasicStats.buildFrom((List)Lists.newArrayList((Object[])new BasicStats[]{bs0, bs1}));
        Assert.assertEquals((Object)Statistics.State.PARTIAL, (Object)res.getState());
    }

    public static class LocalPartishBuilder {
        Map<String, String> params = new HashMap<String, String>();

        public LocalPartishBuilder numRows(int i) {
            this.params.put("numRows", String.valueOf(i));
            return this;
        }

        public LocalPartishBuilder rawDataSize(int i) {
            this.params.put("rawDataSize", String.valueOf(i));
            return this;
        }

        public LocalPartishBuilder totalSize(int i) {
            this.params.put("totalSize", String.valueOf(i));
            return this;
        }

        public Partish buildPartition() {
            org.apache.hadoop.hive.ql.metadata.Partition partition = (org.apache.hadoop.hive.ql.metadata.Partition)Mockito.mock(org.apache.hadoop.hive.ql.metadata.Partition.class);
            Partition tpartition = (Partition)Mockito.mock(Partition.class);
            ((org.apache.hadoop.hive.ql.metadata.Partition)Mockito.doReturn((Object)tpartition).when((Object)partition)).getTPartition();
            ((Partition)Mockito.doReturn(this.params).when((Object)tpartition)).getParameters();
            return Partish.buildFor(null, (org.apache.hadoop.hive.ql.metadata.Partition)partition);
        }
    }
}

