/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd;

import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.security.HadoopDefaultAuthenticator;
import org.apache.hadoop.hive.ql.security.HiveAuthenticationProvider;
import org.apache.hadoop.hive.ql.security.authorization.plugin.DisallowTransformHook;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthorizer;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzPluginException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzSessionContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAccessController;
import org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory;
import org.junit.Assert;
import org.junit.Test;

public class TestSQLStdHiveAccessControllerCLI {
    @Test
    public void testConfigProcessing() throws HiveAuthzPluginException {
        HiveConf processedConf = new HiveConf();
        SQLStdHiveAccessController accessController = new SQLStdHiveAccessController(null, processedConf, (HiveAuthenticationProvider)new HadoopDefaultAuthenticator(), this.getCLISessionCtx());
        accessController.applyAuthorizationConfigPolicy(processedConf);
        Assert.assertFalse((String)"Check for transform query disabling hook", (boolean)processedConf.getVar(HiveConf.ConfVars.PRE_EXEC_HOOKS).contains(DisallowTransformHook.class.getName()));
        processedConf.verifyAndSet("dummy.param", "dummy.val");
        processedConf.verifyAndSet(HiveConf.ConfVars.HIVE_AUTHORIZATION_ENABLED.varname, "true");
    }

    private HiveAuthzSessionContext getCLISessionCtx() {
        HiveAuthzSessionContext.Builder ctxBuilder = new HiveAuthzSessionContext.Builder();
        ctxBuilder.setClientType(HiveAuthzSessionContext.CLIENT_TYPE.HIVECLI);
        return ctxBuilder.build();
    }

    @Test
    public void testAuthEnable() throws Exception {
        HiveConf processedConf = new HiveConf();
        processedConf.setBoolVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_ENABLED, true);
        SQLStdHiveAuthorizerFactory authorizerFactory = new SQLStdHiveAuthorizerFactory();
        HiveAuthorizer authorizer = authorizerFactory.createHiveAuthorizer(null, processedConf, (HiveAuthenticationProvider)new HadoopDefaultAuthenticator(), this.getCLISessionCtx());
    }
}

