/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.plugin.metastore;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObjectUtils;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.TestHiveMetaStoreAuthorizer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Assert;
import org.junit.Test;

public class TestTablePermissionFilterAlgos {
    private static final Logger LOGGER = LogManager.getLogger(TestHiveMetaStoreAuthorizer.class);
    private static final boolean TEST = true;
    private static final boolean SHUFFLE_TABLENAMES = false;
    private static final int NUM_DB = 2;
    private static final int NUM_TBL = 100;
    private static final int NLOOPS = 1;
    private final List<TestTable> tables = TestTablePermissionFilterAlgos.createTables(2, 100);
    private final List<TestTable> filtered = this.tables.stream().filter(t -> t.getTableName().endsWith("0")).collect(Collectors.toList());

    private static List<TestTable> createTables(int dbs, int tbls) {
        Random rnd = new Random(20230815L);
        ArrayList<Integer> dbis = new ArrayList<Integer>(dbs);
        for (int i = 0; i < dbs; ++i) {
            dbis.add(i);
        }
        Collections.shuffle(dbis, rnd);
        ArrayList<Integer> tblis = new ArrayList<Integer>(tbls);
        for (int i = 0; i < tbls; ++i) {
            tblis.add(i);
        }
        ArrayList<TestTable> tables = new ArrayList<TestTable>(dbs * tbls);
        Iterator iterator = dbis.iterator();
        while (iterator.hasNext()) {
            int d = (Integer)iterator.next();
            Iterator iterator2 = tblis.iterator();
            while (iterator2.hasNext()) {
                int t = (Integer)iterator2.next();
                String dbname = String.format("db%05x", d);
                String tblName = String.format("tbl%05x", t);
                tables.add(new TestTable(dbname, tblName));
            }
        }
        return tables;
    }

    @Test
    public void testIndexedLookup() {
        System.gc();
        Chrono chrono = new Chrono();
        chrono.start();
        int cnt = 0;
        for (int l = 0; l < 1; ++l) {
            TestLookup index = new TestLookup(this.tables);
            List<TestTable> tts = l % 2 == 1 ? this.tables : this.filtered;
            cnt = 0;
            for (TestTable tt : tts) {
                if (!index.contains(tt)) continue;
                ++cnt;
            }
            Assert.assertEquals((long)cnt, (long)tts.size());
        }
        chrono.stop();
        LOGGER.info("lookup elapse " + chrono.elapse());
    }

    private static ImmutablePair<String, String> tableKey(TestTable tt) {
        return new ImmutablePair((Object)tt.getDbName(), (Object)tt.getTableName());
    }

    @Test
    public void testKeyPairLookup() {
        System.gc();
        Chrono chrono = new Chrono();
        chrono.start();
        for (int l = 0; l < 1; ++l) {
            Set index = this.tables.stream().map(TestTablePermissionFilterAlgos::tableKey).collect(Collectors.toSet());
            List<TestTable> tts = l % 2 == 1 ? this.tables : this.filtered;
            int cnt = 0;
            for (TestTable tt : tts) {
                if (!index.contains(TestTablePermissionFilterAlgos.tableKey(tt))) continue;
                ++cnt;
            }
            Assert.assertEquals((long)cnt, (long)tts.size());
        }
        chrono.stop();
        LOGGER.info("set pair elapse " + chrono.elapse());
    }

    @Test
    public void testTestTableLookup() {
        System.gc();
        Chrono chrono = new Chrono();
        chrono.start();
        for (int l = 0; l < 1; ++l) {
            HashSet<TestTable> index = new HashSet<TestTable>(this.tables);
            List<TestTable> tts = l % 2 == 1 ? this.tables : this.filtered;
            int cnt = 0;
            for (TestTable tt : tts) {
                if (!index.contains(tt)) continue;
                ++cnt;
            }
            Assert.assertEquals((long)cnt, (long)tts.size());
        }
        chrono.stop();
        LOGGER.info("set table elapse " + chrono.elapse());
    }

    private static String tableFullName(TestTable tt) {
        return tt.getDbName() + "." + tt.getTableName();
    }

    @Test
    public void testFullNameLookup() {
        System.gc();
        Chrono chrono = new Chrono();
        chrono.start();
        for (int l = 0; l < 1; ++l) {
            Set index = this.tables.stream().map(TestTablePermissionFilterAlgos::tableFullName).collect(Collectors.toSet());
            List<TestTable> tts = l % 2 == 1 ? this.tables : this.filtered;
            int cnt = 0;
            for (TestTable tt : tts) {
                if (!index.contains(TestTablePermissionFilterAlgos.tableFullName(tt))) continue;
                ++cnt;
            }
            Assert.assertEquals((long)cnt, (long)tts.size());
        }
        chrono.stop();
        LOGGER.info("set fullname elapse " + chrono.elapse());
    }

    private static class TestTable {
        private int hashCode = -1;
        private final String dbName;
        private final String tableName;

        private TestTable(String dbName, String tableName) {
            this.dbName = dbName;
            this.tableName = tableName;
        }

        public String toString() {
            return TestTablePermissionFilterAlgos.tableFullName(this);
        }

        public String getDbName() {
            return this.dbName;
        }

        public String getTableName() {
            return this.tableName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof TestTable) {
                TestTable tt = (TestTable)o;
                return this.dbName.equals(tt.dbName) && this.tableName.equals(tt.tableName);
            }
            return false;
        }

        public int hashCode() {
            int h = this.hashCode;
            if (h < 0) {
                this.hashCode = h = Math.abs(31 * this.dbName.hashCode() + this.tableName.hashCode());
            }
            return h;
        }
    }

    static class Chrono {
        long start;
        long end;

        Chrono() {
        }

        void start() {
            this.start = System.currentTimeMillis();
        }

        void stop() {
            this.end = System.currentTimeMillis();
        }

        String elapse() {
            return String.format("%.3f", (double)(this.end - this.start) / 1000.0);
        }
    }

    private static class TestLookup
    extends HivePrivilegeObjectUtils.TableLookup<TestTable> {
        protected TestLookup(List<TestTable> tables) {
            super(tables);
        }

        protected String getDbName(TestTable o) {
            return o.getDbName();
        }

        protected String getTableName(TestTable o) {
            return o.getTableName();
        }
    }
}

