/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.plugin.metastore;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HMSHandler;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.ObjectStore;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AlterDataConnectorRequest;
import org.apache.hadoop.hive.metastore.api.Catalog;
import org.apache.hadoop.hive.metastore.api.CreateCatalogRequest;
import org.apache.hadoop.hive.metastore.api.CreateDataConnectorRequest;
import org.apache.hadoop.hive.metastore.api.DataConnector;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.DropCatalogRequest;
import org.apache.hadoop.hive.metastore.api.DropDataConnectorRequest;
import org.apache.hadoop.hive.metastore.api.GetDatabaseObjectsRequest;
import org.apache.hadoop.hive.metastore.api.GetDatabaseObjectsResponse;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.Role;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TableMeta;
import org.apache.hadoop.hive.metastore.client.builder.CatalogBuilder;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.client.builder.RoleBuilder;
import org.apache.hadoop.hive.metastore.client.builder.TableBuilder;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.events.PreEventContext;
import org.apache.hadoop.hive.ql.security.HadoopDefaultMetastoreAuthenticator;
import org.apache.hadoop.hive.ql.security.HiveAuthenticationProvider;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAccessControlException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthorizer;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthorizerFactory;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzPluginException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzSessionContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveMetastoreClientFactory;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.HiveMetaStoreAuthorizer;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.HiveMetaStoreAuthzInfo;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.MockMetaStoreOwnerFilterHook;
import org.apache.hadoop.hive.ql.security.authorization.plugin.metastore.filtercontext.TableFilterContext;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Assert;
import org.junit.Before;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestHiveMetaStoreAuthorizer {
    private static final String dbName = "test";
    private static final String tblName = "tmptbl";
    private static final String viewName = "tmpview";
    private static final String roleName = "tmpRole";
    private static final String catalogName = "testCatalog";
    private static final String dcName = "testDC";
    private static final String unAuthorizedUser = "bob";
    static final String authorizedUser = "sam";
    private static final String superUser = "hive";
    private static final String default_db = "default";
    private static final String metaConfVal = "";
    private static final String TEST_DATA_DIR = new File("file:///testdata").getPath();
    private RawStore rawStore;
    private Configuration conf;
    private HMSHandler hmsHandler;
    static HiveAuthorizer mockHiveAuthorizer;
    static final List<String> allowedUsers;

    @Before
    public void setUp() throws Exception {
        this.conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_IN_TEST, (boolean)true);
        MetastoreConf.setBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_TXN_STATS_ENABLED, (boolean)true);
        MetastoreConf.setBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.AGGREGATE_STATS_CACHE_ENABLED, (boolean)false);
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.PARTITION_NAME_WHITELIST_PATTERN, (String)metaConfVal);
        MetastoreConf.setLongVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_CONNECTION_RETRIES, (long)3L);
        MetastoreConf.setBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, (boolean)false);
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, (String)MockHiveAuthorizerFactory.class.getName());
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.PRE_EVENT_LISTENERS, (String)HiveMetaStoreAuthorizer.class.getName());
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_METASTORE_AUTHENTICATOR_MANAGER, (String)HadoopDefaultMetastoreAuthenticator.class.getName());
        MetastoreConf.setVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.FILTER_HOOK, (String)MockMetaStoreOwnerFilterHook.class.getName());
        this.conf.set("hadoop.proxyuser.hive.groups", "*");
        this.conf.set("hadoop.proxyuser.hive.hosts", "*");
        this.conf.set("hadoop.proxyuser.hive.users", "*");
        MetaStoreTestUtils.setConfForStandloneMode((Configuration)this.conf);
        this.hmsHandler = new HMSHandler(dbName, this.conf);
        this.hmsHandler.init();
        this.rawStore = new ObjectStore();
        this.rawStore.setConf(this.hmsHandler.getConf());
        HMSHandler.createDefaultCatalog((RawStore)this.rawStore, (Warehouse)new Warehouse(this.conf));
        try {
            DropDataConnectorRequest dropDcReq = new DropDataConnectorRequest(dcName);
            dropDcReq.setIfNotExists(true);
            dropDcReq.setCheckReferences(true);
            this.hmsHandler.drop_dataconnector_req(dropDcReq);
            this.hmsHandler.drop_table(dbName, tblName, true);
            this.hmsHandler.drop_database(dbName, true, false);
            this.hmsHandler.drop_catalog(new DropCatalogRequest(catalogName));
            FileUtils.deleteDirectory((File)new File(TEST_DATA_DIR));
        }
        catch (Exception exception) {
            // empty catch block
        }
        mockHiveAuthorizer = (HiveAuthorizer)Mockito.mock(HiveAuthorizer.class);
        TestHiveMetaStoreAuthorizer.configureMockAuthorizer();
    }

    private static void configureMockAuthorizer() throws HiveAuthzPluginException, HiveAccessControlException {
        ((HiveAuthorizer)Mockito.doAnswer(invocation -> {
            String user;
            HiveOperationType opType = (HiveOperationType)invocation.getArgument(0);
            try {
                user = UserGroupInformation.getLoginUser().getShortUserName();
            }
            catch (Exception e) {
                throw new HiveAuthzPluginException("Unable to get UserGroupInformation");
            }
            if (!allowedUsers.contains(user) && !user.equals(superUser)) {
                throw new HiveAuthzPluginException("Operation type " + opType + " not allowed for user:" + user);
            }
            return null;
        }).when((Object)mockHiveAuthorizer)).checkPrivileges((HiveOperationType)ArgumentMatchers.any(HiveOperationType.class), (List)ArgumentMatchers.any(), (List)ArgumentMatchers.any(), (HiveAuthzContext)ArgumentMatchers.any(HiveAuthzContext.class));
    }

    private Pair<List<HivePrivilegeObject>, List<HivePrivilegeObject>> getHivePrivilegeObjectsFromLastCall() throws HiveAuthzPluginException, HiveAccessControlException {
        Class<List> class_listPrivObjects = List.class;
        ArgumentCaptor inputsCapturer = ArgumentCaptor.forClass(class_listPrivObjects);
        ArgumentCaptor outputsCapturer = ArgumentCaptor.forClass(class_listPrivObjects);
        ((HiveAuthorizer)Mockito.verify((Object)mockHiveAuthorizer)).checkPrivileges((HiveOperationType)ArgumentMatchers.any(HiveOperationType.class), (List)inputsCapturer.capture(), (List)outputsCapturer.capture(), (HiveAuthzContext)ArgumentMatchers.any(HiveAuthzContext.class));
        return new ImmutablePair((Object)((List)inputsCapturer.getValue()), (Object)((List)outputsCapturer.getValue()));
    }

    @Test
    public void testA_CreateDatabase_unAuthorizedUser() throws Exception {
        UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createRemoteUser((String)unAuthorizedUser));
        try {
            Database db = new DatabaseBuilder().setName(dbName).build(this.conf);
            this.hmsHandler.create_database(db);
        }
        catch (Exception e) {
            String err = e.getMessage();
            String expected = "Operation type " + HiveOperationType.CREATEDATABASE + " not allowed for user:bob";
            Assert.assertEquals((Object)expected, (Object)err);
        }
    }

    @Test
    public void testB_CreateTable_unAuthorizedUser() throws Exception {
        UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createRemoteUser((String)unAuthorizedUser));
        try {
            Table table = ((TableBuilder)new TableBuilder().setTableName(tblName).addCol("name", "string")).setOwner(unAuthorizedUser).build(this.conf);
            this.hmsHandler.create_table(table);
        }
        catch (Exception e) {
            String err = e.getMessage();
            String expected = "Operation type " + HiveOperationType.CREATETABLE + " not allowed for user:bob";
            Assert.assertEquals((Object)expected, (Object)err);
        }
    }

    @Test
    public void testC_CreateView_anyUser() throws Exception {
        UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createRemoteUser((String)authorizedUser));
        try {
            Table viewObj = ((TableBuilder)new TableBuilder().setTableName(viewName).setType(TableType.VIRTUAL_VIEW.name()).addCol("name", "string")).setOwner(authorizedUser).build(this.conf);
            this.hmsHandler.create_table(viewObj);
            Map params = viewObj.getParameters();
            Assert.assertTrue((boolean)params.containsKey("Authorized"));
            Assert.assertTrue((boolean)"false".equalsIgnoreCase((String)params.get("Authorized")));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testC2_AlterView_anyUser() throws Exception {
        UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createRemoteUser((String)authorizedUser));
        try {
            Table viewObj = ((TableBuilder)new TableBuilder().setTableName(viewName).setType(TableType.VIRTUAL_VIEW.name()).addCol("name", "string")).setOwner(authorizedUser).build(this.conf);
            this.hmsHandler.create_table(viewObj);
            viewObj = ((TableBuilder)new TableBuilder().setTableName(viewName).setType(TableType.VIRTUAL_VIEW.name()).addCol("dep", "string")).setOwner(authorizedUser).build(this.conf);
            this.hmsHandler.alter_table(default_db, viewName, viewObj);
            Map params = viewObj.getParameters();
            Assert.assertTrue((boolean)params.containsKey("Authorized"));
            Assert.assertTrue((boolean)"false".equalsIgnoreCase((String)params.get("Authorized")));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testD_CreateView_SuperUser() throws Exception {
        UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createRemoteUser((String)superUser));
        try {
            Table viewObj = ((TableBuilder)new TableBuilder().setTableName(viewName).setType(TableType.VIRTUAL_VIEW.name()).addCol("name", "string")).build(this.conf);
            this.hmsHandler.create_table(viewObj);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testE_CreateRole__anyUser() throws Exception {
        UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createRemoteUser((String)authorizedUser));
        try {
            Role role = new RoleBuilder().setRoleName(roleName).setOwnerName(authorizedUser).build();
            this.hmsHandler.create_role(role);
        }
        catch (Exception e) {
            String err = e.getMessage();
            String expected = "Operation type " + PreEventContext.PreEventType.AUTHORIZATION_API_CALL.name() + " not allowed for user:sam";
            Assert.assertEquals((Object)expected, (Object)err);
        }
    }

    @Test
    public void testF_CreateCatalog_anyUser() throws Exception {
        UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createRemoteUser((String)authorizedUser));
        try {
            Catalog catalog = new CatalogBuilder().setName(catalogName).setLocation(TEST_DATA_DIR).build();
            this.hmsHandler.create_catalog(new CreateCatalogRequest(catalog));
        }
        catch (Exception e) {
            String err = e.getMessage();
            String expected = "Operation type " + PreEventContext.PreEventType.CREATE_CATALOG.name() + " not allowed for user:sam";
            Assert.assertEquals((Object)expected, (Object)err);
        }
    }

    @Test
    public void testG_CreateCatalog_SuperUser() throws Exception {
        UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createRemoteUser((String)superUser));
        try {
            Catalog catalog = new CatalogBuilder().setName(catalogName).setLocation(TEST_DATA_DIR).build();
            this.hmsHandler.create_catalog(new CreateCatalogRequest(catalog));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testH_CreateDatabase_authorizedUser() throws Exception {
        UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createRemoteUser((String)authorizedUser));
        try {
            Database db = new DatabaseBuilder().setName(dbName).setOwnerName(authorizedUser).setOwnerType(PrincipalType.USER).build(this.conf);
            this.hmsHandler.create_database(db);
            Pair<List<HivePrivilegeObject>, List<HivePrivilegeObject>> io = this.getHivePrivilegeObjectsFromLastCall();
            List outputs = (List)io.getRight();
            Assert.assertEquals((String)"Should have one output for create database", (long)1L, (long)outputs.size());
            HivePrivilegeObject dbObj = (HivePrivilegeObject)outputs.get(0);
            Assert.assertEquals((String)"Output object should be a database", (Object)HivePrivilegeObject.HivePrivilegeObjectType.DATABASE, (Object)dbObj.getType());
        }
        catch (Exception e) {
            Assert.fail((String)("Authorized user should be allowed to create database: " + e.getMessage()));
        }
    }

    @Test
    public void testI_CreateTable_authorizedUser() throws Exception {
        UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createRemoteUser((String)authorizedUser));
        try {
            Table table = ((TableBuilder)new TableBuilder().setTableName(tblName).addCol("name", "string")).setOwner(authorizedUser).build(this.conf);
            this.hmsHandler.create_table(table);
            Pair<List<HivePrivilegeObject>, List<HivePrivilegeObject>> io = this.getHivePrivilegeObjectsFromLastCall();
            List outputs = (List)io.getRight();
            List tableOutputs = outputs.stream().filter(o -> o.getType() == HivePrivilegeObject.HivePrivilegeObjectType.TABLE_OR_VIEW).collect(Collectors.toList());
            Assert.assertEquals((String)"Should have exactly one table output for create table", (long)1L, (long)tableOutputs.size());
            HivePrivilegeObject tableObj = (HivePrivilegeObject)tableOutputs.get(0);
            Assert.assertEquals((String)"Output object should be a table", (Object)HivePrivilegeObject.HivePrivilegeObjectType.TABLE_OR_VIEW, (Object)tableObj.getType());
        }
        catch (Exception e) {
            Assert.fail((String)("Authorized user should be allowed to create table: " + e.getMessage()));
        }
    }

    @Test
    public void testJ_AlterTable_AuthorizedUser() throws Exception {
        UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createRemoteUser((String)authorizedUser));
        try {
            Table table = ((TableBuilder)new TableBuilder().setTableName(tblName).addCol("name", "string")).setOwner(authorizedUser).build(this.conf);
            this.hmsHandler.create_table(table);
            Table alteredTable = ((TableBuilder)new TableBuilder().addCol("dep", "string")).build(this.conf);
            this.hmsHandler.alter_table(default_db, tblName, alteredTable);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testK_DropTable_authorizedUser() throws Exception {
        UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createRemoteUser((String)authorizedUser));
        try {
            this.hmsHandler.drop_table(dbName, tblName, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testL_DropDatabase_authorizedUser() throws Exception {
        UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createRemoteUser((String)authorizedUser));
        try {
            this.hmsHandler.drop_database(dbName, true, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testM_DropCatalog_SuperUser() throws Exception {
        UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createRemoteUser((String)superUser));
        try {
            this.hmsHandler.drop_catalog(new DropCatalogRequest(catalogName));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testNShowDatabaseAuthorizedUser() throws Exception {
        UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createRemoteUser((String)authorizedUser));
        try {
            this.hmsHandler.get_all_databases();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testOShowDatabaseUnauthorizedUser() throws Exception {
        UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createRemoteUser((String)unAuthorizedUser));
        try {
            this.hmsHandler.get_all_databases();
        }
        catch (Exception e) {
            String err = e.getMessage();
            if (StringUtils.isNotEmpty((CharSequence)err)) {
                // empty if block
            }
        }
    }

    @Test
    public void testPShowTablesAuthorizedUser() throws Exception {
        UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createRemoteUser((String)authorizedUser));
        try {
            this.hmsHandler.get_all_tables(default_db);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testQShowTablesUnauthorizedUser() throws Exception {
        UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createRemoteUser((String)unAuthorizedUser));
        try {
            this.hmsHandler.get_all_tables(default_db);
        }
        catch (Exception e) {
            String err = e.getMessage();
            if (StringUtils.isNotEmpty((CharSequence)err)) {
                // empty if block
            }
        }
    }

    @Test
    public void testGetDatabaseObjects_UnauthorizedUser() throws Exception {
        UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createRemoteUser((String)unAuthorizedUser));
        try {
            Database db = new DatabaseBuilder().setName(dbName).build(this.conf);
            this.hmsHandler.create_database(db);
            GetDatabaseObjectsRequest request = new GetDatabaseObjectsRequest();
            request.setCatalogName(superUser);
            this.hmsHandler.get_databases_req(request);
        }
        catch (Exception e) {
            String err = e.getMessage();
            Assert.assertTrue((String)"Exception message should contain operation type", (err.contains("Operation type") && err.contains("not allowed for user:bob") ? 1 : 0) != 0);
        }
        finally {
            UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createRemoteUser((String)superUser));
            try {
                this.hmsHandler.drop_database(dbName, true, false);
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetDatabaseObjects_AuthorizedUser() throws Exception {
        UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createRemoteUser((String)authorizedUser));
        try {
            Database db = new DatabaseBuilder().setName(dbName).setOwnerName(authorizedUser).build(this.conf);
            this.hmsHandler.create_database(db);
            GetDatabaseObjectsRequest request = new GetDatabaseObjectsRequest();
            request.setCatalogName(superUser);
            GetDatabaseObjectsResponse response = this.hmsHandler.get_databases_req(request);
            Assert.assertNotNull((String)"Response should not be null", (Object)response);
            Assert.assertNotNull((String)"Databases list should not be null", (Object)response.getDatabases());
            Assert.assertTrue((String)"Should find the created database", (boolean)response.getDatabases().stream().anyMatch(d -> d.getName().equals(dbName)));
        }
        finally {
            try {
                this.hmsHandler.drop_database(dbName, true, false);
            }
            catch (Exception exception) {}
        }
    }

    @Test
    public void testTableFilterContextWithOwnership() throws Exception {
        ArrayList<TableMeta> tableMetas = new ArrayList<TableMeta>();
        TableMeta ownerTableMeta = new TableMeta();
        ownerTableMeta.setCatName(superUser);
        ownerTableMeta.setDbName(default_db);
        ownerTableMeta.setTableName("owner_table");
        ownerTableMeta.setOwnerName(authorizedUser);
        ownerTableMeta.setOwnerType(PrincipalType.USER);
        tableMetas.add(ownerTableMeta);
        TableMeta otherTableMeta = new TableMeta();
        otherTableMeta.setCatName(superUser);
        otherTableMeta.setDbName(default_db);
        otherTableMeta.setTableName("other_table");
        otherTableMeta.setOwnerName(unAuthorizedUser);
        otherTableMeta.setOwnerType(PrincipalType.USER);
        tableMetas.add(otherTableMeta);
        TableFilterContext filterContext = TableFilterContext.createFromTableMetas((String)default_db, tableMetas);
        List tables = filterContext.getTables();
        Assert.assertEquals((String)"Should have two tables in context", (long)2L, (long)tables.size());
        boolean foundOwnerTable = false;
        boolean foundOtherTable = false;
        for (Table table : tables) {
            if (table.getTableName().equals("owner_table")) {
                foundOwnerTable = true;
                Assert.assertEquals((String)"owner_table should have authorized user as owner", (Object)authorizedUser, (Object)table.getOwner());
                continue;
            }
            if (!table.getTableName().equals("other_table")) continue;
            foundOtherTable = true;
            Assert.assertEquals((String)"other_table should have unauthorized user as owner", (Object)unAuthorizedUser, (Object)table.getOwner());
        }
        Assert.assertTrue((String)"owner_table not found in tables", (boolean)foundOwnerTable);
        Assert.assertTrue((String)"other_table not found in tables", (boolean)foundOtherTable);
        HiveMetaStoreAuthzInfo authzInfo = filterContext.getAuthzContext();
        List privObjects = authzInfo.getInputHObjs();
        Assert.assertEquals((String)"Should have two privilege objects", (long)2L, (long)privObjects.size());
        foundOwnerTable = false;
        foundOtherTable = false;
        for (HivePrivilegeObject obj : privObjects) {
            if (obj.getObjectName().equals("owner_table")) {
                foundOwnerTable = true;
                Assert.assertEquals((String)"owner_table privilege object should have authorized user as owner", (Object)authorizedUser, (Object)obj.getOwnerName());
                continue;
            }
            if (!obj.getObjectName().equals("other_table")) continue;
            foundOtherTable = true;
            Assert.assertEquals((String)"other_table privilege object should have unauthorized user as owner", (Object)unAuthorizedUser, (Object)obj.getOwnerName());
        }
        Assert.assertTrue((String)"owner_table not found in privilege objects", (boolean)foundOwnerTable);
        Assert.assertTrue((String)"other_table not found in privilege objects", (boolean)foundOtherTable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetDatabaseObjects_WithPattern() throws Exception {
        UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createRemoteUser((String)authorizedUser));
        String testDb1 = "test_db1";
        String testDb2 = "test_db2";
        String otherDb = "other_db";
        try {
            Database db1 = new DatabaseBuilder().setName(testDb1).setOwnerName(authorizedUser).build(this.conf);
            this.hmsHandler.create_database(db1);
            Database db2 = new DatabaseBuilder().setName(testDb2).setOwnerName(authorizedUser).build(this.conf);
            this.hmsHandler.create_database(db2);
            Database db3 = new DatabaseBuilder().setName(otherDb).setOwnerName(authorizedUser).build(this.conf);
            this.hmsHandler.create_database(db3);
            GetDatabaseObjectsRequest request = new GetDatabaseObjectsRequest();
            request.setCatalogName(superUser);
            request.setPattern("test_*");
            GetDatabaseObjectsResponse response = this.hmsHandler.get_databases_req(request);
            Assert.assertNotNull((String)"Response should not be null", (Object)response);
            Assert.assertNotNull((String)"Databases list should not be null", (Object)response.getDatabases());
            List dbNames = response.getDatabases().stream().map(Database::getName).collect(Collectors.toList());
            Assert.assertTrue((String)"Should find test_db1", (boolean)dbNames.contains(testDb1));
            Assert.assertTrue((String)"Should find test_db2", (boolean)dbNames.contains(testDb2));
            Assert.assertFalse((String)"Should not find other_db", (boolean)dbNames.contains(otherDb));
        }
        finally {
            try {
                this.hmsHandler.drop_database(testDb1, true, false);
                this.hmsHandler.drop_database(testDb2, true, false);
                this.hmsHandler.drop_database(otherDb, true, false);
            }
            catch (Exception exception) {}
        }
    }

    @Test
    public void testR_CreateDataConnector_unAuthorizedUser() {
        UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createRemoteUser((String)unAuthorizedUser));
        try {
            DataConnector connector = new DataConnector(dcName, "mysql", "jdbc:mysql://localhost:3306/hive");
            CreateDataConnectorRequest connectorReq = new CreateDataConnectorRequest(connector);
            this.hmsHandler.create_dataconnector_req(connectorReq);
        }
        catch (Exception e) {
            String err = e.getMessage();
            String expected = "Operation type " + HiveOperationType.CREATEDATACONNECTOR + " not allowed for user:bob";
            Assert.assertEquals((Object)expected, (Object)err);
        }
    }

    @Test
    public void testS_CreateDataConnector_authorizedUser() {
        UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createRemoteUser((String)authorizedUser));
        try {
            DataConnector connector = new DataConnector(dcName, "mysql", "jdbc:mysql://localhost:3306/hive");
            CreateDataConnectorRequest connectorReq = new CreateDataConnectorRequest(connector);
            this.hmsHandler.create_dataconnector_req(connectorReq);
        }
        catch (Exception e) {
            Assert.fail((String)("testS_CreateDataConnector_authorizedUser() failed with " + e));
        }
    }

    @Test
    public void testT_AlterDataConnector_AuthorizedUser() {
        UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createRemoteUser((String)authorizedUser));
        try {
            DataConnector connector = new DataConnector(dcName, "mysql", "jdbc:mysql://localhost:3306/hive");
            CreateDataConnectorRequest connectorReq = new CreateDataConnectorRequest(connector);
            this.hmsHandler.create_dataconnector_req(connectorReq);
            DataConnector newConnector = new DataConnector(dcName, "mysql", "jdbc:mysql://localhost:3308/hive");
            AlterDataConnectorRequest alterReq = new AlterDataConnectorRequest(dcName, newConnector);
            this.hmsHandler.alter_dataconnector_req(alterReq);
        }
        catch (Exception e) {
            Assert.fail((String)("testT_AlterDataConnector_AuthorizedUser() failed with " + e));
        }
    }

    @Test
    public void testU_DropDataConnector_authorizedUser() {
        UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createRemoteUser((String)authorizedUser));
        try {
            DropDataConnectorRequest dropDcReq = new DropDataConnectorRequest(dcName);
            dropDcReq.setIfNotExists(true);
            dropDcReq.setCheckReferences(true);
            this.hmsHandler.drop_dataconnector_req(dropDcReq);
        }
        catch (Exception e) {
            Assert.fail((String)("testU_DropDataConnector_authorizedUser() failed with " + e));
        }
    }

    @Test
    public void testUnAuthorizedCause() {
        block3: {
            UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createRemoteUser((String)unAuthorizedUser));
            try {
                Database db = new DatabaseBuilder().setName(dbName).build(this.conf);
                this.hmsHandler.create_database(db);
            }
            catch (Exception e) {
                String expectedErrMsg;
                boolean foundAuthzException = false;
                for (Throwable current = e; current != null; current = current.getCause()) {
                    if (!(current instanceof HiveAuthzPluginException)) continue;
                    foundAuthzException = true;
                    expectedErrMsg = "Operation type " + HiveOperationType.CREATEDATABASE + " not allowed for user:bob";
                    Assert.assertTrue((String)("Expected error message mismatch. Actual: '" + current.getMessage() + "'"), (boolean)current.getMessage().contains(expectedErrMsg));
                    break;
                }
                if (foundAuthzException) break block3;
                expectedErrMsg = "Operation type " + HiveOperationType.CREATEDATABASE + " not allowed for user:bob";
                Assert.assertTrue((String)("Expected HiveAuthzPluginException in exception chain. Message: '" + e.getMessage() + "'"), (boolean)e.getMessage().contains(expectedErrMsg));
            }
        }
    }

    static {
        allowedUsers = Arrays.asList(authorizedUser, "rob");
    }

    public static class MockHiveAuthorizerFactory
    implements HiveAuthorizerFactory {
        public HiveAuthorizer createHiveAuthorizer(HiveMetastoreClientFactory metastoreClientFactory, HiveConf conf, HiveAuthenticationProvider hiveAuthenticator, HiveAuthzSessionContext ctx) {
            return mockHiveAuthorizer;
        }
    }
}

