/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.plugin.metastore;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.MetaStoreFilterHook;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionSpec;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TableMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockMetaStoreOwnerFilterHook
implements MetaStoreFilterHook {
    private static final Logger LOG = LoggerFactory.getLogger(MockMetaStoreOwnerFilterHook.class);
    private static final String AUTHORIZED_OWNER = "sam";

    public MockMetaStoreOwnerFilterHook(Configuration conf) {
        LOG.info("Initialized MockMetaStoreFilterHook with authorized owner: sam");
    }

    public List<String> filterDatabases(List<String> dbList) throws MetaException {
        LOG.debug("filterDatabases: Original list size: {}", (Object)(dbList != null ? dbList.size() : 0));
        return dbList;
    }

    public Database filterDatabase(Database dataBase) throws MetaException, NoSuchObjectException {
        if (dataBase == null) {
            LOG.debug("filterDatabase: Database is null");
            return null;
        }
        String dbName = dataBase.getName();
        String ownerName = dataBase.getOwnerName();
        if (!AUTHORIZED_OWNER.equals(ownerName)) {
            LOG.info("filterDatabase: Filtering out database '{}' - owner '{}' is not authorized", (Object)dbName, (Object)ownerName);
            return null;
        }
        LOG.debug("filterDatabase: Allowed access to database '{}' for owner '{}'", (Object)dbName, (Object)ownerName);
        return dataBase;
    }

    public List<String> filterTableNames(String catName, String dbName, List<String> tableList) throws MetaException {
        LOG.debug("filterTableNames: Returning all tables for {}.{}, count: {}", new Object[]{catName, dbName, tableList != null ? tableList.size() : 0});
        return tableList;
    }

    public List<TableMeta> filterTableMetas(String catName, String dbName, List<TableMeta> tableMetas) throws MetaException {
        if (tableMetas == null) {
            LOG.debug("filterTableMetas: Table metas list is null");
            return null;
        }
        LOG.info("filterTableMetas: Filtering {} table metas for {}.{}", new Object[]{tableMetas.size(), catName, dbName});
        List<TableMeta> filtered = tableMetas.stream().filter(tm -> {
            boolean authorized = AUTHORIZED_OWNER.equals(tm.getOwnerName());
            if (!authorized) {
                LOG.debug("Filtering out table meta '{}' - owner '{}' is not authorized", (Object)tm.getTableName(), (Object)tm.getOwnerName());
            }
            return authorized;
        }).collect(Collectors.toList());
        LOG.info("filterTableMetas: Filtered result contains {} table metas", (Object)filtered.size());
        return filtered;
    }

    public List<TableMeta> filterTableMetas(List<TableMeta> tableMetas) throws MetaException {
        if (tableMetas == null) {
            return null;
        }
        LOG.info("filterTableMetas: Filtering {} table metas", (Object)tableMetas.size());
        return tableMetas.stream().filter(tm -> AUTHORIZED_OWNER.equals(tm.getOwnerName())).collect(Collectors.toList());
    }

    public Table filterTable(Table table) throws MetaException, NoSuchObjectException {
        if (table == null) {
            LOG.debug("filterTable: Table is null");
            return null;
        }
        String tableName = table.getTableName();
        String owner = table.getOwner();
        if (!AUTHORIZED_OWNER.equals(owner)) {
            LOG.info("filterTable: Filtering out table '{}' - owner '{}' is not authorized", (Object)tableName, (Object)owner);
            return null;
        }
        LOG.debug("filterTable: Allowed access to table '{}' for owner '{}'", (Object)tableName, (Object)owner);
        return table;
    }

    public List<Table> filterTables(List<Table> tableList) throws MetaException {
        if (tableList == null) {
            LOG.debug("filterTables: Table list is null");
            return null;
        }
        LOG.info("filterTables: Filtering {} tables", (Object)tableList.size());
        List<Table> filtered = tableList.stream().filter(t -> {
            boolean authorized = AUTHORIZED_OWNER.equals(t.getOwner());
            if (!authorized) {
                LOG.debug("Filtering out table '{}' - owner '{}' is not authorized", (Object)t.getTableName(), (Object)t.getOwner());
            }
            return authorized;
        }).collect(Collectors.toList());
        LOG.info("filterTables: Filtered result contains " + filtered.size() + " tables");
        return filtered;
    }

    public List<Partition> filterPartitions(List<Partition> partitionList) throws MetaException {
        LOG.debug("filterPartitions: Returning all partitions, count: {}", (Object)(partitionList != null ? partitionList.size() : 0));
        return partitionList;
    }

    public List<PartitionSpec> filterPartitionSpecs(List<PartitionSpec> partitionSpecList) throws MetaException {
        LOG.debug("filterPartitionSpecs: Returning all partition specs, count: {}", (Object)(partitionSpecList != null ? partitionSpecList.size() : 0));
        return partitionSpecList;
    }

    public Partition filterPartition(Partition partition) throws MetaException, NoSuchObjectException {
        if (partition != null) {
            LOG.debug("filterPartition: Returning partition for table: {}", (Object)partition.getTableName());
        }
        return partition;
    }

    public List<String> filterPartitionNames(String catName, String dbName, String tblName, List<String> partitionNames) throws MetaException {
        LOG.debug("filterPartitionNames: Returning all partition names for {}.{}.{}, count: {}", new Object[]{catName, dbName, tblName, partitionNames != null ? partitionNames.size() : 0});
        return partitionNames;
    }

    public List<String> filterDataConnectors(List<String> dcList) throws MetaException {
        LOG.debug("filterDataConnectors: Returning all data connectors, count: {}", (Object)(dcList != null ? dcList.size() : 0));
        return dcList;
    }
}

