/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.plugin;

import java.util.List;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveConfForTest;
import org.apache.hadoop.hive.metastore.utils.TestTxnDbUtil;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.lockmgr.DbTxnManager;
import org.apache.hadoop.hive.ql.security.HiveAuthenticationProvider;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAccessControlException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthorizer;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthorizerFactory;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzPluginException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzSessionContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveMetastoreClientFactory;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestHivePrivilegeObjectOwnerNameAndType {
    protected static HiveConf conf;
    protected static Driver driver;
    private static final String TABLE_NAME;
    static HiveAuthorizer mockedAuthorizer;

    @BeforeClass
    public static void beforeTest() throws Exception {
        conf = new HiveConfForTest(TestHivePrivilegeObjectOwnerNameAndType.class);
        conf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, MockedHiveAuthorizerFactory.class.getName());
        conf.setBoolVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_ENABLED, true);
        conf.setBoolVar(HiveConf.ConfVars.HIVE_SERVER2_ENABLE_DOAS, false);
        conf.setBoolVar(HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, true);
        conf.setVar(HiveConf.ConfVars.HIVE_TXN_MANAGER, DbTxnManager.class.getName());
        conf.setVar(HiveConf.ConfVars.HIVE_MAPRED_MODE, "nonstrict");
        conf.setVar(HiveConf.ConfVars.DYNAMIC_PARTITIONING_MODE, "nonstrict");
        TestTxnDbUtil.prepDb((Configuration)conf);
        SessionState.start((HiveConf)conf);
        driver = new Driver(conf);
        TestHivePrivilegeObjectOwnerNameAndType.runCmd("create table " + TABLE_NAME + " (i int, j int, k string) partitioned by (city string, `date` string) ");
    }

    private static void runCmd(String cmd) throws Exception {
        driver.run(cmd);
    }

    @AfterClass
    public static void afterTests() throws Exception {
        TestHivePrivilegeObjectOwnerNameAndType.runCmd("drop table if exists " + TABLE_NAME);
        driver.close();
    }

    @Test
    public void testOwnerNames() throws Exception {
        Mockito.reset((Object[])new HiveAuthorizer[]{mockedAuthorizer});
        driver.compile("create table default.t1 (name string)", true);
        Pair<List<HivePrivilegeObject>, List<HivePrivilegeObject>> io = this.getHivePrivilegeObjectInputs();
        boolean containsDBOwnerName = false;
        boolean containsTblOwnerName = false;
        for (HivePrivilegeObject hpo : (List)io.getLeft()) {
            if (hpo.getType() == HivePrivilegeObject.HivePrivilegeObjectType.DATABASE && hpo.getOwnerName() != null) {
                containsDBOwnerName = true;
            }
            if (hpo.getType() != HivePrivilegeObject.HivePrivilegeObjectType.TABLE_OR_VIEW || hpo.getOwnerName() == null) continue;
            containsTblOwnerName = true;
        }
        for (HivePrivilegeObject hpo : (List)io.getRight()) {
            if (hpo.getType() == HivePrivilegeObject.HivePrivilegeObjectType.DATABASE && hpo.getOwnerName() != null) {
                containsDBOwnerName = true;
            }
            if (hpo.getType() != HivePrivilegeObject.HivePrivilegeObjectType.TABLE_OR_VIEW || hpo.getOwnerName() == null) continue;
            containsTblOwnerName = true;
        }
        if (!containsTblOwnerName || !containsDBOwnerName) {
            String errorMessage = "Ownername is not present in HivePrivilegeObject";
            throw new HiveAuthzPluginException(errorMessage);
        }
    }

    @Test
    public void testOwnerType() throws Exception {
        Mockito.reset((Object[])new HiveAuthorizer[]{mockedAuthorizer});
        driver.compile("create table default.t1 (name string)", true);
        Pair<List<HivePrivilegeObject>, List<HivePrivilegeObject>> io = this.getHivePrivilegeObjectInputs();
        boolean containsOwnerType = false;
        for (HivePrivilegeObject hpo : (List)io.getLeft()) {
            if (hpo.getOwnerType() == null) continue;
            containsOwnerType = true;
        }
        for (HivePrivilegeObject hpo : (List)io.getRight()) {
            if (hpo.getOwnerType() == null) continue;
            containsOwnerType = true;
        }
        Assert.assertTrue((boolean)containsOwnerType);
    }

    @Test
    public void testActionTypeForPartitionedTable() throws Exception {
        TestHivePrivilegeObjectOwnerNameAndType.runCmd("CREATE EXTERNAL TABLE Part (eid int, name int) PARTITIONED BY (position int, dept int, sal int)");
        Mockito.reset((Object[])new HiveAuthorizer[]{mockedAuthorizer});
        TestHivePrivilegeObjectOwnerNameAndType.runCmd("insert overwrite table part partition(position=2,DEPT,SAL) select 2,2,2,2");
        Pair<List<HivePrivilegeObject>, List<HivePrivilegeObject>> io = this.getHivePrivilegeObjectInputs();
        List hpoList = (List)io.getValue();
        Assert.assertFalse((boolean)hpoList.isEmpty());
        for (HivePrivilegeObject hpo : hpoList) {
            Assert.assertEquals((Object)hpo.getActionType(), (Object)HivePrivilegeObject.HivePrivObjectActionType.INSERT_OVERWRITE);
        }
    }

    @Test
    public void testSingleInstanceOfHPOForPartitionedTable() throws Exception {
        Mockito.reset((Object[])new HiveAuthorizer[]{mockedAuthorizer});
        TestHivePrivilegeObjectOwnerNameAndType.runCmd("insert overwrite table part partition(position=2,DEPT,SAL) select 2,2,2,2 union all select 1,2,3,4 union all select 3,4,5,6");
        Pair<List<HivePrivilegeObject>, List<HivePrivilegeObject>> io = this.getHivePrivilegeObjectInputs();
        List hpoList = (List)io.getValue();
        Assert.assertEquals((long)1L, (long)hpoList.size());
    }

    private Pair<List<HivePrivilegeObject>, List<HivePrivilegeObject>> getHivePrivilegeObjectInputs() throws HiveAuthzPluginException, HiveAccessControlException {
        Class<List> classListPrivObjects = List.class;
        ArgumentCaptor inputsCapturer = ArgumentCaptor.forClass(classListPrivObjects);
        ArgumentCaptor outputsCapturer = ArgumentCaptor.forClass(classListPrivObjects);
        ((HiveAuthorizer)Mockito.verify((Object)mockedAuthorizer)).checkPrivileges((HiveOperationType)ArgumentMatchers.any(HiveOperationType.class), (List)inputsCapturer.capture(), (List)outputsCapturer.capture(), (HiveAuthzContext)ArgumentMatchers.any(HiveAuthzContext.class));
        return new ImmutablePair((Object)((List)inputsCapturer.getValue()), (Object)((List)outputsCapturer.getValue()));
    }

    static {
        TABLE_NAME = TestHivePrivilegeObjectOwnerNameAndType.class.getSimpleName() + "Table";
    }

    static class MockedHiveAuthorizerFactory
    implements HiveAuthorizerFactory {
        MockedHiveAuthorizerFactory() {
        }

        public HiveAuthorizer createHiveAuthorizer(HiveMetastoreClientFactory metastoreClientFactory, HiveConf conf, HiveAuthenticationProvider authenticator, HiveAuthzSessionContext ctx) {
            mockedAuthorizer = (HiveAuthorizer)Mockito.mock(HiveAuthorizer.class);
            return mockedAuthorizer;
        }
    }
}

