/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.secrets;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.secrets.SecretSource;
import org.apache.hadoop.hive.ql.secrets.URISecretSource;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class URISecretSourceTest {
    private MockSecretSource source;

    @Before
    public void setupTest() {
        this.source = new MockSecretSource();
        URISecretSource.getInstance().register((SecretSource)this.source);
    }

    @After
    public void tearDownTest() {
        URISecretSource.getInstance().removeForTest((SecretSource)this.source);
    }

    @Test
    public void testURISecret() throws Exception {
        Assert.assertNull((Object)Utilities.getPasswdFromUri(null));
        Assert.assertNull((Object)Utilities.getPasswdFromUri((String)""));
        Assert.assertEquals((Object)"mysecret", (Object)Utilities.getPasswdFromUri((String)"test:///mysecret"));
    }

    @Test(expected=HiveException.class)
    public void testInvalidScheme() throws Exception {
        Utilities.getPasswdFromUri((String)"test1:///mysecret");
    }

    @Test(expected=URISyntaxException.class)
    public void testInvalidUri() throws Exception {
        Utilities.getPasswdFromUri((String)"1test:///mysecret");
    }

    @Test(expected=IOException.class)
    public void testIncorrectUriForScheme() throws Exception {
        Utilities.getPasswdFromUri((String)"test:///mysecret#cry");
    }

    private static class MockSecretSource
    implements SecretSource {
        private MockSecretSource() {
        }

        public String getURIScheme() {
            return "test";
        }

        public String getSecret(URI uri) throws IOException {
            if (uri.getFragment() != null) {
                throw new IOException("I cannot handle this");
            }
            return uri.getPath().substring(1);
        }

        public void close() throws IOException {
        }
    }
}

