/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.secrets;

import com.amazonaws.secretsmanager.caching.SecretCache;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.hive.ql.secrets.AWSSecretsManagerSecretSource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class AWSSecretsManagerSecretSourceTest {
    private AWSSecretsManagerSecretSource source = new AWSSecretsManagerSecretSource();
    private SecretCache cache;

    @Before
    public void setupTest() {
        this.cache = (SecretCache)Mockito.mock(SecretCache.class);
        this.source.setCache(this.cache);
    }

    @Test
    public void testAWSSecretsManagerScheme() {
        Assert.assertEquals((Object)"aws-sm", (Object)this.source.getURIScheme());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAWSSecretsManagerInvalidScheme() throws Exception {
        this.source.getSecret(new URI("awssm:///test"));
    }

    @Test
    public void testAWSSecretsManagerSuccess() throws Exception {
        Mockito.when((Object)this.cache.getSecretString("test")).thenReturn((Object)"{\"password\":\"super-secret\"}");
        Assert.assertEquals((Object)"super-secret", (Object)this.source.getSecret(new URI("aws-sm:///test")));
    }

    @Test(expected=IOException.class)
    public void testAWSSecretsManagerServiceException() throws Exception {
        Mockito.when((Object)this.cache.getSecretString("bad")).thenThrow(RuntimeException.class);
        this.source.getSecret(new URI("aws-sm:///bad"));
    }

    @Test(expected=IOException.class)
    public void testAWSSecretsManagerInvalidJson() throws Exception {
        Mockito.when((Object)this.cache.getSecretString("test")).thenReturn((Object)"{\"password\":\"super-secret\"");
        this.source.getSecret(new URI("aws-sm:///test"));
    }

    @Test(expected=IOException.class)
    public void testAWSSecretsManagerArrayJson() throws Exception {
        Mockito.when((Object)this.cache.getSecretString("test")).thenReturn((Object)"[]");
        this.source.getSecret(new URI("aws-sm:///test"));
    }
}

