/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.schq;

import org.apache.hadoop.hive.metastore.api.QueryState;
import org.apache.hadoop.hive.metastore.api.ScheduledQueryKey;
import org.apache.hadoop.hive.metastore.api.ScheduledQueryPollResponse;
import org.apache.hadoop.hive.metastore.api.ScheduledQueryProgressInfo;
import org.apache.hadoop.hive.ql.scheduled.IScheduledQueryMaintenanceService;

public class MockScheduledQueryService
implements IScheduledQueryMaintenanceService {
    public final Object notifier = new Object();
    int id = 0;
    private String stmt;
    public ScheduledQueryProgressInfo lastProgressInfo;

    public MockScheduledQueryService(String string) {
        this.stmt = string;
    }

    public ScheduledQueryPollResponse scheduledQueryPoll() {
        ScheduledQueryPollResponse r = new ScheduledQueryPollResponse();
        r.setQuery(this.stmt);
        r.setScheduleKey(new ScheduledQueryKey("sch1", this.getClusterNamespace()));
        r.setUser("nobody");
        if (this.id == 0) {
            r.setExecutionId((long)this.id++);
            return r;
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduledQueryProgress(ScheduledQueryProgressInfo info) {
        System.out.printf("%d, state: %s, error: %s", info.getScheduledExecutionId(), info.getState(), info.getErrorMessage());
        this.lastProgressInfo = info;
        if (info.getState() == QueryState.FINISHED || info.getState() == QueryState.FAILED) {
            Object object = this.notifier;
            synchronized (object) {
                this.notifier.notifyAll();
            }
        }
    }

    public String getClusterNamespace() {
        return "default";
    }
}

