/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.reexec;

import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.tez.TezRuntimeException;
import org.apache.hadoop.hive.ql.hooks.HookContext;
import org.apache.hadoop.hive.ql.reexec.ReExecuteLostAMQueryPlugin;
import org.junit.Assert;
import org.junit.Test;

public class TestReExecuteLostAMQueryPlugin {
    @Test
    public void testRetryOnUnmanagedAmFailure() throws Exception {
        this.testReExecuteWithExceptionMessage("AM record not found (likely died)");
    }

    @Test
    public void testRetryOnLostAmContainerMessageWithLineBreak() throws Exception {
        this.testReExecuteWithExceptionMessage("Application application_1728328561547_0042 failed 1 times (global limit =5; local limit is =1) due to AM Container for appattempt_1728328561547_0042_000001 exited with  exitCode: -100\nFailing this attempt.Diagnostics: Container released on a *lost* nodeFor more detailed output, check the application tracking page: https://host/cluster/app/application_1728328561547_0042 Then click on links to logs of each attempt.\n. Failing the application.");
    }

    @Test
    public void testRetryOnNoCurrentDAGException() throws Exception {
        this.testReExecuteWithExceptionMessage("No running DAG at present");
    }

    private void testReExecuteWithExceptionMessage(String message) throws Exception {
        ReExecuteLostAMQueryPlugin plugin = new ReExecuteLostAMQueryPlugin();
        ReExecuteLostAMQueryPlugin.LocalHook hook = new ReExecuteLostAMQueryPlugin.LocalHook(plugin);
        HookContext context = new HookContext(null, QueryState.getNewQueryState((HiveConf)new HiveConf(), null), null, null, null, null, null, null, null, false, null, null);
        context.setHookType(HookContext.HookType.ON_FAILURE_HOOK);
        context.setException((Throwable)new TezRuntimeException("dag_0_0", message));
        hook.run(context);
        Assert.assertTrue((boolean)plugin.shouldReExecute(1));
    }
}

