/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.processors;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.common.io.SessionStream;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveConfForTest;
import org.apache.hadoop.hive.ql.processors.CommandProcessorException;
import org.apache.hadoop.hive.ql.processors.SetProcessor;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestSetProcessor {
    private static final String TEST_SYSTEM_PROPERTY = "testSystemPropertyPassword";
    private static final String TEST_SYSTEM_PROPERTY_VALUE = "testSystemPropertyValue";
    private static final String TEST_ENV_VAR_PASSWORD_VALUE = "testEnvPasswordValue";
    private static final String TEST_ENV_VAR_PASSWORD = "testEnvPassword";
    private ByteArrayOutputStream baos;
    private static SessionState state;
    private SetProcessor processor;

    @BeforeClass
    public static void before() throws Exception {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put(TEST_ENV_VAR_PASSWORD, TEST_ENV_VAR_PASSWORD_VALUE);
        TestSetProcessor.setEnv(env);
        System.setProperty(TEST_SYSTEM_PROPERTY, TEST_SYSTEM_PROPERTY_VALUE);
        HiveConfForTest conf = new HiveConfForTest(TestSetProcessor.class);
        SessionState.start((HiveConf)conf);
        state = SessionState.get();
    }

    @Before
    public void setupTest() throws Exception {
        this.baos = new ByteArrayOutputStream();
        TestSetProcessor.state.out = new SessionStream((OutputStream)this.baos);
        this.processor = new SetProcessor();
    }

    @Test
    public void testHiddenConfig() throws Exception {
        this.runSetProcessor("");
        String output = this.baos.toString();
        Assert.assertFalse((boolean)output.contains(HiveConf.ConfVars.METASTORE_PWD.varname + "="));
        Assert.assertFalse((boolean)output.contains(HiveConf.ConfVars.HIVE_SERVER2_SSL_KEYSTORE_PASSWORD.varname + "="));
    }

    @Test
    public void testHiddenConfigSetVarName() throws CommandProcessorException {
        this.runSetProcessor(HiveConf.ConfVars.METASTORE_PWD.varname);
        String output = this.baos.toString();
        Assert.assertTrue((boolean)output.contains("hidden"));
    }

    @Test
    public void testEnvPasswordMask() throws Exception {
        this.runSetProcessor("");
        String output = this.baos.toString();
        Assert.assertFalse((boolean)output.contains("testEnvPassword="));
    }

    @Test
    public void testEnvPasswordMaskIndividual() throws Exception {
        this.runSetProcessor("env:testEnvPassword");
        String output = this.baos.toString();
        Assert.assertFalse((boolean)output.contains(TEST_ENV_VAR_PASSWORD_VALUE));
        Assert.assertTrue((boolean)output.contains("hidden"));
    }

    @Test
    public void testSystemProperty() throws Exception {
        this.runSetProcessor("");
        String output = this.baos.toString();
        Assert.assertFalse((boolean)output.contains("testSystemPropertyPassword="));
    }

    @Test
    public void testSystemPropertyIndividual() throws Exception {
        this.runSetProcessor("system:testSystemPropertyPassword");
        String output = this.baos.toString();
        Assert.assertFalse((boolean)output.contains(TEST_SYSTEM_PROPERTY_VALUE));
        Assert.assertTrue((boolean)output.contains("hidden"));
    }

    private void runSetProcessor(String command) throws CommandProcessorException {
        this.processor.run(command);
        TestSetProcessor.state.out.flush();
    }

    private static final void setEnv(Map<String, String> newenv) throws Exception {
        Class<?>[] classes = Collections.class.getDeclaredClasses();
        Map<String, String> env = System.getenv();
        for (Class<?> cl : classes) {
            if (!"java.util.Collections$UnmodifiableMap".equals(cl.getName())) continue;
            Field field = cl.getDeclaredField("m");
            field.setAccessible(true);
            Object obj = field.get(env);
            Map map = (Map)obj;
            map.clear();
            map.putAll(newenv);
        }
    }
}

