/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan.mapping;

import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.DriverFactory;
import org.apache.hadoop.hive.ql.IDriver;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.parse.ParseException;
import org.apache.hadoop.hive.ql.plan.mapper.PlanMapper;
import org.apache.hadoop.hive.ql.plan.mapping.TestCounterMapping;
import org.apache.hadoop.hive.ql.processors.CommandProcessorException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hive.testutils.HiveTestEnvSetup;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;

public class TestStatEstimations {
    @ClassRule
    public static HiveTestEnvSetup env_setup = new HiveTestEnvSetup();
    @Rule
    public TestRule methodRule = env_setup.getMethodRule();

    @BeforeClass
    public static void beforeClass() throws Exception {
        String[] cmds;
        IDriver driver = TestStatEstimations.createDriver();
        TestStatEstimations.dropTables(driver);
        for (String cmd : cmds = new String[]{"create table t2(a integer, b string) STORED AS ORC", "insert into t2 values (1, 'A1'),(2, 'A2'),(3, 'A3'),(4, 'A4'),(5, 'A5'),(6, 'B1'),(7, 'B2'),(8, 'B3'),(9, 'B4'),(10, 'B5')", "analyze table t2 compute statistics for columns"}) {
            driver.run(cmd);
        }
    }

    @AfterClass
    public static void afterClass() throws Exception {
        IDriver driver = TestStatEstimations.createDriver();
        TestStatEstimations.dropTables(driver);
    }

    public static void dropTables(IDriver driver) throws Exception {
        String[] tables;
        for (String t : tables = new String[]{"t2"}) {
            driver.run("drop table if exists " + t);
        }
    }

    private PlanMapper getMapperForQuery(IDriver driver, String query) throws CommandProcessorException {
        driver.run(query);
        PlanMapper pm0 = driver.getContext().getPlanMapper();
        return pm0;
    }

    @Test
    public void testFilterStringIn() throws ParseException, CommandProcessorException {
        IDriver driver = TestStatEstimations.createDriver();
        String query = "explain select a from t2 where b IN ('A3', 'ABC', 'AXZ') order by a";
        PlanMapper pm = this.getMapperForQuery(driver, query);
        List fos = pm.getAll(FilterOperator.class);
        fos.sort(TestCounterMapping.OPERATOR_ID_COMPARATOR.reversed());
        FilterOperator fop = (FilterOperator)fos.get(0);
        Assert.assertEquals((long)1L, (long)fop.getStatistics().getNumRows());
    }

    @Ignore
    @Test
    public void testFilterStringNotIn() throws CommandProcessorException {
        IDriver driver = TestStatEstimations.createDriver();
        String query = "explain select a from t2 where b NOT IN ('XXX', 'UUU') order by a";
        PlanMapper pm = this.getMapperForQuery(driver, query);
        List fos = pm.getAll(FilterOperator.class);
        fos.sort(TestCounterMapping.OPERATOR_ID_COMPARATOR.reversed());
        Assert.assertEquals((long)1L, (long)fos.size());
        FilterOperator fop = (FilterOperator)fos.get(0);
        Assert.assertEquals((long)10L, (long)fop.getStatistics().getNumRows());
    }

    @Test
    public void testFilterIntIn() throws ParseException, CommandProcessorException {
        IDriver driver = TestStatEstimations.createDriver();
        String query = "explain select a from t2 where a IN (-1,0,1,2,10,20,30,40) order by a";
        PlanMapper pm = this.getMapperForQuery(driver, query);
        List fos = pm.getAll(FilterOperator.class);
        fos.sort(TestCounterMapping.OPERATOR_ID_COMPARATOR.reversed());
        Assert.assertThat((Object)fos.size(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
        FilterOperator fop = (FilterOperator)fos.get(0);
        Assert.assertEquals((long)3L, (long)fop.getStatistics().getNumRows());
    }

    private static IDriver createDriver() {
        HiveConf conf = TestStatEstimations.env_setup.getTestCtx().hiveConf;
        conf.setBoolVar(HiveConf.ConfVars.HIVE_STATS_USE_BITVECTORS, true);
        conf.setBoolVar(HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED, false);
        conf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, "org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory");
        SessionState.start((HiveConf)conf);
        IDriver driver = DriverFactory.newDriver((HiveConf)conf);
        return driver;
    }
}

