/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan.mapping;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.DriverFactory;
import org.apache.hadoop.hive.ql.IDriver;
import org.apache.hadoop.hive.ql.exec.CommonJoinOperator;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveFilter;
import org.apache.hadoop.hive.ql.plan.Statistics;
import org.apache.hadoop.hive.ql.plan.mapper.PlanMapper;
import org.apache.hadoop.hive.ql.plan.mapper.StatsSources;
import org.apache.hadoop.hive.ql.plan.mapping.TestCounterMapping;
import org.apache.hadoop.hive.ql.processors.CommandProcessorException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.stats.OperatorStats;
import org.apache.hadoop.hive.ql.stats.OperatorStatsReaderHook;
import org.apache.hive.testutils.HiveTestEnvSetup;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TestRule;

public class TestReOptimization {
    @ClassRule
    public static HiveTestEnvSetup env_setup = new HiveTestEnvSetup();
    @Rule
    public TestRule methodRule = env_setup.getMethodRule();
    @Rule
    public ExpectedException exceptionRule = ExpectedException.none();

    @BeforeClass
    public static void beforeClass() throws Exception {
        String[] cmds;
        IDriver driver = TestReOptimization.createDriver("");
        TestReOptimization.dropTables(driver);
        for (String cmd : cmds = new String[]{"create table tu(id_uv int,id_uw int,u int)", "create table tv(id_uv int,v int)", "create table tw(id_uw int,w int)", "insert into tu values (10,10,10),(1,1,1),(2,2,2),(3,3,3),(4,4,4),(5,5,5),(6,6,6)", "insert into tv values (10,10),(1,1),(2,2),(3,3)", "insert into tw values (10,10),(1,1),(2,2),(3,3),(4,4),(5,5),(6,6),(7,7),(8,8),(9,9)"}) {
            driver.run(cmd);
        }
    }

    @AfterClass
    public static void afterClass() throws Exception {
        IDriver driver = TestReOptimization.createDriver("");
        TestReOptimization.dropTables(driver);
    }

    @After
    public void after() {
        StatsSources.clearGlobalStats();
    }

    public static void dropTables(IDriver driver) throws Exception {
        String[] tables;
        for (String t : tables = new String[]{"tu", "tv", "tw"}) {
            driver.run("drop table if exists " + t);
        }
    }

    private PlanMapper getMapperForQuery(IDriver driver, String query) {
        try {
            driver.run(query);
        }
        catch (CommandProcessorException e) {
            throw new RuntimeException("running the query " + query + " was not successful");
        }
        PlanMapper pm0 = driver.getContext().getPlanMapper();
        return pm0;
    }

    @Test
    public void testStatsAreSetInReopt() throws Exception {
        IDriver driver = TestReOptimization.createDriver("overlay,reoptimize");
        String query = "select assert_true_oom(${hiveconf:zzz} > sum(u*v)) from tu join tv on (tu.id_uv=tv.id_uv) where u<10 and v>1";
        PlanMapper pm = this.getMapperForQuery(driver, query);
        Iterator itG = pm.iterateGroups();
        int checkedOperators = 0;
        while (itG.hasNext()) {
            PlanMapper.EquivGroup g = (PlanMapper.EquivGroup)itG.next();
            List fos = g.getAll(FilterOperator.class);
            List oss = g.getAll(OperatorStats.class);
            if (fos.size() <= 0 || oss.size() <= 0) continue;
            fos.sort(TestCounterMapping.OPERATOR_ID_COMPARATOR.reversed());
            FilterOperator fo = (FilterOperator)fos.get(0);
            OperatorStats os = (OperatorStats)oss.get(0);
            Statistics stats = fo.getStatistics();
            Assert.assertEquals((long)os.getOutputRecords(), (long)stats.getNumRows());
            if (os.getOutputRecords() != 3L && os.getOutputRecords() != 6L) {
                Assert.fail((String)"nonexpected number of records produced");
            }
            ++checkedOperators;
        }
        Assert.assertEquals((long)2L, (long)checkedOperators);
    }

    @Test
    public void testReExecutedIfMapJoinError() throws Exception {
        IDriver driver = TestReOptimization.createDriver("overlay,reoptimize");
        String query = "select assert_true_oom(${hiveconf:zzz}>sum(1)) from tu join tv on (tu.id_uv=tv.id_uv) where u<10 and v>1";
        this.getMapperForQuery(driver, query);
    }

    @Test
    public void testNotReExecutedIfAssertionError() throws Exception {
        IDriver driver = TestReOptimization.createDriver("reoptimize");
        String query = "select assert_true(${hiveconf:zzz}>sum(1)) from tu join tv on (tu.id_uv=tv.id_uv) where u<10 and v>1";
        this.exceptionRule.expect(RuntimeException.class);
        this.exceptionRule.expectMessage("running the query " + query + " was not successful");
        this.getMapperForQuery(driver, query);
    }

    @Test
    public void testStatCachingQuery() throws Exception {
        HiveConf conf = TestReOptimization.env_setup.getTestCtx().hiveConf;
        conf.setVar(HiveConf.ConfVars.HIVE_QUERY_REEXECUTION_STATS_PERSISTENCE, "query");
        conf.setBoolVar(HiveConf.ConfVars.HIVE_QUERY_REEXECUTION_ALWAYS_COLLECT_OPERATOR_STATS, true);
        this.checkRuntimeStatsReuse(false, false, false);
    }

    @Test
    public void testStatCachingHS2() throws Exception {
        HiveConf conf = TestReOptimization.env_setup.getTestCtx().hiveConf;
        conf.setVar(HiveConf.ConfVars.HIVE_QUERY_REEXECUTION_STATS_PERSISTENCE, "hiveserver");
        conf.setBoolVar(HiveConf.ConfVars.HIVE_QUERY_REEXECUTION_ALWAYS_COLLECT_OPERATOR_STATS, true);
        this.checkRuntimeStatsReuse(true, true, false);
    }

    @Test
    public void testStatCachingMetaStore() throws Exception {
        HiveConf conf = TestReOptimization.env_setup.getTestCtx().hiveConf;
        conf.setVar(HiveConf.ConfVars.HIVE_QUERY_REEXECUTION_STATS_PERSISTENCE, "metastore");
        conf.setBoolVar(HiveConf.ConfVars.HIVE_QUERY_REEXECUTION_ALWAYS_COLLECT_OPERATOR_STATS, true);
        this.checkRuntimeStatsReuse(true, true, true);
    }

    private void checkRuntimeStatsReuse(boolean expectInSameSession, boolean expectNewHs2Session, boolean expectHs2Instance) throws CommandProcessorException {
        IDriver driver = TestReOptimization.createDriver("reoptimize");
        this.checkUsageOfRuntimeStats(driver, false);
        driver = DriverFactory.newDriver((HiveConf)TestReOptimization.env_setup.getTestCtx().hiveConf);
        this.checkUsageOfRuntimeStats(driver, expectInSameSession);
        driver = TestReOptimization.createDriver("reoptimize");
        this.checkUsageOfRuntimeStats(driver, expectNewHs2Session);
        StatsSources.clearGlobalStats();
        driver = TestReOptimization.createDriver("reoptimize");
        driver.run("select count(*) from tu group by id_uv");
        this.checkUsageOfRuntimeStats(driver, expectHs2Instance);
    }

    private void checkUsageOfRuntimeStats(IDriver driver, boolean expected) throws CommandProcessorException {
        String query = "select sum(u) from tu join tv on (tu.id_uv=tv.id_uv) where u<10 and v>1";
        PlanMapper pm = this.getMapperForQuery(driver, query);
        Assert.assertEquals((long)1L, (long)driver.getContext().getExecutionIndex());
        List allJoin = pm.getAll(CommonJoinOperator.class);
        CommonJoinOperator join = (CommonJoinOperator)allJoin.iterator().next();
        Statistics joinStat = join.getStatistics();
        Assert.assertEquals((String)"expectation of the usage of runtime stats doesn't match", (Object)expected, (Object)joinStat.isRuntimeStats());
    }

    @Test
    public void testExplainSupport() throws Exception {
        IDriver driver = TestReOptimization.createDriver("overlay,reoptimize");
        String query = "explain reoptimization select 1 from tu join tv on (tu.id_uv=tv.id_uv) where u<10 and v>1";
        this.getMapperForQuery(driver, query);
        ArrayList res = new ArrayList();
        ArrayList res1 = new ArrayList();
        while (driver.getResults(res1)) {
            res.addAll(res1);
        }
        Assert.assertEquals((String)"2FIL", (long)2L, (long)res.stream().filter(line -> line.contains("FIL_")).count());
        Assert.assertEquals((String)"2FIL(runtime)", (long)2L, (long)res.stream().filter(line -> line.contains("FIL") && line.contains("runtime")).count());
    }

    @Test
    public void testReOptimizationCanSendBackStatsToCBO() throws Exception {
        IDriver driver = TestReOptimization.createDriver("overlay,reoptimize");
        String query = "select assert_true_oom(${hiveconf:zzz} > sum(u*v*w)) from tu\n        join tv on (tu.id_uv=tv.id_uv)\n        join tw on (tu.id_uw=tw.id_uw)\n        where w>9 and u>1 and v>3";
        PlanMapper pm = this.getMapperForQuery(driver, query);
        Iterator itG = pm.iterateGroups();
        int checkedOperators = 0;
        while (itG.hasNext()) {
            PlanMapper.EquivGroup g = (PlanMapper.EquivGroup)itG.next();
            List fos = g.getAll(FilterOperator.class);
            List oss = g.getAll(OperatorStats.class);
            List hfs = g.getAll(HiveFilter.class);
            if (fos.size() <= 0 || oss.size() <= 0 || hfs.size() <= 0) continue;
            fos.sort(TestCounterMapping.OPERATOR_ID_COMPARATOR.reversed());
            HiveFilter hf = (HiveFilter)hfs.get(0);
            FilterOperator fo = (FilterOperator)fos.get(0);
            OperatorStats os = (OperatorStats)oss.get(0);
            long cntFilter = RelMetadataQuery.instance().getRowCount((RelNode)hf).longValue();
            if (fo.getStatistics() != null) {
                // empty if block
            }
            Assert.assertEquals((long)os.getOutputRecords(), (long)cntFilter);
            ++checkedOperators;
        }
        Assert.assertEquals((long)3L, (long)checkedOperators);
    }

    private static IDriver createDriver(String strategies) {
        HiveConf conf = TestReOptimization.env_setup.getTestCtx().hiveConf;
        conf.setBoolVar(HiveConf.ConfVars.HIVE_QUERY_REEXECUTION_ENABLED, true);
        conf.setBoolVar(HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED, false);
        conf.setVar(HiveConf.ConfVars.HIVE_CBO_FALLBACK_STRATEGY, "NEVER");
        conf.setVar(HiveConf.ConfVars.HIVE_QUERY_REEXECUTION_STRATEGIES, strategies);
        conf.setBoolVar(HiveConf.ConfVars.HIVE_EXPLAIN_USER, true);
        conf.set("zzz", "1");
        conf.set("reexec.overlay.zzz", "2000");
        conf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, "org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory");
        HiveConf.setBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, (boolean)false);
        HiveConf.setVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.POST_EXEC_HOOKS, (String)OperatorStatsReaderHook.class.getName());
        SessionState.start((HiveConf)conf);
        IDriver driver = DriverFactory.newDriver((HiveConf)conf);
        return driver;
    }
}

