/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveConfForTest;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.parse.AbstractSemanticAnalyzerHook;
import org.apache.hadoop.hive.ql.parse.HiveSemanticAnalyzerHookContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.processors.CommandProcessorException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestViewEntity {
    private static Driver driver;
    private final String NAME_PREFIX = "TestViewEntity5".toLowerCase();

    @BeforeClass
    public static void onetimeSetup() throws Exception {
        HiveConfForTest conf = new HiveConfForTest(TestViewEntity.class);
        conf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, "org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory");
        conf.setVar(HiveConf.ConfVars.SEMANTIC_ANALYZER_HOOK, CheckInputReadEntity.class.getName());
        HiveConf.setBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, (boolean)false);
        SessionState.start((HiveConf)conf);
        driver = new Driver((HiveConf)conf);
    }

    @AfterClass
    public static void cleanUp() throws Exception {
        driver.close();
        driver.destroy();
    }

    @Test
    public void testUnionView() throws Exception {
        String prefix = "tunionview" + this.NAME_PREFIX;
        String tab1 = prefix + "t1";
        String tab2 = prefix + "t2";
        String view1 = prefix + "v1";
        driver.run("create table " + tab1 + "(id int)");
        driver.run("create table " + tab2 + "(id int)");
        driver.run("create view " + view1 + " as select t.id from (select " + tab1 + ".id from " + tab1 + " union all select " + tab2 + ".id from " + tab2 + ") as t");
        driver.compile("select * from " + view1, true);
        Assert.assertEquals((Object)("default@" + view1), (Object)CheckInputReadEntity.readEntities[0].getName());
        Assert.assertEquals((Object)("default@" + tab1), (Object)CheckInputReadEntity.readEntities[1].getName());
        Assert.assertFalse((String)"Table is not direct input", (boolean)CheckInputReadEntity.readEntities[1].isDirect());
        Assert.assertEquals((Object)("default@" + view1), (Object)((ReadEntity)CheckInputReadEntity.readEntities[1].getParents().iterator().next()).getName());
        Assert.assertEquals((Object)("default@" + tab2), (Object)CheckInputReadEntity.readEntities[2].getName());
        Assert.assertFalse((String)"Table is not direct input", (boolean)CheckInputReadEntity.readEntities[2].isDirect());
        Assert.assertEquals((Object)("default@" + view1), (Object)((ReadEntity)CheckInputReadEntity.readEntities[2].getParents().iterator().next()).getName());
    }

    @Test
    public void testViewInSubQuery() throws Exception {
        String prefix = "tvsubquery" + this.NAME_PREFIX;
        String tab1 = prefix + "t";
        String view1 = prefix + "v";
        driver.run("create table " + tab1 + "(id int)");
        driver.run("create view " + view1 + " as select * from " + tab1);
        driver.compile("select * from " + view1, true);
        Assert.assertEquals((Object)("default@" + view1), (Object)CheckInputReadEntity.readEntities[0].getName());
        Assert.assertEquals((Object)("default@" + tab1), (Object)CheckInputReadEntity.readEntities[1].getName());
        Assert.assertFalse((String)"Table is not direct input", (boolean)CheckInputReadEntity.readEntities[1].isDirect());
    }

    @Test
    public void testViewInSubQueryWithWhereClauseCbo() throws Exception {
        driver.getConf().setBoolVar(HiveConf.ConfVars.HIVE_CBO_ENABLED, true);
        this.testViewInSubQueryWithWhereClause();
    }

    @Test
    public void testViewInSubQueryWithWhereClauseRbo() throws Exception {
        driver.getConf().setBoolVar(HiveConf.ConfVars.HIVE_CBO_ENABLED, false);
        this.testViewInSubQueryWithWhereClause();
    }

    private void testViewInSubQueryWithWhereClause() throws CommandProcessorException {
        ReadEntity[] readEntities;
        String prefix = "tvsubquerywithwhereclause" + this.NAME_PREFIX;
        String tab1 = prefix + "t";
        String view1 = prefix + "v";
        String view2 = prefix + "v2";
        String tab1row1 = "'x','y','z'";
        String tab1row2 = "'a','b','c'";
        driver.run("drop table if exists " + tab1);
        driver.run("drop view if exists " + view1);
        driver.run("drop view if exists " + view2);
        driver.run("create table " + tab1 + "(col1 string, col2 string, col3 string)");
        driver.run("insert into " + tab1 + " values ('x','y','z')");
        driver.run("create view " + view1 + " as select " + tab1 + ".col1, " + tab1 + ".col2, " + tab1 + ".col3  from " + tab1);
        driver.run("insert into " + tab1 + " values ('a','b','c')");
        driver.run("create view " + view2 + " as select " + tab1 + ".col1, " + tab1 + ".col2, " + tab1 + ".col3  from " + tab1 + " where " + tab1 + ".col1 NOT IN (SELECT " + view1 + ".col1 FROM " + view1 + ")");
        driver.compile("select * from " + view2, true);
        for (ReadEntity readEntity : readEntities = CheckInputReadEntity.readEntities) {
            String name = readEntity.getName();
            if (name.equals("default@" + tab1)) {
                Assert.assertFalse((String)"Table should not be direct input", (boolean)readEntity.isDirect());
                continue;
            }
            if (name.equals("default@" + view1)) {
                Assert.assertFalse((String)"View1 should not be direct input", (boolean)readEntity.isDirect());
                continue;
            }
            if (name.equals("default@" + view2)) {
                Assert.assertTrue((String)"View2 should be direct input", (boolean)readEntity.isDirect());
                continue;
            }
            Assert.fail((String)"Unrecognized ReadEntity input");
        }
    }

    @Test
    public void testSubQueryInSubView() throws Exception {
        String prefix = "tvsubqueryinsubview" + this.NAME_PREFIX;
        String tab1 = prefix + "t";
        String view1 = prefix + "v";
        String view2 = prefix + "v2";
        driver.run("create table " + tab1 + "(id int)");
        driver.run("create view " + view1 + " as select * from " + tab1);
        driver.run("create view " + view2 + " as select * from (select * from " + view1 + ") x");
        driver.compile("select * from " + view2, true);
        Assert.assertEquals((Object)("default@" + view2), (Object)CheckInputReadEntity.readEntities[0].getName());
        Assert.assertEquals((Object)("default@" + view1), (Object)CheckInputReadEntity.readEntities[1].getName());
        Assert.assertFalse((String)"Table is not direct input", (boolean)CheckInputReadEntity.readEntities[1].isDirect());
        Set parents = CheckInputReadEntity.readEntities[1].getParents();
        Assert.assertTrue((String)"Table does not have parent", (parents != null && parents.size() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)("default@" + tab1), (Object)CheckInputReadEntity.readEntities[2].getName());
        Assert.assertFalse((String)"Table is not direct input", (boolean)CheckInputReadEntity.readEntities[2].isDirect());
    }

    @Test
    public void testUnionAllInSubView() throws Exception {
        String prefix = "tvunionallinsubview" + this.NAME_PREFIX;
        String tab1 = prefix + "t";
        String view1 = prefix + "v";
        String view2 = prefix + "v2";
        driver.run("create table " + tab1 + "(id int)");
        driver.run("create view " + view1 + " as select * from " + tab1);
        driver.run("create view " + view2 + " as select * from (select * from " + view1 + " union all select * from " + view1 + ") x");
        driver.compile("select * from " + view2, true);
        Assert.assertEquals((Object)("default@" + view2), (Object)CheckInputReadEntity.readEntities[0].getName());
        Assert.assertEquals((Object)("default@" + view1), (Object)CheckInputReadEntity.readEntities[1].getName());
        Assert.assertFalse((String)"Table is not direct input", (boolean)CheckInputReadEntity.readEntities[1].isDirect());
        Set parents = CheckInputReadEntity.readEntities[1].getParents();
        Assert.assertTrue((String)"Table does not have parent", (parents != null && parents.size() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)("default@" + tab1), (Object)CheckInputReadEntity.readEntities[2].getName());
        Assert.assertFalse((String)"Table is not direct input", (boolean)CheckInputReadEntity.readEntities[2].isDirect());
    }

    @Test
    public void alterView() throws CommandProcessorException {
        driver.run("create table test_table (id int)");
        driver.run("create view test_view as select * from test_table");
        driver.compile("create view test_view_1 as select * from test_view", true);
        Assert.assertEquals((Object)"default@test_view", (Object)CheckInputReadEntity.readEntities[0].getName());
        Assert.assertTrue((String)"default@test_view", (boolean)CheckInputReadEntity.readEntities[0].isDirect());
        Assert.assertEquals((Object)"default@test_table", (Object)CheckInputReadEntity.readEntities[1].getName());
        Assert.assertFalse((String)"default@test_table", (boolean)CheckInputReadEntity.readEntities[1].isDirect());
        driver.run("create view test_view_1 as select * from test_view");
        driver.compile("alter view test_view_1 as select * from test_view", true);
        Assert.assertEquals((Object)"default@test_view", (Object)CheckInputReadEntity.readEntities[0].getName());
        Assert.assertTrue((String)"default@test_view", (boolean)CheckInputReadEntity.readEntities[0].isDirect());
        Assert.assertEquals((Object)"default@test_table", (Object)CheckInputReadEntity.readEntities[1].getName());
        Assert.assertFalse((String)"default@test_table", (boolean)CheckInputReadEntity.readEntities[1].isDirect());
    }

    public static class CheckInputReadEntity
    extends AbstractSemanticAnalyzerHook {
        public static ReadEntity[] readEntities;

        public void postAnalyze(HiveSemanticAnalyzerHookContext context, List<Task<?>> rootTasks) throws SemanticException {
            readEntities = context.getInputs().toArray(new ReadEntity[0]);
        }
    }
}

