/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.mapred.TextInputFormat;
import org.junit.Assert;
import org.junit.Test;

public class TestMapWork {
    @Test
    public void testGetAndSetConsistency() {
        MapWork mw = new MapWork();
        LinkedHashMap<Path, ArrayList> pathToAliases = new LinkedHashMap<Path, ArrayList>();
        pathToAliases.put(new Path("p0"), Lists.newArrayList((Object[])new String[]{"a1", "a2"}));
        mw.setPathToAliases(pathToAliases);
        Map pta = mw.getPathToAliases();
        Assert.assertEquals(pathToAliases, (Object)pta);
    }

    @Test
    public void testPath() {
        Path p1 = new Path("hdfs://asd/asd");
        Path p2 = new Path("hdfs://asd/asd/");
        Assert.assertEquals((Object)p1, (Object)p2);
    }

    @Test
    public void testDeriveLlapSetsCacheAffinityForTextInputFormat() {
        MapWork mapWork = new MapWork();
        PartitionDesc partitionDesc = new PartitionDesc();
        partitionDesc.setInputFileFormatClass(TextInputFormat.class);
        mapWork.addPathToPartitionInfo(new Path("/tmp"), partitionDesc);
        Configuration conf = new Configuration(false);
        HiveConf.setVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_ENABLED, (String)"true");
        HiveConf.setBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_NONVECTOR_WRAPPER_ENABLED, (boolean)true);
        mapWork.deriveLlap(conf, false);
        Assert.assertTrue((String)"Cache affinity should be set for TextInputFormat, as LLAP serde cache would use it", (boolean)mapWork.getCacheAffinity());
    }
}

