/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.type;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.type.HiveFunctionHelper;
import org.junit.Assert;
import org.junit.Test;

public class TestHiveFunctionHelper {
    @Test
    public void testGetUDTFFunction() throws SemanticException {
        JavaTypeFactoryImpl typeFactory = new JavaTypeFactoryImpl();
        RexBuilder rexBuilder = new RexBuilder((RelDataTypeFactory)typeFactory);
        ArrayList operands = Lists.newArrayList((Object[])new RexNode[]{rexBuilder.makeLiteral("hello"), rexBuilder.makeLiteral("world")});
        ArrayList arrayNode = Lists.newArrayList((Object[])new RexNode[]{rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.ARRAY_VALUE_CONSTRUCTOR, (List)operands)});
        HiveFunctionHelper functionHelper = new HiveFunctionHelper(rexBuilder);
        RexCall explodeNode = functionHelper.getUDTFFunction("explode", (List)arrayNode);
        Assert.assertEquals((Object)explodeNode.toString(), (Object)"explode(ARRAY('hello', 'world'))");
        Assert.assertEquals((Object)explodeNode.getType().toString(), (Object)"RecordType(CHAR(5) col)");
    }

    @Test(expected=Exception.class)
    public void testGetUDTFFunctionThrowingException() throws SemanticException {
        JavaTypeFactoryImpl typeFactory = new JavaTypeFactoryImpl();
        RexBuilder rexBuilder = new RexBuilder((RelDataTypeFactory)typeFactory);
        ArrayList operands = Lists.newArrayList((Object[])new RexNode[]{rexBuilder.makeLiteral("hello")});
        HiveFunctionHelper functionHelper = new HiveFunctionHelper(rexBuilder);
        functionHelper.getUDTFFunction("upper", (List)operands);
    }
}

