/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.type;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.type.ExprNodeDescExprFactory;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;

public class TestExprNodeDescExprFactory
extends TestCase {
    public void testToExprWhenColumnIsPrimitive() throws SemanticException {
        ExprNodeDescExprFactory exprFactory = new ExprNodeDescExprFactory();
        ColumnInfo columnInfo = new ColumnInfo();
        columnInfo.setTypeName("decimal(3,2)");
        DecimalTypeInfo typeInfo = new DecimalTypeInfo(3, 2);
        columnInfo.setObjectinspector((ObjectInspector)PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)typeInfo, (Object)new HiveDecimalWritable(HiveDecimal.create((double)6.4))));
        ExprNodeDesc exprNodeDesc = exprFactory.toExpr(columnInfo, null, 0);
        MatcherAssert.assertThat((Object)exprNodeDesc.getExprString(), (Matcher)CoreMatchers.is((Object)"6.4"));
    }

    public void testToExprWhenColumnIsPrimitiveNullValue() throws SemanticException {
        ExprNodeDescExprFactory exprFactory = new ExprNodeDescExprFactory();
        ColumnInfo columnInfo = new ColumnInfo();
        columnInfo.setTypeName("decimal(3,2)");
        DecimalTypeInfo typeInfo = new DecimalTypeInfo(3, 2);
        columnInfo.setObjectinspector((ObjectInspector)PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)typeInfo, null));
        ExprNodeDesc exprNodeDesc = exprFactory.toExpr(columnInfo, null, 0);
        MatcherAssert.assertThat((Object)exprNodeDesc.getExprString(), (Matcher)CoreMatchers.is((Object)"null"));
    }

    public void testToExprWhenColumnIsList() throws SemanticException {
        ExprNodeDescExprFactory exprFactory = new ExprNodeDescExprFactory();
        ColumnInfo columnInfo = new ColumnInfo();
        columnInfo.setTypeName("array<decimal(3,2)>");
        DecimalTypeInfo typeInfo = new DecimalTypeInfo(3, 2);
        columnInfo.setObjectinspector((ObjectInspector)ObjectInspectorFactory.getStandardConstantListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)typeInfo), Arrays.asList(new HiveDecimalWritable(HiveDecimal.create((double)5.0)), new HiveDecimalWritable(HiveDecimal.create((double)0.4)), null)));
        ExprNodeDesc exprNodeDesc = exprFactory.toExpr(columnInfo, null, 0);
        MatcherAssert.assertThat((Object)exprNodeDesc.getExprString(), (Matcher)CoreMatchers.is((Object)"Const array<decimal(3,2)> [5, 0.4, null]"));
    }

    public void testToExprWhenColumnIsListWithNullValue() throws SemanticException {
        ExprNodeDescExprFactory exprFactory = new ExprNodeDescExprFactory();
        ColumnInfo columnInfo = new ColumnInfo();
        columnInfo.setTypeName("array<decimal(3,2)>");
        DecimalTypeInfo typeInfo = new DecimalTypeInfo(3, 2);
        columnInfo.setObjectinspector((ObjectInspector)ObjectInspectorFactory.getStandardConstantListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)typeInfo), null));
        ExprNodeDesc exprNodeDesc = exprFactory.toExpr(columnInfo, null, 0);
        MatcherAssert.assertThat((Object)exprNodeDesc.getExprString(), (Matcher)CoreMatchers.is((Object)"Const array<decimal(3,2)> null"));
    }

    public void testToExprWhenColumnIsMap() throws SemanticException {
        ExprNodeDescExprFactory exprFactory = new ExprNodeDescExprFactory();
        ColumnInfo columnInfo = new ColumnInfo();
        columnInfo.setTypeName("map<int,string>");
        columnInfo.setObjectinspector((ObjectInspector)ObjectInspectorFactory.getStandardConstantMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.INT), (ObjectInspector)PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.STRING), (Map)new HashMap<IntWritable, Text>(){
            {
                this.put(new IntWritable(4), new Text("foo"));
                this.put(null, null);
            }
        }));
        ExprNodeDesc exprNodeDesc = exprFactory.toExpr(columnInfo, null, 0);
        MatcherAssert.assertThat((Object)exprNodeDesc.getExprString(), (Matcher)CoreMatchers.is((Object)"Const map<int,string> {null=null, 4=foo}"));
    }

    public void testToExprWhenColumnIsMapWithNullValue() throws SemanticException {
        ExprNodeDescExprFactory exprFactory = new ExprNodeDescExprFactory();
        ColumnInfo columnInfo = new ColumnInfo();
        columnInfo.setTypeName("map<int,string>");
        columnInfo.setObjectinspector((ObjectInspector)ObjectInspectorFactory.getStandardConstantMapObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.INT), (ObjectInspector)PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.STRING), null));
        ExprNodeDesc exprNodeDesc = exprFactory.toExpr(columnInfo, null, 0);
        MatcherAssert.assertThat((Object)exprNodeDesc.getExprString(), (Matcher)CoreMatchers.is((Object)"Const map<int,string> null"));
    }

    public void testToExprWhenColumnIsStruct() throws SemanticException {
        ExprNodeDescExprFactory exprFactory = new ExprNodeDescExprFactory();
        ColumnInfo columnInfo = new ColumnInfo();
        columnInfo.setTypeName("struct<f1:int,f2:string>");
        columnInfo.setObjectinspector((ObjectInspector)ObjectInspectorFactory.getStandardConstantStructObjectInspector(Arrays.asList("f1", "f2"), Arrays.asList(PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.INT), PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.STRING)), Arrays.asList(new IntWritable(4), new Text("foo"))));
        ExprNodeDesc exprNodeDesc = exprFactory.toExpr(columnInfo, null, 0);
        MatcherAssert.assertThat((Object)exprNodeDesc.getExprString(), (Matcher)CoreMatchers.is((Object)"const struct(4,'foo')"));
    }

    public void testToExprWhenColumnIsStructWithNullFields() throws SemanticException {
        ExprNodeDescExprFactory exprFactory = new ExprNodeDescExprFactory();
        ColumnInfo columnInfo = new ColumnInfo();
        columnInfo.setTypeName("struct<f1:int,f2:string>");
        columnInfo.setObjectinspector((ObjectInspector)ObjectInspectorFactory.getStandardConstantStructObjectInspector(Arrays.asList("f1", "f2"), Arrays.asList(PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.INT), PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.STRING)), Arrays.asList(null, null)));
        ExprNodeDesc exprNodeDesc = exprFactory.toExpr(columnInfo, null, 0);
        MatcherAssert.assertThat((Object)exprNodeDesc.getExprString(), (Matcher)CoreMatchers.is((Object)"const struct(null,null)"));
    }

    public void testToExprWhenColumnIsStructWithNullValue() throws SemanticException {
        ExprNodeDescExprFactory exprFactory = new ExprNodeDescExprFactory();
        ColumnInfo columnInfo = new ColumnInfo();
        columnInfo.setTypeName("struct<f1:int,f2:string>");
        columnInfo.setObjectinspector((ObjectInspector)ObjectInspectorFactory.getStandardConstantStructObjectInspector(Arrays.asList("f1", "f2"), Arrays.asList(PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.INT), PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)PrimitiveObjectInspector.PrimitiveCategory.STRING)), null));
        ExprNodeDesc exprNodeDesc = exprFactory.toExpr(columnInfo, null, 0);
        MatcherAssert.assertThat((Object)exprNodeDesc.getExprString(), (Matcher)CoreMatchers.is((Object)"null"));
    }
}

