/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.type;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveConfForTest;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.type.ExprNodeTypeCheck;
import org.apache.hadoop.hive.ql.parse.type.TypeCheckCtx;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestDecimalStringValidation {
    private final FunctionCall call;

    public TestDecimalStringValidation(FunctionCall call) {
        this.call = call;
    }

    @Parameterized.Parameters(name="{index}: {0}")
    public static Collection<FunctionCall> params() throws Exception {
        ExprNodeDesc[] characterExps = new ExprNodeDesc[]{new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.varcharTypeInfo, "varchar_col", null, false), new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.charTypeInfo, "char_col", null, false), new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, "string_col", null, false), new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.varcharTypeInfo, (Object)"123.3"), new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.charTypeInfo, (Object)"123.3"), new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, (Object)"123.3")};
        ExprNodeDesc[] numericExps = new ExprNodeDesc[]{new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.decimalTypeInfo, "decimal_col", null, false), new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.decimalTypeInfo, (Object)123.3)};
        FunctionInfo[] functions = new FunctionInfo[]{FunctionRegistry.getFunctionInfo((String)"="), FunctionRegistry.getFunctionInfo((String)"<"), FunctionRegistry.getFunctionInfo((String)">"), FunctionRegistry.getFunctionInfo((String)"<>"), FunctionRegistry.getFunctionInfo((String)"<="), FunctionRegistry.getFunctionInfo((String)">="), FunctionRegistry.getFunctionInfo((String)"<=>")};
        ArrayList<FunctionCall> input = new ArrayList<FunctionCall>();
        for (ExprNodeDesc chrExp : characterExps) {
            for (ExprNodeDesc numExp : numericExps) {
                for (FunctionInfo function : functions) {
                    input.add(new FunctionCall(chrExp, numExp, function));
                    input.add(new FunctionCall(numExp, chrExp, function));
                }
            }
        }
        return input;
    }

    @Test
    public void testValidationDecimalWithCharacterFailsWhenStrictChecksEnabled() {
        HiveConfForTest conf = new HiveConfForTest(this.getClass());
        conf.setBoolVar(HiveConf.ConfVars.HIVE_STRICT_CHECKS_TYPE_SAFETY, true);
        try {
            this.validateCall((HiveConf)conf);
            Assert.fail((String)("Validation of " + this.call + " should fail"));
        }
        catch (Exception e) {
            Assert.assertEquals((Object)HiveConf.StrictChecks.checkTypeSafety((Configuration)conf), (Object)e.getMessage());
        }
    }

    @Test
    public void testValidationDecimalWithCharacterSucceedsWhenStrictChecksDisabled() throws SemanticException {
        HiveConfForTest conf = new HiveConfForTest(this.getClass());
        conf.setBoolVar(HiveConf.ConfVars.HIVE_STRICT_CHECKS_TYPE_SAFETY, false);
        this.validateCall((HiveConf)conf);
    }

    private void validateCall(HiveConf conf) throws SemanticException {
        SessionState.start((HiveConf)conf);
        TypeCheckCtx ctx = new TypeCheckCtx(null);
        ExprNodeTypeCheck.getExprNodeDefaultExprProcessor().validateUDF(null, false, ctx, this.call.function, Arrays.asList(this.call.expL, this.call.expR));
    }

    private static class FunctionCall {
        private final ExprNodeDesc expL;
        private final ExprNodeDesc expR;
        private final FunctionInfo function;

        public FunctionCall(ExprNodeDesc expL, ExprNodeDesc expR, FunctionInfo function) {
            this.expL = expL;
            this.expR = expR;
            this.function = function;
        }

        public String toString() {
            return this.function.getDisplayName() + "(" + this.expL + "," + this.expR + ")";
        }
    }
}

