/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.type;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.parse.type.ExprNodeTypeCheck;
import org.apache.hadoop.hive.ql.parse.type.TypeCheckCtx;
import org.apache.hadoop.hive.ql.parse.type.TypeCheckProcFactory;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestBigIntCompareValidation {
    private ExprNodeConstantDesc constant;
    private TypeCheckProcFactory.DefaultExprProcessor processor;
    private String errorMsg;
    private FunctionInfo functionInfo;

    @Before
    public void setUp() throws Exception {
        this.constant = new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.longTypeInfo, (Object)0L);
        this.processor = ExprNodeTypeCheck.getExprNodeDefaultExprProcessor();
        this.errorMsg = HiveConf.StrictChecks.checkTypeSafety((Configuration)new HiveConf());
        this.functionInfo = FunctionRegistry.getFunctionInfo((String)"=");
    }

    @Test
    public void testCompareWithVarchar() {
        ExprNodeColumnDesc nodeDesc = new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.varcharTypeInfo, "_c0", null, false);
        this.testValidateUDFOnComparingBigInt((ExprNodeDesc)nodeDesc);
    }

    @Test
    public void testCompareWithString() {
        ExprNodeColumnDesc nodeDesc = new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.stringTypeInfo, "_c1", null, false);
        this.testValidateUDFOnComparingBigInt((ExprNodeDesc)nodeDesc);
    }

    @Test
    public void testCompareWithChar() {
        ExprNodeColumnDesc nodeDesc = new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.charTypeInfo, "_c2", null, false);
        this.testValidateUDFOnComparingBigInt((ExprNodeDesc)nodeDesc);
    }

    private void testValidateUDFOnComparingBigInt(ExprNodeDesc nodeDesc) {
        try {
            TypeCheckCtx ctx = new TypeCheckCtx(null);
            this.processor.validateUDF(null, false, ctx, this.functionInfo, (List)Lists.newArrayList((Object[])new ExprNodeDesc[]{this.constant, nodeDesc}));
            Assert.fail((String)("Should throw exception as comparing a bigint and a " + nodeDesc.getTypeString()));
        }
        catch (Exception e) {
            Assert.assertEquals((Object)this.errorMsg, (Object)e.getMessage());
        }
    }
}

