/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.metric;

import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.HashMap;
import java.util.LinkedList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.repl.ReplAck;
import org.apache.hadoop.hive.ql.exec.repl.ReplDumpWork;
import org.apache.hadoop.hive.ql.exec.repl.ReplLoadWork;
import org.apache.hadoop.hive.ql.parse.ExplainConfiguration;
import org.apache.hadoop.hive.ql.parse.repl.dump.metric.BootstrapDumpMetricCollector;
import org.apache.hadoop.hive.ql.parse.repl.dump.metric.IncrementalDumpMetricCollector;
import org.apache.hadoop.hive.ql.parse.repl.load.metric.BootstrapLoadMetricCollector;
import org.apache.hadoop.hive.ql.parse.repl.load.metric.IncrementalLoadMetricCollector;
import org.apache.hadoop.hive.ql.parse.repl.metric.MetricCollector;
import org.apache.hadoop.hive.ql.parse.repl.metric.event.Progress;
import org.apache.hadoop.hive.ql.parse.repl.metric.event.ReplicationMetric;
import org.apache.hadoop.hive.ql.parse.repl.metric.event.Status;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TestReplicationMetricUpdateOnFailure {
    FileSystem fs;
    HiveConf conf;
    String TEST_PATH;
    @Rule
    public final TestName testName = new TestName();
    RuntimeException recoverableException = new RuntimeException();
    RuntimeException nonRecoverableException = new RuntimeException(ErrorMsg.REPL_FAILED_WITH_NON_RECOVERABLE_ERROR.getMsg());

    @Before
    public void setup() throws Exception {
        this.conf = new HiveConf();
        this.conf.set(HiveConf.ConfVars.HIVE_IN_TEST.varname, "false");
        this.conf.set("scheduled.query.schedulename", "repl");
        this.conf.set("scheduled.query.executionid", "1");
        String tid = TestReplicationMetricUpdateOnFailure.class.getCanonicalName().toLowerCase().replace('.', '_') + "_" + System.currentTimeMillis();
        this.TEST_PATH = System.getProperty("test.warehouse.dir", "/tmp") + "/" + tid;
        Path testPath = new Path(this.TEST_PATH);
        this.fs = FileSystem.get((URI)testPath.toUri(), (Configuration)this.conf);
        this.fs.mkdirs(testPath);
    }

    @Test
    public void testReplDumpFailure() throws Exception {
        String dumpDir = this.TEST_PATH + "/" + this.testName.getMethodName();
        IncrementalDumpMetricCollector metricCollector = new IncrementalDumpMetricCollector(null, this.TEST_PATH, this.conf, Long.valueOf(0L));
        ReplDumpWork replDumpWork = (ReplDumpWork)Mockito.mock(ReplDumpWork.class);
        Mockito.when((Object)replDumpWork.getCurrentDumpPath()).thenReturn((Object)new Path(dumpDir));
        Mockito.when((Object)replDumpWork.getMetricCollector()).thenReturn((Object)metricCollector);
        Mockito.when((Object)replDumpWork.dataCopyIteratorsInitialized()).thenThrow(new Throwable[]{this.recoverableException, this.nonRecoverableException});
        Task replDumpTask = TaskFactory.get((Serializable)replDumpWork, (HiveConf)this.conf);
        String stageName = "REPL_DUMP";
        metricCollector.reportStageStart(stageName, new HashMap());
        Assert.assertThrows(RuntimeException.class, () -> replDumpTask.execute());
        this.performRecoverableChecks(stageName);
        metricCollector.reportStageStart(stageName, new HashMap());
        Assert.assertThrows(RuntimeException.class, () -> replDumpTask.execute());
        this.performNonRecoverableChecks(dumpDir, stageName);
    }

    @Test
    public void testReplDumpRecoverableMissingStage() throws Exception {
        String dumpDir = this.TEST_PATH + "/" + this.testName.getMethodName();
        MetricCollector.getInstance().deinit();
        BootstrapDumpMetricCollector metricCollector = new BootstrapDumpMetricCollector(null, this.TEST_PATH, this.conf, Long.valueOf(0L));
        ReplDumpWork replDumpWork = (ReplDumpWork)Mockito.mock(ReplDumpWork.class);
        Mockito.when((Object)replDumpWork.getMetricCollector()).thenReturn((Object)metricCollector);
        Mockito.when((Object)replDumpWork.getCurrentDumpPath()).thenReturn((Object)new Path(dumpDir));
        Mockito.when((Object)replDumpWork.dataCopyIteratorsInitialized()).thenThrow(new Throwable[]{this.recoverableException});
        Task replDumpTask = TaskFactory.get((Serializable)replDumpWork, (HiveConf)this.conf);
        Assert.assertEquals((long)0L, (long)MetricCollector.getInstance().getMetrics().size());
        Assert.assertThrows(RuntimeException.class, () -> replDumpTask.execute());
        this.performRecoverableChecks("REPL_DUMP");
    }

    @Test
    public void testReplDumpNonRecoverableMissingStage() throws Exception {
        String dumpDir = this.TEST_PATH + "/" + this.testName.getMethodName();
        MetricCollector.getInstance().deinit();
        IncrementalDumpMetricCollector metricCollector = new IncrementalDumpMetricCollector(null, this.TEST_PATH, this.conf, Long.valueOf(0L));
        ReplDumpWork replDumpWork = (ReplDumpWork)Mockito.mock(ReplDumpWork.class);
        Mockito.when((Object)replDumpWork.getCurrentDumpPath()).thenReturn((Object)new Path(dumpDir));
        Mockito.when((Object)replDumpWork.getMetricCollector()).thenReturn((Object)metricCollector);
        Mockito.when((Object)replDumpWork.dataCopyIteratorsInitialized()).thenThrow(new Throwable[]{this.nonRecoverableException});
        Task replDumpTask = TaskFactory.get((Serializable)replDumpWork, (HiveConf)this.conf);
        Assert.assertEquals((long)0L, (long)MetricCollector.getInstance().getMetrics().size());
        Assert.assertThrows(RuntimeException.class, () -> replDumpTask.execute());
        this.performNonRecoverableChecks(dumpDir, "REPL_DUMP");
    }

    @Test
    public void testReplLoadFailure() throws Exception {
        String dumpDir = this.TEST_PATH + "/" + this.testName.getMethodName();
        MetricCollector.getInstance().deinit();
        IncrementalLoadMetricCollector metricCollector = new IncrementalLoadMetricCollector(null, this.TEST_PATH, 0L, this.conf);
        ReplLoadWork replLoadWork = (ReplLoadWork)Mockito.mock(ReplLoadWork.class);
        Mockito.when((Object)replLoadWork.getTargetDatabase()).thenReturn((Object)"dummy");
        Mockito.when((Object)replLoadWork.getDumpDirectory()).thenReturn((Object)new Path(dumpDir + "/test").toString());
        Mockito.when((Object)replLoadWork.getMetricCollector()).thenReturn((Object)metricCollector);
        Mockito.when((Object)replLoadWork.getRootTask()).thenThrow(new Throwable[]{this.recoverableException, this.nonRecoverableException});
        Task replLoadTask = TaskFactory.get((Serializable)replLoadWork, (HiveConf)this.conf);
        String stageName = "REPL_LOAD";
        metricCollector.reportStageStart(stageName, new HashMap());
        Assert.assertThrows(RuntimeException.class, () -> replLoadTask.execute());
        this.performRecoverableChecks(stageName);
        metricCollector.reportStageStart(stageName, new HashMap());
        Assert.assertThrows(RuntimeException.class, () -> replLoadTask.execute());
        this.performNonRecoverableChecks(dumpDir, stageName);
    }

    @Test
    public void testReplLoadRecoverableMissingStage() throws Exception {
        String dumpDir = this.TEST_PATH + "/" + this.testName.getMethodName();
        MetricCollector.getInstance().deinit();
        BootstrapLoadMetricCollector metricCollector = new BootstrapLoadMetricCollector(null, this.TEST_PATH, 0L, this.conf);
        ReplLoadWork replLoadWork = (ReplLoadWork)Mockito.mock(ReplLoadWork.class);
        Mockito.when((Object)replLoadWork.getTargetDatabase()).thenReturn((Object)"dummy");
        Mockito.when((Object)replLoadWork.getDumpDirectory()).thenReturn((Object)new Path(dumpDir + "/test").toString());
        Mockito.when((Object)replLoadWork.getMetricCollector()).thenReturn((Object)metricCollector);
        Mockito.when((Object)replLoadWork.getRootTask()).thenThrow(new Throwable[]{this.recoverableException});
        Task replLoadTask = TaskFactory.get((Serializable)replLoadWork, (HiveConf)this.conf);
        Assert.assertEquals((long)0L, (long)MetricCollector.getInstance().getMetrics().size());
        Assert.assertThrows(RuntimeException.class, () -> replLoadTask.execute());
        this.performRecoverableChecks("REPL_LOAD");
    }

    @Test
    public void testReplLoadNonRecoverableMissingStage() throws Exception {
        String dumpDir = this.TEST_PATH + "/" + this.testName.getMethodName();
        MetricCollector.getInstance().deinit();
        IncrementalLoadMetricCollector metricCollector = new IncrementalLoadMetricCollector(null, this.TEST_PATH, 0L, this.conf);
        ReplLoadWork replLoadWork = (ReplLoadWork)Mockito.mock(ReplLoadWork.class);
        Mockito.when((Object)replLoadWork.getTargetDatabase()).thenReturn((Object)"dummy");
        Mockito.when((Object)replLoadWork.getDumpDirectory()).thenReturn((Object)new Path(dumpDir + "/test").toString());
        Mockito.when((Object)replLoadWork.getMetricCollector()).thenReturn((Object)metricCollector);
        Mockito.when((Object)replLoadWork.getRootTask()).thenThrow(new Throwable[]{this.nonRecoverableException});
        Task replLoadTask = TaskFactory.get((Serializable)replLoadWork, (HiveConf)this.conf);
        Assert.assertEquals((long)0L, (long)MetricCollector.getInstance().getMetrics().size());
        Assert.assertThrows(RuntimeException.class, () -> replLoadTask.execute());
        this.performNonRecoverableChecks(dumpDir, "REPL_LOAD");
    }

    @Test
    public void testDDLTaskFailure() throws Exception {
        DDLWork ddlWork = (DDLWork)Mockito.mock(DDLWork.class);
        Context context = (Context)Mockito.mock(Context.class);
        Mockito.when((Object)context.getExplainAnalyze()).thenReturn((Object)ExplainConfiguration.AnalyzeState.ANALYZING);
        Mockito.when((Object)ddlWork.isReplication()).thenReturn((Object)true);
        String dumpDir = this.TEST_PATH + "/" + this.testName.getMethodName();
        Mockito.when((Object)ddlWork.getDumpDirectory()).thenReturn((Object)dumpDir);
        Task ddlTask = TaskFactory.get((Serializable)ddlWork, (HiveConf)this.conf);
        ddlTask.initialize(null, null, null, context);
        IncrementalLoadMetricCollector metricCollector = new IncrementalLoadMetricCollector(null, this.TEST_PATH, 1L, this.conf);
        Mockito.when((Object)ddlWork.getMetricCollector()).thenReturn((Object)metricCollector);
        Mockito.when((Object)ddlWork.getDDLDesc()).thenThrow(new Throwable[]{this.recoverableException, this.nonRecoverableException});
        String stageName = "REPL_LOAD";
        metricCollector.reportStageStart(stageName, new HashMap());
        ddlTask.execute();
        this.performRecoverableChecks(stageName);
        metricCollector.reportStageStart(stageName, new HashMap());
        ddlTask.execute();
        this.performNonRecoverableChecks(dumpDir, stageName);
    }

    @Test
    public void testRecoverableDDLFailureWithStageMissing() throws Exception {
        DDLWork ddlWork = (DDLWork)Mockito.mock(DDLWork.class);
        Context context = (Context)Mockito.mock(Context.class);
        Mockito.when((Object)context.getExplainAnalyze()).thenReturn((Object)ExplainConfiguration.AnalyzeState.ANALYZING);
        Mockito.when((Object)ddlWork.isReplication()).thenReturn((Object)true);
        String dumpDir = this.TEST_PATH + "/" + this.testName.getMethodName();
        Mockito.when((Object)ddlWork.getDumpDirectory()).thenReturn((Object)dumpDir);
        Task ddlTask = TaskFactory.get((Serializable)ddlWork, (HiveConf)this.conf);
        ddlTask.initialize(null, null, null, context);
        MetricCollector.getInstance().deinit();
        IncrementalLoadMetricCollector metricCollector = new IncrementalLoadMetricCollector(null, this.TEST_PATH, 1L, this.conf);
        Assert.assertEquals((long)0L, (long)MetricCollector.getInstance().getMetrics().size());
        HashMap metricMap = new HashMap();
        Mockito.when((Object)ddlWork.getMetricCollector()).thenReturn((Object)metricCollector);
        Mockito.when((Object)ddlWork.getDDLDesc()).thenThrow(new Throwable[]{this.recoverableException});
        ddlTask.execute();
        this.performRecoverableChecks("REPL_LOAD");
    }

    @Test
    public void testNonRecoverableDDLFailureWithStageMissing() throws Exception {
        DDLWork ddlWork = (DDLWork)Mockito.mock(DDLWork.class);
        Context context = (Context)Mockito.mock(Context.class);
        Mockito.when((Object)context.getExplainAnalyze()).thenReturn((Object)ExplainConfiguration.AnalyzeState.ANALYZING);
        Mockito.when((Object)ddlWork.isReplication()).thenReturn((Object)true);
        String dumpDir = this.TEST_PATH + "/" + this.testName.getMethodName();
        Mockito.when((Object)ddlWork.getDumpDirectory()).thenReturn((Object)dumpDir);
        Task ddlTask = TaskFactory.get((Serializable)ddlWork, (HiveConf)this.conf);
        ddlTask.initialize(null, null, null, context);
        MetricCollector.getInstance().deinit();
        IncrementalLoadMetricCollector metricCollector = new IncrementalLoadMetricCollector(null, this.TEST_PATH, 1L, this.conf);
        Assert.assertEquals((long)0L, (long)MetricCollector.getInstance().getMetrics().size());
        HashMap metricMap = new HashMap();
        Mockito.when((Object)ddlWork.getMetricCollector()).thenReturn((Object)metricCollector);
        Mockito.when((Object)ddlWork.getDDLDesc()).thenThrow(new Throwable[]{this.nonRecoverableException});
        ddlTask.execute();
        this.performNonRecoverableChecks(dumpDir, "REPL_LOAD");
    }

    void performRecoverableChecks(String stageName) {
        LinkedList metricList = MetricCollector.getInstance().getMetrics();
        Assert.assertEquals((long)1L, (long)metricList.size());
        ReplicationMetric updatedMetric = (ReplicationMetric)metricList.get(0);
        Progress updatedProgress = updatedMetric.getProgress();
        Assert.assertEquals((Object)Status.FAILED, (Object)updatedProgress.getStatus());
        Assert.assertEquals((long)1L, (long)updatedProgress.getStages().size());
        Assert.assertEquals((Object)Status.FAILED, (Object)updatedProgress.getStageByName(stageName).getStatus());
        Assert.assertNotEquals((long)0L, (long)updatedProgress.getStageByName(stageName).getEndTime());
    }

    void performNonRecoverableChecks(String dumpDir, String stageName) throws IOException {
        LinkedList metricList = MetricCollector.getInstance().getMetrics();
        Assert.assertEquals((long)1L, (long)metricList.size());
        ReplicationMetric updatedMetric = (ReplicationMetric)metricList.get(0);
        Progress updatedProgress = updatedMetric.getProgress();
        Assert.assertEquals((Object)Status.FAILED_ADMIN, (Object)updatedProgress.getStatus());
        Assert.assertEquals((long)1L, (long)updatedProgress.getStages().size());
        Assert.assertEquals((Object)Status.FAILED_ADMIN, (Object)updatedProgress.getStageByName(stageName).getStatus());
        Assert.assertNotEquals((long)0L, (long)updatedProgress.getStageByName(stageName).getEndTime());
        Path expectedNonRecoverablePath = new Path(new Path(dumpDir), ReplAck.NON_RECOVERABLE_MARKER.toString());
        Assert.assertTrue((boolean)this.fs.exists(expectedNonRecoverablePath));
        this.fs.delete(expectedNonRecoverablePath, true);
        MetricCollector.getInstance().deinit();
    }
}

