/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.metric;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.repl.ReplConst;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.GetReplicationMetricsRequest;
import org.apache.hadoop.hive.metastore.api.ReplicationMetricList;
import org.apache.hadoop.hive.metastore.api.ReplicationMetrics;
import org.apache.hadoop.hive.metastore.messaging.MessageDeserializer;
import org.apache.hadoop.hive.metastore.messaging.MessageFactory;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.exec.repl.ReplStatsTracker;
import org.apache.hadoop.hive.ql.exec.repl.util.ReplUtils;
import org.apache.hadoop.hive.ql.exec.repl.util.SnapshotUtils;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.repl.dump.metric.BootstrapDumpMetricCollector;
import org.apache.hadoop.hive.ql.parse.repl.dump.metric.IncrementalDumpMetricCollector;
import org.apache.hadoop.hive.ql.parse.repl.load.FailoverMetaData;
import org.apache.hadoop.hive.ql.parse.repl.metric.MetricSink;
import org.apache.hadoop.hive.ql.parse.repl.metric.event.Metadata;
import org.apache.hadoop.hive.ql.parse.repl.metric.event.Metric;
import org.apache.hadoop.hive.ql.parse.repl.metric.event.Progress;
import org.apache.hadoop.hive.ql.parse.repl.metric.event.ProgressMapper;
import org.apache.hadoop.hive.ql.parse.repl.metric.event.ReplicationMetric;
import org.apache.hadoop.hive.ql.parse.repl.metric.event.Stage;
import org.apache.hadoop.hive.ql.parse.repl.metric.event.StageMapper;
import org.apache.hadoop.hive.ql.parse.repl.metric.event.Status;
import org.apache.thrift.TException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TestReplicationMetricSink {
    MessageDeserializer deserializer;
    HiveConf conf;
    @Mock
    private FailoverMetaData fmd;

    @Before
    public void setup() throws Exception {
        this.conf = new HiveConf();
        this.conf.set("scheduled.query.schedulename", "repl");
        this.conf.set("scheduled.query.executionid", "1");
        MetricSink metricSinkSpy = (MetricSink)Mockito.spy((Object)MetricSink.getInstance());
        ((MetricSink)Mockito.doReturn((Object)1L).when((Object)metricSinkSpy)).getFrequencyInSecs();
        metricSinkSpy.init(this.conf);
        this.deserializer = MessageFactory.getDefaultInstanceForReplMetrics((Configuration)this.conf).getDeserializer();
    }

    private String deSerialize(String msg) {
        return this.deserializer.deSerializeGenericString(msg);
    }

    @Ignore(value="HIVE-26262")
    @Test
    public void testSuccessBootstrapDumpMetrics() throws Exception {
        BootstrapDumpMetricCollector bootstrapDumpMetricCollector = new BootstrapDumpMetricCollector("testAcidTablesReplLoadBootstrapIncr_1592205875387", "hdfs://localhost:65158/tmp/org_apache_hadoop_hive_ql_parse_TestReplicationScenarios_245261428230295/hrepl0/dGVzdGFjaWR0YWJsZXNyZXBsbG9hZGJvb3RzdHJhcGluY3JfMTU5MjIwNTg3NTM4Nw==/0/hive", this.conf, Long.valueOf(0L));
        HashMap<String, Long> metricMap = new HashMap();
        metricMap.put(ReplUtils.MetricName.TABLES.name(), 10L);
        metricMap.put(ReplUtils.MetricName.FUNCTIONS.name(), 1L);
        bootstrapDumpMetricCollector.reportStageStart("dump", metricMap);
        bootstrapDumpMetricCollector.reportStageProgress("dump", ReplUtils.MetricName.TABLES.name(), 1L);
        bootstrapDumpMetricCollector.reportStageProgress("dump", ReplUtils.MetricName.TABLES.name(), 2L);
        bootstrapDumpMetricCollector.reportStageProgress("dump", ReplUtils.MetricName.FUNCTIONS.name(), 1L);
        bootstrapDumpMetricCollector.reportStageEnd("dump", Status.SUCCESS, 10L, new SnapshotUtils.ReplSnapshotCount(), new ReplStatsTracker(0));
        bootstrapDumpMetricCollector.reportEnd(Status.SUCCESS);
        Metadata expectedMetadata = new Metadata("testAcidTablesReplLoadBootstrapIncr_1592205875387", Metadata.ReplicationType.BOOTSTRAP, "dummyDir");
        expectedMetadata.setLastReplId(10L);
        Progress expectedProgress = new Progress();
        expectedProgress.setStatus(Status.SUCCESS);
        Stage dumpStage = new Stage("dump", Status.SUCCESS, 0L);
        dumpStage.setEndTime(0L);
        Metric expectedTableMetric = new Metric(ReplUtils.MetricName.TABLES.name(), 10L);
        expectedTableMetric.setCurrentCount(3L);
        Metric expectedFuncMetric = new Metric(ReplUtils.MetricName.FUNCTIONS.name(), 1L);
        expectedFuncMetric.setCurrentCount(1L);
        dumpStage.addMetric(expectedTableMetric);
        dumpStage.addMetric(expectedFuncMetric);
        expectedProgress.addStage(dumpStage);
        ReplicationMetric expectedMetric = new ReplicationMetric(1L, "repl", 0L, expectedMetadata);
        expectedMetric.setProgress(expectedProgress);
        Thread.sleep(20000L);
        GetReplicationMetricsRequest metricsRequest = new GetReplicationMetricsRequest();
        metricsRequest.setPolicy("repl");
        ReplicationMetricList actualReplicationMetrics = Hive.get((HiveConf)this.conf).getMSC().getReplicationMetrics(metricsRequest);
        ReplicationMetrics actualThriftMetric = (ReplicationMetrics)actualReplicationMetrics.getReplicationMetricList().get(0);
        ObjectMapper mapper = new ObjectMapper();
        ReplicationMetric actualMetric = new ReplicationMetric(actualThriftMetric.getScheduledExecutionId(), actualThriftMetric.getPolicy(), actualThriftMetric.getDumpExecutionId(), (Metadata)mapper.readValue(actualThriftMetric.getMetadata(), Metadata.class));
        actualMetric.setMessageFormat(actualThriftMetric.getMessageFormat());
        ProgressMapper progressMapper = (ProgressMapper)mapper.readValue(this.deSerialize(actualThriftMetric.getProgress()), ProgressMapper.class);
        Progress progress = new Progress();
        progress.setStatus(progressMapper.getStatus());
        for (StageMapper stageMapper : progressMapper.getStages()) {
            Stage stage = new Stage();
            stage.setName(stageMapper.getName());
            stage.setStatus(stageMapper.getStatus());
            stage.setStartTime(stageMapper.getStartTime());
            stage.setEndTime(stageMapper.getEndTime());
            for (Metric metric : stageMapper.getMetrics()) {
                stage.addMetric(metric);
            }
            progress.addStage(stage);
        }
        actualMetric.setProgress(progress);
        this.checkSuccess(actualMetric, expectedMetric, "dump", Arrays.asList(ReplUtils.MetricName.TABLES.name(), ReplUtils.MetricName.FUNCTIONS.name()));
        this.conf.set("scheduled.query.executionid", "2");
        IncrementalDumpMetricCollector incrementDumpMetricCollector = new IncrementalDumpMetricCollector("testAcidTablesReplLoadBootstrapIncr_1592205875387", "hdfs://localhost:65158/tmp/org_apache_hadoop_hive_ql_parse_TestReplicationScenarios_245261428230295/hrepl0/dGVzdGFjaWR0YWJsZXNyZXBsbG9hZGJvb3RzdHJhcGluY3JfMTU5MjIwNTg3NTM4Nw==/0/hive", this.conf, Long.valueOf(0L));
        metricMap = new HashMap();
        metricMap.put(ReplUtils.MetricName.EVENTS.name(), 10L);
        incrementDumpMetricCollector.reportStageStart("dump", metricMap);
        incrementDumpMetricCollector.reportStageProgress("dump", ReplUtils.MetricName.EVENTS.name(), 10L);
        incrementDumpMetricCollector.reportStageEnd("dump", Status.SUCCESS, 10L, new SnapshotUtils.ReplSnapshotCount(), new ReplStatsTracker(0));
        incrementDumpMetricCollector.reportEnd(Status.SUCCESS);
        expectedMetadata = new Metadata("testAcidTablesReplLoadBootstrapIncr_1592205875387", Metadata.ReplicationType.INCREMENTAL, "dummyDir");
        expectedMetadata.setLastReplId(10L);
        expectedProgress = new Progress();
        expectedProgress.setStatus(Status.SUCCESS);
        dumpStage = new Stage("dump", Status.SUCCESS, 0L);
        dumpStage.setEndTime(0L);
        Metric expectedEventsMetric = new Metric(ReplUtils.MetricName.EVENTS.name(), 10L);
        expectedEventsMetric.setCurrentCount(10L);
        dumpStage.addMetric(expectedEventsMetric);
        expectedProgress.addStage(dumpStage);
        expectedMetric = new ReplicationMetric(2L, "repl", 0L, expectedMetadata);
        expectedMetric.setProgress(expectedProgress);
        Thread.sleep(20000L);
        metricsRequest = new GetReplicationMetricsRequest();
        metricsRequest.setPolicy("repl");
        actualReplicationMetrics = Hive.get((HiveConf)this.conf).getMSC().getReplicationMetrics(metricsRequest);
        Assert.assertEquals((long)2L, (long)actualReplicationMetrics.getReplicationMetricListSize());
        actualThriftMetric = (ReplicationMetrics)actualReplicationMetrics.getReplicationMetricList().get(0);
        mapper = new ObjectMapper();
        actualMetric = new ReplicationMetric(actualThriftMetric.getScheduledExecutionId(), actualThriftMetric.getPolicy(), actualThriftMetric.getDumpExecutionId(), (Metadata)mapper.readValue(actualThriftMetric.getMetadata(), Metadata.class));
        actualMetric.setMessageFormat(actualThriftMetric.getMessageFormat());
        progressMapper = (ProgressMapper)mapper.readValue(this.deSerialize(actualThriftMetric.getProgress()), ProgressMapper.class);
        progress = new Progress();
        progress.setStatus(progressMapper.getStatus());
        for (StageMapper stageMapper : progressMapper.getStages()) {
            Stage stage = new Stage();
            stage.setName(stageMapper.getName());
            stage.setStatus(stageMapper.getStatus());
            stage.setStartTime(stageMapper.getStartTime());
            stage.setEndTime(stageMapper.getEndTime());
            for (Metric metric : stageMapper.getMetrics()) {
                stage.addMetric(metric);
            }
            progress.addStage(stage);
        }
        actualMetric.setProgress(progress);
        this.checkSuccessIncremental(actualMetric, expectedMetric, "dump", Arrays.asList(ReplUtils.MetricName.EVENTS.name()));
        Mockito.when((Object)this.fmd.getFailoverEventId()).thenReturn((Object)100L);
        Mockito.when((Object)this.fmd.getFilePath()).thenReturn((Object)"hdfs://localhost:65158/tmp/org_apache_hadoop_hive_ql_parse_TestReplicationScenarios_245261428230295/hrepl0/dGVzdGFjaWR0YWJsZXNyZXBsbG9hZGJvb3RzdHJhcGluY3JfMTU5MjIwNTg3NTM4Nw==/0/hive/");
        this.conf.set("scheduled.query.executionid", "3");
        String stagingDir = "hdfs://localhost:65158/tmp/org_apache_hadoop_hive_ql_parse_TestReplicationScenarios_245261428230295/hrepl0/dGVzdGFjaWR0YWJsZXNyZXBsbG9hZGJvb3RzdHJhcGluY3JfMTU5MjIwNTg3NTM4Nw==/0/hive/";
        IncrementalDumpMetricCollector failoverDumpMetricCollector = new IncrementalDumpMetricCollector("testAcidTablesReplLoadBootstrapIncr_1592205875387", stagingDir, this.conf, Long.valueOf(0L));
        metricMap = new HashMap<String, Long>(){
            {
                this.put(ReplUtils.MetricName.EVENTS.name(), 10L);
            }
        };
        failoverDumpMetricCollector.reportFailoverStart("dump", (Map)metricMap, this.fmd, MetaStoreUtils.FailoverEndpoint.SOURCE.toString(), ReplConst.FailoverType.PLANNED.toString());
        failoverDumpMetricCollector.reportStageProgress("dump", ReplUtils.MetricName.EVENTS.name(), 10L);
        failoverDumpMetricCollector.reportStageEnd("dump", Status.SUCCESS, 10L, new SnapshotUtils.ReplSnapshotCount(), new ReplStatsTracker(0));
        failoverDumpMetricCollector.reportEnd(Status.FAILOVER_READY);
        expectedMetadata = new Metadata("testAcidTablesReplLoadBootstrapIncr_1592205875387", Metadata.ReplicationType.INCREMENTAL, "dummyDir");
        expectedMetadata.setLastReplId(10L);
        expectedMetadata.setFailoverEventId(100L);
        expectedMetadata.setFailoverMetadataLoc(stagingDir + "_failovermetadata");
        expectedMetadata.setFailoverEndPoint(MetaStoreUtils.FailoverEndpoint.SOURCE.toString());
        expectedMetadata.setFailoverType(ReplConst.FailoverType.PLANNED.toString());
        expectedProgress = new Progress();
        expectedProgress.setStatus(Status.FAILOVER_READY);
        dumpStage = new Stage("dump", Status.SUCCESS, 0L);
        dumpStage.setEndTime(0L);
        expectedEventsMetric = new Metric(ReplUtils.MetricName.EVENTS.name(), 10L);
        expectedEventsMetric.setCurrentCount(10L);
        dumpStage.addMetric(expectedEventsMetric);
        expectedProgress.addStage(dumpStage);
        expectedMetric = new ReplicationMetric(3L, "repl", 0L, expectedMetadata);
        expectedMetric.setProgress(expectedProgress);
        Thread.sleep(20000L);
        metricsRequest = new GetReplicationMetricsRequest();
        metricsRequest.setPolicy("repl");
        actualReplicationMetrics = Hive.get((HiveConf)this.conf).getMSC().getReplicationMetrics(metricsRequest);
        Assert.assertEquals((long)3L, (long)actualReplicationMetrics.getReplicationMetricListSize());
        actualThriftMetric = (ReplicationMetrics)actualReplicationMetrics.getReplicationMetricList().get(0);
        mapper = new ObjectMapper();
        actualMetric = new ReplicationMetric(actualThriftMetric.getScheduledExecutionId(), actualThriftMetric.getPolicy(), actualThriftMetric.getDumpExecutionId(), (Metadata)mapper.readValue(actualThriftMetric.getMetadata(), Metadata.class));
        actualMetric.setMessageFormat(actualThriftMetric.getMessageFormat());
        progressMapper = (ProgressMapper)mapper.readValue(this.deSerialize(actualThriftMetric.getProgress()), ProgressMapper.class);
        progress = new Progress();
        progress.setStatus(progressMapper.getStatus());
        for (StageMapper stageMapper : progressMapper.getStages()) {
            Stage stage = new Stage();
            stage.setName(stageMapper.getName());
            stage.setStatus(stageMapper.getStatus());
            stage.setStartTime(stageMapper.getStartTime());
            stage.setEndTime(stageMapper.getEndTime());
            for (Metric metric : stageMapper.getMetrics()) {
                stage.addMetric(metric);
            }
            progress.addStage(stage);
        }
        actualMetric.setProgress(progress);
        this.checkSuccessIncremental(actualMetric, expectedMetric, "dump", Arrays.asList(ReplUtils.MetricName.EVENTS.name()));
    }

    private void checkSuccess(ReplicationMetric actual, ReplicationMetric expected, String stageName, List<String> metricNames) {
        Assert.assertEquals((long)expected.getDumpExecutionId(), (long)actual.getDumpExecutionId());
        Assert.assertEquals((Object)expected.getPolicy(), (Object)actual.getPolicy());
        Assert.assertEquals((long)expected.getScheduledExecutionId(), (long)actual.getScheduledExecutionId());
        Assert.assertEquals((Object)expected.getMetadata().getReplicationType(), (Object)actual.getMetadata().getReplicationType());
        Assert.assertEquals((Object)expected.getMetadata().getDbName(), (Object)actual.getMetadata().getDbName());
        Assert.assertEquals((Object)expected.getMetadata().getStagingDir(), (Object)actual.getMetadata().getStagingDir());
        Assert.assertEquals((long)expected.getMetadata().getLastReplId(), (long)actual.getMetadata().getLastReplId());
        Assert.assertEquals((Object)expected.getProgress().getStatus(), (Object)actual.getProgress().getStatus());
        Assert.assertEquals((Object)expected.getProgress().getStageByName(stageName).getStatus(), (Object)actual.getProgress().getStageByName(stageName).getStatus());
        for (String metricName : metricNames) {
            Assert.assertEquals((long)expected.getProgress().getStageByName(stageName).getMetricByName(metricName).getTotalCount(), (long)actual.getProgress().getStageByName(stageName).getMetricByName(metricName).getTotalCount());
            Assert.assertEquals((long)expected.getProgress().getStageByName(stageName).getMetricByName(metricName).getCurrentCount(), (long)actual.getProgress().getStageByName(stageName).getMetricByName(metricName).getCurrentCount());
        }
    }

    private void checkSuccessIncremental(ReplicationMetric actual, ReplicationMetric expected, String stageName, List<String> metricNames) {
        Assert.assertEquals((long)expected.getDumpExecutionId(), (long)actual.getDumpExecutionId());
        Assert.assertEquals((Object)expected.getPolicy(), (Object)actual.getPolicy());
        Assert.assertEquals((long)expected.getScheduledExecutionId(), (long)actual.getScheduledExecutionId());
        Assert.assertEquals((Object)expected.getMetadata().getReplicationType(), (Object)actual.getMetadata().getReplicationType());
        Assert.assertEquals((Object)expected.getMetadata().getDbName(), (Object)actual.getMetadata().getDbName());
        Assert.assertEquals((Object)expected.getMetadata().getStagingDir(), (Object)actual.getMetadata().getStagingDir());
        Assert.assertEquals((long)expected.getMetadata().getLastReplId(), (long)actual.getMetadata().getLastReplId());
        Assert.assertEquals((Object)expected.getMetadata().getFailoverEndPoint(), (Object)actual.getMetadata().getFailoverEndPoint());
        Assert.assertEquals((Object)expected.getMetadata().getFailoverType(), (Object)actual.getMetadata().getFailoverType());
        Assert.assertEquals((Object)expected.getProgress().getStatus(), (Object)actual.getProgress().getStatus());
        Assert.assertEquals((Object)expected.getProgress().getStageByName(stageName).getStatus(), (Object)actual.getProgress().getStageByName(stageName).getStatus());
        for (String metricName : metricNames) {
            Assert.assertEquals((long)expected.getProgress().getStageByName(stageName).getMetricByName(metricName).getTotalCount(), (long)actual.getProgress().getStageByName(stageName).getMetricByName(metricName).getTotalCount());
            Assert.assertEquals((long)expected.getProgress().getStageByName(stageName).getMetricByName(metricName).getCurrentCount(), (long)actual.getProgress().getStageByName(stageName).getMetricByName(metricName).getCurrentCount());
        }
    }

    @Ignore(value="HIVE-26262")
    @Test
    public void testReplStatsInMetrics() throws HiveException, InterruptedException, TException {
        int origRMProgress = ReplStatsTracker.RM_PROGRESS_LENGTH;
        ReplStatsTracker.RM_PROGRESS_LENGTH = 10;
        IncrementalDumpMetricCollector incrementDumpMetricCollector = new IncrementalDumpMetricCollector("testAcidTablesReplLoadBootstrapIncr_1592205875387", "hdfs://localhost:65158/tmp/org_apache_hadoop_hive_ql_parse_TestReplicationScenarios_245261428230295/hrepl0/dGVzdGFjaWR0YWJsZXNyZXBsbG9hZGJvb3RzdHJhcGluY3JfMTU5MjIwNTg3NTM4Nw==/0/hive", this.conf, Long.valueOf(0L));
        HashMap<String, Long> metricMap = new HashMap<String, Long>();
        ReplStatsTracker repl = (ReplStatsTracker)Mockito.mock(ReplStatsTracker.class);
        Mockito.when((Object)repl.toString()).thenReturn((Object)RandomStringUtils.randomAlphabetic((int)1000));
        metricMap.put(ReplUtils.MetricName.EVENTS.name(), 10L);
        incrementDumpMetricCollector.reportStageStart("dump", metricMap);
        incrementDumpMetricCollector.reportStageProgress("dump", ReplUtils.MetricName.EVENTS.name(), 10L);
        incrementDumpMetricCollector.reportStageEnd("dump", Status.SUCCESS, 10L, new SnapshotUtils.ReplSnapshotCount(), repl);
        Thread.sleep(20000L);
        GetReplicationMetricsRequest metricsRequest = new GetReplicationMetricsRequest();
        metricsRequest.setPolicy("repl");
        ReplicationMetricList actualReplicationMetrics = Hive.get((HiveConf)this.conf).getMSC().getReplicationMetrics(metricsRequest);
        String progress = this.deSerialize(((ReplicationMetrics)actualReplicationMetrics.getReplicationMetricList().get(0)).getProgress());
        Assert.assertTrue((String)progress, (boolean)progress.contains("ERROR: RM_PROGRESS LIMIT EXCEEDED."));
        ReplStatsTracker.RM_PROGRESS_LENGTH = origRMProgress;
        repl = new ReplStatsTracker(15);
        Assert.assertEquals((long)ReplStatsTracker.TOP_K_MAX, (long)repl.getK());
    }
}

