/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.metric;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections4.map.ListOrderedMap;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.repl.ReplConst;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.messaging.MessageFactory;
import org.apache.hadoop.hive.metastore.messaging.MessageSerializer;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.exec.repl.ReplStatsTracker;
import org.apache.hadoop.hive.ql.exec.repl.util.ReplUtils;
import org.apache.hadoop.hive.ql.exec.repl.util.SnapshotUtils;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.DumpType;
import org.apache.hadoop.hive.ql.parse.repl.dump.metric.BootstrapDumpMetricCollector;
import org.apache.hadoop.hive.ql.parse.repl.dump.metric.IncrementalDumpMetricCollector;
import org.apache.hadoop.hive.ql.parse.repl.dump.metric.OptimizedBootstrapDumpMetricCollector;
import org.apache.hadoop.hive.ql.parse.repl.dump.metric.PreOptimizedBootstrapDumpMetricCollector;
import org.apache.hadoop.hive.ql.parse.repl.load.FailoverMetaData;
import org.apache.hadoop.hive.ql.parse.repl.load.metric.BootstrapLoadMetricCollector;
import org.apache.hadoop.hive.ql.parse.repl.load.metric.IncrementalLoadMetricCollector;
import org.apache.hadoop.hive.ql.parse.repl.metric.MetricCollector;
import org.apache.hadoop.hive.ql.parse.repl.metric.MetricSink;
import org.apache.hadoop.hive.ql.parse.repl.metric.event.Metadata;
import org.apache.hadoop.hive.ql.parse.repl.metric.event.Metric;
import org.apache.hadoop.hive.ql.parse.repl.metric.event.Progress;
import org.apache.hadoop.hive.ql.parse.repl.metric.event.ReplicationMetric;
import org.apache.hadoop.hive.ql.parse.repl.metric.event.Stage;
import org.apache.hadoop.hive.ql.parse.repl.metric.event.Status;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TestReplicationMetricCollector {
    HiveConf conf;
    private FailoverMetaData fmd;
    private MetricSink metricSinkInstance;
    MockedStatic<MetricSink> metricSinkMockedStatic;

    @Before
    public void setup() throws Exception {
        this.fmd = (FailoverMetaData)Mockito.mock(FailoverMetaData.class);
        this.metricSinkInstance = (MetricSink)Mockito.mock(MetricSink.class);
        this.conf = new HiveConf();
        this.conf.set("scheduled.query.schedulename", "repl");
        this.conf.set("scheduled.query.executionid", "1");
        MetricCollector.getInstance().init(this.conf);
        Mockito.when((Object)this.fmd.getFailoverEventId()).thenReturn((Object)10L);
        Mockito.when((Object)this.fmd.getFilePath()).thenReturn((Object)"dummyDir");
        this.disableBackgroundThreads();
    }

    private void disableBackgroundThreads() {
        this.metricSinkMockedStatic = Mockito.mockStatic(MetricSink.class);
        this.metricSinkMockedStatic.when(MetricSink::getInstance).thenReturn((Object)this.metricSinkInstance);
    }

    @After
    public void finalize() {
        MetricCollector.getInstance().deinit();
        this.metricSinkMockedStatic.close();
    }

    @Test
    public void testFailureCacheHardLimit() throws Exception {
        MetricCollector.getInstance().deinit();
        this.conf = new HiveConf();
        MetricCollector collector = MetricCollector.getInstance();
        MetricCollector metricCollectorSpy = (MetricCollector)Mockito.spy((Object)collector);
        ((MetricCollector)Mockito.doReturn((Object)1L).when((Object)metricCollectorSpy)).getMaxSize((HiveConf)Mockito.any());
        metricCollectorSpy.init(this.conf);
        metricCollectorSpy.addMetric(new ReplicationMetric(1L, "repl", 0L, null));
        try {
            metricCollectorSpy.addMetric(new ReplicationMetric(2L, "repl", 0L, null));
            Assert.fail();
        }
        catch (SemanticException e) {
            Assert.assertEquals((Object)"Metrics are not getting collected. ", (Object)e.getMessage());
        }
    }

    @Test
    public void testFailureNoScheduledId() throws Exception {
        MetricCollector.getInstance().deinit();
        this.conf = new HiveConf();
        MetricCollector.getInstance().init(this.conf);
        BootstrapDumpMetricCollector bootstrapDumpMetricCollector = new BootstrapDumpMetricCollector("db", "dummyDir", this.conf, Long.valueOf(0L));
        HashMap<String, Long> metricMap = new HashMap<String, Long>();
        metricMap.put(ReplUtils.MetricName.TABLES.name(), 10L);
        metricMap.put(ReplUtils.MetricName.FUNCTIONS.name(), 1L);
        bootstrapDumpMetricCollector.reportStageStart("dump", metricMap);
        bootstrapDumpMetricCollector.reportStageEnd("dump", Status.SUCCESS);
        Assert.assertEquals((long)0L, (long)MetricCollector.getInstance().getMetrics().size());
    }

    @Test
    public void testFailureNoPolicyId() throws Exception {
        MetricCollector.getInstance().deinit();
        this.conf = new HiveConf();
        MetricCollector.getInstance().init(this.conf);
        BootstrapDumpMetricCollector bootstrapDumpMetricCollector = new BootstrapDumpMetricCollector("db", "dummyDir", this.conf, Long.valueOf(0L));
        HashMap<String, Long> metricMap = new HashMap<String, Long>();
        metricMap.put(ReplUtils.MetricName.TABLES.name(), 10L);
        metricMap.put(ReplUtils.MetricName.FUNCTIONS.name(), 1L);
        bootstrapDumpMetricCollector.reportStageStart("dump", metricMap);
        bootstrapDumpMetricCollector.reportStageEnd("dump", Status.SUCCESS);
        Assert.assertEquals((long)0L, (long)MetricCollector.getInstance().getMetrics().size());
    }

    @Test
    public void testSuccessBootstrapDumpMetrics() throws Exception {
        BootstrapDumpMetricCollector bootstrapDumpMetricCollector = new BootstrapDumpMetricCollector("db", "dummyDir", this.conf, Long.valueOf(0L));
        HashMap<String, Long> metricMap = new HashMap<String, Long>();
        metricMap.put(ReplUtils.MetricName.TABLES.name(), 10L);
        metricMap.put(ReplUtils.MetricName.FUNCTIONS.name(), 1L);
        bootstrapDumpMetricCollector.reportStageStart("dump", metricMap);
        bootstrapDumpMetricCollector.reportStageProgress("dump", ReplUtils.MetricName.TABLES.name(), 1L);
        LinkedList actualMetrics = MetricCollector.getInstance().getMetrics();
        Assert.assertEquals((long)1L, (long)actualMetrics.size());
        bootstrapDumpMetricCollector.reportStageProgress("dump", ReplUtils.MetricName.TABLES.name(), 2L);
        bootstrapDumpMetricCollector.reportStageProgress("dump", ReplUtils.MetricName.FUNCTIONS.name(), 1L);
        actualMetrics = MetricCollector.getInstance().getMetrics();
        Assert.assertEquals((long)1L, (long)actualMetrics.size());
        bootstrapDumpMetricCollector.reportStageEnd("dump", Status.SUCCESS, 10L, new SnapshotUtils.ReplSnapshotCount(), new ReplStatsTracker(0));
        bootstrapDumpMetricCollector.reportEnd(Status.SUCCESS);
        actualMetrics = MetricCollector.getInstance().getMetrics();
        Assert.assertEquals((long)1L, (long)actualMetrics.size());
        Metadata expectedMetadata = new Metadata("db", Metadata.ReplicationType.BOOTSTRAP, "dummyDir");
        expectedMetadata.setLastReplId(10L);
        Progress expectedProgress = new Progress();
        expectedProgress.setStatus(Status.SUCCESS);
        Stage dumpStage = new Stage("dump", Status.SUCCESS, 0L);
        dumpStage.setEndTime(0L);
        Metric expectedTableMetric = new Metric(ReplUtils.MetricName.TABLES.name(), 10L);
        expectedTableMetric.setCurrentCount(3L);
        Metric expectedFuncMetric = new Metric(ReplUtils.MetricName.FUNCTIONS.name(), 1L);
        expectedFuncMetric.setCurrentCount(1L);
        dumpStage.addMetric(expectedTableMetric);
        dumpStage.addMetric(expectedFuncMetric);
        expectedProgress.addStage(dumpStage);
        ReplicationMetric expectedMetric = new ReplicationMetric(1L, "repl", 0L, expectedMetadata);
        expectedMetric.setProgress(expectedProgress);
        this.checkSuccess((ReplicationMetric)actualMetrics.get(0), expectedMetric, "dump", Arrays.asList(ReplUtils.MetricName.TABLES.name(), ReplUtils.MetricName.FUNCTIONS.name()));
    }

    @Test
    public void testSuccessIncrDumpMetrics() throws Exception {
        IncrementalDumpMetricCollector incrDumpMetricCollector = new IncrementalDumpMetricCollector("db", "dummyDir", this.conf, Long.valueOf(0L));
        HashMap<String, Long> metricMap = new HashMap<String, Long>();
        metricMap.put(ReplUtils.MetricName.TABLES.name(), 10L);
        metricMap.put(ReplUtils.MetricName.FUNCTIONS.name(), 1L);
        incrDumpMetricCollector.reportStageStart("dump", metricMap);
        incrDumpMetricCollector.reportStageProgress("dump", ReplUtils.MetricName.TABLES.name(), 1L);
        LinkedList actualMetrics = MetricCollector.getInstance().getMetrics();
        Assert.assertEquals((long)1L, (long)actualMetrics.size());
        incrDumpMetricCollector.reportStageProgress("dump", ReplUtils.MetricName.TABLES.name(), 2L);
        incrDumpMetricCollector.reportStageProgress("dump", ReplUtils.MetricName.FUNCTIONS.name(), 1L);
        actualMetrics = MetricCollector.getInstance().getMetrics();
        Assert.assertEquals((long)1L, (long)actualMetrics.size());
        incrDumpMetricCollector.reportStageEnd("dump", Status.SUCCESS, 10L, new SnapshotUtils.ReplSnapshotCount(), new ReplStatsTracker(0));
        incrDumpMetricCollector.reportEnd(Status.SUCCESS);
        actualMetrics = MetricCollector.getInstance().getMetrics();
        Assert.assertEquals((long)1L, (long)actualMetrics.size());
        Metadata expectedMetadata = new Metadata("db", Metadata.ReplicationType.INCREMENTAL, "dummyDir");
        expectedMetadata.setLastReplId(10L);
        Progress expectedProgress = new Progress();
        expectedProgress.setStatus(Status.SUCCESS);
        Stage dumpStage = new Stage("dump", Status.SUCCESS, 0L);
        dumpStage.setEndTime(0L);
        Metric expectedTableMetric = new Metric(ReplUtils.MetricName.TABLES.name(), 10L);
        expectedTableMetric.setCurrentCount(3L);
        Metric expectedFuncMetric = new Metric(ReplUtils.MetricName.FUNCTIONS.name(), 1L);
        expectedFuncMetric.setCurrentCount(1L);
        dumpStage.addMetric(expectedTableMetric);
        dumpStage.addMetric(expectedFuncMetric);
        expectedProgress.addStage(dumpStage);
        ReplicationMetric expectedMetric = new ReplicationMetric(1L, "repl", 0L, expectedMetadata);
        expectedMetric.setProgress(expectedProgress);
        this.checkSuccess((ReplicationMetric)actualMetrics.get(0), expectedMetric, "dump", Arrays.asList(ReplUtils.MetricName.TABLES.name(), ReplUtils.MetricName.FUNCTIONS.name()));
    }

    @Test
    public void testSuccessPreOptimizedBootstrapDumpMetrics() throws Exception {
        PreOptimizedBootstrapDumpMetricCollector preOptimizedBootstrapDumpMetricCollector = new PreOptimizedBootstrapDumpMetricCollector("db", "dummyDir", this.conf, Long.valueOf(-1L), MetaStoreUtils.FailoverEndpoint.SOURCE.toString(), ReplConst.FailoverType.UNPLANNED.toString());
        HashMap<String, Long> metricMap = new HashMap<String, Long>();
        metricMap.put(ReplUtils.MetricName.TABLES.name(), 0L);
        metricMap.put(ReplUtils.MetricName.FUNCTIONS.name(), 0L);
        preOptimizedBootstrapDumpMetricCollector.reportStageStart("dump", metricMap);
        preOptimizedBootstrapDumpMetricCollector.reportStageProgress("dump", ReplUtils.MetricName.TABLES.name(), 0L);
        LinkedList actualMetrics = MetricCollector.getInstance().getMetrics();
        Assert.assertEquals((long)1L, (long)actualMetrics.size());
        preOptimizedBootstrapDumpMetricCollector.reportStageEnd("dump", Status.SUCCESS, -1L, new SnapshotUtils.ReplSnapshotCount(), new ReplStatsTracker(0));
        preOptimizedBootstrapDumpMetricCollector.reportEnd(Status.SUCCESS);
        actualMetrics = MetricCollector.getInstance().getMetrics();
        Assert.assertEquals((long)1L, (long)actualMetrics.size());
        Metadata expectedMetadata = new Metadata("db", Metadata.ReplicationType.PRE_OPTIMIZED_BOOTSTRAP, "dummyDir");
        expectedMetadata.setLastReplId(-1L);
        expectedMetadata.setFailoverEndPoint(MetaStoreUtils.FailoverEndpoint.SOURCE.toString());
        expectedMetadata.setFailoverType(ReplConst.FailoverType.UNPLANNED.toString());
        Progress expectedProgress = new Progress();
        expectedProgress.setStatus(Status.SUCCESS);
        Stage dumpStage = new Stage("dump", Status.SUCCESS, 0L);
        dumpStage.setEndTime(0L);
        Metric expectedTableMetric = new Metric(ReplUtils.MetricName.TABLES.name(), 0L);
        expectedTableMetric.setCurrentCount(0L);
        Metric expectedFuncMetric = new Metric(ReplUtils.MetricName.FUNCTIONS.name(), 0L);
        expectedFuncMetric.setCurrentCount(0L);
        dumpStage.addMetric(expectedTableMetric);
        dumpStage.addMetric(expectedFuncMetric);
        expectedProgress.addStage(dumpStage);
        ReplicationMetric expectedMetric = new ReplicationMetric(1L, "repl", -1L, expectedMetadata);
        expectedMetric.setProgress(expectedProgress);
        this.checkSuccess((ReplicationMetric)actualMetrics.get(0), expectedMetric, "dump", Arrays.asList(ReplUtils.MetricName.TABLES.name(), ReplUtils.MetricName.FUNCTIONS.name()));
    }

    @Test
    public void testSuccessOptimizedBootstrapDumpMetrics() throws Exception {
        OptimizedBootstrapDumpMetricCollector optimizedBootstrapDumpMetricCollector = new OptimizedBootstrapDumpMetricCollector("db", "dummyDir", this.conf, Long.valueOf(0L), MetaStoreUtils.FailoverEndpoint.SOURCE.toString(), ReplConst.FailoverType.UNPLANNED.toString());
        HashMap<String, Long> metricMap = new HashMap<String, Long>();
        metricMap.put(ReplUtils.MetricName.TABLES.name(), 10L);
        metricMap.put(ReplUtils.MetricName.FUNCTIONS.name(), 1L);
        optimizedBootstrapDumpMetricCollector.reportStageStart("dump", metricMap);
        optimizedBootstrapDumpMetricCollector.reportStageProgress("dump", ReplUtils.MetricName.TABLES.name(), 1L);
        LinkedList actualMetrics = MetricCollector.getInstance().getMetrics();
        Assert.assertEquals((long)1L, (long)actualMetrics.size());
        optimizedBootstrapDumpMetricCollector.reportStageProgress("dump", ReplUtils.MetricName.TABLES.name(), 2L);
        optimizedBootstrapDumpMetricCollector.reportStageProgress("dump", ReplUtils.MetricName.FUNCTIONS.name(), 1L);
        actualMetrics = MetricCollector.getInstance().getMetrics();
        Assert.assertEquals((long)1L, (long)actualMetrics.size());
        optimizedBootstrapDumpMetricCollector.reportStageEnd("dump", Status.SUCCESS, 10L, new SnapshotUtils.ReplSnapshotCount(), new ReplStatsTracker(0));
        optimizedBootstrapDumpMetricCollector.reportEnd(Status.SUCCESS);
        actualMetrics = MetricCollector.getInstance().getMetrics();
        Assert.assertEquals((long)1L, (long)actualMetrics.size());
        Metadata expectedMetadata = new Metadata("db", Metadata.ReplicationType.OPTIMIZED_BOOTSTRAP, "dummyDir");
        expectedMetadata.setLastReplId(10L);
        expectedMetadata.setFailoverEndPoint(MetaStoreUtils.FailoverEndpoint.SOURCE.toString());
        expectedMetadata.setFailoverType(ReplConst.FailoverType.UNPLANNED.toString());
        Progress expectedProgress = new Progress();
        expectedProgress.setStatus(Status.SUCCESS);
        Stage dumpStage = new Stage("dump", Status.SUCCESS, 0L);
        dumpStage.setEndTime(0L);
        Metric expectedTableMetric = new Metric(ReplUtils.MetricName.TABLES.name(), 10L);
        expectedTableMetric.setCurrentCount(3L);
        Metric expectedFuncMetric = new Metric(ReplUtils.MetricName.FUNCTIONS.name(), 1L);
        expectedFuncMetric.setCurrentCount(1L);
        dumpStage.addMetric(expectedTableMetric);
        dumpStage.addMetric(expectedFuncMetric);
        expectedProgress.addStage(dumpStage);
        ReplicationMetric expectedMetric = new ReplicationMetric(1L, "repl", 0L, expectedMetadata);
        expectedMetric.setProgress(expectedProgress);
        this.checkSuccess((ReplicationMetric)actualMetrics.get(0), expectedMetric, "dump", Arrays.asList(ReplUtils.MetricName.TABLES.name(), ReplUtils.MetricName.FUNCTIONS.name()));
    }

    @Test
    public void testFailoverReadyDumpMetrics() throws Exception {
        IncrementalDumpMetricCollector incrDumpMetricCollector = new IncrementalDumpMetricCollector("db", "dummyDir", this.conf, Long.valueOf(0L));
        HashMap<String, Long> metricMap = new HashMap<String, Long>();
        metricMap.put(ReplUtils.MetricName.EVENTS.name(), 10L);
        incrDumpMetricCollector.reportFailoverStart("dump", metricMap, this.fmd, MetaStoreUtils.FailoverEndpoint.SOURCE.toString(), ReplConst.FailoverType.PLANNED.toString());
        incrDumpMetricCollector.reportStageProgress("dump", ReplUtils.MetricName.EVENTS.name(), 2L);
        LinkedList actualMetrics = MetricCollector.getInstance().getMetrics();
        Assert.assertEquals((long)1L, (long)actualMetrics.size());
        incrDumpMetricCollector.reportStageEnd("dump", Status.SUCCESS, 10L, new SnapshotUtils.ReplSnapshotCount(), new ReplStatsTracker(0));
        incrDumpMetricCollector.reportEnd(Status.FAILOVER_READY);
        actualMetrics = MetricCollector.getInstance().getMetrics();
        Assert.assertEquals((long)1L, (long)actualMetrics.size());
        Metadata expectedMetadata = new Metadata("db", Metadata.ReplicationType.INCREMENTAL, "dummyDir");
        expectedMetadata.setLastReplId(10L);
        expectedMetadata.setFailoverEventId(10L);
        expectedMetadata.setFailoverMetadataLoc("dummyDir");
        expectedMetadata.setFailoverEndPoint(MetaStoreUtils.FailoverEndpoint.SOURCE.toString());
        expectedMetadata.setFailoverType(ReplConst.FailoverType.PLANNED.toString());
        Progress expectedProgress = new Progress();
        expectedProgress.setStatus(Status.FAILOVER_READY);
        Stage dumpStage = new Stage("dump", Status.SUCCESS, 0L);
        dumpStage.setEndTime(0L);
        Metric expectedEventMetric = new Metric(ReplUtils.MetricName.EVENTS.name(), 10L);
        expectedEventMetric.setCurrentCount(2L);
        dumpStage.addMetric(expectedEventMetric);
        expectedProgress.addStage(dumpStage);
        ReplicationMetric expectedMetric = new ReplicationMetric(1L, "repl", 0L, expectedMetadata);
        expectedMetric.setProgress(expectedProgress);
        this.checkSuccess((ReplicationMetric)actualMetrics.get(0), expectedMetric, "dump", Arrays.asList(ReplUtils.MetricName.EVENTS.name()));
    }

    @Test
    public void testSuccessBootstrapLoadMetrics() throws Exception {
        BootstrapLoadMetricCollector bootstrapLoadMetricCollector = new BootstrapLoadMetricCollector("db", "dummyDir", 1L, this.conf);
        HashMap<String, Long> metricMap = new HashMap<String, Long>();
        metricMap.put(ReplUtils.MetricName.TABLES.name(), 10L);
        metricMap.put(ReplUtils.MetricName.FUNCTIONS.name(), 1L);
        bootstrapLoadMetricCollector.reportStageStart("dump", metricMap);
        bootstrapLoadMetricCollector.reportStageProgress("dump", ReplUtils.MetricName.TABLES.name(), 1L);
        LinkedList actualMetrics = MetricCollector.getInstance().getMetrics();
        Assert.assertEquals((long)1L, (long)actualMetrics.size());
        bootstrapLoadMetricCollector.reportStageProgress("dump", ReplUtils.MetricName.TABLES.name(), 2L);
        bootstrapLoadMetricCollector.reportStageProgress("dump", ReplUtils.MetricName.FUNCTIONS.name(), 1L);
        actualMetrics = MetricCollector.getInstance().getMetrics();
        Assert.assertEquals((long)1L, (long)actualMetrics.size());
        bootstrapLoadMetricCollector.reportStageEnd("dump", Status.SUCCESS, 10L, new SnapshotUtils.ReplSnapshotCount(), new ReplStatsTracker(0));
        bootstrapLoadMetricCollector.reportEnd(Status.SUCCESS);
        actualMetrics = MetricCollector.getInstance().getMetrics();
        Assert.assertEquals((long)1L, (long)actualMetrics.size());
        Metadata expectedMetadata = new Metadata("db", Metadata.ReplicationType.BOOTSTRAP, "dummyDir");
        expectedMetadata.setLastReplId(10L);
        Progress expectedProgress = new Progress();
        expectedProgress.setStatus(Status.SUCCESS);
        Stage dumpStage = new Stage("dump", Status.SUCCESS, 0L);
        dumpStage.setEndTime(0L);
        Metric expectedTableMetric = new Metric(ReplUtils.MetricName.TABLES.name(), 10L);
        expectedTableMetric.setCurrentCount(3L);
        Metric expectedFuncMetric = new Metric(ReplUtils.MetricName.FUNCTIONS.name(), 1L);
        expectedFuncMetric.setCurrentCount(1L);
        dumpStage.addMetric(expectedTableMetric);
        dumpStage.addMetric(expectedFuncMetric);
        expectedProgress.addStage(dumpStage);
        ReplicationMetric expectedMetric = new ReplicationMetric(1L, "repl", 1L, expectedMetadata);
        expectedMetric.setProgress(expectedProgress);
        this.checkSuccess((ReplicationMetric)actualMetrics.get(0), expectedMetric, "dump", Arrays.asList(ReplUtils.MetricName.TABLES.name(), ReplUtils.MetricName.FUNCTIONS.name()));
    }

    @Test
    public void testSuccessIncrLoadMetrics() throws Exception {
        IncrementalLoadMetricCollector incrLoadMetricCollector = new IncrementalLoadMetricCollector("db", "dummyDir", 1L, this.conf);
        HashMap<String, Long> metricMap = new HashMap<String, Long>();
        metricMap.put(ReplUtils.MetricName.TABLES.name(), 10L);
        metricMap.put(ReplUtils.MetricName.FUNCTIONS.name(), 1L);
        incrLoadMetricCollector.reportStageStart("dump", metricMap);
        incrLoadMetricCollector.reportStageProgress("dump", ReplUtils.MetricName.TABLES.name(), 1L);
        LinkedList actualMetrics = MetricCollector.getInstance().getMetrics();
        Assert.assertEquals((long)1L, (long)actualMetrics.size());
        incrLoadMetricCollector.reportStageProgress("dump", ReplUtils.MetricName.TABLES.name(), 2L);
        incrLoadMetricCollector.reportStageProgress("dump", ReplUtils.MetricName.FUNCTIONS.name(), 1L);
        actualMetrics = MetricCollector.getInstance().getMetrics();
        Assert.assertEquals((long)1L, (long)actualMetrics.size());
        incrLoadMetricCollector.reportStageEnd("dump", Status.SUCCESS, 10L, new SnapshotUtils.ReplSnapshotCount(), new ReplStatsTracker(0));
        incrLoadMetricCollector.reportEnd(Status.SUCCESS);
        actualMetrics = MetricCollector.getInstance().getMetrics();
        Assert.assertEquals((long)1L, (long)actualMetrics.size());
        Metadata expectedMetadata = new Metadata("db", Metadata.ReplicationType.INCREMENTAL, "dummyDir");
        expectedMetadata.setLastReplId(10L);
        Progress expectedProgress = new Progress();
        expectedProgress.setStatus(Status.SUCCESS);
        Stage dumpStage = new Stage("dump", Status.SUCCESS, 0L);
        dumpStage.setEndTime(0L);
        Metric expectedTableMetric = new Metric(ReplUtils.MetricName.TABLES.name(), 10L);
        expectedTableMetric.setCurrentCount(3L);
        Metric expectedFuncMetric = new Metric(ReplUtils.MetricName.FUNCTIONS.name(), 1L);
        expectedFuncMetric.setCurrentCount(1L);
        dumpStage.addMetric(expectedTableMetric);
        dumpStage.addMetric(expectedFuncMetric);
        expectedProgress.addStage(dumpStage);
        ReplicationMetric expectedMetric = new ReplicationMetric(1L, "repl", 1L, expectedMetadata);
        expectedMetric.setProgress(expectedProgress);
        this.checkSuccess((ReplicationMetric)actualMetrics.get(0), expectedMetric, "dump", Arrays.asList(ReplUtils.MetricName.TABLES.name(), ReplUtils.MetricName.FUNCTIONS.name()));
    }

    private void checkSuccess(ReplicationMetric actual, ReplicationMetric expected, String stageName, List<String> metricNames) {
        Assert.assertEquals((long)expected.getDumpExecutionId(), (long)actual.getDumpExecutionId());
        Assert.assertEquals((Object)expected.getPolicy(), (Object)actual.getPolicy());
        Assert.assertEquals((long)expected.getScheduledExecutionId(), (long)actual.getScheduledExecutionId());
        Assert.assertEquals((Object)expected.getMetadata().getReplicationType(), (Object)actual.getMetadata().getReplicationType());
        Assert.assertEquals((Object)expected.getMetadata().getDbName(), (Object)actual.getMetadata().getDbName());
        Assert.assertEquals((Object)expected.getMetadata().getStagingDir(), (Object)actual.getMetadata().getStagingDir());
        Assert.assertEquals((long)expected.getMetadata().getLastReplId(), (long)actual.getMetadata().getLastReplId());
        Assert.assertEquals((Object)expected.getMetadata().getFailoverEndPoint(), (Object)actual.getMetadata().getFailoverEndPoint());
        Assert.assertEquals((Object)expected.getMetadata().getFailoverType(), (Object)actual.getMetadata().getFailoverType());
        Assert.assertEquals((Object)expected.getProgress().getStatus(), (Object)actual.getProgress().getStatus());
        Assert.assertEquals((Object)expected.getProgress().getStageByName(stageName).getStatus(), (Object)actual.getProgress().getStageByName(stageName).getStatus());
        for (String metricName : metricNames) {
            Assert.assertEquals((long)expected.getProgress().getStageByName(stageName).getMetricByName(metricName).getTotalCount(), (long)actual.getProgress().getStageByName(stageName).getMetricByName(metricName).getTotalCount());
            Assert.assertEquals((long)expected.getProgress().getStageByName(stageName).getMetricByName(metricName).getCurrentCount(), (long)actual.getProgress().getStageByName(stageName).getMetricByName(metricName).getCurrentCount());
        }
    }

    @Test
    public void testSuccessStageFailure() throws Exception {
        BootstrapDumpMetricCollector bootstrapDumpMetricCollector = new BootstrapDumpMetricCollector("db", "dummyDir", this.conf, Long.valueOf(0L));
        HashMap<String, Long> metricMap = new HashMap<String, Long>();
        metricMap.put(ReplUtils.MetricName.TABLES.name(), 10L);
        metricMap.put(ReplUtils.MetricName.FUNCTIONS.name(), 1L);
        bootstrapDumpMetricCollector.reportStageStart("dump", metricMap);
        bootstrapDumpMetricCollector.reportStageEnd("dump", Status.FAILED);
        LinkedList metricList = MetricCollector.getInstance().getMetrics();
        Assert.assertEquals((long)1L, (long)metricList.size());
        ReplicationMetric actualMetric = (ReplicationMetric)metricList.get(0);
        Assert.assertEquals((Object)Status.FAILED, (Object)actualMetric.getProgress().getStatus());
    }

    @Test
    public void testSuccessStageFailedAdmin() throws Exception {
        BootstrapDumpMetricCollector bootstrapDumpMetricCollector = new BootstrapDumpMetricCollector("db", "dummyDir", this.conf, Long.valueOf(0L));
        HashMap<String, Long> metricMap = new HashMap<String, Long>();
        metricMap.put(ReplUtils.MetricName.TABLES.name(), 10L);
        metricMap.put(ReplUtils.MetricName.FUNCTIONS.name(), 1L);
        bootstrapDumpMetricCollector.reportStageStart("dump", metricMap);
        bootstrapDumpMetricCollector.reportStageEnd("dump", Status.FAILED_ADMIN, "errorlogpath");
        LinkedList metricList = MetricCollector.getInstance().getMetrics();
        Assert.assertEquals((long)1L, (long)metricList.size());
        ReplicationMetric actualMetric = (ReplicationMetric)metricList.get(0);
        Assert.assertEquals((Object)Status.FAILED_ADMIN, (Object)actualMetric.getProgress().getStatus());
        Assert.assertEquals((Object)"errorlogpath", (Object)actualMetric.getProgress().getStageByName("dump").getErrorLogPath());
    }

    @Test
    public void testReplStatsTracker() throws Exception {
        ReplStatsTracker repl = new ReplStatsTracker(5);
        repl.addEntry("EVENT_ADD_PARTITION", "1", 2345L);
        repl.addEntry("EVENT_ADD_PARTITION", "2", 23451L);
        repl.addEntry("EVENT_ADD_PARTITION", "3", 23451L);
        repl.addEntry("EVENT_ADD_DATABASE", "4", 234544L);
        repl.addEntry("EVENT_ALTER_PARTITION", "5", 2145L);
        repl.addEntry("EVENT_CREATE_TABLE", "6", 2245L);
        repl.addEntry("EVENT_ADD_PARTITION", "7", 1245L);
        repl.addEntry("EVENT_ADD_PARTITION", "8", 23425L);
        repl.addEntry("EVENT_ALTER_PARTITION", "9", 21345L);
        repl.addEntry("EVENT_CREATE_TABLE", "10", 1345L);
        repl.addEntry("EVENT_ADD_DATABASE", "11", 345L);
        repl.addEntry("EVENT_ADD_DATABASE", "12", 12345L);
        repl.addEntry("EVENT_ADD_DATABASE", "13", 3345L);
        repl.addEntry("EVENT_ALTER_PARTITION", "14", 2645L);
        repl.addEntry("EVENT_ALTER_PARTITION", "15", 2555L);
        repl.addEntry("EVENT_CREATE_TABLE", "16", 23765L);
        repl.addEntry("EVENT_ADD_PARTITION", "17", 23435L);
        repl.addEntry("EVENT_DROP_PARTITION", "18", 2205L);
        repl.addEntry("EVENT_CREATE_TABLE", "19", 2195L);
        repl.addEntry("EVENT_DROP_PARTITION", "20", 2225L);
        repl.addEntry("EVENT_DROP_PARTITION", "21", 2225L);
        repl.addEntry("EVENT_DROP_PARTITION", "22", 23485L);
        repl.addEntry("EVENT_CREATE_TABLE", "23", 2385L);
        repl.addEntry("EVENT_DROP_PARTITION", "24", 234250L);
        repl.addEntry("EVENT_DROP_PARTITION", "25", 15L);
        repl.addEntry("EVENT_CREATE_TABLE", "26", 23425L);
        repl.addEntry("EVENT_CREATE_TABLE", "27", 23445L);
        Assert.assertEquals((long)5L, (long)repl.getTopKEvents().size());
        Assert.assertArrayEquals((String)((ListOrderedMap)repl.getTopKEvents().get("EVENT_ADD_PARTITION")).valueList().toString(), (Object[])new Long[]{23451L, 23451L, 23435L, 23425L, 2345L}, (Object[])((ListOrderedMap)repl.getTopKEvents().get("EVENT_ADD_PARTITION")).valueList().toArray());
        Assert.assertEquals((long)6L, (long)((DescriptiveStatistics)repl.getDescMap().get("EVENT_ADD_PARTITION")).getN());
        Assert.assertArrayEquals((String)((ListOrderedMap)repl.getTopKEvents().get("EVENT_DROP_PARTITION")).valueList().toString(), (Object[])new Long[]{234250L, 23485L, 2225L, 2225L, 2205L}, (Object[])((ListOrderedMap)repl.getTopKEvents().get("EVENT_DROP_PARTITION")).valueList().toArray());
        Assert.assertEquals((long)6L, (long)((DescriptiveStatistics)repl.getDescMap().get("EVENT_DROP_PARTITION")).getN());
        Assert.assertArrayEquals((String)((ListOrderedMap)repl.getTopKEvents().get("EVENT_CREATE_TABLE")).valueList().toString(), (Object[])new Long[]{23765L, 23445L, 23425L, 2385L, 2245L}, (Object[])((ListOrderedMap)repl.getTopKEvents().get("EVENT_CREATE_TABLE")).valueList().toArray());
        Assert.assertEquals((long)7L, (long)((DescriptiveStatistics)repl.getDescMap().get("EVENT_CREATE_TABLE")).getN());
        Assert.assertArrayEquals((String)((ListOrderedMap)repl.getTopKEvents().get("EVENT_ALTER_PARTITION")).valueList().toString(), (Object[])new Long[]{21345L, 2645L, 2555L, 2145L}, (Object[])((ListOrderedMap)repl.getTopKEvents().get("EVENT_ALTER_PARTITION")).valueList().toArray());
        Assert.assertEquals((long)4L, (long)((DescriptiveStatistics)repl.getDescMap().get("EVENT_ALTER_PARTITION")).getN());
        Assert.assertArrayEquals((String)((ListOrderedMap)repl.getTopKEvents().get("EVENT_ADD_DATABASE")).valueList().toString(), (Object[])new Long[]{234544L, 12345L, 3345L, 345L}, (Object[])((ListOrderedMap)repl.getTopKEvents().get("EVENT_ADD_DATABASE")).valueList().toArray());
        Assert.assertEquals((long)4L, (long)((DescriptiveStatistics)repl.getDescMap().get("EVENT_ADD_DATABASE")).getN());
    }

    @Test
    public void testReplStatsTrackerLimit() {
        MessageSerializer serializer = MessageFactory.getDefaultInstanceForReplMetrics((Configuration)this.conf).getSerializer();
        ReplStatsTracker repl = new ReplStatsTracker(10);
        this.generateStatsString(10, repl);
        String replStatsTracker = repl.toString();
        String gzipSerialized = serializer.serialize(replStatsTracker);
        Assert.assertTrue((String)("ReplStat string is " + gzipSerialized.length()), (gzipSerialized.length() < ReplStatsTracker.RM_PROGRESS_LENGTH ? 1 : 0) != 0);
        repl = new ReplStatsTracker(5);
        this.generateStatsString(5, repl);
        replStatsTracker = repl.toString();
        gzipSerialized = serializer.serialize(replStatsTracker);
        Assert.assertTrue((String)("ReplStat string is " + gzipSerialized.length()), (gzipSerialized.length() < ReplStatsTracker.RM_PROGRESS_LENGTH ? 1 : 0) != 0);
        repl = new ReplStatsTracker(2);
        this.generateStatsString(2, repl);
        Assert.assertTrue((boolean)repl.toString().contains("NaN"));
    }

    private void generateStatsString(int k, ReplStatsTracker repl) {
        DumpType[] types;
        for (DumpType type : types = DumpType.values()) {
            for (int i = 0; i < k; ++i) {
                int eventId = 1000000 + i * type.ordinal();
                repl.addEntry(type.toString(), Integer.toString(eventId), (long)(10000 + i + i * 1234));
            }
        }
    }
}

