/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.load.message;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.ResourceType;
import org.apache.hadoop.hive.metastore.api.ResourceUri;
import org.apache.hadoop.hive.ql.exec.ReplCopyTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.load.MetaData;
import org.apache.hadoop.hive.ql.parse.repl.load.message.CreateFunctionHandler;
import org.apache.hadoop.hive.ql.parse.repl.load.message.MessageHandler;
import org.apache.hadoop.hive.ql.parse.repl.metric.ReplicationMetricCollector;
import org.apache.hadoop.util.Time;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=MockitoJUnitRunner.class)
public class TestPrimaryToReplicaResourceFunction {
    private CreateFunctionHandler.PrimaryToReplicaResourceFunction function;
    @Mock
    private HiveConf hiveConf;
    @Mock
    private Function functionObj;
    @Mock
    private FileSystem mockFs;
    MockedStatic<Time> timeMockedStatic;
    private static Logger logger = LoggerFactory.getLogger(TestPrimaryToReplicaResourceFunction.class);

    @Before
    public void setup() {
        MetaData metadata = new MetaData(null, null, null, null, this.functionObj);
        MessageHandler.Context context = new MessageHandler.Context("primaryDb", null, null, null, this.hiveConf, null, null, logger);
        Mockito.when((Object)this.hiveConf.getVar(HiveConf.ConfVars.REPL_FUNCTIONS_ROOT_DIR)).thenReturn((Object)"/someBasePath/withADir/");
        this.timeMockedStatic = Mockito.mockStatic(Time.class);
        this.timeMockedStatic.when(Time::monotonicNowNanos).thenReturn((Object)0L);
        this.function = new CreateFunctionHandler.PrimaryToReplicaResourceFunction(context, metadata, "replicaDbName");
    }

    @After
    public void tearDown() {
        this.timeMockedStatic.close();
    }

    @Test
    public void createDestinationPath() throws IOException, SemanticException, URISyntaxException {
        MockedStatic fileSystemMockedStatic = Mockito.mockStatic(FileSystem.class);
        MockedStatic ignoredReplCopyTaskMockedStatic = Mockito.mockStatic(ReplCopyTask.class);
        MockedStatic createFunctionHandlerMockedStatic = Mockito.mockStatic(CreateFunctionHandler.class);
        fileSystemMockedStatic.when(() -> FileSystem.get((Configuration)((Configuration)ArgumentMatchers.any(Configuration.class)))).thenReturn((Object)this.mockFs);
        fileSystemMockedStatic.when(() -> FileSystem.get((URI)((URI)ArgumentMatchers.any(URI.class)), (Configuration)((Configuration)ArgumentMatchers.any(Configuration.class)))).thenReturn((Object)this.mockFs);
        Mockito.when((Object)this.mockFs.getScheme()).thenReturn((Object)"hdfs");
        Mockito.when((Object)this.mockFs.getUri()).thenReturn((Object)new URI("hdfs", "somehost:9000", null, null, null));
        Mockito.when((Object)this.functionObj.getFunctionName()).thenReturn((Object)"someFunctionName");
        Task mock = (Task)Mockito.mock(Task.class);
        Mockito.when((Object)ReplCopyTask.getLoadCopyTask((ReplicationSpec)((ReplicationSpec)ArgumentMatchers.any(ReplicationSpec.class)), (Path)((Path)ArgumentMatchers.any(Path.class)), (Path)((Path)ArgumentMatchers.any(Path.class)), (HiveConf)((HiveConf)ArgumentMatchers.any(HiveConf.class)), (String)((String)ArgumentMatchers.any()), (ReplicationMetricCollector)((ReplicationMetricCollector)ArgumentMatchers.any()))).thenReturn((Object)mock);
        ResourceUri resourceUri = this.function.destinationResourceUri(new ResourceUri(ResourceType.JAR, "hdfs://localhost:9000/user/someplace/ab.jar#e094828883"));
        Assert.assertThat((Object)resourceUri.getUri(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)("hdfs://somehost:9000/someBasePath/withADir/replicadbname/somefunctionname/" + String.valueOf(0L) + "/ab.jar"))));
    }
}

