/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.dump;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.repl.dump.ExportJob;
import org.apache.hadoop.hive.ql.parse.repl.dump.ExportService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=MockitoJUnitRunner.class)
public class TestExportService {
    protected static final Logger LOG = LoggerFactory.getLogger(TestExportService.class);
    @Mock
    HiveConf conf;
    private final int nThreads = 50;
    private static int taskNumber = 0;
    private final int totalTask = 50;
    private Semaphore sem;
    private ExportService exportService;

    @After
    public void finalize() {
        for (int i = 0; i < 50; ++i) {
            this.sem.release();
        }
    }

    private ExportJob runParallelTask() {
        return new ExportJob(){

            public void run() {
                Assert.assertTrue((boolean)TestExportService.this.sem.tryAcquire());
                LOG.debug("Current task number is: {} and thread is: {} ", (Object)(++taskNumber), (Object)Thread.currentThread().getName());
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    private void configureAndSubmitTasks() throws HiveException {
        Mockito.when((Object)this.conf.getIntVar(HiveConf.ConfVars.REPL_TABLE_DUMP_PARALLELISM)).thenReturn((Object)50);
        this.exportService = new ExportService(this.conf);
        taskNumber = 0;
        this.sem = new Semaphore(50);
        for (int i = 0; i < 50; ++i) {
            this.exportService.submit(this.runParallelTask());
        }
        this.exportService.waitForTasksToFinishAndShutdown();
    }

    @Test
    public void testExportServiceWithParallelism() throws Exception {
        this.configureAndSubmitTasks();
        long actualNumTasksExecuted = this.exportService.getTotalTaskEverExecuted();
        Assert.assertEquals((long)50L, (long)actualNumTasksExecuted);
        Assert.assertTrue((boolean)this.exportService.await(Long.MAX_VALUE, TimeUnit.MILLISECONDS));
    }
}

