/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.lang.reflect.Field;
import java.time.Instant;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.hadoop.hive.ql.exec.repl.util.ReplUtils;
import org.apache.hadoop.hive.ql.parse.repl.ReplState;
import org.apache.hadoop.hive.ql.parse.repl.load.log.state.DataCopyEnd;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class TestReplStateLogTimeFormat {
    private static final long randomDate = 1659367078L;
    private static final String UTCString = Instant.ofEpochSecond(1659367078L).toString();
    private static final Set<Class<? extends ReplState>> DUMP_LOG_EXEMPTED_CLASSES = new HashSet<Class<? extends ReplState>>();
    private static final Set<Class<? extends ReplState>> LOAD_LOG_EXEMPTED_CLASSES = new HashSet<Class<? extends ReplState>>();

    private void verifyAnnotationAndSetEpoch(ReplState replState) throws Exception {
        boolean isAnnotationSet = false;
        for (Field field : replState.getClass().getDeclaredFields()) {
            if (!Objects.nonNull(field.getAnnotation(JsonSerialize.class)) || !ReplUtils.TimeSerializer.class.equals((Object)field.getAnnotation(JsonSerialize.class).using())) continue;
            field.setAccessible(true);
            field.set(replState, 1659367078L);
            isAnnotationSet = true;
        }
        Assert.assertTrue((String)String.format("Class %s has a time field which is not annotated with @JsonSerialize(using = ReplUtils.TimeSerializer.class) Please annotate the time field with it or add it to appropriate exempted set above", replState.getClass().getName()), (boolean)isAnnotationSet);
    }

    private void verifyUTCString(ReplState replState) throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        String json = objectMapper.writeValueAsString((Object)replState);
        Assert.assertTrue((String)String.format("Expected UTC string %s not found in serialized representation of %s", UTCString, replState.getClass().getName()), (boolean)json.contains(UTCString));
    }

    private void verifyTimeFormat(String packagePath, Set<Class<? extends ReplState>> EXEMPTED_CLASS) throws Exception {
        Set replStateLogClasses = new Reflections(packagePath, new Scanner[0]).getSubTypesOf(ReplState.class);
        for (Class cls : replStateLogClasses) {
            if (EXEMPTED_CLASS.contains(cls)) continue;
            ReplState replState = (ReplState)Mockito.mock((Class)cls);
            this.verifyAnnotationAndSetEpoch(replState);
            this.verifyUTCString(replState);
        }
    }

    @Test
    public void testReplLogTimeFormat() throws Exception {
        this.verifyTimeFormat("org.apache.hadoop.hive.ql.parse.repl.dump.log.state", DUMP_LOG_EXEMPTED_CLASSES);
        this.verifyTimeFormat("org.apache.hadoop.hive.ql.parse.repl.load.log.state", LOAD_LOG_EXEMPTED_CLASSES);
    }

    @Test(expected=AssertionError.class)
    public void testClassWithoutAnnotation() throws Exception {
        ReplState replStateClassWithoutAnnotation = new ReplState(){
            private Long StartTime;
        };
        this.verifyAnnotationAndSetEpoch(replStateClassWithoutAnnotation);
    }

    static {
        LOAD_LOG_EXEMPTED_CLASSES.add(DataCopyEnd.class);
    }
}

