/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathPermissionException;
import org.apache.hadoop.hive.common.DataCopyStatistics;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.ReplChangeManager;
import org.apache.hadoop.hive.ql.parse.repl.CopyUtils;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class TestCopyUtils {
    @Test
    public void distcpShouldNotBeCalledOnlyForOneFile() throws Exception {
        try (MockedStatic userGroupInformationMockedStatic = Mockito.mockStatic(UserGroupInformation.class);){
            userGroupInformationMockedStatic.when(UserGroupInformation::getCurrentUser).thenReturn(Mockito.mock(UserGroupInformation.class));
            HiveConf conf = (HiveConf)Mockito.spy((Object)new HiveConf());
            ((HiveConf)Mockito.doReturn((Object)1L).when((Object)conf)).getLong(HiveConf.ConfVars.HIVE_EXEC_COPYFILE_MAXSIZE.varname, 0x2000000L);
            CopyUtils copyUtils = new CopyUtils("", conf, null);
            long MB_128 = 0x8000000L;
            Assert.assertFalse((boolean)copyUtils.limitReachedForLocalCopy(MB_128, 1L));
        }
    }

    @Test
    public void distcpShouldNotBeCalledForSmallerFileSize() throws Exception {
        try (MockedStatic userGroupInformationMockedStatic = Mockito.mockStatic(UserGroupInformation.class);){
            userGroupInformationMockedStatic.when(UserGroupInformation::getCurrentUser).thenReturn(Mockito.mock(UserGroupInformation.class));
            HiveConf conf = (HiveConf)Mockito.spy((Object)new HiveConf());
            CopyUtils copyUtils = new CopyUtils("", conf, null);
            long MB_16 = 0x1000000L;
            Assert.assertFalse((boolean)copyUtils.limitReachedForLocalCopy(MB_16, 100L));
        }
    }

    @Test(expected=IOException.class)
    public void shouldThrowExceptionOnDistcpFailure() throws Exception {
        Path destination = (Path)Mockito.mock(Path.class);
        Path source = (Path)Mockito.mock(Path.class);
        FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);
        List<Path> srcPaths = Arrays.asList(source, source);
        HiveConf conf = (HiveConf)Mockito.mock(HiveConf.class);
        CopyUtils copyUtils = (CopyUtils)Mockito.spy((Object)new CopyUtils(null, conf, fs));
        ((CopyUtils)Mockito.doReturn((Object)false).when((Object)copyUtils)).regularCopy((FileSystem)ArgumentMatchers.same((Object)fs), ArgumentMatchers.anyList());
        Mockito.when((Object)source.getFileSystem((Configuration)ArgumentMatchers.same((Object)conf))).thenReturn((Object)fs);
        try (MockedStatic fileUtilsMockedStatic = Mockito.mockStatic(FileUtils.class);
             MockedStatic utilsMockedStatic = Mockito.mockStatic(Utils.class);){
            fileUtilsMockedStatic.when(() -> FileUtils.distCp((FileSystem)((FileSystem)ArgumentMatchers.same((Object)fs)), (List)ArgumentMatchers.anyList(), (Path)((Path)ArgumentMatchers.same((Object)destination)), (boolean)ArgumentMatchers.anyBoolean(), (UserGroupInformation)((UserGroupInformation)ArgumentMatchers.eq(null)), (HiveConf)((HiveConf)ArgumentMatchers.same((Object)conf)), (HadoopShims)((HadoopShims)ArgumentMatchers.same((Object)ShimLoader.getHadoopShims())))).thenReturn((Object)false);
            utilsMockedStatic.when(Utils::getUGI).thenReturn(Mockito.mock(UserGroupInformation.class));
            copyUtils.doCopy(destination, srcPaths);
        }
    }

    @Test
    public void testFSCallsFailOnParentExceptions() throws Exception {
        try (MockedStatic userGroupInformationMockedStatic = Mockito.mockStatic(UserGroupInformation.class);
             MockedStatic replChangeManagerMockedStatic = Mockito.mockStatic(ReplChangeManager.class);){
            userGroupInformationMockedStatic.when(UserGroupInformation::getCurrentUser).thenReturn(Mockito.mock(UserGroupInformation.class));
            HiveConf conf = (HiveConf)Mockito.mock(HiveConf.class);
            conf.set(HiveConf.ConfVars.REPL_RETRY_INTIAL_DELAY.varname, "1s");
            FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);
            Path source = (Path)Mockito.mock(Path.class);
            Path destination = (Path)Mockito.mock(Path.class);
            ContentSummary cs = (ContentSummary)Mockito.mock(ContentSummary.class);
            PathPermissionException exception = new PathPermissionException("Failed");
            replChangeManagerMockedStatic.when(() -> ReplChangeManager.checksumFor((Path)source, (FileSystem)fs)).thenThrow(new Throwable[]{exception}).thenReturn((Object)"dummy");
            Mockito.when((Object)fs.exists((Path)ArgumentMatchers.same((Object)source))).thenThrow(new Throwable[]{exception}).thenReturn((Object)true);
            Mockito.when((Object)fs.delete((Path)ArgumentMatchers.same((Object)source), ArgumentMatchers.anyBoolean())).thenThrow(new Throwable[]{exception}).thenReturn((Object)true);
            Mockito.when((Object)fs.mkdirs((Path)ArgumentMatchers.same((Object)source))).thenThrow(new Throwable[]{exception}).thenReturn((Object)true);
            Mockito.when((Object)fs.rename((Path)ArgumentMatchers.same((Object)source), (Path)ArgumentMatchers.same((Object)destination))).thenThrow(new Throwable[]{exception}).thenReturn((Object)true);
            Mockito.when((Object)fs.getContentSummary((Path)ArgumentMatchers.same((Object)source))).thenThrow(new Throwable[]{exception}).thenReturn((Object)cs);
            CopyUtils copyUtils = new CopyUtils(UserGroupInformation.getCurrentUser().getUserName(), conf, fs);
            CopyUtils copyUtilsSpy = (CopyUtils)Mockito.spy((Object)copyUtils);
            try {
                copyUtilsSpy.exists(fs, source);
            }
            catch (Exception e) {
                Assert.assertEquals(exception.getClass(), e.getCause().getClass());
            }
            ((FileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.times((int)1))).exists(source);
            try {
                copyUtils.delete(fs, source, true);
            }
            catch (Exception e) {
                Assert.assertEquals(exception.getClass(), e.getCause().getClass());
            }
            ((FileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.times((int)1))).delete(source, true);
            try {
                copyUtils.mkdirs(fs, source);
            }
            catch (Exception e) {
                Assert.assertEquals(exception.getClass(), e.getCause().getClass());
            }
            ((FileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.times((int)1))).mkdirs(source);
            try {
                copyUtils.rename(fs, source, destination);
            }
            catch (Exception e) {
                Assert.assertEquals(exception.getClass(), e.getCause().getClass());
            }
            ((FileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.times((int)1))).rename(source, destination);
            try {
                copyUtilsSpy.getContentSummary(fs, source);
            }
            catch (Exception e) {
                Assert.assertEquals(exception.getClass(), e.getCause().getClass());
            }
            ((FileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.times((int)1))).getContentSummary(source);
            try {
                copyUtilsSpy.checkSumFor(source, fs);
            }
            catch (Exception e) {
                Assert.assertEquals(exception.getClass(), e.getCause().getClass());
            }
            ((CopyUtils)Mockito.verify((Object)copyUtilsSpy, (VerificationMode)Mockito.times((int)1))).checkSumFor(source, fs);
        }
    }

    @Test
    public void testRetryableFSCalls() throws Exception {
        try (MockedStatic userGroupInformationMockedStatic = Mockito.mockStatic(UserGroupInformation.class);
             MockedStatic replChangeManagerMockedStatic = Mockito.mockStatic(ReplChangeManager.class);){
            userGroupInformationMockedStatic.when(UserGroupInformation::getCurrentUser).thenReturn(Mockito.mock(UserGroupInformation.class));
            HiveConf conf = (HiveConf)Mockito.mock(HiveConf.class);
            conf.set(HiveConf.ConfVars.REPL_RETRY_INTIAL_DELAY.varname, "1s");
            FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);
            Path source = (Path)Mockito.mock(Path.class);
            Path destination = (Path)Mockito.mock(Path.class);
            ContentSummary cs = (ContentSummary)Mockito.mock(ContentSummary.class);
            replChangeManagerMockedStatic.when(() -> ReplChangeManager.checksumFor((Path)source, (FileSystem)fs)).thenThrow(new Throwable[]{new IOException("Failed")}).thenReturn((Object)"dummy");
            Mockito.when((Object)fs.exists((Path)ArgumentMatchers.same((Object)source))).thenThrow(new Throwable[]{new IOException("Failed")}).thenReturn((Object)true);
            Mockito.when((Object)fs.delete((Path)ArgumentMatchers.same((Object)source), ArgumentMatchers.anyBoolean())).thenThrow(new Throwable[]{new IOException("Failed")}).thenReturn((Object)true);
            Mockito.when((Object)fs.mkdirs((Path)ArgumentMatchers.same((Object)source))).thenThrow(new Throwable[]{new IOException("Failed")}).thenReturn((Object)true);
            Mockito.when((Object)fs.rename((Path)ArgumentMatchers.same((Object)source), (Path)ArgumentMatchers.same((Object)destination))).thenThrow(new Throwable[]{new IOException("Failed")}).thenReturn((Object)true);
            Mockito.when((Object)fs.getContentSummary((Path)ArgumentMatchers.same((Object)source))).thenThrow(new Throwable[]{new IOException("Failed")}).thenReturn((Object)cs);
            CopyUtils copyUtils = new CopyUtils(UserGroupInformation.getCurrentUser().getUserName(), conf, fs);
            CopyUtils copyUtilsSpy = (CopyUtils)Mockito.spy((Object)copyUtils);
            Assert.assertEquals((Object)true, (Object)copyUtilsSpy.exists(fs, source));
            ((FileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.times((int)2))).exists(source);
            Assert.assertEquals((Object)true, (Object)copyUtils.delete(fs, source, true));
            ((FileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.times((int)2))).delete(source, true);
            Assert.assertEquals((Object)true, (Object)copyUtils.mkdirs(fs, source));
            ((FileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.times((int)2))).mkdirs(source);
            Assert.assertEquals((Object)true, (Object)copyUtils.rename(fs, source, destination));
            ((FileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.times((int)2))).rename(source, destination);
            Assert.assertEquals((Object)cs, (Object)copyUtilsSpy.getContentSummary(fs, source));
            ((FileSystem)Mockito.verify((Object)fs, (VerificationMode)Mockito.times((int)2))).getContentSummary(source);
            Assert.assertEquals((Object)"dummy", (Object)copyUtilsSpy.checkSumFor(source, fs));
        }
    }

    @Test
    public void testParallelCopySuccess() throws Exception {
        try (MockedStatic userGroupInformationMockedStatic = Mockito.mockStatic(UserGroupInformation.class);){
            userGroupInformationMockedStatic.when(UserGroupInformation::getCurrentUser).thenReturn(Mockito.mock(UserGroupInformation.class));
            HiveConf conf = (HiveConf)Mockito.spy((Object)new HiveConf());
            Mockito.when((Object)conf.getIntVar(HiveConf.ConfVars.REPL_PARALLEL_COPY_TASKS)).thenReturn((Object)2);
            Mockito.when((Object)conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST_REPL)).thenReturn((Object)true);
            FileSystem destFs = (FileSystem)Mockito.mock(FileSystem.class);
            CopyUtils copyUtils = new CopyUtils(UserGroupInformation.getCurrentUser().getUserName(), conf, destFs);
            CopyUtils copyUtilsSpy = (CopyUtils)Mockito.spy((Object)copyUtils);
            ExecutorService executorService = Executors.newFixedThreadPool(2);
            ExecutorService mockExecutorService = (ExecutorService)Mockito.spy((Object)executorService);
            Mockito.when((Object)copyUtilsSpy.getExecutorService()).thenReturn((Object)mockExecutorService);
            Path destination = new Path("dest");
            Path source = (Path)Mockito.mock(Path.class);
            FileSystem fs = (FileSystem)Mockito.mock(FileSystem.class);
            ReplChangeManager.FileInfo srcFileInfo = new ReplChangeManager.FileInfo(fs, source, "path1");
            List<ReplChangeManager.FileInfo> srcFiles = Arrays.asList(srcFileInfo);
            ((CopyUtils)Mockito.doNothing().when((Object)copyUtilsSpy)).doCopy((Map.Entry)Mockito.any(), (UserGroupInformation)Mockito.any(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean(), (DataCopyStatistics)Mockito.any());
            copyUtilsSpy.copyAndVerify(destination, srcFiles, source, true, true);
            Class<List> listClass = List.class;
            ArgumentCaptor callableCapture = ArgumentCaptor.forClass(listClass);
            ((ExecutorService)Mockito.verify((Object)mockExecutorService, (VerificationMode)Mockito.times((int)0))).invokeAll((Collection)callableCapture.capture());
            ReplChangeManager.FileInfo srcFileInfo1 = new ReplChangeManager.FileInfo(fs, source, "path2");
            ReplChangeManager.FileInfo srcFileInfo2 = new ReplChangeManager.FileInfo(fs, source, "path3");
            srcFiles = Arrays.asList(srcFileInfo1, srcFileInfo2);
            executorService = Executors.newFixedThreadPool(2);
            mockExecutorService = (ExecutorService)Mockito.spy((Object)executorService);
            Mockito.when((Object)copyUtilsSpy.getExecutorService()).thenReturn((Object)mockExecutorService);
            copyUtilsSpy.copyAndVerify(destination, srcFiles, source, true, true);
            ((ExecutorService)Mockito.verify((Object)mockExecutorService, (VerificationMode)Mockito.times((int)1))).invokeAll((Collection)callableCapture.capture());
        }
    }
}

