/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.authorization;

import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveConfForTest;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.security.HiveAuthenticationProvider;
import org.apache.hadoop.hive.ql.security.SessionStateUserAuthenticator;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAccessController;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthorizer;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthorizerFactory;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthorizerImpl;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzSessionContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveMetastoreClientFactory;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestSessionUserName {
    @Before
    public void setup() throws Exception {
        HiveAuthorizerStoringUserNameFactory.username = null;
    }

    @Test
    public void testSessionDefaultUser() throws Exception {
        SessionState ss = new SessionState(this.getAuthV2HiveConf());
        this.setupDataNucleusFreeHive(ss.getConf());
        SessionState.start((SessionState)ss);
        Assert.assertEquals((String)"check username", (Object)ss.getAuthenticator().getUserName(), (Object)HiveAuthorizerStoringUserNameFactory.username);
    }

    @Test
    public void testSessionConstructorUser() throws Exception {
        String USER_NAME = "authtestuser";
        SessionState ss = new SessionState(this.getAuthV2HiveConf(), "authtestuser");
        this.setupDataNucleusFreeHive(ss.getConf());
        SessionState.start((SessionState)ss);
        ss.getAuthenticator();
        Assert.assertEquals((String)"check username", (Object)"authtestuser", (Object)HiveAuthorizerStoringUserNameFactory.username);
    }

    @Test
    public void testSessionGetGroupNames() throws Exception {
        String testUser = "authtestuser";
        List<String> testGroups = Arrays.asList("group1", "group2");
        UserGroupInformation.createUserForTesting((String)"authtestuser", (String[])testGroups.toArray(new String[0]));
        SessionState ss = new SessionState(this.getAuthV2HiveConf(), "authtestuser");
        this.setupDataNucleusFreeHive(ss.getConf());
        Assert.assertEquals((String)"check groups", testGroups, (Object)ss.getAuthenticator().getGroupNames());
    }

    @Test
    public void testSessionNullUser() throws Exception {
        SessionState ss = new SessionState(this.getAuthV2HiveConf(), null);
        this.setupDataNucleusFreeHive(ss.getConf());
        SessionState.start((SessionState)ss);
        Assert.assertNull((String)"getGroupNames when userName == null", (Object)ss.getAuthenticator().getGroupNames());
    }

    private void setupDataNucleusFreeHive(HiveConf hiveConf) throws MetaException {
        Hive db = (Hive)Mockito.mock(Hive.class);
        Mockito.when((Object)db.getMSC()).thenReturn(null);
        Mockito.when((Object)db.getConf()).thenReturn((Object)hiveConf);
        Hive.set((Hive)db);
    }

    private HiveConf getAuthV2HiveConf() {
        HiveConfForTest conf = new HiveConfForTest(this.getClass());
        conf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, HiveAuthorizerStoringUserNameFactory.class.getName());
        conf.setVar(HiveConf.ConfVars.HIVE_AUTHENTICATOR_MANAGER, SessionStateUserAuthenticator.class.getName());
        return conf;
    }

    static class HiveAuthorizerStoringUserNameFactory
    implements HiveAuthorizerFactory {
        static String username;

        HiveAuthorizerStoringUserNameFactory() {
        }

        public HiveAuthorizer createHiveAuthorizer(HiveMetastoreClientFactory metastoreClientFactory, HiveConf conf, HiveAuthenticationProvider authenticator, HiveAuthzSessionContext ctx) {
            username = authenticator.getUserName();
            HiveAccessController acontroller = (HiveAccessController)Mockito.mock(HiveAccessController.class);
            return new HiveAuthorizerImpl(acontroller, null);
        }
    }
}

