/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.MaterializationSnapshot;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveConfForTest;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.SourceTable;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.QueryProperties;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.cache.results.QueryResultsCache;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.lockmgr.DbTxnManager;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.MaterializedViewMetadata;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.QB;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.security.HadoopDefaultAuthenticator;
import org.apache.hadoop.hive.ql.security.HiveAuthenticationProvider;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSemanticAnalyzer {
    private static final Logger LOG = LoggerFactory.getLogger((String)TestSemanticAnalyzer.class.getName());
    private static Hive db;
    private static HiveConf conf;

    @BeforeClass
    public static void beforeClass() throws Exception {
        conf = new HiveConfForTest(TestSemanticAnalyzer.class);
        conf.set("hive.security.authorization.enabled", "false");
        conf.set("hive.security.authorization.manager", "org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdConfOnlyAuthorizerFactory");
        db = Hive.get((HiveConf)conf);
        TestSemanticAnalyzer.createDatabase("other_db");
        Table table1 = TestSemanticAnalyzer.createKeyValueTable("table1");
        TestSemanticAnalyzer.createKeyValueTable("table2");
        TestSemanticAnalyzer.createKeyValueTable("table3");
        TestSemanticAnalyzer.createPartitionedTable("table_part");
        Table tableAcid = TestSemanticAnalyzer.createAcidTable("table_acid");
        TestSemanticAnalyzer.createKeyValueTable("other_db", "table1");
        TestSemanticAnalyzer.createView("view1", table1);
        TestSemanticAnalyzer.createMaterializedView("mview1", table1);
        TestSemanticAnalyzer.createMaterializedView("mview_acid", tableAcid);
        db.createRole("role1", "hive");
    }

    private static void createDatabase(String dbName) throws Exception {
        Database database = new Database();
        database.setName(dbName);
        db.createDatabase(database);
    }

    private static Table createKeyValueTable(String tableName) throws Exception {
        return TestSemanticAnalyzer.createKeyValueTable("default", tableName);
    }

    private static Table createKeyValueTable(String dbName, String tableName) throws Exception {
        Table table = TestSemanticAnalyzer.createSimpleTableWithColumns(dbName, tableName);
        db.createTable(table);
        return table;
    }

    private static Table createAcidTable(String tableAcid) throws HiveException {
        Table table = TestSemanticAnalyzer.createSimpleTableWithColumns("default", tableAcid);
        table.setProperty("transactional", "true");
        TestSemanticAnalyzer.setOrc(table);
        db.createTable(table);
        return table;
    }

    private static void createPartitionedTable(String tablePart) throws HiveException {
        Table table = TestSemanticAnalyzer.createSimpleTableWithColumns("default", tablePart);
        ArrayList<FieldSchema> partitionColumns = new ArrayList<FieldSchema>();
        partitionColumns.add(new FieldSchema("part_col", "string", "Partition column description"));
        table.setPartCols(partitionColumns);
        db.createTable(table);
    }

    private static void setOrc(Table table) throws HiveException {
        table.setInputFormatClass("org.apache.hadoop.hive.ql.io.orc.OrcInputFormat");
        table.setOutputFormatClass("org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat");
        table.setSerializationLib("org.apache.hadoop.hive.ql.io.orc.OrcSerde");
    }

    private static Table createSimpleTableWithColumns(String dbName, String tableName) {
        Table table = new Table(dbName, tableName);
        ArrayList<FieldSchema> columns = new ArrayList<FieldSchema>();
        columns.add(new FieldSchema("key", "string", "First column"));
        columns.add(new FieldSchema("value", "int", "Second column"));
        table.setFields(columns);
        return table;
    }

    private static void createView(String viewName, Table sourceTable) throws HiveException {
        Table view = new Table("default", viewName);
        view.setTableType(TableType.VIRTUAL_VIEW);
        view.setViewOriginalText(String.format("SELECT * FROM %s", sourceTable.getTableName()));
        view.setViewExpandedText(String.format("SELECT * FROM %s", sourceTable.getTableName()));
        db.createTable(view);
    }

    private static void createMaterializedView(String materializedViewName, Table sourceTable) throws HiveException {
        Table materializedView = new Table("default", materializedViewName);
        materializedView.setTableType(TableType.MATERIALIZED_VIEW);
        materializedView.setViewOriginalText(String.format("SELECT * FROM %s", sourceTable.getTableName()));
        materializedView.setViewExpandedText(String.format("SELECT * FROM %s", sourceTable.getTableName()));
        materializedView.getSd().setCols(sourceTable.getCols());
        MaterializedViewMetadata metadata = new MaterializedViewMetadata(MetaStoreUtils.getDefaultCatalog((Configuration)conf), sourceTable.getDbName(), materializedViewName, (Set)Sets.newHashSet((Object[])new SourceTable[]{sourceTable.createSourceTable()}), (MaterializationSnapshot)Mockito.mock(MaterializationSnapshot.class));
        materializedView.setMaterializedViewMetadata(metadata);
        db.createTable(materializedView);
    }

    @AfterClass
    public static void afterClass() {
        db.close(true);
    }

    @Test
    public void testNormalizeColSpec() throws Exception {
        this.checkNormalization("date", "2010-01-01", "2010-01-01", Date.valueOf((String)"2010-01-01"));
        this.checkNormalization("date", "2010-1-01", "2010-01-01", Date.valueOf((String)"2010-01-01"));
        this.checkNormalization("date", "2010-1-1", "2010-01-01", Date.valueOf((String)"2010-01-01"));
        this.checkNormalization("string", "2010-1-1", "2010-1-1", "2010-1-1");
        try {
            this.checkNormalization("date", "foo", "", "foo");
            Assert.fail((String)"should throw");
        }
        catch (SemanticException semanticException) {
            // empty catch block
        }
        try {
            this.checkNormalization("date", "2010-01-01", "2010-01-01", "2010-01-01");
            Assert.fail((String)"should throw");
        }
        catch (SemanticException semanticException) {
            // empty catch block
        }
    }

    public void checkNormalization(String colType, String originalColSpec, String result, Object colValue) throws SemanticException {
        String colName = "col";
        HashMap<String, String> partSpec = new HashMap<String, String>();
        partSpec.put("col", originalColSpec);
        BaseSemanticAnalyzer.normalizeColSpec(partSpec, (String)"col", (String)colType, (String)originalColSpec, (Object)colValue);
        Assert.assertEquals((Object)result, partSpec.get("col"));
        if (colValue instanceof Date) {
            DateWritableV2 dw = new DateWritableV2((Date)colValue);
            BaseSemanticAnalyzer.normalizeColSpec(partSpec, (String)"col", (String)colType, (String)originalColSpec, (Object)dw);
            Assert.assertEquals((Object)result, partSpec.get("col"));
        }
    }

    @Test
    public void testUnescapeSQLString() {
        Assert.assertEquals((Object)"abcdefg", (Object)BaseSemanticAnalyzer.unescapeSQLString((String)"\"abcdefg\""));
        Assert.assertEquals((Object)"C0FFEE", (Object)BaseSemanticAnalyzer.unescapeSQLString((String)"'C0FFEE'"));
        Assert.assertEquals((Object)"\u0000", (Object)BaseSemanticAnalyzer.unescapeSQLString((String)"'\\0'"));
        Assert.assertEquals((Object)"'", (Object)BaseSemanticAnalyzer.unescapeSQLString((String)"\"\\'\""));
        Assert.assertEquals((Object)"\"", (Object)BaseSemanticAnalyzer.unescapeSQLString((String)"'\\\"'"));
        Assert.assertEquals((Object)"\b", (Object)BaseSemanticAnalyzer.unescapeSQLString((String)"\"\\b\""));
        Assert.assertEquals((Object)"\n", (Object)BaseSemanticAnalyzer.unescapeSQLString((String)"'\\n'"));
        Assert.assertEquals((Object)"\r", (Object)BaseSemanticAnalyzer.unescapeSQLString((String)"\"\\r\""));
        Assert.assertEquals((Object)"\t", (Object)BaseSemanticAnalyzer.unescapeSQLString((String)"'\\t'"));
        Assert.assertEquals((Object)"\u001a", (Object)BaseSemanticAnalyzer.unescapeSQLString((String)"\"\\Z\""));
        Assert.assertEquals((Object)"\\", (Object)BaseSemanticAnalyzer.unescapeSQLString((String)"'\\\\'"));
        Assert.assertEquals((Object)"\\%", (Object)BaseSemanticAnalyzer.unescapeSQLString((String)"\"\\%\""));
        Assert.assertEquals((Object)"\\_", (Object)BaseSemanticAnalyzer.unescapeSQLString((String)"'\\_'"));
        Assert.assertEquals((Object)"3 + 5 = 8", (Object)BaseSemanticAnalyzer.unescapeSQLString((String)"'3 + 5 = \\070'"));
        Assert.assertEquals((Object)"\u0000", (Object)BaseSemanticAnalyzer.unescapeSQLString((String)"\"\\000\""));
        Assert.assertEquals((Object)"256", (Object)BaseSemanticAnalyzer.unescapeSQLString((String)"\"\\256\""));
        Assert.assertEquals((Object)"How cute \u732b are", (Object)BaseSemanticAnalyzer.unescapeSQLString((String)"\"How cute \\u732B are\""));
        Assert.assertEquals((Object)"\ud867\ude3d is a fish", (Object)BaseSemanticAnalyzer.unescapeSQLString((String)"\"\\uD867\ude3d is a fish\""));
    }

    @Test
    public void testSkipAuthorization() throws Exception {
        HiveConf hiveConf = new HiveConf();
        hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_ENABLED, true);
        hiveConf.setVar(HiveConf.ConfVars.HIVE_SERVER2_SERVICE_USERS, "u1,u2");
        SessionState ss = new SessionState(hiveConf);
        ss.setIsHiveServerQuery(true);
        ss.setAuthenticator((HiveAuthenticationProvider)new HadoopDefaultAuthenticator(){

            public String getUserName() {
                return "u3";
            }
        });
        SessionState.setCurrentSessionState((SessionState)ss);
        BaseSemanticAnalyzer analyzer = new BaseSemanticAnalyzer(new QueryState.Builder().withHiveConf(hiveConf).nonIsolated().build(), null){

            public void analyzeInternal(ASTNode ast) throws SemanticException {
            }
        };
        Assert.assertFalse((boolean)analyzer.skipAuthorization());
        hiveConf.setVar(HiveConf.ConfVars.HIVE_SERVER2_SERVICE_USERS, "u1,u2,u3");
        Assert.assertTrue((boolean)analyzer.skipAuthorization());
    }

    @Test
    public void testSelectCacheable() throws Exception {
        this.checkQueryCanUseCache("SELECT key from table1", true);
    }

    @Test
    public void testInsertCacheable() throws Exception {
        this.checkQueryCanUseCache("INSERT INTO table1 VALUES ('asdf', 2)", false);
    }

    @Test
    public void testInsertOverwriteDirectoryCacheable() throws Exception {
        this.checkQueryCanUseCache("INSERT OVERWRITE DIRECTORY '/tmp' SELECT key FROM table2", false);
    }

    @Test
    public void testInsertOverwriteDirectoryWithNonTrivialSubqueryCacheable() throws Exception {
        this.checkQueryCanUseCache("insert overwrite directory '/tmp' SELECT a.key, MAX(b.value) AS MAX_VALUE, COUNT(DISTINCT b.key) AS UNIQUE_KEYS, AVG(c.value) AS VALS FROM table1 a JOIN table2 b ON a.key = b.key JOIN table3 c ON a.key = c.key GROUP BY a.key HAVING AVG(LENGTH(a.key) + LENGTH(b.key)) > 5 ORDER BY MAX_VALUE DESC, UNIQUE_KEYS ASC", false);
    }

    private void checkQueryCanUseCache(String query, boolean canUseCache) throws Exception {
        conf.setBoolVar(HiveConf.ConfVars.HIVE_QUERY_RESULTS_CACHE_ENABLED, true);
        conf.setBoolVar(HiveConf.ConfVars.HIVE_SERVER2_ENABLE_DOAS, false);
        QueryResultsCache.initialize((HiveConf)conf);
        QueryResultsCache cache = QueryResultsCache.getInstance();
        String cacheDirPath = cache.getCacheDirPath().toUri().getPath();
        SessionState.start((HiveConf)conf);
        Context ctx = new Context((Configuration)conf);
        ASTNode astNode = ParseUtils.parse((String)query, (Context)ctx);
        QueryState queryState = new QueryState.Builder().withHiveConf(conf).build();
        SemanticAnalyzer analyzer = (SemanticAnalyzer)Mockito.spy((Object)((SemanticAnalyzer)SemanticAnalyzerFactory.get((QueryState)queryState, (ASTNode)astNode)));
        analyzer.initCtx(ctx);
        ArrayList capturedValues = new ArrayList();
        ((SemanticAnalyzer)Mockito.doAnswer(invocation -> {
            Operator fileSinkOperator = (Operator)invocation.callRealMethod();
            capturedValues.add(fileSinkOperator);
            return fileSinkOperator;
        }).when((Object)analyzer)).genFileSinkPlan(ArgumentMatchers.anyString(), (QB)ArgumentMatchers.any(QB.class), (Operator)ArgumentMatchers.any(Operator.class));
        analyzer.analyze(astNode, ctx);
        Assert.assertEquals((String)"genFileSinkPlan is supposed to be called once during semantic analysis", (long)1L, (long)capturedValues.size());
        FileSinkOperator operator = (FileSinkOperator)capturedValues.get(0);
        String finalPath = ((FileSinkDesc)operator.getConf()).getDestPath().toUri().toString();
        if (canUseCache) {
            Assert.assertTrue((String)String.format("Final path %s is not in the cache folder (%s), which is unexpected", finalPath, cacheDirPath), (boolean)finalPath.contains(cacheDirPath));
        } else {
            Assert.assertFalse((String)String.format("Final path %s is in cache folder (%s), which is unexpected", finalPath, cacheDirPath), (boolean)finalPath.contains(cacheDirPath));
        }
    }

    @Test
    public void testQueryTypes() throws Exception {
        this.checkQueryType("SELECT key FROM table1", QueryProperties.QueryType.DQL, "QUERY");
        this.checkQueryType("WITH a AS (SELECT key FROM table1) SELECT * FROM a", QueryProperties.QueryType.DQL, "QUERY");
        this.checkQueryType("SELECT key FROM table_non_existing", QueryProperties.QueryType.DQL, "QUERY");
        this.checkQueryType("WITH a AS (SELECT key FROM table_non_existing) SELECT * FROM a", QueryProperties.QueryType.DQL, "QUERY");
        this.checkQueryType("SELECT a.value, b.value FROM table1 a JOIN table2 b ON a.key = b.key", QueryProperties.QueryType.DQL, "QUERY");
        this.checkQueryType("ANALYZE TABLE table1 COMPUTE STATISTICS", QueryProperties.QueryType.STATS, "QUERY");
        this.checkQueryType("ANALYZE TABLE table1 COMPUTE STATISTICS FOR COLUMNS", QueryProperties.QueryType.STATS, "ANALYZE_TABLE");
        this.checkQueryType("INSERT INTO table1 VALUES ('1', 1)", QueryProperties.QueryType.DML, "INSERT");
        this.checkQueryType("INSERT OVERWRITE TABLE table1 SELECT * FROM table2", QueryProperties.QueryType.DML, "INSERT");
        this.checkQueryType("INSERT OVERWRITE DIRECTORY '/' SELECT * FROM table2", QueryProperties.QueryType.DML, "INSERT");
        this.checkQueryType("UPDATE table_acid SET value = 2 WHERE key = '1'", QueryProperties.QueryType.DML, "UPDATE");
        this.checkQueryType("DELETE FROM table_acid WHERE key = '1'", QueryProperties.QueryType.DML, "DELETE");
        this.checkQueryType("MERGE INTO table_acid AS target USING table1 AS source ON source.key = target.key WHEN MATCHED THEN UPDATE SET key = 3 WHEN NOT MATCHED THEN INSERT VALUES ('3', 4)", QueryProperties.QueryType.DML, "MERGE");
        this.checkQueryType("LOAD DATA INPATH '/data.csv' INTO TABLE table1", QueryProperties.QueryType.DML, "LOAD");
        this.checkQueryType("SHOW DATABASES", QueryProperties.QueryType.DDL, "SHOWDATABASES");
        this.checkQueryType("SHOW TABLES", QueryProperties.QueryType.DDL, "SHOWTABLES");
        this.checkQueryType("CREATE DATABASE test_database_to_create", QueryProperties.QueryType.DDL, "CREATEDATABASE");
        this.checkQueryType("CREATE EXTERNAL TABLE test_part(id int) PARTITIONED BY(dt string) STORED AS ORC", QueryProperties.QueryType.DDL, "CREATETABLE");
        this.checkQueryType("CREATE TABLE t AS SELECT * FROM table_acid", QueryProperties.QueryType.DDL, "CREATETABLE_AS_SELECT");
        this.checkQueryType("ALTER TABLE table_part ADD PARTITION (part_col='3')", QueryProperties.QueryType.DDL, "ALTERTABLE_ADDPARTS");
        this.checkQueryType("DROP TABLE table1", QueryProperties.QueryType.DDL, "DROPTABLE");
        this.checkQueryType("CREATE TABLE target AS SELECT * FROM table1", QueryProperties.QueryType.DDL, "CREATETABLE_AS_SELECT");
        this.checkQueryType("TRUNCATE TABLE table1", QueryProperties.QueryType.DDL, "TRUNCATETABLE");
        this.checkQueryType("CREATE VIEW v1 AS SELECT * FROM table1", QueryProperties.QueryType.DDL, "CREATEVIEW");
        this.checkQueryType("DROP VIEW IF EXISTS v1", QueryProperties.QueryType.DDL, "DROPVIEW");
        this.checkQueryType("ALTER VIEW view1 AS SELECT * FROM table1", QueryProperties.QueryType.DDL, "ALTERVIEW_AS");
        this.checkQueryType("CREATE MATERIALIZED VIEW mv1 AS SELECT * FROM table_acid", QueryProperties.QueryType.DDL, "CREATE_MATERIALIZED_VIEW");
        this.checkQueryType("DROP MATERIALIZED VIEW IF EXISTS mv1", QueryProperties.QueryType.DDL, "DROP_MATERIALIZED_VIEW");
        this.checkQueryType("ALTER MATERIALIZED VIEW mview_acid ENABLE REWRITE", QueryProperties.QueryType.DDL, "ALTER_MATERIALIZED_VIEW_REWRITE");
        this.checkQueryType("ALTER MATERIALIZED VIEW mview_acid REBUILD", QueryProperties.QueryType.DDL, "ALTER_MATERIALIZED_VIEW_REBUILD");
        this.checkQueryType("DESCRIBE FORMATTED table_acid", QueryProperties.QueryType.DDL, "DESCTABLE");
        this.checkQueryType("EXPORT TABLE table_acid TO '/path'", QueryProperties.QueryType.DDL, "QUERY");
        this.checkQueryType("EXPORT TABLE table1 TO '/path'", QueryProperties.QueryType.DDL, "EXPORT");
        this.checkQueryType("GRANT ROLE role1 TO USER user1", QueryProperties.QueryType.DCL, "GRANT_ROLE");
        this.checkQueryType("REVOKE ROLE role1 FROM USER user1", QueryProperties.QueryType.DCL, "REVOKE_ROLE");
        this.checkQueryType("EXPLAIN SELECT key FROM table1", QueryProperties.QueryType.DQL, "EXPLAIN");
        this.checkQueryType("EXPLAIN INSERT INTO table1 VALUES ('1', 1)", QueryProperties.QueryType.DQL, "EXPLAIN");
        this.checkQueryType("MSCK REPAIR TABLE table_part", QueryProperties.QueryType.OTHER, "MSCK");
        this.checkQueryType("ALTER TABLE table_acid COMPACT 'major'", QueryProperties.QueryType.OTHER, "ALTERTABLE_COMPACT");
        this.checkQueryType("COMMIT", QueryProperties.QueryType.OTHER, "COMMIT");
        this.checkQueryType("START TRANSACTION", QueryProperties.QueryType.OTHER, "START TRANSACTION");
        this.checkQueryType("ROLLBACK", QueryProperties.QueryType.OTHER, "ROLLBACK");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkQueryType(String query, QueryProperties.QueryType expectedQueryType, String expectedOperation) throws Exception {
        SessionState.start((SessionState)new SessionState(conf));
        Context ctx = new Context((Configuration)conf);
        ASTNode astNode = ParseUtils.parse((String)query, (Context)ctx);
        QueryState queryState = new QueryState.Builder().withHiveConf(conf).build();
        HiveConf.setVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_QUERY_ID, (String)"test_query_id");
        SessionState.get().addQueryState("test_query_id", queryState);
        HiveTxnManager txnManager = (HiveTxnManager)Mockito.mock(DbTxnManager.class);
        Mockito.when((Object)txnManager.supportsAcid()).thenReturn((Object)true);
        queryState.setTxnManager(txnManager);
        BaseSemanticAnalyzer analyzer = (BaseSemanticAnalyzer)Mockito.spy((Object)SemanticAnalyzerFactory.get((QueryState)queryState, (ASTNode)astNode));
        analyzer.initCtx(ctx);
        try {
            analyzer.analyze(astNode, ctx);
        }
        catch (SemanticException e) {
            LOG.info("Ignoring semantic exception because the inner state of the Semantic Analyzer still can and will be asserted in this unit test.", (Throwable)e);
        }
        finally {
            analyzer.endAnalysis(astNode);
        }
        QueryProperties.QueryType queryType = analyzer.getQueryProperties().getQueryType();
        Assert.assertEquals((String)String.format("Expected query type for query '%s' is '%s', seen '%s'", query, expectedQueryType, queryType), (Object)expectedQueryType, (Object)queryType);
        String operationOrSqlKind = queryState.getSqlKind() == null ? queryState.getCommandType() : queryState.getSqlKind().toString();
        Assert.assertEquals((String)String.format("Expected operation(or sqlKind) for query '%s' is '%s', seen '%s'", query, expectedOperation, operationOrSqlKind), (Object)expectedOperation, (Object)operationOrSqlKind);
    }

    @Test
    public void testUsedTables() throws Exception {
        this.checkTablesUsed("SELECT key FROM table1", Sets.newHashSet((Object[])new String[]{"default.table1"}));
        this.checkTablesUsed("INSERT OVERWRITE TABLE table1 SELECT * FROM table2", Sets.newHashSet((Object[])new String[]{"default.table1", "default.table2"}));
        this.checkTablesUsed("INSERT OVERWRITE TABLE table1 SELECT * FROM other_db.table1", Sets.newHashSet((Object[])new String[]{"default.table1", "other_db.table1"}));
        this.checkTablesUsed("SELECT a.value, b.value FROM table1 a JOIN table2 b ON a.key = b.key", Sets.newHashSet((Object[])new String[]{"default.table1", "default.table2"}));
    }

    private void checkTablesUsed(String query, Set<String> tables) throws Exception {
        SessionState.start((HiveConf)conf);
        Context ctx = new Context((Configuration)conf);
        ASTNode astNode = ParseUtils.parse((String)query, (Context)ctx);
        QueryState queryState = new QueryState.Builder().withHiveConf(conf).build();
        SemanticAnalyzer analyzer = (SemanticAnalyzer)Mockito.spy((Object)((SemanticAnalyzer)SemanticAnalyzerFactory.get((QueryState)queryState, (ASTNode)astNode)));
        analyzer.initCtx(ctx);
        analyzer.analyze(astNode, ctx);
        analyzer.endAnalysis(astNode);
        Set result = analyzer.getQueryProperties().getUsedTables();
        Assert.assertEquals(new TreeSet<String>(tables), new TreeSet(result));
    }
}

