/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveConfForTest;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.QueryProperties;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.lockmgr.DbTxnManager;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class TestQueryProperties {
    private static HiveConf conf;
    private static Hive db;
    @Parameterized.Parameter(value=0)
    public boolean useCbo;
    private SemanticAnalyzer analyzer;

    @Parameterized.Parameters(name="useCbo={0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({true}, {false});
    }

    @BeforeClass
    public static void setUpAll() throws Exception {
        conf = new HiveConfForTest(TestQueryProperties.class);
        db = Hive.get((HiveConf)conf);
        conf.setVar(HiveConf.ConfVars.HIVE_AUTHENTICATOR_MANAGER, "org.apache.hadoop.hive.ql.security.HadoopDefaultAuthenticator");
        conf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, "org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory");
        Database database = new Database();
        database.setName("test_db");
        db.createDatabase(database);
        Table testTable = new Table("test_db", "test_table");
        List columns = testTable.getCols();
        columns.add(new FieldSchema("t1", "string", ""));
        columns.add(new FieldSchema("t2", "string", ""));
        Map parameters = testTable.getParameters();
        parameters.put("numRows", "10");
        parameters.put("rawDataSize", "10");
        parameters.put("totalSize", "10");
        testTable.setProperty("transactional", "true");
        testTable.setInputFormatClass("org.apache.hadoop.hive.ql.io.orc.OrcInputFormat");
        testTable.setOutputFormatClass("org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat");
        testTable.setSerializationLib("org.apache.hadoop.hive.ql.io.orc.OrcSerde");
        db.createTable(testTable);
    }

    private QueryProperties analyze(String sql, boolean fullAnalyze) throws Exception {
        SessionState.start((HiveConf)conf);
        Context context = new Context((Configuration)conf);
        ASTNode node = ParseUtils.parse((String)sql, (Context)context);
        QueryState state = new QueryState.Builder().withHiveConf(conf).build();
        HiveTxnManager txnManager = (HiveTxnManager)Mockito.mock(DbTxnManager.class);
        Mockito.when((Object)txnManager.supportsAcid()).thenReturn((Object)true);
        state.setTxnManager(txnManager);
        HiveConf.setBoolVar((Configuration)state.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_CBO_ENABLED, (boolean)this.useCbo);
        this.analyzer = (SemanticAnalyzer)SemanticAnalyzerFactory.get((QueryState)state, (ASTNode)node);
        this.analyzer.initCtx(context);
        this.analyzer.init(false);
        if (fullAnalyze) {
            this.analyzer.analyze(node, context);
        } else {
            this.analyzer.genResolvedParseTree(node, null);
        }
        return this.analyzer.getQueryProperties();
    }

    @Test
    public void testExceptAll() throws Exception {
        if (!this.useCbo) {
            return;
        }
        QueryProperties properties = this.analyze("SELECT t1 FROM test_db.test_table EXCEPT ALL SELECT t2 FROM test_db.test_table", false);
        Assert.assertTrue((boolean)properties.hasExcept());
    }

    @Test
    public void testExceptDistinct() throws Exception {
        if (!this.useCbo) {
            return;
        }
        QueryProperties properties = this.analyze("SELECT t1 FROM test_db.test_table EXCEPT DISTINCT SELECT t2 FROM test_db.test_table", false);
        Assert.assertTrue((boolean)properties.hasExcept());
    }

    @Test
    public void testIntersectAll() throws Exception {
        if (!this.useCbo) {
            return;
        }
        QueryProperties properties = this.analyze("SELECT t1 FROM test_db.test_table INTERSECT ALL SELECT t2 FROM test_db.test_table", false);
        Assert.assertTrue((boolean)properties.hasIntersect());
    }

    @Test
    public void testIntersectDistinct() throws Exception {
        if (!this.useCbo) {
            return;
        }
        QueryProperties properties = this.analyze("SELECT t1 FROM test_db.test_table INTERSECT DISTINCT SELECT t2 FROM test_db.test_table", false);
        Assert.assertTrue((boolean)properties.hasIntersect());
    }

    @Test
    public void testQualify() throws Exception {
        if (!this.useCbo) {
            return;
        }
        QueryProperties properties = this.analyze("SELECT t1 FROM test_db.test_table QUALIFY row_number() OVER (PARTITION BY t1 ORDER BY t2) = 1", false);
        Assert.assertTrue((boolean)properties.hasQualify());
    }

    @Test
    public void testIsDML() throws Exception {
        this.checkIsDML("SELECT * FROM test_db.test_table", false);
        this.checkIsDML("INSERT INTO test_db.test_table VALUES ('a', 'b')", true);
        this.checkIsDML("INSERT OVERWRITE TABLE test_db.test_table SELECT * FROM test_db.test_table", true);
        this.checkIsDML("UPDATE test_db.test_table SET t1 = 'c' WHERE t2 = 'd'", true);
        this.checkIsDML("DELETE FROM test_db.test_table WHERE t2 = 'asdf'", true);
        this.checkIsDML("MERGE INTO test_db.test_table AS target USING test_db.test_table AS source ON source.t1 = target.t1 WHEN MATCHED THEN UPDATE SET t1 = 'a' WHEN NOT MATCHED THEN INSERT VALUES ('q', 'r')", true);
    }

    private void checkIsDML(String query, boolean expectedIsDML) throws Exception {
        QueryProperties properties = this.analyze(query, true);
        Assert.assertEquals((Object)expectedIsDML, (Object)QueryProperties.QueryType.DML.equals((Object)properties.getQueryType()));
    }

    @Test
    public void testFieldsRemainUntouchedOnClear() {
        QueryProperties queryProperties = new QueryProperties();
        Assert.assertNull((Object)queryProperties.getQueryType());
        queryProperties.setQueryType(QueryProperties.QueryType.DDL);
        queryProperties.clear();
        Assert.assertEquals((String)"queryType is not supposed to be cleared", (Object)QueryProperties.QueryType.DDL, (Object)queryProperties.getQueryType());
    }
}

