/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveConfForTest;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.CalcitePlanner;
import org.apache.hadoop.hive.ql.parse.ParseDriver;
import org.apache.hadoop.hive.ql.parse.ParseException;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.SubQueryUtils;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestQBSubQuery {
    static QueryState queryState;
    static HiveConf conf;
    private static String IN_QUERY;
    private static String IN_QUERY2;
    private static String QUERY3;
    ParseDriver pd;
    SemanticAnalyzer sA;

    @BeforeClass
    public static void initialize() {
        queryState = new QueryState.Builder().build();
        conf = new HiveConfForTest(TestQBSubQuery.class);
        SessionState.start((HiveConf)conf);
    }

    @Before
    public void setup() throws SemanticException {
        this.pd = new ParseDriver();
        this.sA = new CalcitePlanner(queryState);
    }

    ASTNode parse(String query) throws ParseException {
        ASTNode nd = this.pd.parse(query).getTree();
        return (ASTNode)nd.getChild(0);
    }

    @Test
    public void testExtractSubQueries() throws Exception {
        ASTNode ast = this.parse(IN_QUERY);
        ASTNode where = this.where(ast);
        List sqs = SubQueryUtils.findSubQueries((ASTNode)((ASTNode)where.getChild(0)));
        Assert.assertEquals((long)1L, (long)sqs.size());
        ASTNode sq = (ASTNode)sqs.get(0);
        Assert.assertEquals((Object)"(tok_subquery_expr (tok_subquery_op kw_in) (tok_query (tok_from (tok_tabref (tok_tabname src) s1)) (tok_insert (tok_destination (tok_dir tok_tmp_file)) (tok_select (tok_selexpr (tok_table_or_col key))) (tok_where (and (> (. (tok_table_or_col s1) key) '9') (> (. (tok_table_or_col s1) value) '9'))))) (. (tok_table_or_col src) key))", (Object)sq.toStringTree());
    }

    @Test
    public void testExtractConjuncts() throws Exception {
        ASTNode ast = this.parse(IN_QUERY);
        ASTNode where = this.where(ast);
        List sqs = SubQueryUtils.findSubQueries((ASTNode)((ASTNode)where.getChild(0)));
        ASTNode sq = (ASTNode)sqs.get(0);
        ASTNode sqWhere = this.where((ASTNode)sq.getChild(1));
        ArrayList conjuncts = new ArrayList();
        SubQueryUtils.extractConjuncts((ASTNode)((ASTNode)sqWhere.getChild(0)), conjuncts);
        Assert.assertEquals((long)2L, (long)conjuncts.size());
        Assert.assertEquals((Object)"(> (. (tok_table_or_col s1) key) '9')", (Object)((ASTNode)conjuncts.get(0)).toStringTree());
        Assert.assertEquals((Object)"(> (. (tok_table_or_col s1) value) '9')", (Object)((ASTNode)conjuncts.get(1)).toStringTree());
    }

    @Test
    public void testRewriteOuterQueryWhere() throws Exception {
        ASTNode ast = this.parse(IN_QUERY);
        ASTNode where = this.where(ast);
        List sqs = SubQueryUtils.findSubQueries((ASTNode)((ASTNode)where.getChild(0)));
        ASTNode sq = (ASTNode)sqs.get(0);
        ASTNode newWhere = SubQueryUtils.rewriteParentQueryWhere((ASTNode)((ASTNode)where.getChild(0)), (ASTNode)sq);
        Assert.assertEquals((Object)"(= 1 1)", (Object)newWhere.toStringTree());
    }

    @Test
    public void testRewriteOuterQueryWhere2() throws Exception {
        ASTNode ast = this.parse(IN_QUERY2);
        ASTNode where = this.where(ast);
        List sqs = SubQueryUtils.findSubQueries((ASTNode)((ASTNode)where.getChild(0)));
        ASTNode sq = (ASTNode)sqs.get(0);
        ASTNode newWhere = SubQueryUtils.rewriteParentQueryWhere((ASTNode)((ASTNode)where.getChild(0)), (ASTNode)sq);
        Assert.assertEquals((Object)"(> (tok_table_or_col value) '9')", (Object)newWhere.toStringTree());
    }

    @Test
    public void testCheckAggOrWindowing() throws Exception {
        ASTNode ast = this.parse(QUERY3);
        ASTNode select = this.select(ast);
        Assert.assertEquals((long)0L, (long)SubQueryUtils.checkAggOrWindowing((ASTNode)((ASTNode)select.getChild(0))));
        Assert.assertEquals((long)1L, (long)SubQueryUtils.checkAggOrWindowing((ASTNode)((ASTNode)select.getChild(1))));
        Assert.assertEquals((long)3L, (long)SubQueryUtils.checkAggOrWindowing((ASTNode)((ASTNode)select.getChild(2))));
    }

    private ASTNode where(ASTNode qry) {
        return (ASTNode)qry.getChild(1).getChild(2);
    }

    private ASTNode select(ASTNode qry) {
        return (ASTNode)qry.getChild(1).getChild(1);
    }

    static {
        IN_QUERY = " select * from src where src.key in (select key from src s1 where s1.key > '9' and s1.value > '9') ";
        IN_QUERY2 = " select * from src where src.key in (select key from src s1 where s1.key > '9' and s1.value > '9') and value > '9'";
        QUERY3 = "select p_mfgr, min(p_size), rank() over(partition by p_mfgr) as r from part group by p_mfgr";
    }
}

