/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.Arrays;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveConfForTest;
import org.apache.hadoop.hive.metastore.api.TxnType;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestParseUtils {
    private String query;
    private TxnType txnType;
    private Configuration conf;

    public TestParseUtils(String query, TxnType txnType) {
        this.query = query;
        this.txnType = txnType;
        this.conf = new HiveConfForTest(this.getClass());
    }

    @Before
    public void before() {
        SessionState.start((HiveConf)((HiveConf)this.conf));
    }

    @After
    public void after() throws Exception {
        SessionState.get().close();
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({"SELECT current_timestamp()", TxnType.READ_ONLY}, {"SELECT count(*) FROM a", TxnType.READ_ONLY}, {"SELECT count(*) FROM a JOIN b ON a.id = b.id", TxnType.READ_ONLY}, {"WITH a AS (SELECT current_timestamp())   SELECT * FROM a", TxnType.READ_ONLY}, {"INSERT INTO a VALUES (1, 2)", TxnType.DEFAULT}, {"INSERT INTO a SELECT * FROM b", TxnType.DEFAULT}, {"INSERT OVERWRITE TABLE a SELECT * FROM b", TxnType.DEFAULT}, {"FROM b INSERT OVERWRITE TABLE a SELECT *", TxnType.DEFAULT}, {"WITH a AS (SELECT current_timestamp())   INSERT INTO b SELECT * FROM a", TxnType.DEFAULT}, {"UPDATE a SET col_b = 1", TxnType.DEFAULT}, {"DELETE FROM a WHERE col_b = 1", TxnType.DEFAULT}, {"CREATE TABLE a (col_b int)", TxnType.DEFAULT}, {"CREATE TABLE a AS SELECT * FROM b", TxnType.DEFAULT}, {"DROP TABLE a", TxnType.DEFAULT}, {"LOAD DATA LOCAL INPATH './examples/files/kv.txt'   OVERWRITE INTO TABLE a", TxnType.DEFAULT}, {"REPL LOAD a INTO a", TxnType.DEFAULT}, {"REPL DUMP a", TxnType.DEFAULT}, {"REPL STATUS a", TxnType.DEFAULT}, {"MERGE INTO a trg using b src   ON src.col_a = trg.col_a WHEN MATCHED THEN   UPDATE SET col_b = src.col_b WHEN NOT MATCHED THEN   INSERT VALUES (src.col_a, src.col_b)", TxnType.DEFAULT}, {"CREATE MATERIALIZED VIEW matview AS SELECT * FROM b", TxnType.DEFAULT}, {"ALTER MATERIALIZED VIEW matview REBUILD", TxnType.MATER_VIEW_REBUILD}, {"ALTER MATERIALIZED VIEW matview DISABLE REWRITE", TxnType.DEFAULT}, {"DROP DATABASE dummy CASCADE", TxnType.SOFT_DELETE}, {"DROP TABLE a", TxnType.SOFT_DELETE}, {"DROP MATERIALIZED VIEW matview", TxnType.SOFT_DELETE}, {"ALTER TABLE TAB_ACID DROP PARTITION (P='FOO')", TxnType.SOFT_DELETE}, {"ALTER TABLE a RENAME TO b", TxnType.DEFAULT}, {"ALTER TABLE a PARTITION (p='foo') RENAME TO PARTITION (p='baz')", TxnType.SOFT_DELETE});
    }

    @Test
    public void testTxnTypeWithEnabledReadOnlyFeature() throws Exception {
        this.enableReadOnlyTxnFeature(true);
        Assert.assertEquals((Object)AcidUtils.getTxnType((Configuration)this.conf, (ASTNode)ParseUtils.parse((String)this.query, (Context)new Context(this.conf))), (Object)this.txnType);
    }

    @Test
    public void testTxnTypeWithDisabledReadOnlyFeature() throws Exception {
        this.enableReadOnlyTxnFeature(false);
        Assert.assertEquals((Object)AcidUtils.getTxnType((Configuration)this.conf, (ASTNode)ParseUtils.parse((String)this.query, (Context)new Context(this.conf))), (Object)(this.txnType == TxnType.READ_ONLY ? TxnType.DEFAULT : this.txnType));
    }

    @Test
    public void testTxnTypeWithLocklessReadsEnabled() throws Exception {
        this.enableLocklessReadsFeature(true);
        Assert.assertEquals((Object)AcidUtils.getTxnType((Configuration)this.conf, (ASTNode)ParseUtils.parse((String)this.query, (Context)new Context(this.conf))), (Object)this.txnType);
    }

    @Test
    public void testTxnTypeWithLocklessReadsDisabled() throws Exception {
        this.enableLocklessReadsFeature(false);
        Assert.assertEquals((Object)AcidUtils.getTxnType((Configuration)this.conf, (ASTNode)ParseUtils.parse((String)this.query, (Context)new Context(this.conf))), (Object)TxnType.DEFAULT);
    }

    private void enableReadOnlyTxnFeature(boolean featureFlag) {
        Assume.assumeTrue((this.txnType == TxnType.READ_ONLY || this.txnType == TxnType.DEFAULT ? 1 : 0) != 0);
        HiveConf.setBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_TXN_READONLY_ENABLED, (boolean)featureFlag);
    }

    private void enableLocklessReadsFeature(boolean featureFlag) {
        Assume.assumeTrue((this.txnType == TxnType.SOFT_DELETE ? 1 : 0) != 0);
        HiveConf.setBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ACID_LOCKLESS_READS_ENABLED, (boolean)featureFlag);
    }
}

