/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.topnkey;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import org.apache.hadoop.hive.ql.optimizer.topnkey.CommonKeyPrefix;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Test;

public class TestCommonKeyPrefix {
    @Test
    public void testmapWhenNoKeysExists() {
        CommonKeyPrefix commonPrefix = CommonKeyPrefix.map(new ArrayList(0), (String)"", (String)"", new ArrayList(0), new HashMap(0), (String)"", (String)"");
        MatcherAssert.assertThat((Object)commonPrefix.isEmpty(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)commonPrefix.size(), (Matcher)Is.is((Object)0));
        MatcherAssert.assertThat((Object)commonPrefix.getMappedOrder(), (Matcher)Is.is((Object)""));
        MatcherAssert.assertThat((Object)commonPrefix.getMappedNullOrder(), (Matcher)Is.is((Object)""));
        MatcherAssert.assertThat((Object)commonPrefix.getMappedColumns().isEmpty(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testmapWhenAllKeysMatch() {
        ExprNodeColumnDesc childCol0 = this.exprNodeColumnDesc("_col0");
        ExprNodeColumnDesc childCol1 = this.exprNodeColumnDesc("_col1");
        ExprNodeColumnDesc parentCol0 = this.exprNodeColumnDesc("KEY._col0");
        ExprNodeColumnDesc parentCol1 = this.exprNodeColumnDesc("KEY._col1");
        HashMap<String, ExprNodeColumnDesc> exprNodeDescMap = new HashMap<String, ExprNodeColumnDesc>();
        exprNodeDescMap.put("_col0", parentCol0);
        exprNodeDescMap.put("_col1", parentCol1);
        CommonKeyPrefix commonPrefix = CommonKeyPrefix.map(Arrays.asList(childCol0, childCol1), (String)"++", (String)"aa", Arrays.asList(parentCol0, parentCol1), exprNodeDescMap, (String)"++", (String)"aa");
        MatcherAssert.assertThat((Object)commonPrefix.isEmpty(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)commonPrefix.size(), (Matcher)Is.is((Object)2));
        MatcherAssert.assertThat((Object)commonPrefix.getMappedOrder(), (Matcher)Is.is((Object)"++"));
        MatcherAssert.assertThat((Object)commonPrefix.getMappedNullOrder(), (Matcher)Is.is((Object)"aa"));
        MatcherAssert.assertThat((Object)((ExprNodeDesc)commonPrefix.getMappedColumns().get(0)), (Matcher)Is.is((Object)parentCol0));
        MatcherAssert.assertThat((Object)((ExprNodeDesc)commonPrefix.getMappedColumns().get(1)), (Matcher)Is.is((Object)parentCol1));
    }

    private ExprNodeColumnDesc exprNodeColumnDesc(String colName) {
        ExprNodeColumnDesc exprNodeColumnDesc = new ExprNodeColumnDesc();
        exprNodeColumnDesc.setColumn(colName);
        exprNodeColumnDesc.setTypeInfo((TypeInfo)TypeInfoFactory.intTypeInfo);
        return exprNodeColumnDesc;
    }

    @Test
    public void testmapWhenOnlyFirstKeyMatchFromTwo() {
        ExprNodeColumnDesc childCol0 = this.exprNodeColumnDesc("_col0");
        ExprNodeColumnDesc differentChildCol = this.exprNodeColumnDesc("_col2");
        ExprNodeColumnDesc parentCol0 = this.exprNodeColumnDesc("KEY._col0");
        ExprNodeColumnDesc parentCol1 = this.exprNodeColumnDesc("KEY._col1");
        HashMap<String, ExprNodeColumnDesc> exprNodeDescMap = new HashMap<String, ExprNodeColumnDesc>();
        exprNodeDescMap.put("_col0", parentCol0);
        exprNodeDescMap.put("_col1", parentCol1);
        CommonKeyPrefix commonPrefix = CommonKeyPrefix.map(Arrays.asList(childCol0, differentChildCol), (String)"++", (String)"aa", Arrays.asList(parentCol0, parentCol1), exprNodeDescMap, (String)"++", (String)"aa");
        MatcherAssert.assertThat((Object)commonPrefix.isEmpty(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)commonPrefix.size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)commonPrefix.getMappedOrder(), (Matcher)Is.is((Object)"+"));
        MatcherAssert.assertThat((Object)((ExprNodeDesc)commonPrefix.getMappedColumns().get(0)), (Matcher)Is.is((Object)parentCol0));
    }

    @Test
    public void testmapWhenAllColumnsMatchButOrderMismatch() {
        ExprNodeColumnDesc childCol0 = this.exprNodeColumnDesc("_col0");
        ExprNodeColumnDesc childCol1 = this.exprNodeColumnDesc("_col1");
        ExprNodeColumnDesc parentCol0 = this.exprNodeColumnDesc("KEY._col0");
        ExprNodeColumnDesc parentCol1 = this.exprNodeColumnDesc("KEY._col1");
        HashMap<String, ExprNodeColumnDesc> exprNodeDescMap = new HashMap<String, ExprNodeColumnDesc>();
        exprNodeDescMap.put("_col0", parentCol0);
        exprNodeDescMap.put("_col1", parentCol1);
        CommonKeyPrefix commonPrefix = CommonKeyPrefix.map(Arrays.asList(childCol0, childCol1), (String)"+-", (String)"aa", Arrays.asList(parentCol0, parentCol1), exprNodeDescMap, (String)"++", (String)"aa");
        MatcherAssert.assertThat((Object)commonPrefix.isEmpty(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)commonPrefix.size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)commonPrefix.getMappedOrder(), (Matcher)Is.is((Object)"+"));
        MatcherAssert.assertThat((Object)commonPrefix.getMappedNullOrder(), (Matcher)Is.is((Object)"a"));
        MatcherAssert.assertThat((Object)((ExprNodeDesc)commonPrefix.getMappedColumns().get(0)), (Matcher)Is.is((Object)parentCol0));
        commonPrefix = CommonKeyPrefix.map(Arrays.asList(childCol0, childCol1), (String)"-+", (String)"aa", Arrays.asList(parentCol0, parentCol1), exprNodeDescMap, (String)"++", (String)"aa");
        MatcherAssert.assertThat((Object)commonPrefix.isEmpty(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testmapWhenAllColumnsMatchButNullOrderMismatch() {
        ExprNodeColumnDesc childCol0 = this.exprNodeColumnDesc("_col0");
        ExprNodeColumnDesc childCol1 = this.exprNodeColumnDesc("_col1");
        ExprNodeColumnDesc parentCol0 = this.exprNodeColumnDesc("KEY._col0");
        ExprNodeColumnDesc parentCol1 = this.exprNodeColumnDesc("KEY._col1");
        HashMap<String, ExprNodeColumnDesc> exprNodeDescMap = new HashMap<String, ExprNodeColumnDesc>();
        exprNodeDescMap.put("_col0", parentCol0);
        exprNodeDescMap.put("_col1", parentCol1);
        CommonKeyPrefix commonPrefix = CommonKeyPrefix.map(Arrays.asList(childCol0, childCol1), (String)"++", (String)"az", Arrays.asList(parentCol0, parentCol1), exprNodeDescMap, (String)"++", (String)"aa");
        MatcherAssert.assertThat((Object)commonPrefix.isEmpty(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)commonPrefix.size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)commonPrefix.getMappedOrder(), (Matcher)Is.is((Object)"+"));
        MatcherAssert.assertThat((Object)commonPrefix.getMappedNullOrder(), (Matcher)Is.is((Object)"a"));
        MatcherAssert.assertThat((Object)((ExprNodeDesc)commonPrefix.getMappedColumns().get(0)), (Matcher)Is.is((Object)parentCol0));
        commonPrefix = CommonKeyPrefix.map(Arrays.asList(childCol0, childCol1), (String)"++", (String)"za", Arrays.asList(parentCol0, parentCol1), exprNodeDescMap, (String)"++", (String)"aa");
        MatcherAssert.assertThat((Object)commonPrefix.isEmpty(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void testmapWhenKeyCountsMismatch() {
        ExprNodeColumnDesc childCol0 = this.exprNodeColumnDesc("_col0");
        ExprNodeColumnDesc childCol1 = this.exprNodeColumnDesc("_col1");
        ExprNodeColumnDesc parentCol0 = this.exprNodeColumnDesc("KEY._col0");
        HashMap<String, ExprNodeColumnDesc> exprNodeDescMap = new HashMap<String, ExprNodeColumnDesc>();
        exprNodeDescMap.put("_col0", parentCol0);
        CommonKeyPrefix commonPrefix = CommonKeyPrefix.map(Arrays.asList(childCol0, childCol1), (String)"++", (String)"aa", Collections.singletonList(parentCol0), exprNodeDescMap, (String)"++", (String)"aa");
        MatcherAssert.assertThat((Object)commonPrefix.isEmpty(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)commonPrefix.size(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat((Object)commonPrefix.getMappedOrder(), (Matcher)Is.is((Object)"+"));
        MatcherAssert.assertThat((Object)((ExprNodeDesc)commonPrefix.getMappedColumns().get(0)), (Matcher)Is.is((Object)parentCol0));
    }
}

