/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.stats.annotation;

import java.util.Arrays;
import java.util.Collections;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.hadoop.hive.common.ndv.fm.FMSketch;
import org.apache.hadoop.hive.common.ndv.hll.HyperLogLog;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.metastore.StatisticsTestUtils;
import org.apache.hadoop.hive.ql.optimizer.stats.annotation.AnnotateStatsProcCtx;
import org.apache.hadoop.hive.ql.optimizer.stats.annotation.StatsRulesProcFactory;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ColStatistics;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.Statistics;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBetween;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.junit.Assert;
import org.junit.Test;

public class TestStatsRulesProcFactory {
    private static final String COL_NAME = "col1";
    private static final ExprNodeDesc COL_EXPR = new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.intTypeInfo, "col1", "table", false);
    private static final AnnotateStatsProcCtx STATS_PROC_CTX = new AnnotateStatsProcCtx(null);
    private static final long[] VALUES = new long[]{1L, 2L, 2L, 2L, 2L, 2L, 2L, 2L, 3L, 4L, 5L, 6L, 7L};

    @Test
    public void testComparisonRowCountZeroNonNullValues() throws SemanticException {
        long numNulls = 2L;
        long[] values = new long[]{};
        Statistics stats = this.createStatistics(values, numNulls);
        ExprNodeGenericFuncDesc exprNodeDesc = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (GenericUDF)new GenericUDFOPLessThan(), Arrays.asList(COL_EXPR, this.createExprNodeConstantDesc(3)));
        long numRows = new StatsRulesProcFactory.FilterStatsRule().evaluateExpression(stats, (ExprNodeDesc)exprNodeDesc, STATS_PROC_CTX, Collections.emptyList(), null, (long)VALUES.length + numNulls);
        Assert.assertEquals((long)0L, (long)numRows);
    }

    @Test
    public void testComparisonRowCountInvalidKll() throws SemanticException {
        long numNulls = 2L;
        Statistics stats = this.createStatistics(VALUES, numNulls);
        ((ColStatistics)stats.getColumnStats().get(0)).setHistogram(null);
        ExprNodeGenericFuncDesc exprNodeDesc = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (GenericUDF)new GenericUDFOPLessThan(), Arrays.asList(COL_EXPR, this.createExprNodeConstantDesc(3)));
        long numRows = new StatsRulesProcFactory.FilterStatsRule().evaluateExpression(stats, (ExprNodeDesc)exprNodeDesc, STATS_PROC_CTX, Collections.emptyList(), null, (long)VALUES.length + numNulls);
        Assert.assertEquals((long)(((long)VALUES.length + numNulls) / 3L), (long)numRows);
        ((ColStatistics)stats.getColumnStats().get(0)).setHistogram(new byte[0]);
        numRows = new StatsRulesProcFactory.FilterStatsRule().evaluateExpression(stats, (ExprNodeDesc)exprNodeDesc, STATS_PROC_CTX, Collections.emptyList(), null, (long)VALUES.length + numNulls);
        Assert.assertEquals((long)(((long)VALUES.length + numNulls) / 3L), (long)numRows);
    }

    @Test
    public void testComparisonRowCountLessThan() throws SemanticException {
        long numNulls = 2L;
        Statistics stats = this.createStatistics(VALUES, numNulls);
        ExprNodeGenericFuncDesc exprNodeDesc = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (GenericUDF)new GenericUDFOPLessThan(), Arrays.asList(COL_EXPR, this.createExprNodeConstantDesc(3)));
        long numRows = new StatsRulesProcFactory.FilterStatsRule().evaluateExpression(stats, (ExprNodeDesc)exprNodeDesc, STATS_PROC_CTX, Collections.emptyList(), null, (long)VALUES.length + numNulls);
        Assert.assertEquals((long)8L, (long)numRows);
    }

    @Test
    public void testComparisonRowCountLessThanMin() throws SemanticException {
        long numNulls = 2L;
        Statistics stats = this.createStatistics(VALUES, numNulls);
        ExprNodeGenericFuncDesc exprNodeDesc = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (GenericUDF)new GenericUDFOPLessThan(), Arrays.asList(COL_EXPR, this.createExprNodeConstantDesc(1)));
        long numRows = new StatsRulesProcFactory.FilterStatsRule().evaluateExpression(stats, (ExprNodeDesc)exprNodeDesc, STATS_PROC_CTX, Collections.emptyList(), null, (long)VALUES.length + numNulls);
        Assert.assertEquals((long)0L, (long)numRows);
    }

    @Test
    public void testComparisonRowCountLessThanBelowMin() throws SemanticException {
        long numNulls = 2L;
        Statistics stats = this.createStatistics(VALUES, numNulls);
        ExprNodeGenericFuncDesc exprNodeDesc = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (GenericUDF)new GenericUDFOPLessThan(), Arrays.asList(COL_EXPR, this.createExprNodeConstantDesc(0)));
        long numRows = new StatsRulesProcFactory.FilterStatsRule().evaluateExpression(stats, (ExprNodeDesc)exprNodeDesc, STATS_PROC_CTX, Collections.emptyList(), null, (long)VALUES.length + numNulls);
        Assert.assertEquals((long)0L, (long)numRows);
    }

    @Test
    public void testComparisonRowCountLessThanMax() throws SemanticException {
        long numNulls = 2L;
        Statistics stats = this.createStatistics(VALUES, numNulls);
        ExprNodeGenericFuncDesc exprNodeDesc = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (GenericUDF)new GenericUDFOPLessThan(), Arrays.asList(COL_EXPR, this.createExprNodeConstantDesc(7)));
        long numRows = new StatsRulesProcFactory.FilterStatsRule().evaluateExpression(stats, (ExprNodeDesc)exprNodeDesc, STATS_PROC_CTX, Collections.emptyList(), null, (long)VALUES.length + numNulls);
        Assert.assertEquals((long)12L, (long)numRows);
    }

    @Test
    public void testComparisonRowCountLessThanAboveMax() throws SemanticException {
        long numNulls = 2L;
        Statistics stats = this.createStatistics(VALUES, numNulls);
        ExprNodeGenericFuncDesc exprNodeDesc = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (GenericUDF)new GenericUDFOPLessThan(), Arrays.asList(COL_EXPR, this.createExprNodeConstantDesc(8)));
        long numRows = new StatsRulesProcFactory.FilterStatsRule().evaluateExpression(stats, (ExprNodeDesc)exprNodeDesc, STATS_PROC_CTX, Collections.emptyList(), null, (long)VALUES.length + numNulls);
        Assert.assertEquals((long)13L, (long)numRows);
    }

    @Test
    public void testComparisonRowCountEqualOrLessThan() throws SemanticException {
        long numNulls = 2L;
        Statistics stats = this.createStatistics(VALUES, numNulls);
        ExprNodeGenericFuncDesc exprNodeDesc = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (GenericUDF)new GenericUDFOPEqualOrLessThan(), Arrays.asList(COL_EXPR, this.createExprNodeConstantDesc(3)));
        long numRows = new StatsRulesProcFactory.FilterStatsRule().evaluateExpression(stats, (ExprNodeDesc)exprNodeDesc, STATS_PROC_CTX, Collections.emptyList(), null, (long)VALUES.length + numNulls);
        Assert.assertEquals((long)9L, (long)numRows);
    }

    @Test
    public void testComparisonRowCountEqualOrLessThanMin() throws SemanticException {
        long numNulls = 2L;
        Statistics stats = this.createStatistics(VALUES, numNulls);
        ExprNodeGenericFuncDesc exprNodeDesc = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (GenericUDF)new GenericUDFOPEqualOrLessThan(), Arrays.asList(COL_EXPR, this.createExprNodeConstantDesc(1)));
        long numRows = new StatsRulesProcFactory.FilterStatsRule().evaluateExpression(stats, (ExprNodeDesc)exprNodeDesc, STATS_PROC_CTX, Collections.emptyList(), null, (long)VALUES.length + numNulls);
        Assert.assertEquals((long)1L, (long)numRows);
    }

    @Test
    public void testComparisonRowCountEqualOrLessThanBelowMin() throws SemanticException {
        long numNulls = 2L;
        Statistics stats = this.createStatistics(VALUES, numNulls);
        ExprNodeGenericFuncDesc exprNodeDesc = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (GenericUDF)new GenericUDFOPEqualOrLessThan(), Arrays.asList(COL_EXPR, this.createExprNodeConstantDesc(0)));
        long numRows = new StatsRulesProcFactory.FilterStatsRule().evaluateExpression(stats, (ExprNodeDesc)exprNodeDesc, STATS_PROC_CTX, Collections.emptyList(), null, (long)VALUES.length + numNulls);
        Assert.assertEquals((long)0L, (long)numRows);
    }

    @Test
    public void testComparisonRowCountEqualOrLessThanMax() throws SemanticException {
        long numNulls = 2L;
        Statistics stats = this.createStatistics(VALUES, numNulls);
        ExprNodeGenericFuncDesc exprNodeDesc = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (GenericUDF)new GenericUDFOPEqualOrLessThan(), Arrays.asList(COL_EXPR, this.createExprNodeConstantDesc(7)));
        long numRows = new StatsRulesProcFactory.FilterStatsRule().evaluateExpression(stats, (ExprNodeDesc)exprNodeDesc, STATS_PROC_CTX, Collections.emptyList(), null, (long)VALUES.length + numNulls);
        Assert.assertEquals((long)13L, (long)numRows);
    }

    @Test
    public void testComparisonRowCountEqualOrLessThanAboveMax() throws SemanticException {
        long numNulls = 2L;
        Statistics stats = this.createStatistics(VALUES, numNulls);
        ExprNodeGenericFuncDesc exprNodeDesc = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (GenericUDF)new GenericUDFOPEqualOrLessThan(), Arrays.asList(COL_EXPR, this.createExprNodeConstantDesc(8)));
        long numRows = new StatsRulesProcFactory.FilterStatsRule().evaluateExpression(stats, (ExprNodeDesc)exprNodeDesc, STATS_PROC_CTX, Collections.emptyList(), null, (long)VALUES.length + numNulls);
        Assert.assertEquals((long)13L, (long)numRows);
    }

    @Test
    public void testComparisonRowCountGreaterThan() throws SemanticException {
        long numNulls = 2L;
        Statistics stats = this.createStatistics(VALUES, numNulls);
        ExprNodeGenericFuncDesc exprNodeDesc = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (GenericUDF)new GenericUDFOPGreaterThan(), Arrays.asList(COL_EXPR, this.createExprNodeConstantDesc(5)));
        long numRows = new StatsRulesProcFactory.FilterStatsRule().evaluateExpression(stats, (ExprNodeDesc)exprNodeDesc, STATS_PROC_CTX, Collections.emptyList(), null, (long)VALUES.length + numNulls);
        Assert.assertEquals((long)2L, (long)numRows);
    }

    @Test
    public void testComparisonRowCountGreaterThanMin() throws SemanticException {
        long numNulls = 2L;
        Statistics stats = this.createStatistics(VALUES, numNulls);
        ExprNodeGenericFuncDesc exprNodeDesc = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (GenericUDF)new GenericUDFOPGreaterThan(), Arrays.asList(COL_EXPR, this.createExprNodeConstantDesc(1)));
        long numRows = new StatsRulesProcFactory.FilterStatsRule().evaluateExpression(stats, (ExprNodeDesc)exprNodeDesc, STATS_PROC_CTX, Collections.emptyList(), null, (long)VALUES.length + numNulls);
        Assert.assertEquals((long)12L, (long)numRows);
    }

    @Test
    public void testComparisonRowCountGreaterThanBelowMin() throws SemanticException {
        long numNulls = 2L;
        Statistics stats = this.createStatistics(VALUES, numNulls);
        ExprNodeGenericFuncDesc exprNodeDesc = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (GenericUDF)new GenericUDFOPGreaterThan(), Arrays.asList(COL_EXPR, this.createExprNodeConstantDesc(0)));
        long numRows = new StatsRulesProcFactory.FilterStatsRule().evaluateExpression(stats, (ExprNodeDesc)exprNodeDesc, STATS_PROC_CTX, Collections.emptyList(), null, (long)VALUES.length + numNulls);
        Assert.assertEquals((long)13L, (long)numRows);
    }

    @Test
    public void testComparisonRowCountGreaterThanMax() throws SemanticException {
        long numNulls = 2L;
        Statistics stats = this.createStatistics(VALUES, numNulls);
        ExprNodeGenericFuncDesc exprNodeDesc = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (GenericUDF)new GenericUDFOPGreaterThan(), Arrays.asList(COL_EXPR, this.createExprNodeConstantDesc(7)));
        long numRows = new StatsRulesProcFactory.FilterStatsRule().evaluateExpression(stats, (ExprNodeDesc)exprNodeDesc, STATS_PROC_CTX, Collections.emptyList(), null, (long)VALUES.length + numNulls);
        Assert.assertEquals((long)0L, (long)numRows);
    }

    @Test
    public void testComparisonRowCountGreaterThanAboveMax() throws SemanticException {
        long numNulls = 2L;
        Statistics stats = this.createStatistics(VALUES, numNulls);
        ExprNodeGenericFuncDesc exprNodeDesc = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (GenericUDF)new GenericUDFOPGreaterThan(), Arrays.asList(COL_EXPR, this.createExprNodeConstantDesc(8)));
        long numRows = new StatsRulesProcFactory.FilterStatsRule().evaluateExpression(stats, (ExprNodeDesc)exprNodeDesc, STATS_PROC_CTX, Collections.emptyList(), null, (long)VALUES.length + numNulls);
        Assert.assertEquals((long)0L, (long)numRows);
    }

    @Test
    public void testComparisonRowCountEqualOrGreaterThan() throws SemanticException {
        long numNulls = 2L;
        Statistics stats = this.createStatistics(VALUES, numNulls);
        ExprNodeGenericFuncDesc exprNodeDesc = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (GenericUDF)new GenericUDFOPEqualOrGreaterThan(), Arrays.asList(COL_EXPR, this.createExprNodeConstantDesc(5)));
        long numRows = new StatsRulesProcFactory.FilterStatsRule().evaluateExpression(stats, (ExprNodeDesc)exprNodeDesc, STATS_PROC_CTX, Collections.emptyList(), null, (long)VALUES.length + numNulls);
        Assert.assertEquals((long)3L, (long)numRows);
    }

    @Test
    public void testComparisonRowCountEqualOrGreaterThanMin() throws SemanticException {
        long numNulls = 2L;
        Statistics stats = this.createStatistics(VALUES, numNulls);
        ExprNodeGenericFuncDesc exprNodeDesc = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (GenericUDF)new GenericUDFOPEqualOrGreaterThan(), Arrays.asList(COL_EXPR, this.createExprNodeConstantDesc(1)));
        long numRows = new StatsRulesProcFactory.FilterStatsRule().evaluateExpression(stats, (ExprNodeDesc)exprNodeDesc, STATS_PROC_CTX, Collections.emptyList(), null, (long)VALUES.length + numNulls);
        Assert.assertEquals((long)13L, (long)numRows);
    }

    @Test
    public void testComparisonRowCountEqualOrGreaterThanBelowMin() throws SemanticException {
        long numNulls = 2L;
        Statistics stats = this.createStatistics(VALUES, numNulls);
        ExprNodeGenericFuncDesc exprNodeDesc = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (GenericUDF)new GenericUDFOPEqualOrGreaterThan(), Arrays.asList(COL_EXPR, this.createExprNodeConstantDesc(0)));
        long numRows = new StatsRulesProcFactory.FilterStatsRule().evaluateExpression(stats, (ExprNodeDesc)exprNodeDesc, STATS_PROC_CTX, Collections.emptyList(), null, (long)VALUES.length + numNulls);
        Assert.assertEquals((long)13L, (long)numRows);
    }

    @Test
    public void testComparisonRowCountEqualOrGreaterThanMax() throws SemanticException {
        long numNulls = 2L;
        Statistics stats = this.createStatistics(VALUES, numNulls);
        ExprNodeGenericFuncDesc exprNodeDesc = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (GenericUDF)new GenericUDFOPEqualOrGreaterThan(), Arrays.asList(COL_EXPR, this.createExprNodeConstantDesc(7)));
        long numRows = new StatsRulesProcFactory.FilterStatsRule().evaluateExpression(stats, (ExprNodeDesc)exprNodeDesc, STATS_PROC_CTX, Collections.emptyList(), null, (long)VALUES.length + numNulls);
        Assert.assertEquals((long)1L, (long)numRows);
    }

    @Test
    public void testComparisonRowCountEqualOrGreaterThanBeyondMax() throws SemanticException {
        long numNulls = 2L;
        Statistics stats = this.createStatistics(VALUES, numNulls);
        ExprNodeGenericFuncDesc exprNodeDesc = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (GenericUDF)new GenericUDFOPEqualOrGreaterThan(), Arrays.asList(COL_EXPR, this.createExprNodeConstantDesc(8)));
        long numRows = new StatsRulesProcFactory.FilterStatsRule().evaluateExpression(stats, (ExprNodeDesc)exprNodeDesc, STATS_PROC_CTX, Collections.emptyList(), null, (long)VALUES.length + numNulls);
        Assert.assertEquals((long)0L, (long)numRows);
    }

    @Test
    public void testComparisonRowCountEqualOrLessThanWhenMinEqualMax() throws SemanticException {
        long[] values = new long[]{1L, 1L};
        long numNulls = 2L;
        Statistics stats = this.createStatistics(values, numNulls);
        ExprNodeGenericFuncDesc exprNodeDesc = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (GenericUDF)new GenericUDFOPEqualOrLessThan(), Arrays.asList(COL_EXPR, this.createExprNodeConstantDesc(1)));
        long numRows = new StatsRulesProcFactory.FilterStatsRule().evaluateExpression(stats, (ExprNodeDesc)exprNodeDesc, STATS_PROC_CTX, Collections.emptyList(), null, (long)values.length + numNulls);
        Assert.assertEquals((long)2L, (long)numRows);
    }

    @Test
    public void testComparisonRowCountEqualOrGreaterThanWhenMinEqualMax() throws SemanticException {
        long[] values = new long[]{1L, 1L};
        long numNulls = 2L;
        Statistics stats = this.createStatistics(values, numNulls);
        ExprNodeGenericFuncDesc exprNodeDesc = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (GenericUDF)new GenericUDFOPEqualOrGreaterThan(), Arrays.asList(COL_EXPR, this.createExprNodeConstantDesc(1)));
        long numRows = new StatsRulesProcFactory.FilterStatsRule().evaluateExpression(stats, (ExprNodeDesc)exprNodeDesc, STATS_PROC_CTX, Collections.emptyList(), null, (long)values.length + numNulls);
        Assert.assertEquals((long)2L, (long)numRows);
    }

    @Test
    public void testBetween() throws SemanticException {
        long numNulls = 2L;
        Statistics stats = this.createStatistics(VALUES, numNulls);
        ExprNodeGenericFuncDesc exprNodeDesc = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (GenericUDF)new GenericUDFBetween(), Arrays.asList(new ExprNodeConstantDesc((Object)Boolean.FALSE), COL_EXPR, this.createExprNodeConstantDesc(3), this.createExprNodeConstantDesc(4)));
        long numRows = new StatsRulesProcFactory.FilterStatsRule().evaluateExpression(stats, (ExprNodeDesc)exprNodeDesc, STATS_PROC_CTX, Collections.emptyList(), null, (long)VALUES.length + numNulls);
        Assert.assertEquals((long)2L, (long)numRows);
    }

    @Test
    public void testLiteralExtraction() {
        double DELTA = 1.0E-5;
        Assert.assertEquals((double)100.0, (double)StatsRulesProcFactory.FilterStatsRule.extractFloatFromLiteralValue((String)"int", (String)"100"), (double)1.0E-5);
        Assert.assertEquals((double)1.0, (double)StatsRulesProcFactory.FilterStatsRule.extractFloatFromLiteralValue((String)"smallint", (String)"1"), (double)1.0E-5);
        Assert.assertEquals((double)1.0, (double)StatsRulesProcFactory.FilterStatsRule.extractFloatFromLiteralValue((String)"tinyint", (String)"1"), (double)1.0E-5);
        Assert.assertEquals((double)1.0E13f, (double)StatsRulesProcFactory.FilterStatsRule.extractFloatFromLiteralValue((String)"bigint", (String)"10000000000000"), (double)1.0E-5);
        Assert.assertEquals((double)15.2f, (double)StatsRulesProcFactory.FilterStatsRule.extractFloatFromLiteralValue((String)"decimal(5, 2)", (String)"15.2"), (double)1.0E-5);
        Assert.assertEquals((double)15.0002f, (double)StatsRulesProcFactory.FilterStatsRule.extractFloatFromLiteralValue((String)"float", (String)"15.0002"), (double)1.0E-5);
        Assert.assertEquals((double)1512.22216796875, (double)StatsRulesProcFactory.FilterStatsRule.extractFloatFromLiteralValue((String)"double", (String)"1512.2222222d"), (double)1.0E-5);
        Assert.assertEquals((double)Date.valueOf((String)"2022-01-05").toEpochSecond(), (double)StatsRulesProcFactory.FilterStatsRule.extractFloatFromLiteralValue((String)"date", (String)"2022-01-05"), (double)1.0E-5);
        Assert.assertEquals((double)Date.valueOf((String)"2022-1-5").toEpochSecond(), (double)StatsRulesProcFactory.FilterStatsRule.extractFloatFromLiteralValue((String)"date", (String)"2022-1-5"), (double)1.0E-5);
        Assert.assertEquals((double)Timestamp.valueOf((String)"2022-01-05 00:00:00").toEpochSecond(), (double)StatsRulesProcFactory.FilterStatsRule.extractFloatFromLiteralValue((String)"timestamp", (String)"2022-01-05 00:00:00"), (double)1.0E-5);
        Assert.assertEquals((double)Timestamp.valueOf((String)"2022-01-05 01:20:02").toEpochSecond(), (double)StatsRulesProcFactory.FilterStatsRule.extractFloatFromLiteralValue((String)"timestamp", (String)"2022-01-05 01:20:02"), (double)1.0E-5);
        Assert.assertEquals((double)Timestamp.valueOf((String)"2022-01-05 01:20:02").toEpochSecond(), (double)StatsRulesProcFactory.FilterStatsRule.extractFloatFromLiteralValue((String)"timestamp", (String)"2022-1-5 01:20:02"), (double)1.0E-5);
    }

    @Test
    public void testLiteralExtractionFailures() {
        String[] types;
        for (String type : types = new String[]{"int", "tinyint", "smallint", "bigint", "date", "timestamp", "float", "double"}) {
            Assert.assertThrows(IllegalArgumentException.class, () -> StatsRulesProcFactory.FilterStatsRule.extractFloatFromLiteralValue((String)type, (String)"abc"));
            Assert.assertThrows(RuntimeException.class, () -> StatsRulesProcFactory.FilterStatsRule.extractFloatFromLiteralValue((String)type, null));
        }
        Assert.assertThrows(IllegalStateException.class, () -> StatsRulesProcFactory.FilterStatsRule.extractFloatFromLiteralValue((String)"typex", (String)"abc"));
    }

    @Test
    public void testBetweenLeftLowerThanMin() throws SemanticException {
        long numNulls = 2L;
        Statistics stats = this.createStatistics(VALUES, numNulls);
        ExprNodeGenericFuncDesc exprNodeDescLeq = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (GenericUDF)new GenericUDFOPEqualOrLessThan(), Arrays.asList(COL_EXPR, this.createExprNodeConstantDesc(4)));
        long numRowsLeq = new StatsRulesProcFactory.FilterStatsRule().evaluateExpression(stats, (ExprNodeDesc)exprNodeDescLeq, STATS_PROC_CTX, Collections.emptyList(), null, (long)VALUES.length + numNulls);
        ExprNodeGenericFuncDesc exprNodeDescBetween = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (GenericUDF)new GenericUDFBetween(), Arrays.asList(new ExprNodeConstantDesc((Object)Boolean.FALSE), COL_EXPR, this.createExprNodeConstantDesc(0), this.createExprNodeConstantDesc(4)));
        long numRowsBetween = new StatsRulesProcFactory.FilterStatsRule().evaluateExpression(stats, (ExprNodeDesc)exprNodeDescBetween, STATS_PROC_CTX, Collections.emptyList(), null, (long)VALUES.length + numNulls);
        Assert.assertEquals((long)numRowsLeq, (long)numRowsBetween);
        Assert.assertEquals((long)10L, (long)numRowsBetween);
    }

    @Test
    public void testBetweenLeftLowerThanMinRightHigherThanMax() throws SemanticException {
        long numNulls = 2L;
        Statistics stats = this.createStatistics(VALUES, numNulls);
        ExprNodeGenericFuncDesc exprNodeDesc = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (GenericUDF)new GenericUDFBetween(), Arrays.asList(new ExprNodeConstantDesc((Object)Boolean.FALSE), COL_EXPR, this.createExprNodeConstantDesc(0), this.createExprNodeConstantDesc(10)));
        long numRowsBetween = new StatsRulesProcFactory.FilterStatsRule().evaluateExpression(stats, (ExprNodeDesc)exprNodeDesc, STATS_PROC_CTX, Collections.emptyList(), null, (long)VALUES.length + numNulls);
        Assert.assertEquals((long)VALUES.length, (long)numRowsBetween);
    }

    @Test
    public void testBetweenRightHigherThanMax() throws SemanticException {
        long numNulls = 2L;
        Statistics stats = this.createStatistics(VALUES, numNulls);
        ExprNodeGenericFuncDesc exprNodeDescGeq = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (GenericUDF)new GenericUDFOPEqualOrGreaterThan(), Arrays.asList(COL_EXPR, this.createExprNodeConstantDesc(2)));
        long numRowsGeq = new StatsRulesProcFactory.FilterStatsRule().evaluateExpression(stats, (ExprNodeDesc)exprNodeDescGeq, STATS_PROC_CTX, Collections.emptyList(), null, (long)VALUES.length + numNulls);
        ExprNodeGenericFuncDesc exprNodeDescBetween = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (GenericUDF)new GenericUDFBetween(), Arrays.asList(new ExprNodeConstantDesc((Object)Boolean.FALSE), COL_EXPR, this.createExprNodeConstantDesc(2), this.createExprNodeConstantDesc(10)));
        long numRowsBetween = new StatsRulesProcFactory.FilterStatsRule().evaluateExpression(stats, (ExprNodeDesc)exprNodeDescBetween, STATS_PROC_CTX, Collections.emptyList(), null, (long)VALUES.length + numNulls);
        Assert.assertEquals((long)numRowsGeq, (long)numRowsBetween);
        Assert.assertEquals((long)12L, (long)numRowsBetween);
    }

    @Test
    public void testBetweenRightLowerThanMin() throws SemanticException {
        long numNulls = 2L;
        Statistics stats = this.createStatistics(VALUES, numNulls);
        ExprNodeGenericFuncDesc exprNodeDescBetween = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (GenericUDF)new GenericUDFBetween(), Arrays.asList(new ExprNodeConstantDesc((Object)Boolean.FALSE), COL_EXPR, this.createExprNodeConstantDesc(-1), this.createExprNodeConstantDesc(0)));
        long numRowsBetween = new StatsRulesProcFactory.FilterStatsRule().evaluateExpression(stats, (ExprNodeDesc)exprNodeDescBetween, STATS_PROC_CTX, Collections.emptyList(), null, (long)VALUES.length + numNulls);
        Assert.assertEquals((long)0L, (long)numRowsBetween);
    }

    @Test
    public void testBetweenLeftHigherThanMax() throws SemanticException {
        long numNulls = 2L;
        Statistics stats = this.createStatistics(VALUES, numNulls);
        ExprNodeGenericFuncDesc exprNodeDescBetween = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (GenericUDF)new GenericUDFBetween(), Arrays.asList(new ExprNodeConstantDesc((Object)Boolean.FALSE), COL_EXPR, this.createExprNodeConstantDesc(10), this.createExprNodeConstantDesc(12)));
        long numRowsBetween = new StatsRulesProcFactory.FilterStatsRule().evaluateExpression(stats, (ExprNodeDesc)exprNodeDescBetween, STATS_PROC_CTX, Collections.emptyList(), null, (long)VALUES.length + numNulls);
        Assert.assertEquals((long)0L, (long)numRowsBetween);
    }

    @Test
    public void testBetweenLeftEqualMax() throws SemanticException {
        long numNulls = 2L;
        Statistics stats = this.createStatistics(VALUES, numNulls);
        ExprNodeGenericFuncDesc exprNodeDescBetween = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (GenericUDF)new GenericUDFBetween(), Arrays.asList(new ExprNodeConstantDesc((Object)Boolean.FALSE), COL_EXPR, this.createExprNodeConstantDesc(3), this.createExprNodeConstantDesc(3)));
        long numRowsBetween = new StatsRulesProcFactory.FilterStatsRule().evaluateExpression(stats, (ExprNodeDesc)exprNodeDescBetween, STATS_PROC_CTX, Collections.emptyList(), null, (long)VALUES.length + numNulls);
        Assert.assertEquals((long)7L, (long)numRowsBetween);
    }

    @Test
    public void testNotBetween() throws SemanticException {
        long numNulls = 2L;
        Statistics stats = this.createStatistics(VALUES, numNulls);
        ExprNodeGenericFuncDesc exprNodeDesc = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (GenericUDF)new GenericUDFBetween(), Arrays.asList(new ExprNodeConstantDesc((Object)Boolean.TRUE), COL_EXPR, this.createExprNodeConstantDesc(3), this.createExprNodeConstantDesc(4)));
        long numRows = new StatsRulesProcFactory.FilterStatsRule().evaluateExpression(stats, (ExprNodeDesc)exprNodeDesc, STATS_PROC_CTX, Collections.emptyList(), null, (long)VALUES.length + numNulls);
        ExprNodeGenericFuncDesc exprNodeDescLth = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (GenericUDF)new GenericUDFOPLessThan(), Arrays.asList(COL_EXPR, this.createExprNodeConstantDesc(3)));
        long numRowsLth = new StatsRulesProcFactory.FilterStatsRule().evaluateExpression(stats, (ExprNodeDesc)exprNodeDescLth, STATS_PROC_CTX, Collections.emptyList(), null, (long)VALUES.length + numNulls);
        ExprNodeGenericFuncDesc exprNodeDescGth = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (GenericUDF)new GenericUDFOPGreaterThan(), Arrays.asList(COL_EXPR, this.createExprNodeConstantDesc(4)));
        long numRowsGth = new StatsRulesProcFactory.FilterStatsRule().evaluateExpression(stats, (ExprNodeDesc)exprNodeDescGth, STATS_PROC_CTX, Collections.emptyList(), null, (long)VALUES.length + numNulls);
        Assert.assertEquals((long)11L, (long)numRows);
        Assert.assertEquals((long)numRows, (long)(numRowsLth + numRowsGth));
    }

    @Test
    public void testNotBetweenLowerThanMinHigherThanMax() throws SemanticException {
        long numNulls = 2L;
        Statistics stats = this.createStatistics(VALUES, numNulls);
        ExprNodeGenericFuncDesc exprNodeDesc = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (GenericUDF)new GenericUDFBetween(), Arrays.asList(new ExprNodeConstantDesc((Object)Boolean.TRUE), COL_EXPR, this.createExprNodeConstantDesc(0), this.createExprNodeConstantDesc(10)));
        long numRows = new StatsRulesProcFactory.FilterStatsRule().evaluateExpression(stats, (ExprNodeDesc)exprNodeDesc, STATS_PROC_CTX, Collections.emptyList(), null, (long)VALUES.length + numNulls);
        Assert.assertEquals((long)0L, (long)numRows);
    }

    @Test
    public void testNotBetweenLeftEqualsRight() throws SemanticException {
        long numNulls = 2L;
        Statistics stats = this.createStatistics(VALUES, numNulls);
        ExprNodeGenericFuncDesc exprNodeDesc = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (GenericUDF)new GenericUDFBetween(), Arrays.asList(new ExprNodeConstantDesc((Object)Boolean.TRUE), COL_EXPR, this.createExprNodeConstantDesc(3), this.createExprNodeConstantDesc(3)));
        long numRows = new StatsRulesProcFactory.FilterStatsRule().evaluateExpression(stats, (ExprNodeDesc)exprNodeDesc, STATS_PROC_CTX, Collections.emptyList(), null, (long)VALUES.length + numNulls);
        Assert.assertEquals((long)(VALUES.length - 1), (long)numRows);
    }

    @Test
    public void testNotBetweenRightLowerThanLeft() throws SemanticException {
        long numNulls = 2L;
        Statistics stats = this.createStatistics(VALUES, numNulls);
        ExprNodeGenericFuncDesc exprNodeDesc = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (GenericUDF)new GenericUDFBetween(), Arrays.asList(new ExprNodeConstantDesc((Object)Boolean.TRUE), COL_EXPR, this.createExprNodeConstantDesc(4), this.createExprNodeConstantDesc(3)));
        long numRows = new StatsRulesProcFactory.FilterStatsRule().evaluateExpression(stats, (ExprNodeDesc)exprNodeDesc, STATS_PROC_CTX, Collections.emptyList(), null, (long)VALUES.length + numNulls);
        Assert.assertEquals((long)VALUES.length, (long)numRows);
    }

    private ExprNodeDesc createExprNodeConstantDesc(int value) {
        return new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (Object)value);
    }

    private Statistics createStatistics(long[] values, long numNulls) {
        long numDVs = Arrays.stream(values).distinct().count();
        Statistics stats = new Statistics((long)values.length + numNulls, 100L, 100L, 100L);
        HyperLogLog hll = StatisticsTestUtils.createHll((long[])values);
        float[] val = new float[values.length];
        for (int i = 0; i < values.length; ++i) {
            val[i] = values[i];
        }
        KllFloatsSketch kll = StatisticsTestUtils.createKll((float[])val);
        ColStatistics colStatistics = TestStatsRulesProcFactory.createColStatistics(COL_NAME, "int", numNulls, numDVs, hll, kll);
        stats.addToColumnStats(Collections.singletonList(colStatistics));
        return stats;
    }

    private static ColStatistics createColStatistics(String colName, String colType, long numNulls, long numDVs, Object hll, KllFloatsSketch kll) {
        ColStatistics colStatistics = new ColStatistics(colName, colType);
        colStatistics.setNumNulls(numNulls);
        colStatistics.setCountDistint(numDVs);
        if (hll != null) {
            if (hll instanceof HyperLogLog) {
                colStatistics.setBitVectors(((HyperLogLog)hll).serialize());
            } else if (hll instanceof FMSketch) {
                colStatistics.setBitVectors(((FMSketch)hll).serialize());
            } else {
                throw new IllegalArgumentException("Unsupported HLL class: " + hll.getClass().getName());
            }
        }
        if (kll != null) {
            colStatistics.setHistogram(kll.toByteArray());
        }
        return colStatistics;
    }
}

