/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.signature;

import java.util.Collections;
import java.util.List;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgramBuilder;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.tools.RelBuilder;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;
import org.apache.hadoop.hive.ql.optimizer.calcite.RelOptHiveTable;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HivePointLookupOptimizerRule;
import org.apache.hadoop.hive.ql.optimizer.signature.RelTreeSignature;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFConcat;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TestRelSignature {
    @Mock
    private RelOptSchema schemaMock;
    @Mock
    RelOptHiveTable tableMock;
    @Mock
    Table hiveTableMDMock;
    private HepPlanner planner;
    private RelBuilder builder;
    @Deprecated
    GenericUDF udf = new GenericUDFConcat();
    @Deprecated
    CompilationOpContext cCtx = new CompilationOpContext();

    @Before
    public void before() {
        HepProgramBuilder programBuilder = new HepProgramBuilder();
        programBuilder.addRuleInstance((RelOptRule)new HivePointLookupOptimizerRule.FilterCondition(2));
        this.planner = new HepPlanner(programBuilder.build());
        JavaTypeFactoryImpl typeFactory = new JavaTypeFactoryImpl();
        RexBuilder rexBuilder = new RexBuilder((RelDataTypeFactory)typeFactory);
        RelOptCluster optCluster = RelOptCluster.create((RelOptPlanner)this.planner, (RexBuilder)rexBuilder);
        RelDataType rowTypeMock = typeFactory.createStructType(MyRecord.class);
        LogicalTableScan tableScan = LogicalTableScan.create((RelOptCluster)optCluster, (RelOptTable)this.tableMock, Collections.emptyList());
        ((RelOptHiveTable)Mockito.doReturn((Object)tableScan).when((Object)this.tableMock)).toRel((RelOptTable.ToRelContext)ArgumentMatchers.any());
        ((RelOptHiveTable)Mockito.doReturn((Object)rowTypeMock).when((Object)this.tableMock)).getRowType();
        ((RelOptSchema)Mockito.doReturn((Object)this.tableMock).when((Object)this.schemaMock)).getTableForMember((List)ArgumentMatchers.any());
        ((RelOptHiveTable)Mockito.lenient().doReturn((Object)this.hiveTableMDMock).when((Object)this.tableMock)).getHiveTableMD();
        this.builder = HiveRelFactories.HIVE_BUILDER.create(optCluster, this.schemaMock);
    }

    public RexNode eq(String field, int value) {
        return this.builder.call((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.builder.field(field), this.builder.literal((Object)value)});
    }

    @Test
    public void testFilterOpEquals() {
        RelNode r7 = this.builder.scan(new String[]{"t"}).filter(new RexNode[]{this.eq("f1", 7)}).build();
        RelNode r8 = this.builder.scan(new String[]{"t"}).filter(new RexNode[]{this.eq("f1", 8)}).build();
        RelNode r7b = this.builder.scan(new String[]{"t"}).filter(new RexNode[]{this.eq("f1", 7)}).build();
        TestRelSignature.checkEquals(r7, r7b);
        TestRelSignature.checkNotEquals(r7, r8);
    }

    public static void checkEquals(RelNode r7, RelNode r7b) {
        RelTreeSignature s1 = RelTreeSignature.of((RelNode)r7);
        RelTreeSignature s2 = RelTreeSignature.of((RelNode)r7b);
        Assert.assertEquals((long)s1.hashCode(), (long)s2.hashCode());
        Assert.assertEquals((Object)s1, (Object)s2);
    }

    public static void checkNotEquals(RelNode r7, RelNode r8) {
        RelTreeSignature s1 = RelTreeSignature.of((RelNode)r7);
        RelTreeSignature s2 = RelTreeSignature.of((RelNode)r8);
        Assert.assertNotEquals((long)s1.hashCode(), (long)s2.hashCode());
        Assert.assertNotEquals((Object)s1, (Object)s2);
    }

    private Operator<? extends OperatorDesc> getFilterOp(int constVal) {
        ExprNodeConstantDesc pred = new ExprNodeConstantDesc((Object)constVal);
        FilterDesc fd = new FilterDesc((ExprNodeDesc)pred, true);
        Operator op = OperatorFactory.get((CompilationOpContext)this.cCtx, (OperatorDesc)fd);
        return op;
    }

    private static class MyRecord {
        public int f1;
        public int f2;
        public int f3;

        private MyRecord() {
        }
    }
}

