/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.physical;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.AbstractMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.SMBMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorAggregationDesc;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorGroupByOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorUDAFCountStar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.gen.VectorUDAFSumLong;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.optimizer.physical.Vectorizer;
import org.apache.hadoop.hive.ql.plan.AggregationDesc;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.DynamicValue;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDynamicValueDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.SMBJoinDesc;
import org.apache.hadoop.hive.ql.plan.VectorGroupByDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFSum;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFAbs;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBetween;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPGreaterThan;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestVectorizer {
    static VectorizationContext vContext = null;

    @Before
    public void setUp() {
        ArrayList<String> columns = new ArrayList<String>();
        columns.add("col0");
        columns.add("col1");
        columns.add("col2");
        columns.add("col3");
        vContext = new VectorizationContext("name", columns);
    }

    @Test
    public void testAggregateOnUDF() throws HiveException, Vectorizer.VectorizerCannotVectorizeException {
        ExprNodeColumnDesc colExprA = new ExprNodeColumnDesc(Integer.class, "col1", "T", false);
        ExprNodeColumnDesc colExprB = new ExprNodeColumnDesc(Integer.class, "col2", "T", false);
        ArrayList<ExprNodeColumnDesc> children = new ArrayList<ExprNodeColumnDesc>();
        children.add(colExprA);
        ExprNodeGenericFuncDesc exprNodeDesc = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (GenericUDF)new GenericUDFAbs(), children);
        ArrayList<ExprNodeGenericFuncDesc> params = new ArrayList<ExprNodeGenericFuncDesc>();
        params.add(exprNodeDesc);
        ArrayList<ObjectInspector> paramOIs = new ArrayList<ObjectInspector>();
        paramOIs.add(exprNodeDesc.getWritableObjectInspector());
        AggregationDesc aggDesc = new AggregationDesc("sum", FunctionRegistry.getGenericUDAFEvaluator((String)"sum", paramOIs, (boolean)false, (boolean)false), params, false, GenericUDAFEvaluator.Mode.PARTIAL1);
        ArrayList<String> outputColumnNames = new ArrayList<String>();
        outputColumnNames.add("_col0");
        GroupByDesc desc = new GroupByDesc();
        VectorGroupByDesc vectorDesc = new VectorGroupByDesc();
        vectorDesc.setProcessingMode(VectorGroupByDesc.ProcessingMode.HASH);
        vectorDesc.setVecAggrDescs(new VectorAggregationDesc[]{new VectorAggregationDesc.VectorAggregationDescBuilder().aggregationName(aggDesc.getGenericUDAFName()).evaluator((GenericUDAFEvaluator)new GenericUDAFSum.GenericUDAFSumLong()).udafEvaluatorMode(aggDesc.getMode()).inputTypeInfo((TypeInfo)TypeInfoFactory.longTypeInfo).inputColVectorType(ColumnVector.Type.LONG).outputTypeInfo((TypeInfo)TypeInfoFactory.longTypeInfo).outputColVectorType(ColumnVector.Type.LONG).vectorAggregationClass(VectorUDAFCountStar.class).build()});
        desc.setOutputColumnNames(outputColumnNames);
        ArrayList<AggregationDesc> aggDescList = new ArrayList<AggregationDesc>();
        aggDescList.add(aggDesc);
        desc.setAggregators(aggDescList);
        ArrayList<ExprNodeColumnDesc> grpByKeys = new ArrayList<ExprNodeColumnDesc>();
        grpByKeys.add(colExprB);
        desc.setKeys(grpByKeys);
        Operator gbyOp = OperatorFactory.get((CompilationOpContext)new CompilationOpContext(), (OperatorDesc)desc);
        desc.setMode(GroupByDesc.Mode.HASH);
        VectorizationContext ctx = new VectorizationContext("name", Arrays.asList("col1", "col2"));
        Vectorizer v = new Vectorizer();
        v.testSetCurrentBaseWork((BaseWork)new MapWork());
        VectorGroupByOperator vectorOp = (VectorGroupByOperator)Vectorizer.vectorizeGroupByOperator((Operator)gbyOp, (VectorizationContext)ctx, (VectorGroupByDesc)vectorDesc);
        Assert.assertEquals(VectorUDAFSumLong.class, (Object)vectorDesc.getVecAggrDescs()[0].getVecAggrClass());
    }

    @Test
    public void testValidateNestedExpressions() {
        ExprNodeColumnDesc col1Expr = new ExprNodeColumnDesc(Integer.class, "col1", "table", false);
        ExprNodeConstantDesc constDesc = new ExprNodeConstantDesc((Object)10);
        GenericUDFOPGreaterThan udf = new GenericUDFOPGreaterThan();
        ExprNodeGenericFuncDesc greaterExprDesc = new ExprNodeGenericFuncDesc();
        greaterExprDesc.setTypeInfo((TypeInfo)TypeInfoFactory.booleanTypeInfo);
        greaterExprDesc.setGenericUDF((GenericUDF)udf);
        ArrayList<Object> children1 = new ArrayList<Object>(2);
        children1.add(col1Expr);
        children1.add(constDesc);
        greaterExprDesc.setChildren(children1);
        FakeGenericUDF udf2 = new FakeGenericUDF();
        ExprNodeGenericFuncDesc nonSupportedExpr = new ExprNodeGenericFuncDesc();
        nonSupportedExpr.setTypeInfo((TypeInfo)TypeInfoFactory.booleanTypeInfo);
        nonSupportedExpr.setGenericUDF((GenericUDF)udf2);
        GenericUDFOPAnd andUdf = new GenericUDFOPAnd();
        ExprNodeGenericFuncDesc andExprDesc = new ExprNodeGenericFuncDesc();
        andExprDesc.setTypeInfo((TypeInfo)TypeInfoFactory.booleanTypeInfo);
        andExprDesc.setGenericUDF((GenericUDF)andUdf);
        ArrayList<ExprNodeGenericFuncDesc> children3 = new ArrayList<ExprNodeGenericFuncDesc>(2);
        children3.add(greaterExprDesc);
        children3.add(nonSupportedExpr);
        andExprDesc.setChildren(children3);
        Vectorizer v = new Vectorizer();
        v.testSetCurrentBaseWork((BaseWork)new MapWork());
        Assert.assertTrue((boolean)v.validateExprNodeDesc((ExprNodeDesc)andExprDesc, "test", VectorExpressionDescriptor.Mode.FILTER, false));
    }

    private void prepareAbstractMapJoin(AbstractMapJoinOperator<? extends MapJoinDesc> map, MapJoinDesc mjdesc) {
        mjdesc.setPosBigTable(0);
        ArrayList<ExprNodeColumnDesc> expr = new ArrayList<ExprNodeColumnDesc>();
        expr.add(new ExprNodeColumnDesc(Integer.class, "col1", "T", false));
        HashMap keyMap = new HashMap();
        keyMap.put((byte)0, expr);
        ArrayList<ExprNodeColumnDesc> smallTableExpr = new ArrayList<ExprNodeColumnDesc>();
        smallTableExpr.add(new ExprNodeColumnDesc(Integer.class, "col2", "T1", false));
        keyMap.put((byte)1, smallTableExpr);
        mjdesc.setKeys(keyMap);
        mjdesc.setExprs(keyMap);
        Byte[] order = new Byte[]{(byte)0, (byte)1};
        mjdesc.setTagOrder(order);
        GenericUDFOPEqual udf = new GenericUDFOPEqual();
        ExprNodeGenericFuncDesc equalExprDesc = new ExprNodeGenericFuncDesc();
        equalExprDesc.setTypeInfo((TypeInfo)TypeInfoFactory.booleanTypeInfo);
        equalExprDesc.setGenericUDF((GenericUDF)udf);
        ArrayList<ExprNodeColumnDesc> children1 = new ArrayList<ExprNodeColumnDesc>(2);
        children1.add(new ExprNodeColumnDesc(Integer.class, "col2", "T1", false));
        children1.add(new ExprNodeColumnDesc(Integer.class, "col3", "T2", false));
        equalExprDesc.setChildren(children1);
        ArrayList<ExprNodeGenericFuncDesc> filterExpr = new ArrayList<ExprNodeGenericFuncDesc>();
        filterExpr.add(equalExprDesc);
        HashMap<Byte, ArrayList<ExprNodeColumnDesc>> filterMap = new HashMap<Byte, ArrayList<ExprNodeColumnDesc>>();
        filterMap.put((byte)0, expr);
        mjdesc.setFilters(filterMap);
    }

    @Test
    public void testValidateMapJoinOperator() {
        MapJoinOperator map = new MapJoinOperator(new CompilationOpContext());
        MapJoinDesc mjdesc = new MapJoinDesc();
        this.prepareAbstractMapJoin((AbstractMapJoinOperator<? extends MapJoinDesc>)map, mjdesc);
        map.setConf((OperatorDesc)mjdesc);
        Vectorizer vectorizer = new Vectorizer();
        vectorizer.testSetCurrentBaseWork((BaseWork)new MapWork());
    }

    @Test
    public void testValidateSMBJoinOperator() {
        SMBMapJoinOperator map = new SMBMapJoinOperator(new CompilationOpContext());
        SMBJoinDesc mjdesc = new SMBJoinDesc();
        this.prepareAbstractMapJoin((AbstractMapJoinOperator<? extends MapJoinDesc>)map, (MapJoinDesc)mjdesc);
        map.setConf((OperatorDesc)mjdesc);
        Vectorizer vectorizer = new Vectorizer();
        vectorizer.testSetCurrentBaseWork((BaseWork)new MapWork());
    }

    @Test
    public void testExprNodeDynamicValue() {
        ExprNodeDynamicValueDesc exprNode = new ExprNodeDynamicValueDesc(new DynamicValue("id1", (TypeInfo)TypeInfoFactory.stringTypeInfo));
        Vectorizer v = new Vectorizer();
        Assert.assertTrue((boolean)v.validateExprNodeDesc((ExprNodeDesc)exprNode, "Test", VectorExpressionDescriptor.Mode.FILTER, false));
        Assert.assertTrue((boolean)v.validateExprNodeDesc((ExprNodeDesc)exprNode, "Test", VectorExpressionDescriptor.Mode.PROJECTION, false));
    }

    @Test
    public void testExprNodeBetweenWithDynamicValue() {
        ExprNodeConstantDesc notBetween = new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.booleanTypeInfo, (Object)Boolean.FALSE);
        ExprNodeColumnDesc colExpr = new ExprNodeColumnDesc(String.class, "col1", "table", false);
        ExprNodeDynamicValueDesc minExpr = new ExprNodeDynamicValueDesc(new DynamicValue("id1", (TypeInfo)TypeInfoFactory.stringTypeInfo));
        ExprNodeDynamicValueDesc maxExpr = new ExprNodeDynamicValueDesc(new DynamicValue("id2", (TypeInfo)TypeInfoFactory.stringTypeInfo));
        ExprNodeGenericFuncDesc betweenExpr = new ExprNodeGenericFuncDesc();
        GenericUDFBetween betweenUdf = new GenericUDFBetween();
        betweenExpr.setTypeInfo((TypeInfo)TypeInfoFactory.booleanTypeInfo);
        betweenExpr.setGenericUDF((GenericUDF)betweenUdf);
        ArrayList<Object> children1 = new ArrayList<Object>(2);
        children1.add(notBetween);
        children1.add(colExpr);
        children1.add(minExpr);
        children1.add(maxExpr);
        betweenExpr.setChildren(children1);
        Vectorizer v = new Vectorizer();
        v.testSetCurrentBaseWork((BaseWork)new MapWork());
        boolean valid = v.validateExprNodeDesc((ExprNodeDesc)betweenExpr, "Test", VectorExpressionDescriptor.Mode.FILTER, false);
        Assert.assertTrue((boolean)valid);
    }

    @Description(name="fake", value="FAKE")
    static class FakeGenericUDF
    extends GenericUDF {
        FakeGenericUDF() {
        }

        public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
            return null;
        }

        public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
            return null;
        }

        public String getDisplayString(String[] children) {
            return "fake";
        }
    }
}

