/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.physical;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageStatistics;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveConfForTest;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.physical.MetadataOnlyOptimizer;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalContext;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.ReduceWork;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hive.common.util.MockFileSystem;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestNullScanTaskDispatcher {
    private static final Path WAREHOUSE_DIR = new Path("mock:///warehouse");
    private final String PARTITION_FIELD = "part";
    private HiveConf hiveConf;
    private Context context;
    private ParseContext parseContext;
    private SessionState sessionState;
    private MockFileSystem fs;
    private MapWork mapWork = new MapWork();
    private ReduceWork reduceWork = new ReduceWork();
    private Map aliasToWork = new HashMap();

    @Before
    public void setup() {
        this.hiveConf = new HiveConfForTest(this.getClass());
        this.hiveConf.set("fs.mock.impl", MockFileSystem.class.getName());
        this.hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_METADATA_ONLY_QUERIES, true);
        this.sessionState = SessionState.start((HiveConf)this.hiveConf);
        this.parseContext = (ParseContext)Mockito.spy((Object)new ParseContext());
        this.context = new Context((Configuration)this.hiveConf);
        this.parseContext.setTopOps(this.aliasToWork);
        this.mapWork.setAliasToWork(this.aliasToWork);
        this.createReduceWork();
    }

    @After
    public void tearDown() throws IOException {
        StorageStatistics storageStatistics;
        if (this.sessionState != null) {
            this.sessionState.close();
        }
        if ((storageStatistics = FileSystem.getGlobalStorageStatistics().get("mock")) != null) {
            storageStatistics.reset();
        }
        if (this.fs != null) {
            this.fs.clear();
            this.fs.close();
        }
    }

    @Test
    public void testNumberOfListStatusCalls1() throws IOException, SemanticException {
        this.verifyNumberOfReads(3, 10, 10, 3);
    }

    @Test
    public void testNumberOfListStatusCalls2() throws IOException, SemanticException {
        this.verifyNumberOfReads(3, 10, 5, 8);
    }

    @Test
    public void testNumberOfListStatusCalls3() throws IOException, SemanticException {
        this.verifyNumberOfReads(3, 10, 0, 13);
    }

    @Test
    public void testNumberOfListStatusCalls4() throws IOException, SemanticException {
        this.verifyNumberOfReads(0, 10, 0, 10);
    }

    @Test
    public void testNumberOfListStatusCalls5() throws IOException, SemanticException {
        this.verifyNumberOfReads(0, 10, 10, 0);
    }

    @Test
    public void testNumberOfListStatusCalls_whenExternalLookupRunsInCaller() throws IOException, SemanticException {
        this.verifyNumberOfReads(1, 0, 0, 1);
    }

    @Test
    public void testTwoManagedTables() throws IOException, SemanticException {
        String managedTable1 = "table1";
        String managedTable2 = "table2";
        this.createTable("table1", 100, 99);
        this.createTable("table2", 200, 190);
        TableScanOperator tso1 = this.createTableScanOperator(false);
        TableScanOperator tso2 = this.createTableScanOperator(false);
        this.aliasToWork.put("table1", tso1);
        this.aliasToWork.put("table2", tso2);
        PhysicalContext physicalContext = new PhysicalContext(this.hiveConf, this.parseContext, this.context, this.getAsRootTaskList(this.mapWork, this.reduceWork), null);
        new MetadataOnlyOptimizer().resolve(physicalContext);
        Assert.assertEquals((long)1L, (long)this.mapWork.getPathToPartitionInfo().size());
        StorageStatistics statistics = FileSystem.getGlobalStorageStatistics().get("mock");
        Assert.assertEquals((long)11L, (long)statistics.getLong("readOps"));
    }

    private void verifyNumberOfReads(int externalPartitionCount, int managedPartitionCount, int upToDateManagedPartitions, int expectedReadOps) throws IOException, SemanticException {
        String MANAGED_TEST_TABLE = "managedTestTable";
        String EXTERNAL_TEST_TABLE = "externalTestTable";
        this.createTable("externalTestTable", externalPartitionCount, 0);
        this.createTable("managedTestTable", managedPartitionCount, upToDateManagedPartitions);
        TableScanOperator tsoManaged = this.createTableScanOperator(false);
        TableScanOperator tsoExternal = this.createTableScanOperator(true);
        this.aliasToWork.put("managedTestTable", tsoManaged);
        this.aliasToWork.put("externalTestTable", tsoExternal);
        PhysicalContext physicalContext = new PhysicalContext(this.hiveConf, this.parseContext, this.context, this.getAsRootTaskList(this.mapWork, this.reduceWork), null);
        new MetadataOnlyOptimizer().resolve(physicalContext);
        Assert.assertEquals((long)1L, (long)this.mapWork.getPathToPartitionInfo().size());
        StorageStatistics statistics = FileSystem.getGlobalStorageStatistics().get("mock");
        Assert.assertEquals((long)expectedReadOps, (long)statistics.getLong("readOps"));
    }

    private void createReduceWork() {
        GroupByOperator gbo = new GroupByOperator((CompilationOpContext)Mockito.mock(CompilationOpContext.class));
        GroupByDesc groupByDesc = (GroupByDesc)Mockito.mock(GroupByDesc.class);
        Mockito.when((Object)groupByDesc.isDistinctLike()).thenReturn((Object)true);
        gbo.setConf((OperatorDesc)groupByDesc);
        FileSinkOperator fso = new FileSinkOperator((CompilationOpContext)Mockito.mock(CompilationOpContext.class));
        gbo.setChildOperators(Collections.singletonList(fso));
        this.reduceWork.setReducer((Operator)gbo);
    }

    private TableScanOperator createTableScanOperator(boolean isExternal) {
        TableScanOperator tso = new TableScanOperator((CompilationOpContext)Mockito.mock(CompilationOpContext.class));
        TableScanDesc tableScanDesc = (TableScanDesc)Mockito.mock(TableScanDesc.class);
        Table table = (Table)Mockito.mock(Table.class);
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        if (isExternal) {
            parameterMap.put("EXTERNAL", "TRUE");
        }
        org.apache.hadoop.hive.metastore.api.Table ttable = (org.apache.hadoop.hive.metastore.api.Table)Mockito.mock(org.apache.hadoop.hive.metastore.api.Table.class);
        Mockito.when((Object)ttable.getParameters()).thenReturn(parameterMap);
        Mockito.when((Object)table.getTTable()).thenReturn((Object)ttable);
        Mockito.when((Object)tableScanDesc.getTableMetadata()).thenReturn((Object)table);
        tso.setConf((OperatorDesc)tableScanDesc);
        return tso;
    }

    private void addPartitionPath(MapWork mapWork, String table, Path path) {
        mapWork.addPathToAlias(path, table);
        PartitionDesc partitionDesc = new PartitionDesc();
        partitionDesc.setProperties(new Properties());
        partitionDesc.setPartSpec(new LinkedHashMap());
        partitionDesc.setTableDesc((TableDesc)Mockito.mock(TableDesc.class));
        mapWork.addPathToPartitionInfo(path, partitionDesc);
    }

    private List<Task<?>> getAsRootTaskList(MapWork mapWork, ReduceWork reduceWork) {
        MapredWork mapredWork = new MapredWork();
        mapredWork.setMapWork(mapWork);
        mapredWork.setReduceWork(reduceWork);
        Task task = TaskFactory.get((Serializable)mapredWork);
        return Collections.singletonList(task);
    }

    private Partition createMockPartitionObject(Path path, boolean isUpToDate) {
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)partition.getPartitionPath()).thenReturn((Object)path);
        HashMap<String, String> parameters = new HashMap<String, String>();
        Mockito.when((Object)partition.getParameters()).thenReturn(parameters);
        parameters.put("COLUMN_STATS_ACCURATE", Boolean.toString(isUpToDate).toUpperCase());
        parameters.put("numRows", "0");
        return partition;
    }

    private void createTable(String tableName, int partitionCount, int upToDatePartitions) throws IOException, SemanticException {
        Path tablePath = new Path(WAREHOUSE_DIR, tableName);
        HashSet<Partition> partitionSet = new HashSet<Partition>();
        this.fs = (MockFileSystem)WAREHOUSE_DIR.getFileSystem((Configuration)this.hiveConf);
        for (int i = 0; i < partitionCount; ++i) {
            Path p = new Path(tablePath, "part=" + i);
            this.addPartitionPath(this.mapWork, tableName, p);
            this.fs.create(p);
            boolean upToDate = i < upToDatePartitions;
            partitionSet.add(this.createMockPartitionObject(p, upToDate));
        }
        PrunedPartitionList ppl = (PrunedPartitionList)Mockito.mock(PrunedPartitionList.class);
        Mockito.when((Object)ppl.getPartitions()).thenReturn(partitionSet);
        ((ParseContext)Mockito.doReturn((Object)ppl).when((Object)this.parseContext)).getPrunedPartitions(ArgumentMatchers.startsWith((String)tableName), (TableScanOperator)ArgumentMatchers.any());
    }
}

