/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.listbucketingpruner;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.ql.optimizer.listbucketingpruner.ListBucketingPruner;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.junit.Assert;
import org.junit.Test;

public class TestDynamicMultiDimeCollection {
    private static String DEF_DIR = "default";

    @Test
    public void testUniqueElementsList1() {
        ArrayList<List<String>> values = new ArrayList<List<String>>();
        List<String> v1 = Arrays.asList("1", "a", "x");
        List<String> v2 = Arrays.asList("2", "b", "x");
        List<String> v3 = Arrays.asList("1", "c", "x");
        List<String> v4 = Arrays.asList("2", "a", "y");
        values.add(v1);
        values.add(v2);
        values.add(v3);
        values.add(v4);
        List actuals = ListBucketingPruner.DynamicMultiDimensionalCollection.uniqueElementsList(values, (String)DEF_DIR);
        ArrayList<List<String>> expecteds = new ArrayList<List<String>>();
        v1 = Arrays.asList("1", "2", "default");
        v2 = Arrays.asList("a", "b", "c", "default");
        v3 = Arrays.asList("x", "y", "default");
        expecteds.add(v1);
        expecteds.add(v2);
        expecteds.add(v3);
        Assert.assertEquals(expecteds, (Object)actuals);
    }

    @Test
    public void testUniqueElementsList2() {
        ArrayList<List<String>> values = new ArrayList<List<String>>();
        List<String> v1 = Arrays.asList("1", "a", "x");
        values.add(v1);
        List actuals = ListBucketingPruner.DynamicMultiDimensionalCollection.uniqueElementsList(values, (String)DEF_DIR);
        ArrayList<List<String>> expecteds = new ArrayList<List<String>>();
        v1 = Arrays.asList("1", "default");
        List<String> v2 = Arrays.asList("a", "default");
        List<String> v3 = Arrays.asList("x", "default");
        expecteds.add(v1);
        expecteds.add(v2);
        expecteds.add(v3);
        Assert.assertEquals(expecteds, (Object)actuals);
    }

    @Test
    public void testUniqueElementsList3() {
        ArrayList<List<String>> values = new ArrayList<List<String>>();
        List<String> v1 = Arrays.asList("1");
        List<String> v2 = Arrays.asList("2");
        List<String> v3 = Arrays.asList("3");
        List<String> v4 = Arrays.asList("4");
        values.add(v1);
        values.add(v2);
        values.add(v3);
        values.add(v4);
        List actuals = ListBucketingPruner.DynamicMultiDimensionalCollection.uniqueElementsList(values, (String)DEF_DIR);
        ArrayList<List<String>> expecteds = new ArrayList<List<String>>();
        v1 = Arrays.asList("1", "2", "3", "4", "default");
        expecteds.add(v1);
        Assert.assertEquals(expecteds, (Object)actuals);
    }

    @Test
    public void testFlat3() throws SemanticException {
        ArrayList<List<String>> uniqSkewedElements = new ArrayList<List<String>>();
        List<String> v1 = Arrays.asList("1", "2", "default");
        List<String> v2 = Arrays.asList("a", "b", "c", "default");
        List<String> v3 = Arrays.asList("x", "y", "default");
        uniqSkewedElements.add(v1);
        uniqSkewedElements.add(v2);
        uniqSkewedElements.add(v3);
        List actuals = ListBucketingPruner.DynamicMultiDimensionalCollection.flat(uniqSkewedElements);
        Assert.assertTrue((actuals.size() == 36 ? 1 : 0) != 0);
    }

    @Test
    public void testFlat2() throws SemanticException {
        ArrayList<List<String>> uniqSkewedElements = new ArrayList<List<String>>();
        List<String> v1 = Arrays.asList("1", "2");
        uniqSkewedElements.add(v1);
        List actual = ListBucketingPruner.DynamicMultiDimensionalCollection.flat(uniqSkewedElements);
        ArrayList<List<String>> expected = new ArrayList<List<String>>();
        v1 = Arrays.asList("1");
        List<String> v2 = Arrays.asList("2");
        expected.add(v1);
        expected.add(v2);
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testFlat1() throws SemanticException {
        ArrayList<List<String>> uniqSkewedElements = new ArrayList<List<String>>();
        List<String> v1 = Arrays.asList("1", "2");
        List<String> v2 = Arrays.asList("3", "4");
        uniqSkewedElements.add(v1);
        uniqSkewedElements.add(v2);
        List actual = ListBucketingPruner.DynamicMultiDimensionalCollection.flat(uniqSkewedElements);
        ArrayList<List<String>> expected = new ArrayList<List<String>>();
        v1 = Arrays.asList("1", "3");
        v2 = Arrays.asList("1", "4");
        List<String> v3 = Arrays.asList("2", "3");
        List<String> v4 = Arrays.asList("2", "4");
        expected.add(v1);
        expected.add(v2);
        expected.add(v3);
        expected.add(v4);
        Assert.assertEquals(expected, (Object)actual);
    }
}

