/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.lineage;

import java.util.function.Predicate;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.QueryProperties;
import org.apache.hadoop.hive.ql.optimizer.lineage.Generator;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class TestGenerator {
    @Test
    public void testCreateFilterPredicateFromConf() {
        HiveConf conf = new HiveConf();
        conf.set(HiveConf.ConfVars.HIVE_LINEAGE_STATEMENT_FILTER.varname, "CREATE_tABLE_AS_sELECT," + HiveOperation.QUERY.name());
        Predicate predicate = Generator.createFilterPredicateFromConf((Configuration)conf);
        ParseContext parseContext = new ParseContext();
        QueryProperties queryProperties = new QueryProperties();
        queryProperties.setCTAS(true);
        parseContext.setQueryProperties(queryProperties);
        MatcherAssert.assertThat((Object)predicate.test(parseContext), (Matcher)CoreMatchers.is((Object)true));
        parseContext = new ParseContext();
        queryProperties = new QueryProperties();
        queryProperties.setQuery(true);
        parseContext.setQueryProperties(queryProperties);
        MatcherAssert.assertThat((Object)predicate.test(parseContext), (Matcher)CoreMatchers.is((Object)true));
        parseContext = new ParseContext();
        queryProperties = new QueryProperties();
        queryProperties.setView(true);
        parseContext.setQueryProperties(queryProperties);
        MatcherAssert.assertThat((Object)predicate.test(parseContext), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testCreateFilterPredicateFromConfReturnsAlwaysTrueWhenSettingIsNotPresent() {
        HiveConf conf = new HiveConf();
        Predicate predicate = Generator.createFilterPredicateFromConf((Configuration)conf);
        MatcherAssert.assertThat((Object)predicate.test(new ParseContext()), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testCreateFilterPredicateFromConfReturnsAlwaysFalseWhenSettingValueIsEmptyString() {
        HiveConf conf = new HiveConf();
        conf.set(HiveConf.ConfVars.HIVE_LINEAGE_STATEMENT_FILTER.varname, "");
        Predicate predicate = Generator.createFilterPredicateFromConf((Configuration)conf);
        MatcherAssert.assertThat((Object)predicate.test(new ParseContext()), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testCreateFilterPredicateFromConfThrowsExceptionWhenInputStringIsInvalid() {
        HiveConf conf = new HiveConf();
        conf.set(HiveConf.ConfVars.HIVE_LINEAGE_STATEMENT_FILTER.varname, "Invalid");
        EnumConstantNotPresentException exception = (EnumConstantNotPresentException)Assert.assertThrows(EnumConstantNotPresentException.class, () -> Generator.createFilterPredicateFromConf((Configuration)conf));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.is((Object)"org.apache.hadoop.hive.ql.optimizer.lineage.Generator$LineageInfoFilter.Invalid"));
    }

    @Test
    public void testCreateFilterPredicateFromConfThrowsExceptionWhenNoneAndAnyOtherConstantPresent() {
        HiveConf conf = new HiveConf();
        conf.set(HiveConf.ConfVars.HIVE_LINEAGE_STATEMENT_FILTER.varname, "None," + HiveOperation.QUERY.name());
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> Generator.createFilterPredicateFromConf((Configuration)conf));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.is((Object)"No other value can be specified when NONE is present!"));
    }
}

