/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.UnionOperator;
import org.apache.hadoop.hive.ql.exec.tez.TezTask;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.graph.OperatorGraph;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.TezCompiler;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.plan.TezWork;
import org.apache.hadoop.hive.ql.plan.UnionDesc;
import org.apache.hadoop.hive.ql.plan.UnionWork;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestOperatorGraph {
    TezCompilerMimic tezCompiler;
    ParseContext pctx;
    TableScanOperator ts1;
    TableScanOperator ts2;
    UnionOperator union;
    SelectOperator sel;
    ReduceSinkOperator rs;
    GroupByOperator gby;
    FileSinkOperator fs;

    private boolean isMatchingOperatorSet(Set<Operator<?>> opSet1, Set<Operator<?>> opSet2) {
        List opSetTypes1 = opSet1.stream().filter(op -> !(op instanceof UnionOperator)).map(Operator::getName).sorted().collect(Collectors.toList());
        List opSetTypes2 = opSet2.stream().filter(op -> !(op instanceof UnionOperator)).map(Operator::getName).sorted().collect(Collectors.toList());
        if (opSetTypes1.size() == opSetTypes2.size()) {
            boolean result = true;
            for (int i = 0; i < opSet1.size(); ++i) {
                result = result && opSetTypes1.get(i) == opSetTypes2.get(i);
            }
            return result;
        }
        return false;
    }

    private void connectOperators(Operator<?> parent, Operator<?> child) {
        parent.getChildOperators().add(child);
        child.getParentOperators().add(parent);
    }

    @Before
    public void setUp() throws SemanticException {
        CompilationOpContext cCtx = new CompilationOpContext();
        this.ts1 = new TableScanOperator(cCtx);
        this.ts2 = new TableScanOperator(cCtx);
        this.union = new UnionOperator(cCtx);
        this.sel = new SelectOperator(cCtx);
        this.rs = new ReduceSinkOperator(cCtx);
        this.gby = new GroupByOperator(cCtx);
        this.fs = new FileSinkOperator(cCtx);
        TableScanDesc tsConf1 = new TableScanDesc(new Table("db", "table1"));
        tsConf1.setAlias("table1");
        tsConf1.getTableMetadata().getSd().setLocation("file:///table1");
        TableScanDesc tsConf2 = new TableScanDesc(new Table("db", "table2"));
        tsConf2.setAlias("table2");
        tsConf2.getTableMetadata().getSd().setLocation("file:///table2");
        TableDesc rsTableDesc = new TableDesc();
        rsTableDesc.setProperties(new Properties());
        ReduceSinkDesc rsConf = new ReduceSinkDesc();
        rsConf.setKeySerializeInfo(rsTableDesc);
        GroupByDesc gbyConf = new GroupByDesc();
        gbyConf.setKeys(new ArrayList());
        TableDesc fsTableDesc = new TableDesc();
        fsTableDesc.setProperties(new Properties());
        FileSinkDesc fsConf = new FileSinkDesc();
        fsConf.setTableInfo(fsTableDesc);
        this.ts1.setConf((OperatorDesc)tsConf1);
        this.ts2.setConf((OperatorDesc)tsConf2);
        this.union.setConf((OperatorDesc)new UnionDesc());
        this.sel.setConf((OperatorDesc)new SelectDesc());
        this.rs.setConf((OperatorDesc)rsConf);
        this.gby.setConf((OperatorDesc)gbyConf);
        this.fs.setConf((OperatorDesc)fsConf);
        this.connectOperators((Operator<?>)this.ts1, (Operator<?>)this.union);
        this.connectOperators((Operator<?>)this.ts2, (Operator<?>)this.union);
        this.connectOperators((Operator<?>)this.union, (Operator<?>)this.sel);
        this.connectOperators((Operator<?>)this.sel, (Operator<?>)this.rs);
        this.connectOperators((Operator<?>)this.rs, (Operator<?>)this.gby);
        this.connectOperators((Operator<?>)this.gby, (Operator<?>)this.fs);
        HiveConf conf = new HiveConf();
        conf.setBoolean(HiveConf.ConfVars.HIVE_CLI_TEZ_INITIALIZE_SESSION.varname, false);
        SessionState.start((HiveConf)conf);
        QueryState queryState = QueryState.getNewQueryState((HiveConf)conf, null);
        SemanticAnalyzer sem = new SemanticAnalyzer(queryState);
        this.tezCompiler = new TezCompilerMimic();
        this.tezCompiler.init(queryState, null, null);
        this.pctx = sem.getParseContext();
        this.pctx.setContext(new Context((Configuration)conf));
        this.pctx.setTopOps(new HashMap());
        this.pctx.getTopOps().put("table1", this.ts1);
        this.pctx.getTopOps().put("table2", this.ts2);
    }

    @After
    public void tearDown() {
        this.tezCompiler = null;
        this.pctx = null;
        this.ts1 = null;
        this.ts2 = null;
        this.union = null;
        this.sel = null;
        this.rs = null;
        this.gby = null;
        this.fs = null;
    }

    @Test
    public void testCompareDAGIncludingUnion() throws SemanticException {
        OperatorGraph og = new OperatorGraph(this.pctx);
        HashSet operatorGraphClusters = new HashSet(og.getClusters());
        List nonUnionBaseWorks = this.tezCompiler.runGenerateTaskTree(this.pctx).stream().filter(work -> !(work instanceof UnionWork)).collect(Collectors.toList());
        Assert.assertEquals((long)nonUnionBaseWorks.size(), (long)operatorGraphClusters.size());
        for (BaseWork work2 : nonUnionBaseWorks) {
            Optional<OperatorGraph.Cluster> matchingCluster = operatorGraphClusters.stream().filter(cluster -> this.isMatchingOperatorSet(work2.getAllOperators(), cluster.getMembers())).findFirst();
            Assert.assertTrue((boolean)matchingCluster.isPresent());
            operatorGraphClusters.remove(matchingCluster.get());
        }
    }

    private class TezCompilerMimic
    extends TezCompiler {
        private TezCompilerMimic() {
        }

        public List<BaseWork> runGenerateTaskTree(ParseContext pCtx) throws SemanticException {
            ArrayList rootTasks = new ArrayList();
            this.generateTaskTree(rootTasks, pCtx, new ArrayList(), new HashSet(), new HashSet());
            Assert.assertEquals((long)1L, (long)rootTasks.size());
            Assert.assertTrue((boolean)(rootTasks.get(0) instanceof TezTask));
            TezTask tezTask = (TezTask)rootTasks.get(0);
            return ((TezWork)tezTask.getWork()).getAllWork();
        }
    }
}

