/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.translator;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rel.type.RelRecordType;
import org.apache.calcite.sql.type.ArraySqlType;
import org.apache.calcite.sql.type.BasicSqlType;
import org.apache.calcite.sql.type.MapSqlType;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveTypeSystemImpl;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.ASTConverter;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestASTConverter {
    private static final String EXPECTED_STRUCT_TREE = "\nTOK_STRUCT\n   TOK_TABCOLLIST\n      TOK_TABCOL\n         a\n         TOK_INT\n      TOK_TABCOL\n         b\n         TOK_CHAR\n            30\n      TOK_TABCOL\n         c\n         TOK_NULL\n";
    private static final String EXPECTED_TREE = "\nTOK_QUERY\n   TOK_INSERT\n      TOK_DESTINATION\n         TOK_DIR\n            TOK_TMP_FILE\n      TOK_SELECT\n         TOK_SELEXPR\n            TOK_FUNCTION\n               TOK_INT\n               TOK_NULL\n            a\n         TOK_SELEXPR\n            TOK_FUNCTION\n               TOK_CHAR\n                  30\n               TOK_NULL\n            b\n         TOK_SELEXPR\n            TOK_NULL\n            c\n      TOK_LIMIT\n         0\n         0\n";
    private static final String EXPECTED_COMPLEX_TREE = "\nTOK_STRUCT\n   TOK_TABCOLLIST\n      TOK_TABCOL\n         a\n         TOK_STRUCT\n            TOK_TABCOLLIST\n               TOK_TABCOL\n                  f1\n                  TOK_INT\n               TOK_TABCOL\n                  farray\n                  TOK_LIST\n                     TOK_INT\n               TOK_TABCOL\n                  fmap\n                  TOK_MAP\n                     TOK_INT\n                     TOK_INT\n               TOK_TABCOL\n                  fstruct\n                  TOK_STRUCT\n                     TOK_TABCOLLIST\n                        TOK_TABCOL\n                           nf1\n                           TOK_INT\n                        TOK_TABCOL\n                           nf2\n                           TOK_CHAR\n                              30\n";

    TestASTConverter() {
    }

    @Test
    void testConvertTypeWhenInputIsStruct() {
        List<RelDataTypeField> fields = Arrays.asList(new RelDataTypeFieldImpl("a", 0, (RelDataType)new BasicSqlType((RelDataTypeSystem)new HiveTypeSystemImpl(), SqlTypeName.INTEGER)), new RelDataTypeFieldImpl("b", 1, (RelDataType)new BasicSqlType((RelDataTypeSystem)new HiveTypeSystemImpl(), SqlTypeName.CHAR, 30)), new RelDataTypeFieldImpl("c", 2, (RelDataType)new BasicSqlType((RelDataTypeSystem)new HiveTypeSystemImpl(), SqlTypeName.NULL)));
        RelRecordType dataType = new RelRecordType(fields);
        ASTNode tree = ASTConverter.convertType((RelDataType)dataType);
        MatcherAssert.assertThat((Object)tree.dump(), (Matcher)Is.is((Object)EXPECTED_STRUCT_TREE));
    }

    @Test
    void testEmptyPlanWhenInputSchemaIsEmpty() {
        RelRecordType dataType = new RelRecordType(Collections.emptyList());
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ASTConverter.emptyPlan((RelDataType)dataType));
        Assertions.assertTrue((boolean)thrown.getMessage().contains("Schema is empty"));
    }

    @Test
    void testEmptyPlan() {
        List<RelDataTypeField> fields = Arrays.asList(new RelDataTypeFieldImpl("a", 0, (RelDataType)new BasicSqlType((RelDataTypeSystem)new HiveTypeSystemImpl(), SqlTypeName.INTEGER)), new RelDataTypeFieldImpl("b", 1, (RelDataType)new BasicSqlType((RelDataTypeSystem)new HiveTypeSystemImpl(), SqlTypeName.CHAR, 30)), new RelDataTypeFieldImpl("c", 2, (RelDataType)new BasicSqlType((RelDataTypeSystem)new HiveTypeSystemImpl(), SqlTypeName.NULL)));
        RelRecordType dataType = new RelRecordType(fields);
        ASTNode tree = ASTConverter.emptyPlan((RelDataType)dataType);
        MatcherAssert.assertThat((Object)tree.dump(), (Matcher)Is.is((Object)EXPECTED_TREE));
    }

    @Test
    void testEmptyPlanWithNestedComplexTypes() {
        List<RelDataTypeField> nestedStructFields = Arrays.asList(new RelDataTypeFieldImpl("nf1", 0, (RelDataType)new BasicSqlType((RelDataTypeSystem)new HiveTypeSystemImpl(), SqlTypeName.INTEGER)), new RelDataTypeFieldImpl("nf2", 1, (RelDataType)new BasicSqlType((RelDataTypeSystem)new HiveTypeSystemImpl(), SqlTypeName.CHAR, 30)));
        List<RelDataTypeField> structFields = Arrays.asList(new RelDataTypeFieldImpl("f1", 0, (RelDataType)new BasicSqlType((RelDataTypeSystem)new HiveTypeSystemImpl(), SqlTypeName.INTEGER)), new RelDataTypeFieldImpl("farray", 1, (RelDataType)new ArraySqlType((RelDataType)new BasicSqlType((RelDataTypeSystem)new HiveTypeSystemImpl(), SqlTypeName.INTEGER), true)), new RelDataTypeFieldImpl("fmap", 2, (RelDataType)new MapSqlType((RelDataType)new BasicSqlType((RelDataTypeSystem)new HiveTypeSystemImpl(), SqlTypeName.INTEGER), (RelDataType)new BasicSqlType((RelDataTypeSystem)new HiveTypeSystemImpl(), SqlTypeName.INTEGER), true)), new RelDataTypeFieldImpl("fstruct", 3, (RelDataType)new RelRecordType(nestedStructFields)));
        List<RelDataTypeFieldImpl> fields = Collections.singletonList(new RelDataTypeFieldImpl("a", 0, (RelDataType)new RelRecordType(structFields)));
        RelRecordType dataType = new RelRecordType(fields);
        ASTNode tree = ASTConverter.convertType((RelDataType)dataType);
        MatcherAssert.assertThat((Object)tree.dump(), (Matcher)Is.is((Object)EXPECTED_COMPLEX_TREE));
    }
}

