/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.stats;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.StatisticsTestUtils;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveTypeSystemImpl;
import org.apache.hadoop.hive.ql.optimizer.calcite.RelOptHiveTable;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveBetween;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveRelNode;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableScan;
import org.apache.hadoop.hive.ql.optimizer.calcite.stats.FilterSelectivityEstimator;
import org.apache.hadoop.hive.ql.parse.CalcitePlanner;
import org.apache.hadoop.hive.ql.plan.ColStatistics;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TestFilterSelectivityEstimator {
    private static final float[] VALUES = new float[]{1.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f};
    private static final KllFloatsSketch KLL = StatisticsTestUtils.createKll((float[])VALUES);
    private static final float DELTA = Float.MIN_VALUE;
    private static final RexBuilder REX_BUILDER = new RexBuilder((RelDataTypeFactory)new JavaTypeFactoryImpl((RelDataTypeSystem)new HiveTypeSystemImpl()));
    private static final RelDataTypeFactory TYPE_FACTORY = REX_BUILDER.getTypeFactory();
    private static RelOptCluster relOptCluster;
    private static RexNode intMinus1;
    private static RexNode int0;
    private static RexNode int1;
    private static RexNode int2;
    private static RexNode int3;
    private static RexNode int4;
    private static RexNode int5;
    private static RexNode int7;
    private static RexNode int8;
    private static RexNode int10;
    private static RexNode int11;
    private static RelDataType tableType;
    private static RexNode inputRef0;
    private static RexNode boolFalse;
    private static RexNode boolTrue;
    private static ColStatistics stats;
    @Mock
    private RelOptSchema schemaMock;
    @Mock
    private RelOptHiveTable tableMock;
    @Mock
    private RelMetadataQuery mq;
    private HiveTableScan tableScan;
    private RelNode scan;

    @BeforeClass
    public static void beforeClass() {
        RelDataType integerType = TYPE_FACTORY.createSqlType(SqlTypeName.INTEGER);
        intMinus1 = REX_BUILDER.makeLiteral((Object)-1, integerType, true);
        int0 = REX_BUILDER.makeLiteral((Object)0, integerType, true);
        int1 = REX_BUILDER.makeLiteral((Object)1, integerType, true);
        int2 = REX_BUILDER.makeLiteral((Object)2, integerType, true);
        int3 = REX_BUILDER.makeLiteral((Object)3, integerType, true);
        int4 = REX_BUILDER.makeLiteral((Object)4, integerType, true);
        int5 = REX_BUILDER.makeLiteral((Object)5, integerType, true);
        int7 = REX_BUILDER.makeLiteral((Object)7, integerType, true);
        int8 = REX_BUILDER.makeLiteral((Object)8, integerType, true);
        int10 = REX_BUILDER.makeLiteral((Object)10, integerType, true);
        int11 = REX_BUILDER.makeLiteral((Object)11, integerType, true);
        boolFalse = REX_BUILDER.makeLiteral((Object)false, TYPE_FACTORY.createSqlType(SqlTypeName.BOOLEAN), true);
        boolTrue = REX_BUILDER.makeLiteral((Object)true, TYPE_FACTORY.createSqlType(SqlTypeName.BOOLEAN), true);
        tableType = TYPE_FACTORY.createStructType((List)ImmutableList.of((Object)integerType), (List)ImmutableList.of((Object)"f1"));
        RelOptPlanner planner = CalcitePlanner.createPlanner((HiveConf)new HiveConf());
        relOptCluster = RelOptCluster.create((RelOptPlanner)planner, (RexBuilder)REX_BUILDER);
        stats = new ColStatistics();
        stats.setHistogram(KLL.toByteArray());
    }

    @Before
    public void before() {
        ((RelOptHiveTable)Mockito.doReturn((Object)tableType).when((Object)this.tableMock)).getRowType();
        ((RelOptHiveTable)Mockito.doReturn((Object)VALUES.length).when((Object)this.tableMock)).getRowCount();
        RelBuilder relBuilder = HiveRelFactories.HIVE_BUILDER.create(relOptCluster, this.schemaMock);
        this.tableScan = new HiveTableScan(relOptCluster, relOptCluster.traitSetOf((RelTrait)HiveRelNode.CONVENTION), this.tableMock, "table", null, false, false);
        this.scan = relBuilder.push((RelNode)this.tableScan).build();
        inputRef0 = REX_BUILDER.makeInputRef(this.scan, 0);
    }

    @Test
    public void testIsHistogramAvailableWhenAvailable() {
        ColStatistics colStatistics = new ColStatistics();
        colStatistics.setHistogram(KLL.toByteArray());
        Assert.assertTrue((boolean)FilterSelectivityEstimator.isHistogramAvailable((ColStatistics)colStatistics));
    }

    @Test
    public void testIsHistogramAvailableWhenNullStatistics() {
        Assert.assertFalse((boolean)FilterSelectivityEstimator.isHistogramAvailable(null));
    }

    @Test
    public void testIsHistogramAvailableWhenNullHistogram() {
        Assert.assertFalse((boolean)FilterSelectivityEstimator.isHistogramAvailable((ColStatistics)new ColStatistics()));
    }

    @Test
    public void testIsHistogramAvailableWhenEmptyArray() {
        ColStatistics colStatistics = new ColStatistics();
        colStatistics.setHistogram(new byte[0]);
        Assert.assertFalse((boolean)FilterSelectivityEstimator.isHistogramAvailable((ColStatistics)colStatistics));
    }

    @Test
    public void testLessThanSelectivity() {
        Assert.assertEquals((double)0.6153846153846154, (double)FilterSelectivityEstimator.lessThanSelectivity((KllFloatsSketch)KLL, (float)3.0f), (double)1.4E-45f);
    }

    @Test
    public void testLessThanSelectivityWhenLowerThanMin() {
        Assert.assertEquals((double)0.0, (double)FilterSelectivityEstimator.lessThanSelectivity((KllFloatsSketch)KLL, (float)0.0f), (double)1.4E-45f);
    }

    @Test
    public void testLessThanSelectivityWhenHigherThanMax() {
        Assert.assertEquals((double)1.0, (double)FilterSelectivityEstimator.lessThanSelectivity((KllFloatsSketch)KLL, (float)10.0f), (double)1.4E-45f);
    }

    @Test
    public void testLessThanOrEqualSelectivity() {
        Assert.assertEquals((double)0.6923076923076923, (double)FilterSelectivityEstimator.lessThanOrEqualSelectivity((KllFloatsSketch)KLL, (float)3.0f), (double)1.4E-45f);
    }

    @Test
    public void testLessThanOrEqualSelectivityWhenLowerThanMin() {
        Assert.assertEquals((double)0.0, (double)FilterSelectivityEstimator.lessThanOrEqualSelectivity((KllFloatsSketch)KLL, (float)0.0f), (double)1.4E-45f);
    }

    @Test
    public void testLessThanOrEqualSelectivityWhenHigherThanMax() {
        Assert.assertEquals((double)1.0, (double)FilterSelectivityEstimator.lessThanOrEqualSelectivity((KllFloatsSketch)KLL, (float)10.0f), (double)1.4E-45f);
    }

    @Test
    public void testGreaterThanSelectivity() {
        Assert.assertEquals((double)0.3076923076923077, (double)FilterSelectivityEstimator.greaterThanSelectivity((KllFloatsSketch)KLL, (float)3.0f), (double)1.4E-45f);
    }

    @Test
    public void testGreaterThanSelectivityWhenLowerThanMin() {
        Assert.assertEquals((double)1.0, (double)FilterSelectivityEstimator.greaterThanSelectivity((KllFloatsSketch)KLL, (float)0.0f), (double)1.4E-45f);
    }

    @Test
    public void testGreaterThanSelectivityWhenHigherThanMax() {
        Assert.assertEquals((double)0.0, (double)FilterSelectivityEstimator.greaterThanSelectivity((KllFloatsSketch)KLL, (float)10.0f), (double)1.4E-45f);
    }

    @Test
    public void testGreaterThanOrEqualSelectivity() {
        Assert.assertEquals((double)0.3846153846153846, (double)FilterSelectivityEstimator.greaterThanOrEqualSelectivity((KllFloatsSketch)KLL, (float)3.0f), (double)1.4E-45f);
    }

    @Test
    public void testGreaterThanOrEqualSelectivityWhenLowerThanMin() {
        Assert.assertEquals((double)1.0, (double)FilterSelectivityEstimator.greaterThanOrEqualSelectivity((KllFloatsSketch)KLL, (float)0.0f), (double)1.4E-45f);
    }

    @Test
    public void testGreaterThanOrEqualSelectivityWhenHigherThanMax() {
        Assert.assertEquals((double)0.0, (double)FilterSelectivityEstimator.greaterThanOrEqualSelectivity((KllFloatsSketch)KLL, (float)10.0f), (double)1.4E-45f);
    }

    @Test
    public void testBetweenSelectivity() {
        Assert.assertEquals((double)0.6923076923076923, (double)FilterSelectivityEstimator.betweenSelectivity((KllFloatsSketch)KLL, (float)1.0f, (float)3.0f), (double)1.4E-45f);
    }

    @Test
    public void testBetweenSelectivityFromMinToMax() {
        Assert.assertEquals((double)1.0, (double)FilterSelectivityEstimator.betweenSelectivity((KllFloatsSketch)KLL, (float)1.0f, (float)7.0f), (double)1.4E-45f);
    }

    @Test
    public void testBetweenSelectivityFromLowerThanMinToHigherThanMax() {
        Assert.assertEquals((double)1.0, (double)FilterSelectivityEstimator.betweenSelectivity((KllFloatsSketch)KLL, (float)0.0f, (float)8.0f), (double)1.4E-45f);
    }

    @Test
    public void testBetweenSelectivityLeftLowerThanMin() {
        Assert.assertEquals((double)0.6923076923076923, (double)FilterSelectivityEstimator.betweenSelectivity((KllFloatsSketch)KLL, (float)0.0f, (float)3.0f), (double)1.4E-45f);
    }

    @Test
    public void testBetweenSelectivityRightLowerThanMin() {
        Assert.assertEquals((double)0.0, (double)FilterSelectivityEstimator.betweenSelectivity((KllFloatsSketch)KLL, (float)-1.0f, (float)0.0f), (double)1.4E-45f);
    }

    @Test
    public void testBetweenSelectivityLeftHigherThanMax() {
        Assert.assertEquals((double)0.0, (double)FilterSelectivityEstimator.betweenSelectivity((KllFloatsSketch)KLL, (float)10.0f, (float)11.0f), (double)1.4E-45f);
    }

    @Test
    public void testBetweenSelectivityLeftLowerThanRight() {
        Assert.assertEquals((double)0.0, (double)FilterSelectivityEstimator.betweenSelectivity((KllFloatsSketch)KLL, (float)4.0f, (float)2.0f), (double)1.4E-45f);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBetweenSelectivityLeftEqualsRight_KO() {
        FilterSelectivityEstimator.betweenSelectivity((KllFloatsSketch)KLL, (float)2.0f, (float)2.0f);
    }

    @Test
    public void testComputeRangePredicateSelectivityWhenNoStats() {
        RexNode filter = REX_BUILDER.makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, new RexNode[]{inputRef0, int3});
        FilterSelectivityEstimator estimator = new FilterSelectivityEstimator(this.scan, this.mq);
        Assert.assertEquals((double)0.3333333333333333, (double)estimator.estimateSelectivity(filter), (double)1.4E-45f);
    }

    @Test
    public void testComputeRangePredicateSelectivityLessThan() {
        ((RelOptHiveTable)Mockito.doReturn(Collections.singletonList(stats)).when((Object)this.tableMock)).getColStat(Collections.singletonList(0));
        RexNode filter = REX_BUILDER.makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, new RexNode[]{inputRef0, int3});
        FilterSelectivityEstimator estimator = new FilterSelectivityEstimator(this.scan, this.mq);
        Assert.assertEquals((double)0.6153846153846154, (double)estimator.estimateSelectivity(filter), (double)1.4E-45f);
    }

    @Test
    public void testComputeRangePredicateSelectivityLessThanWhenLowerThanMin() {
        ((RelOptHiveTable)Mockito.doReturn(Collections.singletonList(stats)).when((Object)this.tableMock)).getColStat(Collections.singletonList(0));
        RexNode filter = REX_BUILDER.makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, new RexNode[]{inputRef0, int0});
        FilterSelectivityEstimator estimator = new FilterSelectivityEstimator(this.scan, this.mq);
        Assert.assertEquals((double)0.0, (double)estimator.estimateSelectivity(filter), (double)1.4E-45f);
    }

    @Test
    public void testComputeRangePredicateSelectivityLessThanWhenHigherThanMax() {
        ((RelOptHiveTable)Mockito.doReturn(Collections.singletonList(stats)).when((Object)this.tableMock)).getColStat(Collections.singletonList(0));
        RexNode filter = REX_BUILDER.makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, new RexNode[]{inputRef0, int10});
        FilterSelectivityEstimator estimator = new FilterSelectivityEstimator(this.scan, this.mq);
        Assert.assertEquals((double)1.0, (double)estimator.estimateSelectivity(filter), (double)1.4E-45f);
    }

    @Test
    public void testComputeRangePredicateSelectivityLessThanOrEqual() {
        ((RelOptHiveTable)Mockito.doReturn(Collections.singletonList(stats)).when((Object)this.tableMock)).getColStat(Collections.singletonList(0));
        RexNode filter = REX_BUILDER.makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{inputRef0, int3});
        FilterSelectivityEstimator estimator = new FilterSelectivityEstimator(this.scan, this.mq);
        Assert.assertEquals((double)0.6923076923076923, (double)estimator.estimateSelectivity(filter), (double)1.4E-45f);
    }

    @Test
    public void testComputeRangePredicateSelectivityLessThanOrEqualWhenLowerThanMin() {
        ((RelOptHiveTable)Mockito.doReturn(Collections.singletonList(stats)).when((Object)this.tableMock)).getColStat(Collections.singletonList(0));
        RexNode filter = REX_BUILDER.makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{inputRef0, int0});
        FilterSelectivityEstimator estimator = new FilterSelectivityEstimator(this.scan, this.mq);
        Assert.assertEquals((double)0.0, (double)estimator.estimateSelectivity(filter), (double)1.4E-45f);
    }

    @Test
    public void testComputeRangePredicateSelectivityLessThanOrEqualWhenHigherThanMax() {
        ((RelOptHiveTable)Mockito.doReturn(Collections.singletonList(stats)).when((Object)this.tableMock)).getColStat(Collections.singletonList(0));
        RexNode filter = REX_BUILDER.makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{inputRef0, int10});
        FilterSelectivityEstimator estimator = new FilterSelectivityEstimator(this.scan, this.mq);
        Assert.assertEquals((double)1.0, (double)estimator.estimateSelectivity(filter), (double)1.4E-45f);
    }

    @Test
    public void testComputeRangePredicateSelectivityGreaterThan() {
        ((RelOptHiveTable)Mockito.doReturn(Collections.singletonList(stats)).when((Object)this.tableMock)).getColStat(Collections.singletonList(0));
        RexNode filter = REX_BUILDER.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{inputRef0, int3});
        FilterSelectivityEstimator estimator = new FilterSelectivityEstimator(this.scan, this.mq);
        Assert.assertEquals((double)0.3076923076923077, (double)estimator.estimateSelectivity(filter), (double)1.4E-45f);
    }

    @Test
    public void testComputeRangePredicateSelectivityGreaterThanWhenLowerThanMin() {
        ((RelOptHiveTable)Mockito.doReturn(Collections.singletonList(stats)).when((Object)this.tableMock)).getColStat(Collections.singletonList(0));
        RexNode filter = REX_BUILDER.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{inputRef0, int0});
        FilterSelectivityEstimator estimator = new FilterSelectivityEstimator(this.scan, this.mq);
        Assert.assertEquals((double)1.0, (double)estimator.estimateSelectivity(filter), (double)1.4E-45f);
    }

    @Test
    public void testComputeRangePredicateSelectivityGreaterThanWhenHigherThanMax() {
        ((RelOptHiveTable)Mockito.doReturn(Collections.singletonList(stats)).when((Object)this.tableMock)).getColStat(Collections.singletonList(0));
        RexNode filter = REX_BUILDER.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{inputRef0, int10});
        FilterSelectivityEstimator estimator = new FilterSelectivityEstimator(this.scan, this.mq);
        Assert.assertEquals((double)0.0, (double)estimator.estimateSelectivity(filter), (double)1.4E-45f);
    }

    @Test
    public void testComputeRangePredicateSelectivityGreaterThanOrEqual() {
        ((RelOptHiveTable)Mockito.doReturn(Collections.singletonList(stats)).when((Object)this.tableMock)).getColStat(Collections.singletonList(0));
        RexNode filter = REX_BUILDER.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, new RexNode[]{inputRef0, int3});
        FilterSelectivityEstimator estimator = new FilterSelectivityEstimator(this.scan, this.mq);
        Assert.assertEquals((double)0.38461538461538464, (double)estimator.estimateSelectivity(filter), (double)1.4E-45f);
    }

    @Test
    public void testComputeRangePredicateSelectivityGreaterThanOrEqualWhenLowerThanMin() {
        ((RelOptHiveTable)Mockito.doReturn(Collections.singletonList(stats)).when((Object)this.tableMock)).getColStat(Collections.singletonList(0));
        RexNode filter = REX_BUILDER.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, new RexNode[]{inputRef0, int0});
        FilterSelectivityEstimator estimator = new FilterSelectivityEstimator(this.scan, this.mq);
        Assert.assertEquals((double)1.0, (double)estimator.estimateSelectivity(filter), (double)1.4E-45f);
    }

    @Test
    public void testComputeRangePredicateSelectivityGreaterThanOrEqualWhenHigherThanMax() {
        ((RelOptHiveTable)Mockito.doReturn(Collections.singletonList(stats)).when((Object)this.tableMock)).getColStat(Collections.singletonList(0));
        RexNode filter = REX_BUILDER.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, new RexNode[]{inputRef0, int10});
        FilterSelectivityEstimator estimator = new FilterSelectivityEstimator(this.scan, this.mq);
        Assert.assertEquals((double)0.0, (double)estimator.estimateSelectivity(filter), (double)1.4E-45f);
    }

    @Test
    public void testComputeRangePredicateSelectivityBetween() {
        ((RelOptHiveTable)Mockito.doReturn(Collections.singletonList(stats)).when((Object)this.tableMock)).getColStat(Collections.singletonList(0));
        RexNode filter = REX_BUILDER.makeCall((SqlOperator)HiveBetween.INSTANCE, new RexNode[]{boolFalse, inputRef0, int1, int3});
        FilterSelectivityEstimator estimator = new FilterSelectivityEstimator(this.scan, this.mq);
        Assert.assertEquals((double)0.6923076923076923, (double)estimator.estimateSelectivity(filter), (double)1.4E-45f);
    }

    @Test
    public void testComputeRangePredicateSelectivityBetweenFromMinToMax() {
        ((RelOptHiveTable)Mockito.doReturn(Collections.singletonList(stats)).when((Object)this.tableMock)).getColStat(Collections.singletonList(0));
        RexNode filter = REX_BUILDER.makeCall((SqlOperator)HiveBetween.INSTANCE, new RexNode[]{boolFalse, inputRef0, int1, int7});
        FilterSelectivityEstimator estimator = new FilterSelectivityEstimator(this.scan, this.mq);
        Assert.assertEquals((double)1.0, (double)estimator.estimateSelectivity(filter), (double)1.4E-45f);
    }

    @Test
    public void testComputeRangePredicateSelectivityBetweenFromLowerThanMinToHigherThanMax() {
        ((RelOptHiveTable)Mockito.doReturn(Collections.singletonList(stats)).when((Object)this.tableMock)).getColStat(Collections.singletonList(0));
        RexNode filter = REX_BUILDER.makeCall((SqlOperator)HiveBetween.INSTANCE, new RexNode[]{boolFalse, inputRef0, int0, int8});
        FilterSelectivityEstimator estimator = new FilterSelectivityEstimator(this.scan, this.mq);
        Assert.assertEquals((double)1.0, (double)estimator.estimateSelectivity(filter), (double)1.4E-45f);
    }

    @Test
    public void testComputeRangePredicateSelectivityBetweenLeftLowerThanMin() {
        ((RelOptHiveTable)Mockito.doReturn(Collections.singletonList(stats)).when((Object)this.tableMock)).getColStat(Collections.singletonList(0));
        RexNode filter = REX_BUILDER.makeCall((SqlOperator)HiveBetween.INSTANCE, new RexNode[]{boolFalse, inputRef0, int0, int3});
        FilterSelectivityEstimator estimator = new FilterSelectivityEstimator(this.scan, this.mq);
        Assert.assertEquals((double)0.6923076923076923, (double)estimator.estimateSelectivity(filter), (double)1.4E-45f);
    }

    @Test
    public void testComputeRangePredicateSelectivityBetweenRightLowerThanMin() {
        ((RelOptHiveTable)Mockito.doReturn(Collections.singletonList(stats)).when((Object)this.tableMock)).getColStat(Collections.singletonList(0));
        RexNode filter = REX_BUILDER.makeCall((SqlOperator)HiveBetween.INSTANCE, new RexNode[]{boolFalse, inputRef0, intMinus1, int0});
        FilterSelectivityEstimator estimator = new FilterSelectivityEstimator(this.scan, this.mq);
        Assert.assertEquals((double)0.0, (double)estimator.estimateSelectivity(filter), (double)1.4E-45f);
    }

    @Test
    public void testComputeRangePredicateSelectivityBetweenLeftHigherThanMax() {
        ((RelOptHiveTable)Mockito.doReturn(Collections.singletonList(stats)).when((Object)this.tableMock)).getColStat(Collections.singletonList(0));
        RexNode filter = REX_BUILDER.makeCall((SqlOperator)HiveBetween.INSTANCE, new RexNode[]{boolFalse, inputRef0, int10, int11});
        FilterSelectivityEstimator estimator = new FilterSelectivityEstimator(this.scan, this.mq);
        Assert.assertEquals((double)0.0, (double)estimator.estimateSelectivity(filter), (double)1.4E-45f);
    }

    @Test
    public void testComputeRangePredicateSelectivityBetweenLeftLowerThanRight() {
        ((RelOptHiveTable)Mockito.doReturn(Collections.singletonList(stats)).when((Object)this.tableMock)).getColStat(Collections.singletonList(0));
        RexNode filter = REX_BUILDER.makeCall((SqlOperator)HiveBetween.INSTANCE, new RexNode[]{boolFalse, inputRef0, int4, int2});
        FilterSelectivityEstimator estimator = new FilterSelectivityEstimator(this.scan, this.mq);
        Assert.assertEquals((double)0.0, (double)estimator.estimateSelectivity(filter), (double)1.4E-45f);
    }

    @Test
    public void testComputeRangePredicateSelectivityBetweenLeftEqualsRight() {
        ((RelOptHiveTable)Mockito.doReturn(Collections.singletonList(stats)).when((Object)this.tableMock)).getColStat(Collections.singletonList(0));
        ((RelMetadataQuery)Mockito.doReturn((Object)10.0).when((Object)this.mq)).getDistinctRowCount(this.scan, ImmutableBitSet.of((int[])new int[]{0}), (RexNode)REX_BUILDER.makeLiteral(true));
        RexNode filter = REX_BUILDER.makeCall((SqlOperator)HiveBetween.INSTANCE, new RexNode[]{boolFalse, inputRef0, int3, int3});
        FilterSelectivityEstimator estimator = new FilterSelectivityEstimator(this.scan, this.mq);
        Assert.assertEquals((double)0.1, (double)estimator.estimateSelectivity(filter), (double)1.4E-45f);
    }

    @Test
    public void testComputeRangePredicateSelectivityNotBetween() {
        ((RelOptHiveTable)Mockito.doReturn(Collections.singletonList(stats)).when((Object)this.tableMock)).getColStat(Collections.singletonList(0));
        RexNode filter = REX_BUILDER.makeCall((SqlOperator)HiveBetween.INSTANCE, new RexNode[]{boolTrue, inputRef0, int3, int5});
        FilterSelectivityEstimator estimator = new FilterSelectivityEstimator(this.scan, this.mq);
        Assert.assertEquals((double)0.7692307692307693, (double)estimator.estimateSelectivity(filter), (double)1.4E-45f);
    }

    @Test
    public void testComputeRangePredicateSelectivityNotBetweenLowerThanMinHigherThanMax() {
        ((RelOptHiveTable)Mockito.doReturn(Collections.singletonList(stats)).when((Object)this.tableMock)).getColStat(Collections.singletonList(0));
        RexNode filter = REX_BUILDER.makeCall((SqlOperator)HiveBetween.INSTANCE, new RexNode[]{boolTrue, inputRef0, int0, int10});
        FilterSelectivityEstimator estimator = new FilterSelectivityEstimator(this.scan, this.mq);
        Assert.assertEquals((double)0.0, (double)estimator.estimateSelectivity(filter), (double)1.4E-45f);
    }

    @Test
    public void testComputeRangePredicateSelectivityNotBetweenRightLowerThanLeft() {
        ((RelOptHiveTable)Mockito.doReturn(Collections.singletonList(stats)).when((Object)this.tableMock)).getColStat(Collections.singletonList(0));
        RexNode filter = REX_BUILDER.makeCall((SqlOperator)HiveBetween.INSTANCE, new RexNode[]{boolTrue, inputRef0, int5, int3});
        FilterSelectivityEstimator estimator = new FilterSelectivityEstimator(this.scan, this.mq);
        Assert.assertEquals((double)1.0, (double)estimator.estimateSelectivity(filter), (double)1.4E-45f);
    }

    @Test
    public void testComputeRangePredicateSelectivityNotBetweenLeftEqualsRight() {
        ((RelOptHiveTable)Mockito.doReturn(Collections.singletonList(stats)).when((Object)this.tableMock)).getColStat(Collections.singletonList(0));
        RexNode filter = REX_BUILDER.makeCall((SqlOperator)HiveBetween.INSTANCE, new RexNode[]{boolTrue, inputRef0, int3, int3});
        FilterSelectivityEstimator estimator = new FilterSelectivityEstimator(this.scan, this.mq);
        Assert.assertEquals((double)1.0, (double)estimator.estimateSelectivity(filter), (double)1.4E-45f);
    }

    @Test
    public void testComputeRangePredicateSelectivityGreaterThanWithNULLS() {
        ((RelOptHiveTable)Mockito.doReturn((Object)20.0).when((Object)this.tableMock)).getRowCount();
        ((RelOptHiveTable)Mockito.doReturn(Collections.singletonList(stats)).when((Object)this.tableMock)).getColStat(Collections.singletonList(0));
        RexNode filter = REX_BUILDER.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN, new RexNode[]{inputRef0, int3});
        FilterSelectivityEstimator estimator = new FilterSelectivityEstimator(this.scan, this.mq);
        Assert.assertEquals((double)0.2, (double)estimator.estimateSelectivity(filter), (double)1.4E-45f);
    }

    @Test
    public void testComputeRangePredicateSelectivityGreaterThanOrEqualWithNULLS() {
        ((RelOptHiveTable)Mockito.doReturn((Object)20.0).when((Object)this.tableMock)).getRowCount();
        ((RelOptHiveTable)Mockito.doReturn(Collections.singletonList(stats)).when((Object)this.tableMock)).getColStat(Collections.singletonList(0));
        RexNode filter = REX_BUILDER.makeCall((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, new RexNode[]{inputRef0, int3});
        FilterSelectivityEstimator estimator = new FilterSelectivityEstimator(this.scan, this.mq);
        Assert.assertEquals((double)0.25, (double)estimator.estimateSelectivity(filter), (double)1.4E-45f);
    }

    @Test
    public void testComputeRangePredicateSelectivityLessThanWithNULLS() {
        ((RelOptHiveTable)Mockito.doReturn((Object)20.0).when((Object)this.tableMock)).getRowCount();
        ((RelOptHiveTable)Mockito.doReturn(Collections.singletonList(stats)).when((Object)this.tableMock)).getColStat(Collections.singletonList(0));
        RexNode filter = REX_BUILDER.makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN, new RexNode[]{inputRef0, int3});
        FilterSelectivityEstimator estimator = new FilterSelectivityEstimator(this.scan, this.mq);
        Assert.assertEquals((double)0.4, (double)estimator.estimateSelectivity(filter), (double)1.4E-45f);
    }

    @Test
    public void testComputeRangePredicateSelectivityLessThanOrEqualWithNULLS() {
        ((RelOptHiveTable)Mockito.doReturn((Object)20.0).when((Object)this.tableMock)).getRowCount();
        ((RelOptHiveTable)Mockito.doReturn(Collections.singletonList(stats)).when((Object)this.tableMock)).getColStat(Collections.singletonList(0));
        RexNode filter = REX_BUILDER.makeCall((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{inputRef0, int3});
        FilterSelectivityEstimator estimator = new FilterSelectivityEstimator(this.scan, this.mq);
        Assert.assertEquals((double)0.45, (double)estimator.estimateSelectivity(filter), (double)1.4E-45f);
    }

    @Test
    public void testComputeRangePredicateSelectivityBetweenWithNULLS() {
        ((RelOptHiveTable)Mockito.doReturn((Object)20.0).when((Object)this.tableMock)).getRowCount();
        ((RelOptHiveTable)Mockito.doReturn(Collections.singletonList(stats)).when((Object)this.tableMock)).getColStat(Collections.singletonList(0));
        RexNode filter = REX_BUILDER.makeCall((SqlOperator)HiveBetween.INSTANCE, new RexNode[]{boolFalse, inputRef0, int1, int3});
        FilterSelectivityEstimator estimator = new FilterSelectivityEstimator(this.scan, this.mq);
        Assert.assertEquals((double)0.45, (double)estimator.estimateSelectivity(filter), (double)1.4E-45f);
    }

    @Test
    public void testComputeRangePredicateSelectivityNotBetweenWithNULLS() {
        ((RelOptHiveTable)Mockito.doReturn((Object)20.0).when((Object)this.tableMock)).getRowCount();
        ((RelOptHiveTable)Mockito.doReturn(Collections.singletonList(stats)).when((Object)this.tableMock)).getColStat(Collections.singletonList(0));
        RexNode filter = REX_BUILDER.makeCall((SqlOperator)HiveBetween.INSTANCE, new RexNode[]{boolTrue, inputRef0, int1, int3});
        FilterSelectivityEstimator estimator = new FilterSelectivityEstimator(this.scan, this.mq);
        Assert.assertEquals((double)0.55, (double)estimator.estimateSelectivity(filter), (double)1.4E-45f);
    }
}

