/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.tools.RelBuilder;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.optimizer.calcite.CalciteSemanticException;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveTypeSystemImpl;
import org.apache.hadoop.hive.ql.optimizer.calcite.RelOptHiveTable;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveRelNode;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableScan;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.TypeConverter;
import org.apache.hadoop.hive.ql.parse.CalcitePlanner;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.junit.Before;
import org.junit.BeforeClass;
import org.mockito.Mock;
import org.mockito.Mockito;

public class TestRuleBase {
    protected static RelBuilder REL_BUILDER;
    protected static final RexBuilder REX_BUILDER;
    protected static final RelDataTypeFactory TYPE_FACTORY;
    protected static RelOptCluster relOptCluster;
    @Mock
    protected RelOptHiveTable t1NativeMock;
    protected static RelDataType t1NativeType;
    protected static Table t1Native;
    @Mock
    protected static HiveStorageHandler t1NativeStorageHandler;
    @Mock
    protected RelOptHiveTable t2NativeMock;
    protected static RelDataType t2NativeType;
    protected static Table t2Native;
    @Mock
    protected static HiveStorageHandler t2NativeStorageHandler;
    @Mock
    protected RelOptHiveTable t3NativeMock;
    protected static RelDataType t3NativeType;
    protected static Table t3Native;
    @Mock
    protected static HiveStorageHandler t3NativeStorageHandler;
    @Mock
    protected RelOptHiveTable tNonNativeTableMock;
    protected static RelDataType tNonNativeType;
    protected static Table tNonNative;
    @Mock
    protected RelOptHiveTable tNNSnapshotsTableMock;
    protected static RelDataType tNNSnapshotsType;
    protected static Table tNNSnapshots;
    @Mock
    protected static HiveStorageHandler tNonNativeStorageHandler;
    @Mock
    protected static HiveStorageHandler tNNSnapshotsStorageHandler;

    @BeforeClass
    public static void beforeClass() throws Exception {
        RelOptPlanner planner = CalcitePlanner.createPlanner((HiveConf)new HiveConf());
        relOptCluster = RelOptCluster.create((RelOptPlanner)planner, (RexBuilder)REX_BUILDER);
        t1Native = TestRuleBase.createTable("t1");
        t2Native = TestRuleBase.createTable("t2");
        t3Native = TestRuleBase.createTable("t3");
        t1NativeType = TestRuleBase.createTableType((Map<String, SqlTypeName>)new HashMap<String, SqlTypeName>(){
            {
                this.put("a", SqlTypeName.INTEGER);
                this.put("b", SqlTypeName.VARCHAR);
                this.put("c", SqlTypeName.INTEGER);
            }
        }, Arrays.asList(VirtualColumn.ROWID, VirtualColumn.ROWISDELETED));
        t2NativeType = TestRuleBase.createTableType((Map<String, SqlTypeName>)new HashMap<String, SqlTypeName>(){
            {
                this.put("d", SqlTypeName.INTEGER);
                this.put("e", SqlTypeName.VARCHAR);
                this.put("f", SqlTypeName.INTEGER);
            }
        }, Arrays.asList(VirtualColumn.ROWID, VirtualColumn.ROWISDELETED));
        t3NativeType = TestRuleBase.createTableType((Map<String, SqlTypeName>)new HashMap<String, SqlTypeName>(){
            {
                this.put("g", SqlTypeName.INTEGER);
                this.put("h", SqlTypeName.VARCHAR);
                this.put("i", SqlTypeName.INTEGER);
            }
        }, Arrays.asList(VirtualColumn.ROWID, VirtualColumn.ROWISDELETED));
        tNonNative = TestRuleBase.createTable("t_non_native");
        tNonNativeType = TestRuleBase.createTableType((Map<String, SqlTypeName>)new HashMap<String, SqlTypeName>(){
            {
                this.put("d", SqlTypeName.INTEGER);
                this.put("e", SqlTypeName.VARCHAR);
                this.put("f", SqlTypeName.INTEGER);
            }
        }, Collections.emptyList());
        tNNSnapshots = TestRuleBase.createTable("t_supports_snapshots");
        tNNSnapshotsType = TestRuleBase.createTableType((Map<String, SqlTypeName>)new HashMap<String, SqlTypeName>(){
            {
                this.put("d", SqlTypeName.INTEGER);
                this.put("e", SqlTypeName.VARCHAR);
                this.put("f", SqlTypeName.INTEGER);
            }
        }, Collections.singletonList(VirtualColumn.SNAPSHOT_ID));
        REL_BUILDER = HiveRelFactories.HIVE_BUILDER.create(relOptCluster, null);
    }

    private static Table createTable(String name) {
        Table table = new Table();
        table.setTTable(new org.apache.hadoop.hive.metastore.api.Table());
        table.setDbName("default");
        table.setTableName(name);
        return table;
    }

    private static RelDataType createTableType(Map<String, SqlTypeName> columns, Collection<VirtualColumn> virtualColumns) throws CalciteSemanticException {
        ArrayList<RelDataType> schema = new ArrayList<RelDataType>(columns.size() + virtualColumns.size());
        ArrayList<String> columnNames = new ArrayList<String>(columns.size() + virtualColumns.size());
        for (Map.Entry<String, SqlTypeName> column : columns.entrySet()) {
            columnNames.add(column.getKey());
            schema.add(TYPE_FACTORY.createTypeWithNullability(TYPE_FACTORY.createSqlType(column.getValue()), true));
        }
        for (VirtualColumn virtualColumn : virtualColumns) {
            columnNames.add(virtualColumn.getName());
            schema.add(TypeConverter.convert((TypeInfo)virtualColumn.getTypeInfo(), (RelDataTypeFactory)TYPE_FACTORY));
        }
        return TYPE_FACTORY.createStructType(schema, columnNames);
    }

    @Before
    public void setup() {
        ((RelOptHiveTable)Mockito.lenient().doReturn((Object)t1NativeType).when((Object)this.t1NativeMock)).getRowType();
        ((RelOptHiveTable)Mockito.lenient().doReturn((Object)t1Native).when((Object)this.t1NativeMock)).getHiveTableMD();
        ((RelOptHiveTable)Mockito.lenient().doReturn((Object)t2NativeType).when((Object)this.t2NativeMock)).getRowType();
        ((RelOptHiveTable)Mockito.lenient().doReturn((Object)t2Native).when((Object)this.t2NativeMock)).getHiveTableMD();
        ((RelOptHiveTable)Mockito.lenient().doReturn((Object)t3NativeType).when((Object)this.t3NativeMock)).getRowType();
        ((RelOptHiveTable)Mockito.lenient().doReturn((Object)t3Native).when((Object)this.t3NativeMock)).getHiveTableMD();
        ((RelOptHiveTable)Mockito.lenient().doReturn((Object)tNonNativeType).when((Object)this.tNonNativeTableMock)).getRowType();
        ((RelOptHiveTable)Mockito.lenient().doReturn((Object)tNonNative).when((Object)this.tNonNativeTableMock)).getHiveTableMD();
        tNonNative.setStorageHandler(tNonNativeStorageHandler);
        ((RelOptHiveTable)Mockito.lenient().doReturn((Object)tNNSnapshotsType).when((Object)this.tNNSnapshotsTableMock)).getRowType();
        ((RelOptHiveTable)Mockito.lenient().doReturn((Object)tNNSnapshots).when((Object)this.tNNSnapshotsTableMock)).getHiveTableMD();
        tNNSnapshots.setStorageHandler(tNNSnapshotsStorageHandler);
    }

    protected RelNode createNonNativeTS() {
        HiveTableScan ts = this.createTS(this.tNonNativeTableMock, "t_non_native");
        ((HiveStorageHandler)Mockito.lenient().doReturn((Object)false).when((Object)tNNSnapshotsStorageHandler)).areSnapshotsSupported();
        return ts;
    }

    protected RelNode createNonNativeTSSupportingSnapshots() {
        HiveTableScan ts = this.createTS(this.tNNSnapshotsTableMock, "t_supports_snapshots");
        ((HiveStorageHandler)Mockito.lenient().doReturn((Object)true).when((Object)tNNSnapshotsStorageHandler)).areSnapshotsSupported();
        return ts;
    }

    protected HiveTableScan createTS(RelOptHiveTable table, String alias) {
        return new HiveTableScan(relOptCluster, relOptCluster.traitSetOf((RelTrait)HiveRelNode.CONVENTION), table, alias, null, false, false);
    }

    static {
        REX_BUILDER = new RexBuilder((RelDataTypeFactory)new JavaTypeFactoryImpl((RelDataTypeSystem)new HiveTypeSystemImpl()));
        TYPE_FACTORY = REX_BUILDER.getTypeFactory();
    }
}

