/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules.views;

import java.util.Collections;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.tools.RelBuilder;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableScan;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.views.IncrementalRebuildMode;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.views.MaterializedViewIncrementalRewritingRelVisitor;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.views.TestRuleBase;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class TestMaterializedViewIncrementalRewritingRelVisitor
extends TestRuleBase {
    @Test
    public void testIncrementalRebuildIsNotAvailableWhenPlanHasUnsupportedOperator() {
        HiveTableScan ts1 = this.createTS(this.t1NativeMock, "t1");
        RelNode mvQueryPlan = REL_BUILDER.push((RelNode)ts1).sort(new int[]{1}).build();
        MaterializedViewIncrementalRewritingRelVisitor visitor = new MaterializedViewIncrementalRewritingRelVisitor();
        MatcherAssert.assertThat((Object)visitor.go(mvQueryPlan).getIncrementalRebuildMode(), (Matcher)Matchers.is((Object)IncrementalRebuildMode.NOT_AVAILABLE));
    }

    @Test
    public void testIncrementalRebuildIsInsertOnlyWhenPlanHasTSOnNonNativeTableWithSnapshots() {
        RelNode ts1 = this.createNonNativeTS();
        Mockito.when((Object)tNonNativeStorageHandler.areSnapshotsSupported()).thenReturn((Object)true);
        RelNode mvQueryPlan = REL_BUILDER.push(ts1).build();
        MaterializedViewIncrementalRewritingRelVisitor visitor = new MaterializedViewIncrementalRewritingRelVisitor();
        MatcherAssert.assertThat((Object)visitor.go(mvQueryPlan).getIncrementalRebuildMode(), (Matcher)Matchers.is((Object)IncrementalRebuildMode.INSERT_ONLY));
        ((HiveStorageHandler)Mockito.verify((Object)tNonNativeStorageHandler, (VerificationMode)Mockito.atLeastOnce())).areSnapshotsSupported();
    }

    @Test
    public void testIncrementalRebuildIsNotAvailableWhenPlanHasTSOnNonNativeTableWithoutSnapshots() {
        RelNode ts1 = this.createNonNativeTS();
        RelNode mvQueryPlan = REL_BUILDER.push(ts1).build();
        MaterializedViewIncrementalRewritingRelVisitor visitor = new MaterializedViewIncrementalRewritingRelVisitor();
        MatcherAssert.assertThat((Object)visitor.go(mvQueryPlan).getIncrementalRebuildMode(), (Matcher)Matchers.is((Object)IncrementalRebuildMode.NOT_AVAILABLE));
        ((HiveStorageHandler)Mockito.verify((Object)tNonNativeStorageHandler, (VerificationMode)Mockito.atLeastOnce())).areSnapshotsSupported();
    }

    @Test
    public void testIncrementalRebuildIsInsertOnlyWhenPlanHasTSOnNonNativeTableSupportsSnapshots() {
        RelNode ts1 = this.createNonNativeTSSupportingSnapshots();
        RelNode mvQueryPlan = REL_BUILDER.push(ts1).build();
        MaterializedViewIncrementalRewritingRelVisitor visitor = new MaterializedViewIncrementalRewritingRelVisitor();
        MatcherAssert.assertThat((Object)visitor.go(mvQueryPlan).getIncrementalRebuildMode(), (Matcher)Matchers.is((Object)IncrementalRebuildMode.INSERT_ONLY));
    }

    @Test
    public void testIncrementalRebuildIsInsertOnlyWhenPlanHasFilter() {
        HiveTableScan ts1 = this.createTS(this.t1NativeMock, "t1");
        RelNode mvQueryPlan = REL_BUILDER.push((RelNode)ts1).filter(new RexNode[]{REX_BUILDER.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, new RexNode[]{REX_BUILDER.makeInputRef((RelNode)ts1, 0)})}).build();
        MaterializedViewIncrementalRewritingRelVisitor visitor = new MaterializedViewIncrementalRewritingRelVisitor();
        MaterializedViewIncrementalRewritingRelVisitor.Result result = visitor.go(mvQueryPlan);
        MatcherAssert.assertThat((Object)result.getIncrementalRebuildMode(), (Matcher)Matchers.is((Object)IncrementalRebuildMode.INSERT_ONLY));
        MatcherAssert.assertThat((Object)result.containsAggregate(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testIncrementalRebuildIsInsertOnlyWhenPlanHasInnerJoin() {
        HiveTableScan ts1 = this.createTS(this.t1NativeMock, "t1");
        HiveTableScan ts2 = this.createTS(this.t2NativeMock, "t2");
        RexNode joinCondition = REX_BUILDER.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{REX_BUILDER.makeInputRef(((RelDataTypeField)ts1.getRowType().getFieldList().get(0)).getType(), 0), REX_BUILDER.makeInputRef(((RelDataTypeField)ts2.getRowType().getFieldList().get(0)).getType(), 5)});
        RelNode mvQueryPlan = REL_BUILDER.push((RelNode)ts1).push((RelNode)ts2).join(JoinRelType.INNER, joinCondition).build();
        MaterializedViewIncrementalRewritingRelVisitor visitor = new MaterializedViewIncrementalRewritingRelVisitor();
        MatcherAssert.assertThat((Object)visitor.go(mvQueryPlan).getIncrementalRebuildMode(), (Matcher)Matchers.is((Object)IncrementalRebuildMode.INSERT_ONLY));
    }

    @Test
    public void testInnerJoinWithDifferentInputs() {
        RelNode tSDoesNotSupport = this.createNonNativeTS();
        RelNode tSSupportsInsertOnly = this.createNonNativeTSSupportingSnapshots();
        HiveTableScan tSSupports = this.createTS(this.t1NativeMock, "t1");
        HiveTableScan tSSupports2 = this.createTS(this.t2NativeMock, "t2");
        this.testInnerJoin(tSDoesNotSupport, tSSupportsInsertOnly, IncrementalRebuildMode.NOT_AVAILABLE);
        this.testInnerJoin(tSSupportsInsertOnly, tSDoesNotSupport, IncrementalRebuildMode.NOT_AVAILABLE);
        this.testInnerJoin(tSSupportsInsertOnly, (RelNode)tSSupports, IncrementalRebuildMode.INSERT_ONLY);
        this.testInnerJoin((RelNode)tSSupports, tSSupportsInsertOnly, IncrementalRebuildMode.INSERT_ONLY);
        this.testInnerJoin((RelNode)tSSupports, (RelNode)tSSupports2, IncrementalRebuildMode.AVAILABLE);
    }

    private void testInnerJoin(RelNode left, RelNode right, IncrementalRebuildMode expected) {
        RexNode joinCondition = REX_BUILDER.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{REX_BUILDER.makeInputRef(((RelDataTypeField)left.getRowType().getFieldList().get(0)).getType(), 0), REX_BUILDER.makeInputRef(((RelDataTypeField)right.getRowType().getFieldList().get(0)).getType(), 5)});
        RelNode mvQueryPlan = REL_BUILDER.push(left).push(right).join(JoinRelType.INNER, joinCondition).aggregate(REL_BUILDER.groupKey(new int[]{0}), new RelBuilder.AggCall[]{REL_BUILDER.aggregateCall(SqlStdOperatorTable.COUNT, new RexNode[0])}).build();
        MaterializedViewIncrementalRewritingRelVisitor visitor = new MaterializedViewIncrementalRewritingRelVisitor();
        MatcherAssert.assertThat((String)String.format("leftInput=%s, rightInput=%s, expected incremental rebuild mode=%s", left, right, expected), (Object)visitor.go(mvQueryPlan).getIncrementalRebuildMode(), (Matcher)Matchers.is((Object)expected));
    }

    @Test
    public void testIncrementalRebuildIsNotAvailableWhenPlanHasJoinOtherThanInner() {
        HiveTableScan ts1 = this.createTS(this.t1NativeMock, "t1");
        HiveTableScan ts2 = this.createTS(this.t2NativeMock, "t2");
        RexNode joinCondition = REX_BUILDER.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{REX_BUILDER.makeInputRef(((RelDataTypeField)ts1.getRowType().getFieldList().get(0)).getType(), 0), REX_BUILDER.makeInputRef(((RelDataTypeField)ts2.getRowType().getFieldList().get(0)).getType(), 5)});
        RelNode mvQueryPlan = REL_BUILDER.push((RelNode)ts1).push((RelNode)ts2).join(JoinRelType.LEFT, joinCondition).build();
        MaterializedViewIncrementalRewritingRelVisitor visitor = new MaterializedViewIncrementalRewritingRelVisitor();
        MatcherAssert.assertThat((Object)visitor.go(mvQueryPlan).getIncrementalRebuildMode(), (Matcher)Matchers.is((Object)IncrementalRebuildMode.NOT_AVAILABLE));
    }

    @Test
    public void testIncrementalRebuildIsInsertOnlyWhenPlanHasAggregate() {
        HiveTableScan ts1 = this.createTS(this.t1NativeMock, "t1");
        RelNode mvQueryPlan = REL_BUILDER.push((RelNode)ts1).aggregate(REL_BUILDER.groupKey(new int[]{0}), new RelBuilder.AggCall[]{REL_BUILDER.aggregateCall(SqlStdOperatorTable.SUM, new RexNode[]{REX_BUILDER.makeInputRef(((RelDataTypeField)ts1.getRowType().getFieldList().get(0)).getType(), 0)})}).build();
        MaterializedViewIncrementalRewritingRelVisitor visitor = new MaterializedViewIncrementalRewritingRelVisitor();
        MaterializedViewIncrementalRewritingRelVisitor.Result result = visitor.go(mvQueryPlan);
        MatcherAssert.assertThat((Object)result.getIncrementalRebuildMode(), (Matcher)Matchers.is((Object)IncrementalRebuildMode.INSERT_ONLY));
        MatcherAssert.assertThat((Object)result.containsAggregate(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)result.getCountStarIndex(), (Matcher)Matchers.is((Object)-1));
    }

    @Test
    public void testIncrementalRebuildIsAvailableWhenPlanHasAggregateAndCountStar() {
        HiveTableScan ts1 = this.createTS(this.t1NativeMock, "t1");
        RelNode mvQueryPlan = REL_BUILDER.push((RelNode)ts1).aggregate(REL_BUILDER.groupKey(new int[]{0}), new RelBuilder.AggCall[]{REL_BUILDER.aggregateCall(SqlStdOperatorTable.SUM, new RexNode[]{REX_BUILDER.makeInputRef(((RelDataTypeField)ts1.getRowType().getFieldList().get(0)).getType(), 0)}), REL_BUILDER.aggregateCall(SqlStdOperatorTable.COUNT, new RexNode[0])}).build();
        MaterializedViewIncrementalRewritingRelVisitor visitor = new MaterializedViewIncrementalRewritingRelVisitor();
        MaterializedViewIncrementalRewritingRelVisitor.Result result = visitor.go(mvQueryPlan);
        MatcherAssert.assertThat((Object)result.getIncrementalRebuildMode(), (Matcher)Matchers.is((Object)IncrementalRebuildMode.AVAILABLE));
        MatcherAssert.assertThat((Object)result.containsAggregate(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)result.getCountStarIndex(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testIncrementalRebuildIsNotAvailableWhenPlanHasAggregateAvg() {
        HiveTableScan ts1 = this.createTS(this.t1NativeMock, "t1");
        RelNode mvQueryPlan = REL_BUILDER.push((RelNode)ts1).aggregate(REL_BUILDER.groupKey(new int[]{0}), new RelBuilder.AggCall[]{REL_BUILDER.aggregateCall(SqlStdOperatorTable.AVG, new RexNode[]{REX_BUILDER.makeInputRef(((RelDataTypeField)ts1.getRowType().getFieldList().get(0)).getType(), 0)})}).build();
        MaterializedViewIncrementalRewritingRelVisitor visitor = new MaterializedViewIncrementalRewritingRelVisitor();
        MatcherAssert.assertThat((Object)visitor.go(mvQueryPlan).getIncrementalRebuildMode(), (Matcher)Matchers.is((Object)IncrementalRebuildMode.NOT_AVAILABLE));
    }

    @Test
    public void testIncrementalRebuildIsInsertOnlyWhenPlanHasAggregateAvgCountSumOfTheSameColumn() {
        HiveTableScan ts1 = this.createTS(this.t1NativeMock, "t1");
        RexInputRef rexInputRef = REX_BUILDER.makeInputRef(((RelDataTypeField)ts1.getRowType().getFieldList().get(0)).getType(), 0);
        RelNode mvQueryPlan = REL_BUILDER.push((RelNode)ts1).aggregate(REL_BUILDER.groupKey(new int[]{0}), new RelBuilder.AggCall[]{REL_BUILDER.aggregateCall(SqlStdOperatorTable.COUNT, new RexNode[]{rexInputRef}), REL_BUILDER.aggregateCall(SqlStdOperatorTable.SUM, new RexNode[]{rexInputRef}), REL_BUILDER.aggregateCall(SqlStdOperatorTable.AVG, new RexNode[]{rexInputRef})}).build();
        MaterializedViewIncrementalRewritingRelVisitor visitor = new MaterializedViewIncrementalRewritingRelVisitor();
        MatcherAssert.assertThat((Object)visitor.go(mvQueryPlan).getIncrementalRebuildMode(), (Matcher)Matchers.is((Object)IncrementalRebuildMode.INSERT_ONLY));
    }

    @Test
    public void testIncrementalRebuildIsNotAvailableWhenPlanHasAggregateAvgCountSumButOfDifferentColumns() {
        HiveTableScan ts1 = this.createTS(this.t1NativeMock, "t1");
        RexInputRef rexInputRef = REX_BUILDER.makeInputRef(((RelDataTypeField)ts1.getRowType().getFieldList().get(0)).getType(), 0);
        RexInputRef rexInputRef2 = REX_BUILDER.makeInputRef(((RelDataTypeField)ts1.getRowType().getFieldList().get(0)).getType(), 1);
        RelNode mvQueryPlan = REL_BUILDER.push((RelNode)ts1).aggregate(REL_BUILDER.groupKey(new int[]{0}), new RelBuilder.AggCall[]{REL_BUILDER.aggregateCall(SqlStdOperatorTable.COUNT, new RexNode[]{rexInputRef}), REL_BUILDER.aggregateCall(SqlStdOperatorTable.SUM, new RexNode[]{rexInputRef2}), REL_BUILDER.aggregateCall(SqlStdOperatorTable.AVG, new RexNode[]{rexInputRef})}).build();
        MaterializedViewIncrementalRewritingRelVisitor visitor = new MaterializedViewIncrementalRewritingRelVisitor();
        MatcherAssert.assertThat((Object)visitor.go(mvQueryPlan).getIncrementalRebuildMode(), (Matcher)Matchers.is((Object)IncrementalRebuildMode.NOT_AVAILABLE));
    }

    @Test
    public void testIncrementalRebuildIsNotAvailableWhenPlanHasNotSupportedAggregateCall() {
        HiveTableScan ts1 = this.createTS(this.t1NativeMock, "t1");
        RexInputRef rexInputRef = REX_BUILDER.makeInputRef(((RelDataTypeField)ts1.getRowType().getFieldList().get(0)).getType(), 0);
        RelNode mvQueryPlan = REL_BUILDER.push((RelNode)ts1).aggregate(REL_BUILDER.groupKey(new int[]{0}), new RelBuilder.AggCall[]{REL_BUILDER.aggregateCall(SqlStdOperatorTable.STDDEV, new RexNode[]{rexInputRef}), REL_BUILDER.aggregateCall(SqlStdOperatorTable.SUM, new RexNode[]{rexInputRef}), REL_BUILDER.aggregateCall(SqlStdOperatorTable.COUNT, new RexNode[]{rexInputRef})}).build();
        MaterializedViewIncrementalRewritingRelVisitor visitor = new MaterializedViewIncrementalRewritingRelVisitor();
        MatcherAssert.assertThat((Object)visitor.go(mvQueryPlan).getIncrementalRebuildMode(), (Matcher)Matchers.is((Object)IncrementalRebuildMode.NOT_AVAILABLE));
    }

    @Test
    public void testIncrementalRebuildIsNotAvailableWhenPlanHasBothSupportedAndNotSupportedAggregateCall() {
        HiveTableScan ts1 = this.createTS(this.t1NativeMock, "t1");
        RexInputRef rexInputRef = REX_BUILDER.makeInputRef(((RelDataTypeField)ts1.getRowType().getFieldList().get(0)).getType(), 0);
        RelNode mvQueryPlan = REL_BUILDER.push((RelNode)ts1).aggregate(REL_BUILDER.groupKey(new int[]{0}), new RelBuilder.AggCall[]{REL_BUILDER.aggregateCall(SqlStdOperatorTable.STDDEV, new RexNode[]{rexInputRef}), REL_BUILDER.aggregateCall(SqlStdOperatorTable.MIN, new RexNode[]{rexInputRef})}).build();
        MaterializedViewIncrementalRewritingRelVisitor visitor = new MaterializedViewIncrementalRewritingRelVisitor();
        MatcherAssert.assertThat((Object)visitor.go(mvQueryPlan).getIncrementalRebuildMode(), (Matcher)Matchers.is((Object)IncrementalRebuildMode.NOT_AVAILABLE));
    }

    @Test
    public void testIncrementalRebuildIsInsertOnlyWhenPlanHasBothSupportedAggregateCallAndOneThatSupportsInsertOnly() {
        HiveTableScan ts1 = this.createTS(this.t1NativeMock, "t1");
        RexInputRef rexInputRef = REX_BUILDER.makeInputRef(((RelDataTypeField)ts1.getRowType().getFieldList().get(0)).getType(), 0);
        RelNode mvQueryPlan = REL_BUILDER.push((RelNode)ts1).aggregate(REL_BUILDER.groupKey(new int[]{0}), new RelBuilder.AggCall[]{REL_BUILDER.aggregateCall(SqlStdOperatorTable.MIN, new RexNode[]{rexInputRef}), REL_BUILDER.aggregateCall(SqlStdOperatorTable.COUNT, new RexNode[0])}).build();
        MaterializedViewIncrementalRewritingRelVisitor visitor = new MaterializedViewIncrementalRewritingRelVisitor();
        MatcherAssert.assertThat((Object)visitor.go(mvQueryPlan).getIncrementalRebuildMode(), (Matcher)Matchers.is((Object)IncrementalRebuildMode.INSERT_ONLY));
    }

    @Test
    public void testIncrementalRebuildIsNotAvailableWhenPlanHasCountDistinct() {
        HiveTableScan ts1 = this.createTS(this.t1NativeMock, "t1");
        RelDataType countRetType = TYPE_FACTORY.createTypeWithNullability(TYPE_FACTORY.createSqlType(SqlTypeName.BIGINT), false);
        AggregateCall aggregateCall = AggregateCall.create((SqlAggFunction)SqlStdOperatorTable.COUNT, (boolean)true, (boolean)false, (boolean)false, Collections.emptyList(), (int)-1, (RelCollation)RelCollations.EMPTY, (RelDataType)countRetType, null);
        RelNode mvQueryPlan = REL_BUILDER.push((RelNode)ts1).aggregate(REL_BUILDER.groupKey(new int[]{0}), Collections.singletonList(aggregateCall)).build();
        MaterializedViewIncrementalRewritingRelVisitor visitor = new MaterializedViewIncrementalRewritingRelVisitor();
        MatcherAssert.assertThat((Object)visitor.go(mvQueryPlan).getIncrementalRebuildMode(), (Matcher)Matchers.is((Object)IncrementalRebuildMode.NOT_AVAILABLE));
    }

    @Test
    public void testIncrementalRebuildIsNotAvailableWhenPlanHasUnsupportedAggregateOnSubPlanSupportsInsertOnly() {
        RelNode ts1 = this.createNonNativeTSSupportingSnapshots();
        RexInputRef rexInputRef = REX_BUILDER.makeInputRef(((RelDataTypeField)ts1.getRowType().getFieldList().get(0)).getType(), 0);
        RelNode mvQueryPlan = REL_BUILDER.push(ts1).aggregate(REL_BUILDER.groupKey(), new RelBuilder.AggCall[]{REL_BUILDER.aggregateCall(SqlStdOperatorTable.STDDEV, new RexNode[]{rexInputRef})}).build();
        MaterializedViewIncrementalRewritingRelVisitor visitor = new MaterializedViewIncrementalRewritingRelVisitor();
        MatcherAssert.assertThat((Object)visitor.go(mvQueryPlan).getIncrementalRebuildMode(), (Matcher)Matchers.is((Object)IncrementalRebuildMode.NOT_AVAILABLE));
    }
}

