/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules.views;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.tools.RelBuilder;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;
import org.apache.hadoop.hive.ql.optimizer.calcite.RelOptHiveTable;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableScan;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.views.HiveMaterializedViewUtils;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.views.HivePushdownSnapshotFilterRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.views.TestRuleBase;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TestHivePushdownSnapshotFilterRule
extends TestRuleBase {
    @Mock
    private RelOptSchema schemaMock;

    @Test
    public void testFilterIsRemovedAndVersionIntervalFromIsSetWhenFilterHasSnapshotIdPredicate() {
        RelNode tableScan = this.createNonNativeTSSupportingSnapshots();
        RelBuilder relBuilder = HiveRelFactories.HIVE_BUILDER.create(relOptCluster, this.schemaMock);
        RelNode root = relBuilder.push(tableScan).filter(new RexNode[]{relBuilder.call((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{relBuilder.field(3), relBuilder.literal((Object)42)})}).build();
        System.out.println(RelOptUtil.toString((RelNode)root));
        RelNode newRoot = HiveMaterializedViewUtils.applyRule((RelNode)root, (RelOptRule)HivePushdownSnapshotFilterRule.INSTANCE);
        MatcherAssert.assertThat((Object)newRoot, (Matcher)IsInstanceOf.instanceOf(HiveTableScan.class));
        HiveTableScan newScan = (HiveTableScan)newRoot;
        RelOptHiveTable optHiveTable = (RelOptHiveTable)newScan.getTable();
        MatcherAssert.assertThat((Object)optHiveTable.getHiveTableMD().getVersionIntervalFrom(), (Matcher)Is.is((Object)"42"));
    }

    @Test
    public void testFilterLeftIntactWhenItDoesNotHaveSnapshotIdPredicate() {
        RelNode tableScan = this.createNonNativeTS();
        RelBuilder relBuilder = HiveRelFactories.HIVE_BUILDER.create(relOptCluster, this.schemaMock);
        RelNode root = relBuilder.push(tableScan).filter(new RexNode[]{relBuilder.call((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{relBuilder.field(0), relBuilder.literal((Object)42)})}).build();
        System.out.println(RelOptUtil.toString((RelNode)root));
        RelNode newRoot = HiveMaterializedViewUtils.applyRule((RelNode)root, (RelOptRule)HivePushdownSnapshotFilterRule.INSTANCE);
        MatcherAssert.assertThat((Object)newRoot.getDigest(), (Matcher)Is.is((Object)root.getDigest()));
    }
}

