/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules.views;

import java.util.Collections;
import java.util.HashMap;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.rel.RelNode;
import org.apache.hadoop.hive.common.type.SnapshotContext;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveFilter;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.views.HiveAugmentSnapshotMaterializationRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.views.HiveMaterializedViewUtils;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.views.TestRuleBase;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TestHiveAugmentSnapshotMaterializationRule
extends TestRuleBase {
    @Test
    public void testWhenSnapshotAndTableAreEmptyNoFilterAdded() {
        RelNode tableScan = this.createNonNativeTSSupportingSnapshots();
        RelOptRule rule = HiveAugmentSnapshotMaterializationRule.with(Collections.emptyMap());
        RelNode newRoot = HiveMaterializedViewUtils.applyRule((RelNode)tableScan, (RelOptRule)rule);
        MatcherAssert.assertThat((Object)newRoot, (Matcher)Is.is((Object)tableScan));
    }

    @Test
    public void testWhenNoSnapshotButTableHasNewDataAFilterWithDefaultSnapshotIDAdded() {
        ((HiveStorageHandler)Mockito.doReturn((Object)new SnapshotContext(10L)).when((Object)tNNSnapshotsStorageHandler)).getCurrentSnapshotContext(tNNSnapshots);
        RelNode tableScan = this.createNonNativeTSSupportingSnapshots();
        RelOptRule rule = HiveAugmentSnapshotMaterializationRule.with(Collections.emptyMap());
        RelNode newRoot = HiveMaterializedViewUtils.applyRule((RelNode)tableScan, (RelOptRule)rule);
        MatcherAssert.assertThat((Object)newRoot, (Matcher)IsInstanceOf.instanceOf(HiveFilter.class));
        HiveFilter filter = (HiveFilter)newRoot;
        MatcherAssert.assertThat((Object)filter.getCondition().toString(), (Matcher)Is.is((Object)"<=($3, null)"));
    }

    @Test
    public void testWhenMVAndTableCurrentSnapshotAreTheSameNoFilterAdded() {
        ((HiveStorageHandler)Mockito.doReturn((Object)new SnapshotContext(42L)).when((Object)tNNSnapshotsStorageHandler)).getCurrentSnapshotContext(tNNSnapshots);
        RelNode tableScan = this.createNonNativeTSSupportingSnapshots();
        HashMap<String, SnapshotContext> mvSnapshot = new HashMap<String, SnapshotContext>();
        mvSnapshot.put(tNNSnapshots.getFullyQualifiedName(), new SnapshotContext(42L));
        RelOptRule rule = HiveAugmentSnapshotMaterializationRule.with(mvSnapshot);
        RelNode newRoot = HiveMaterializedViewUtils.applyRule((RelNode)tableScan, (RelOptRule)rule);
        MatcherAssert.assertThat((Object)newRoot, (Matcher)Is.is((Object)tableScan));
    }

    @Test
    public void testWhenMVSnapshotIsDifferentThanTableCurrentSnapshotHasNewDataAFilterWithMVSnapshotIdAdded() {
        ((HiveStorageHandler)Mockito.doReturn((Object)new SnapshotContext(10L)).when((Object)tNNSnapshotsStorageHandler)).getCurrentSnapshotContext(tNNSnapshots);
        RelNode tableScan = this.createNonNativeTSSupportingSnapshots();
        HashMap<String, SnapshotContext> mvSnapshot = new HashMap<String, SnapshotContext>();
        mvSnapshot.put(tNNSnapshots.getFullyQualifiedName(), new SnapshotContext(42L));
        RelOptRule rule = HiveAugmentSnapshotMaterializationRule.with(mvSnapshot);
        RelNode newRoot = HiveMaterializedViewUtils.applyRule((RelNode)tableScan, (RelOptRule)rule);
        MatcherAssert.assertThat((Object)newRoot, (Matcher)IsInstanceOf.instanceOf(HiveFilter.class));
        HiveFilter filter = (HiveFilter)newRoot;
        MatcherAssert.assertThat((Object)filter.getCondition().toString(), (Matcher)Is.is((Object)"<=($3, 42)"));
    }
}

