/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules.views;

import java.util.BitSet;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.rel.RelNode;
import org.apache.hadoop.hive.common.ValidReaderWriteIdList;
import org.apache.hadoop.hive.common.ValidTxnWriteIdList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveFilter;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableScan;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.views.HiveAugmentMaterializationRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.views.HiveMaterializedViewUtils;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.views.TestRuleBase;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TestHiveAugmentMaterializationRule
extends TestRuleBase {
    @Test
    public void testFilterIsCreatedInTopOfTSWhenTableHasChangesSinceSavedSnapshot() {
        HiveTableScan tableScan = this.createTS(this.t1NativeMock, "t1");
        ValidTxnWriteIdList current = new ValidTxnWriteIdList(Long.valueOf(10L));
        ValidReaderWriteIdList validWriteIdList = new ValidReaderWriteIdList("default.t1", new long[0], new BitSet(), 10L);
        current.addTableValidWriteIdList((ValidWriteIdList)validWriteIdList);
        ValidTxnWriteIdList mv = new ValidTxnWriteIdList(Long.valueOf(5L));
        validWriteIdList = new ValidReaderWriteIdList("default.t1", new long[]{4L, 6L}, new BitSet(), 5L);
        mv.addTableValidWriteIdList((ValidWriteIdList)validWriteIdList);
        HiveAugmentMaterializationRule rule = new HiveAugmentMaterializationRule(REX_BUILDER, current, mv);
        RelNode newRoot = HiveMaterializedViewUtils.applyRule((RelNode)tableScan, (RelOptRule)rule);
        MatcherAssert.assertThat((Object)newRoot, (Matcher)IsInstanceOf.instanceOf(HiveFilter.class));
        HiveFilter filter = (HiveFilter)newRoot;
        MatcherAssert.assertThat((Object)filter.getCondition().toString(), (Matcher)Is.is((Object)"AND(<=($3.writeId, 5), <>($3.writeId, 4), <>($3.writeId, 6))"));
    }
}

