/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.plan.AbstractRelOptPlanner;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgramBuilder;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.tools.RelBuilder;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;
import org.apache.hadoop.hive.ql.optimizer.calcite.RelOptHiveTable;
import org.junit.Assert;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestRuleHelper {
    protected static final JavaTypeFactoryImpl JAVA_TYPE_FACTORY = new JavaTypeFactoryImpl();

    public static AbstractRelOptPlanner buildPlanner(Collection<RelOptRule> rules) {
        HepProgramBuilder programBuilder = new HepProgramBuilder();
        rules.forEach(arg_0 -> ((HepProgramBuilder)programBuilder).addRuleInstance(arg_0));
        return new HepPlanner(programBuilder.build());
    }

    public static RelBuilder buildRelBuilder(AbstractRelOptPlanner planner, RelOptSchema schemaMock, RelOptHiveTable tableMock, Table hiveTableMock, Class<?> clazz) {
        RexBuilder rexBuilder = new RexBuilder((RelDataTypeFactory)JAVA_TYPE_FACTORY);
        RelOptCluster optCluster = RelOptCluster.create((RelOptPlanner)planner, (RexBuilder)rexBuilder);
        RelDataType rowTypeMock = JAVA_TYPE_FACTORY.createStructType(clazz);
        ((RelOptHiveTable)Mockito.doReturn((Object)rowTypeMock).when((Object)tableMock)).getRowType();
        LogicalTableScan tableScan = LogicalTableScan.create((RelOptCluster)optCluster, (RelOptTable)tableMock, Collections.emptyList());
        ((RelOptHiveTable)Mockito.doReturn((Object)tableScan).when((Object)tableMock)).toRel((RelOptTable.ToRelContext)ArgumentMatchers.any());
        ((RelOptSchema)Mockito.doReturn((Object)tableMock).when((Object)schemaMock)).getTableForMember((List)ArgumentMatchers.any());
        ((RelOptHiveTable)Mockito.lenient().doReturn((Object)hiveTableMock).when((Object)tableMock)).getHiveTableMD();
        return HiveRelFactories.HIVE_BUILDER.create(optCluster, schemaMock);
    }

    static RexNode eq(RelBuilder relBuilder, String field, Number value) {
        return relBuilder.call((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{relBuilder.field(field), relBuilder.literal((Object)value)});
    }

    static RexNode or(RelBuilder relBuilder, RexNode ... args) {
        return relBuilder.call((SqlOperator)SqlStdOperatorTable.OR, args);
    }

    static RexNode and(RelBuilder relBuilder, RexNode ... args) {
        return relBuilder.call((SqlOperator)SqlStdOperatorTable.AND, args);
    }

    static void assertPlans(AbstractRelOptPlanner planner, RelNode plan, String expectedPrePlan, String expectedPostPlan) {
        planner.setRoot(plan);
        RelNode optimizedRelNode = planner.findBestExp();
        Assert.assertEquals((String)"Original plans do not match", (Object)expectedPrePlan, (Object)RelOptUtil.toString((RelNode)plan));
        Assert.assertEquals((String)"Optimized plans do not match", (Object)expectedPostPlan, (Object)RelOptUtil.toString((RelNode)optimizedRelNode));
    }

    static class MyRecord {
        public int f1;
        public int f2;
        public double f3;

        MyRecord() {
        }
    }

    static class MyRecordWithNullableField {
        public Integer f1;
        public int f2;
        public double f3;

        MyRecordWithNullableField() {
        }
    }
}

