/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import java.util.Collections;
import org.apache.calcite.plan.AbstractRelOptPlanner;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilder;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.calcite.RelOptHiveTable;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveUnionPullUpConstantsRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.TestRuleHelper;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TestHiveUnionPullUpConstantsRule {
    @Mock
    private RelOptSchema schemaMock;
    @Mock
    RelOptHiveTable tableMock;
    @Mock
    Table hiveTableMDMock;
    private AbstractRelOptPlanner planner;
    private RelBuilder relBuilder;

    public void before(Class<?> clazz) {
        this.planner = TestRuleHelper.buildPlanner(Collections.singletonList(HiveUnionPullUpConstantsRule.INSTANCE));
        this.relBuilder = TestRuleHelper.buildRelBuilder(this.planner, this.schemaMock, this.tableMock, this.hiveTableMDMock, clazz);
    }

    @Test
    public void testNonNullableFields() {
        this.before(TestRuleHelper.MyRecord.class);
        RelNode plan = this.relBuilder.scan(new String[]{"t"}).filter(new RexNode[]{TestRuleHelper.eq(this.relBuilder, "f1", 1)}).project(new RexNode[]{this.relBuilder.field("f1"), this.relBuilder.field("f2")}).scan(new String[]{"t"}).filter(new RexNode[]{TestRuleHelper.eq(this.relBuilder, "f1", 1)}).project(new RexNode[]{this.relBuilder.field("f1"), this.relBuilder.field("f2")}).union(true).build();
        String prePlan = "HiveUnion(all=[true])\n  HiveProject(f1=[$0], f2=[$1])\n    HiveFilter(condition=[=($0, 1)])\n      LogicalTableScan(table=[[]])\n  HiveProject(f1=[$0], f2=[$1])\n    HiveFilter(condition=[=($0, 1)])\n      LogicalTableScan(table=[[]])\n";
        String postPlan = "HiveProject(f1=[1], f2=[$0])\n  HiveUnion(all=[true])\n    HiveProject(f2=[$1])\n      HiveProject(f1=[$0], f2=[$1])\n        HiveFilter(condition=[=($0, 1)])\n          LogicalTableScan(table=[[]])\n    HiveProject(f2=[$1])\n      HiveProject(f1=[$0], f2=[$1])\n        HiveFilter(condition=[=($0, 1)])\n          LogicalTableScan(table=[[]])\n";
        TestRuleHelper.assertPlans(this.planner, plan, prePlan, postPlan);
    }

    @Test
    public void testNullableFields() {
        this.before(TestRuleHelper.MyRecordWithNullableField.class);
        RelNode plan = this.relBuilder.scan(new String[]{"t"}).filter(new RexNode[]{TestRuleHelper.eq(this.relBuilder, "f1", 1)}).project(new RexNode[]{this.relBuilder.field("f1"), this.relBuilder.field("f2")}).scan(new String[]{"t"}).filter(new RexNode[]{TestRuleHelper.eq(this.relBuilder, "f1", 1)}).project(new RexNode[]{this.relBuilder.field("f1"), this.relBuilder.field("f2")}).union(false).build();
        String prePlan = "HiveUnion(all=[true])\n  HiveProject(f1=[$0], f2=[$1])\n    HiveFilter(condition=[=($0, 1)])\n      LogicalTableScan(table=[[]])\n  HiveProject(f1=[$0], f2=[$1])\n    HiveFilter(condition=[=($0, 1)])\n      LogicalTableScan(table=[[]])\n";
        String postPlan = "HiveProject(f1=[CAST(1):JavaType(class java.lang.Integer)], f2=[$0])\n  HiveUnion(all=[true])\n    HiveProject(f2=[$1])\n      HiveProject(f1=[$0], f2=[$1])\n        HiveFilter(condition=[=($0, 1)])\n          LogicalTableScan(table=[[]])\n    HiveProject(f2=[$1])\n      HiveProject(f1=[$0], f2=[$1])\n        HiveFilter(condition=[=($0, 1)])\n          LogicalTableScan(table=[[]])\n";
        TestRuleHelper.assertPlans(this.planner, plan, prePlan, postPlan);
    }
}

