/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import java.util.Arrays;
import org.apache.calcite.plan.AbstractRelOptPlanner;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelDistributions;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilder;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.calcite.RelOptHiveTable;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveProjectMergeRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveSortPullUpConstantsRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.TestRuleHelper;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TestHiveSortExchangePullUpConstantsRule {
    @Mock
    private RelOptSchema schemaMock;
    @Mock
    RelOptHiveTable tableMock;
    @Mock
    Table hiveTableMDMock;
    private AbstractRelOptPlanner planner;
    private RelBuilder relBuilder;

    public void before(Class<?> clazz) {
        this.planner = TestRuleHelper.buildPlanner(Arrays.asList(HiveSortPullUpConstantsRule.SORT_EXCHANGE_INSTANCE, HiveProjectMergeRule.INSTANCE));
        this.relBuilder = TestRuleHelper.buildRelBuilder(this.planner, this.schemaMock, this.tableMock, this.hiveTableMDMock, clazz);
    }

    @Test
    public void testNonNullableFields() {
        this.before(TestRuleHelper.MyRecord.class);
        RelNode plan = this.relBuilder.scan(new String[]{"t"}).filter(new RexNode[]{TestRuleHelper.eq(this.relBuilder, "f1", 1)}).sortExchange(RelDistributions.ROUND_ROBIN_DISTRIBUTED, RelCollations.of((int)0)).project(new RexNode[]{this.relBuilder.field("f1"), this.relBuilder.field("f2")}).build();
        String prePlan = "HiveProject(f1=[$0], f2=[$1])\n  HiveSortExchange(distribution=[rr], collation=[[0]])\n    HiveFilter(condition=[=($0, 1)])\n      LogicalTableScan(table=[[]])\n";
        String postPlan = "HiveProject(f1=[1], f2=[$0])\n  HiveSortExchange(distribution=[rr], collation=[[]])\n    HiveProject(f2=[$1], f3=[$2])\n      HiveFilter(condition=[=($0, 1)])\n        LogicalTableScan(table=[[]])\n";
        TestRuleHelper.assertPlans(this.planner, plan, prePlan, postPlan);
    }

    @Test
    public void testNullableFields() {
        this.before(TestRuleHelper.MyRecordWithNullableField.class);
        RelNode plan = this.relBuilder.scan(new String[]{"t"}).filter(new RexNode[]{TestRuleHelper.eq(this.relBuilder, "f1", 1)}).sortExchange(RelDistributions.ROUND_ROBIN_DISTRIBUTED, RelCollations.of((int)0)).project(new RexNode[]{this.relBuilder.field("f1"), this.relBuilder.field("f2")}).build();
        String prePlan = "HiveProject(f1=[$0], f2=[$1])\n  HiveSortExchange(distribution=[rr], collation=[[0]])\n    HiveFilter(condition=[=($0, 1)])\n      LogicalTableScan(table=[[]])\n";
        String postPlan = "HiveProject(f1=[CAST(1):JavaType(class java.lang.Integer)], f2=[$0])\n  HiveSortExchange(distribution=[rr], collation=[[]])\n    HiveProject(f2=[$1], f3=[$2])\n      HiveFilter(condition=[=($0, 1)])\n        LogicalTableScan(table=[[]])\n";
        TestRuleHelper.assertPlans(this.planner, plan, prePlan, postPlan);
    }
}

